/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.exception.ContentProcessException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PipelineContentImpl
implements PipelineContent {
    protected String _id = "";
    protected Document _document = null;
    protected InputStream _contentStream = null;
    protected String _encoding = null;
    protected Map<String, String> _properties = null;
    protected boolean _xml = false;
    public static final Logger LOGGER = LoggerFactory.getLogger(PipelineContentImpl.class);

    public PipelineContentImpl() {
    }

    public PipelineContentImpl(String id, InputStream contentStream, boolean isXml, Document document, String encoding, Map<String, String> properties) {
        this._id = id;
        this._contentStream = contentStream;
        this._document = document;
        this._encoding = encoding;
        this._xml = isXml;
        this._properties = properties;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public InputStream getContentStream() throws ContentProcessException {
        if (this._xml && this._document == null) {
            this.getDocument();
        }
        if (this._contentStream == null) {
            if (this._document != null) {
                try {
                    this._contentStream = new ByteArrayInputStream(XmlUtils.convertDocumentToString(this._document).getBytes(this._encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ContentProcessException("Error while converting " + this._id + " into docuemnt.", e);
                }
                catch (IOException e) {
                    throw new ContentProcessException("Error while converting " + this._id + " into docuemnt.", e);
                }
            } else {
                throw new ContentProcessException("Error while converting " + this._id + " into docuemnt. Both document and content stream cannot be null.");
            }
        }
        return this._contentStream;
    }

    @Override
    public void setContentStream(InputStream contentStream) {
        this._contentStream = contentStream;
        this._document = null;
    }

    @Override
    public Document getDocument() throws ContentProcessException {
        if (this._xml && this._document == null) {
            if (this._contentStream != null) {
                try {
                    SAXReader saxReader = new SAXReader();
                    try {
                        saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    }
                    catch (SAXException ex) {
                        LOGGER.error("Unable to turn off external entity loading, This could be a security risk.", ex, new Object[0]);
                    }
                    saxReader.setEncoding(this._encoding);
                    this._document = saxReader.read(this._contentStream);
                    this._contentStream = null;
                }
                catch (DocumentException e) {
                    throw new ContentProcessException("Error while converting " + this._id + " into document.", (Exception)((Object)e));
                }
                finally {
                    ContentUtils.release(this._contentStream);
                    this._contentStream = null;
                }
            }
            throw new ContentProcessException("Error while converting " + this._id + " into document. Both document and content stream cannot be null.");
        }
        return this._document;
    }

    @Override
    public void setDocument(Document document) {
        this._document = document;
        ContentUtils.release(this._contentStream);
        this._contentStream = null;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this._properties = properties;
    }

    @Override
    public void addProperty(String key, String value) {
        if (this._properties == null) {
            this._properties = new HashMap<String, String>();
        }
        this._properties.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        if (this._properties != null) {
            return this._properties.get(key);
        }
        return null;
    }

    @Override
    public void closeContentStream() {
        ContentUtils.release(this._contentStream);
    }
}

