/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.content.pipeline;

import org.craftercms.studio.api.v1.content.pipeline.PipelineContent;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.impl.v1.content.pipeline.BaseContentProcessor;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;

public class PostActivityProcessor
extends BaseContentProcessor {
    public static final String NAME = "PostActivityProcessor";
    protected AuditServiceInternal auditServiceInternal;
    protected SiteService siteService;
    protected ContentService contentService;
    protected ContentRepository contentRepository;

    public PostActivityProcessor() {
        super(NAME);
    }

    public PostActivityProcessor(String name) {
        super(name);
    }

    @Override
    public void process(PipelineContent content, ResultTO result) throws SiteNotFoundException {
        if (result.getCommitId() != null) {
            String site = content.getProperty("site");
            boolean skipAuditLogInsert = ContentFormatUtils.getBooleanValue(content.getProperty("skipAuditLogInsert"));
            if (!skipAuditLogInsert) {
                String type = content.getProperty("activityType");
                String user = content.getProperty("user");
                String activityType = "CREATE".equals(type) ? "CREATE" : "UPDATE";
                String folderPath = content.getProperty("folderPath");
                String fileName = content.getProperty("fileName");
                boolean isSystemAsset = ContentFormatUtils.getBooleanValue(content.getProperty("systemAsset"));
                if (isSystemAsset) {
                    ContentAssetInfoTO assetInfoTO = (ContentAssetInfoTO)result.getItem();
                    fileName = assetInfoTO.getFileName();
                }
                String uri = folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
                SiteFeed siteFeed = this.siteService.getSite(site);
                AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
                auditLog.setOperation(activityType);
                auditLog.setActorId(user);
                auditLog.setSiteId(siteFeed.getId());
                auditLog.setPrimaryTargetId(site + ":" + uri);
                auditLog.setPrimaryTargetType("Content Item");
                auditLog.setPrimaryTargetValue(uri);
                auditLog.setPrimaryTargetSubtype(this.contentService.getContentTypeClass(site, uri));
                this.auditServiceInternal.insertAuditLog(auditLog);
            }
            this.contentRepository.markGitLogAudited(site, result.getCommitId());
        }
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

