/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.craftercms.studio.api.v1.ebus.DeploymentEventContext;
import org.craftercms.studio.api.v1.ebus.DeploymentItem;
import org.craftercms.studio.api.v1.ebus.EventListener;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v2.repository.ContentRepository;

public class EnvironmentDeployer {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentDeployer.class);
    private static final String METHOD_PUBLISH_TO_ENVIRONMENT_LISTENER = "onEnvironmentDeploymentEvent";
    protected ContentRepository contentRepository;
    protected EventService eventService;
    protected String beanName;

    @EventListener(value={"studio.event.publishToEnvironment"})
    public void onEnvironmentDeploymentEvent(DeploymentEventContext context) {
        List<DeploymentItem> items = context.getItems();
        ArrayList<DeploymentItemTO> deploymentItems = new ArrayList<DeploymentItemTO>();
        for (DeploymentItem item : items) {
            DeploymentItemTO deploymentItem = new DeploymentItemTO();
            deploymentItem.setSite(item.getSite());
            deploymentItem.setPath(item.getPath());
            deploymentItem.setCommitId(item.getCommitId());
            deploymentItem.setPackageId(item.getPackageId());
        }
        try {
            this.contentRepository.publish(context.getSite(), "", deploymentItems, context.getEnvironment(), context.getAuthor(), context.getComment());
        }
        catch (DeploymentException e) {
            logger.error("Error when publishing site " + context.getSite() + " to environment " + context.getEnvironment(), e, new Object[0]);
        }
    }

    public void subscribeToPublishToEnvironmentEvents() {
        try {
            Method subscribeMethod = EnvironmentDeployer.class.getMethod(METHOD_PUBLISH_TO_ENVIRONMENT_LISTENER, DeploymentEventContext.class);
            this.eventService.subscribe("studio.event.publishToEnvironment", this.beanName, subscribeMethod);
        }
        catch (NoSuchMethodException e) {
            logger.error("Could not subscribe to publish to environment events", e, new Object[0]);
        }
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

