/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.deployment;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.craftercms.studio.api.v1.deployment.PreviewDeployer;
import org.craftercms.studio.api.v1.ebus.EventListener;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.http.HttpStatus;

public class PreviewDeployerImpl
implements PreviewDeployer {
    private static final Logger logger = LoggerFactory.getLogger(PreviewDeployerImpl.class);
    private static final String METHOD_PREVIEW_SYNC_LISTENER = "onPreviewSync";
    protected StudioConfiguration studioConfiguration;
    protected EventService eventService;
    protected String beanName;
    protected CloseableHttpClient httpClient;

    public PreviewDeployerImpl() {
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        this.httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(requestConfig).build();
    }

    public void subscribeToPreviewSyncEvents() {
        try {
            Method subscribeMethod = PreviewDeployerImpl.class.getMethod(METHOD_PREVIEW_SYNC_LISTENER, PreviewEventContext.class);
            this.eventService.subscribe("studio.event.previewSync", this.beanName, subscribeMethod);
        }
        catch (NoSuchMethodException e) {
            logger.error("Could not subscribe to preview sync events", e, new Object[0]);
        }
    }

    @Override
    @EventListener(value={"studio.event.previewSync"})
    public void onPreviewSync(PreviewEventContext context) {
        this.doDeployment(context.getSite(), "authoring", false);
        this.doDeployment(context.getSite(), "preview", context.isWaitTillDeploymentIsDone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeployment(String site, String environment, boolean waitTillDone) {
        String requestUrl = this.getDeployTargetUrl(site, environment);
        HttpPost postRequest = new HttpPost(requestUrl);
        if (waitTillDone) {
            String requestBody = this.getDeployTargetRequestBody(true);
            StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
            postRequest.setEntity((HttpEntity)requestEntity);
        }
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            HttpStatus httpStatus = HttpStatus.valueOf((int)response.getStatusLine().getStatusCode());
            if (!httpStatus.is2xxSuccessful()) {
                logger.error("Preview sync request for site " + site + " returned status " + httpStatus + " (" + httpStatus.getReasonPhrase() + ")", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error while sending preview sync request for site " + site, e, new Object[0]);
        }
        finally {
            postRequest.releaseConnection();
        }
    }

    private String getDeployTargetUrl(String site, String environment) {
        String toRet = this.studioConfiguration.getProperty("studio.preview.defaultPreviewDeployerUrl").replaceAll("\\{siteName\\}", site).replaceAll("\\{siteEnv\\}", environment);
        return toRet;
    }

    private String getDeployTargetRequestBody(boolean waitTillDone) {
        DeployTargetRequestBody requestBody = new DeployTargetRequestBody();
        requestBody.setWaitTillDone(waitTillDone);
        return requestBody.toJson();
    }

    @Override
    public boolean createTarget(String site, String searchEngine) {
        return this.doCreateTarget(site, "authoring", "Elasticsearch", this.studioConfiguration.getProperty("studio.authoring.templateName")) && this.doCreateTarget(site, "preview", searchEngine, this.studioConfiguration.getProperty("studio.preview.templateName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCreateTarget(String site, String environment, String searchEngine, String template) {
        boolean toReturn = true;
        String requestUrl = this.getCreateTargetUrl();
        HttpPost postRequest = new HttpPost(requestUrl);
        String requestBody = this.getCreateTargetRequestBody(site, environment, searchEngine, template);
        StringEntity requestEntity = new StringEntity(requestBody, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)requestEntity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()) != HttpStatus.CREATED) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending preview sync request for site " + site, e, new Object[0]);
            toReturn = false;
        }
        finally {
            postRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getCreateTargetUrl() {
        String toReturn = this.studioConfiguration.getProperty("studio.preview.createTargetUrl");
        return toReturn;
    }

    private String getCreateTargetRequestBody(String site, String environment, String searchEngine, String template) {
        CreateTargetRequestBody requestBody = new CreateTargetRequestBody();
        requestBody.setEnvironment(environment);
        requestBody.setSiteName(site);
        requestBody.setReplace(Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.preview.replace")));
        requestBody.setDisableDeployCron(Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.preview.disableDeployCron")));
        requestBody.setTemplateName(template);
        String repoUrl = this.studioConfiguration.getProperty("studio.preview.repoUrl").replaceAll("\\{siteName\\}", site);
        Path repoUrlPath = Paths.get(repoUrl, new String[0]);
        repoUrl = repoUrlPath.normalize().toAbsolutePath().toString();
        requestBody.setRepoUrl(repoUrl);
        requestBody.setSearchEngine(searchEngine);
        return requestBody.toJson();
    }

    @Override
    public boolean deleteTarget(String site) {
        return this.doDeleteTarget(site, "authoring") && this.doDeleteTarget(site, "preview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDeleteTarget(String site, String environment) {
        boolean toReturn = true;
        String requestUrl = this.getDeleteTargetUrl(site, environment);
        HttpPost postRequest = new HttpPost(requestUrl);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)postRequest);
            if (!HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()).is2xxSuccessful()) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending delete preview target request for site " + site, e, new Object[0]);
            toReturn = false;
        }
        finally {
            postRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getDeleteTargetUrl(String site, String environment) {
        String url = new String(this.studioConfiguration.getProperty("studio.preview.deleteTargetUrl"));
        url = url.replaceAll("\\{siteName\\}", site);
        url = url.replaceAll("\\{siteEnv\\}", environment);
        return url;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected class DeployTargetRequestBody {
        protected boolean waitTillDone;

        protected DeployTargetRequestBody() {
        }

        public boolean isWaitTillDone() {
            return this.waitTillDone;
        }

        public void setWaitTillDone(boolean waitTillDone) {
            this.waitTillDone = waitTillDone;
        }

        public String toJson() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"wait_till_done", (Object)this.waitTillDone);
            return jsonObject.toString();
        }
    }

    protected class CreateTargetRequestBody {
        protected String environment;
        protected String siteName;
        protected boolean replace;
        protected boolean disableDeployCron;
        protected String templateName;
        protected String repoUrl;
        protected String engineUrl;
        protected String searchEngine;

        protected CreateTargetRequestBody() {
        }

        public String toJson() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"env", (Object)this.environment);
            jsonObject.put((Object)"site_name", (Object)this.siteName);
            jsonObject.put((Object)"replace", (Object)this.replace);
            jsonObject.put((Object)"disable_deploy_cron", (Object)this.disableDeployCron);
            jsonObject.put((Object)"template_name", (Object)this.templateName);
            jsonObject.put((Object)"repo_url", (Object)this.repoUrl);
            jsonObject.put((Object)"engine_url", (Object)this.engineUrl);
            jsonObject.put((Object)"search_engine", (Object)this.searchEngine);
            return jsonObject.toString();
        }

        public String getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(String environment) {
            this.environment = environment;
        }

        public String getSiteName() {
            return this.siteName;
        }

        public void setSiteName(String siteName) {
            this.siteName = siteName;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public void setReplace(boolean replace) {
            this.replace = replace;
        }

        public boolean isDisableDeployCron() {
            return this.disableDeployCron;
        }

        public void setDisableDeployCron(boolean disableDeployCron) {
            this.disableDeployCron = disableDeployCron;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public void setRepoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
        }

        public String getSearchEngine() {
            return this.searchEngine;
        }

        public void setSearchEngine(String searchEngine) {
            this.searchEngine = searchEngine;
        }
    }
}

