/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.ebus;

import java.lang.reflect.Method;
import java.util.List;
import org.craftercms.studio.api.v1.ebus.DeploymentEventItem;
import org.craftercms.studio.api.v1.ebus.DeploymentEventMessage;
import org.craftercms.studio.api.v1.ebus.EventListener;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.event.EventService;

public class DeploymentEventLoggerListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEventLoggerListener.class);
    private static final String METHOD_DEPLOYMENT_ENGINE_DEPLOY = "onDeploymentEvent";
    protected EventService eventService;
    protected String beanName;

    @EventListener(value={"studio.event.deploymentEngineDeploy"})
    public void onDeploymentEvent(DeploymentEventMessage message) {
        String endpoint = message.getEndpoint();
        String site = message.getSite();
        List<DeploymentEventItem> items = message.getItems();
        StringBuilder sbItems = new StringBuilder();
        sbItems.append("[ ");
        for (DeploymentEventItem item : items) {
            sbItems.append("{ ").append("\"site\": ").append(item.getSite()).append(", ").append("\"path\": ").append(item.getPath()).append(", ").append("\"oldpath\": ").append(item.getOldPath()).append(", ").append("\"datetime\": ").append(item.getDateTime()).append(", ").append("\"state\": ").append(item.getState()).append(", ").append("\"user\": ").append(item.getUser()).append(" } ");
        }
        sbItems.append("}");
        logger.info(String.format("Event: %s", "studio.event.deploymentEngineDeploy"), new Object[0]);
        logger.info(String.format("Site: %s", site), new Object[0]);
        logger.info(String.format("Endpoint: %s", endpoint), new Object[0]);
        logger.info(String.format("Items: %s", sbItems.toString()), new Object[0]);
    }

    public void subscribeToDeploymentEngineDeployEvents() {
        try {
            Method subscribeMethod = DeploymentEventLoggerListener.class.getMethod(METHOD_DEPLOYMENT_ENGINE_DEPLOY, DeploymentEventMessage.class);
            this.eventService.subscribe("studio.event.deploymentEngineDeploy", this.beanName, subscribeMethod);
        }
        catch (NoSuchMethodException e) {
            logger.error("Could not subscribe to deloyment engine deploy events", e, new Object[0]);
        }
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

