/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.entitlement;

import java.util.Arrays;
import java.util.List;
import org.craftercms.commons.entitlements.exception.UnsupportedEntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.model.Module;
import org.craftercms.commons.entitlements.usage.EntitlementUsageProvider;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;

public class StudioEntitlementUsageProvider
implements EntitlementUsageProvider {
    protected ObjectMetadataManager objectMetadataManager;
    protected SiteService siteService;
    protected UserServiceInternal userServiceInternal;

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public Module getModule() {
        return Module.STUDIO;
    }

    public List<EntitlementType> getSupportedEntitlements() {
        return Arrays.asList(EntitlementType.SITE, EntitlementType.USER, EntitlementType.ITEM);
    }

    public int doGetEntitlementUsage(EntitlementType type) throws UnsupportedEntitlementException, ServiceLayerException {
        switch (type) {
            case SITE: {
                return this.countSites();
            }
            case USER: {
                return this.countUsers();
            }
            case ITEM: {
                return this.countItems();
            }
        }
        throw new UnsupportedEntitlementException(Module.STUDIO, type);
    }

    protected int countSites() {
        return this.siteService.countSites();
    }

    protected int countUsers() throws ServiceLayerException {
        return this.userServiceInternal.getAllUsersTotal();
    }

    protected int countItems() {
        return this.objectMetadataManager.countAllItems();
    }
}

