/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.job;

import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.to.EmailMessageQueueTo;
import org.craftercms.studio.api.v1.to.EmailMessageTO;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailMessageSender
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EmailMessageSender.class);
    protected JavaMailSender emailService;
    protected JavaMailSender emailServiceNoAuth;
    protected EmailMessageQueueTo emailMessages;
    protected StudioConfiguration studioConfiguration;
    private Thread thread;
    private boolean running;

    public String getDefaultFromAddress() {
        return this.studioConfiguration.getProperty("studio.mail.from.default");
    }

    public void initThread() {
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                if (this.emailMessages.size() > 0) {
                    List<EmailMessageTO> list = this.emailMessages.getAll();
                    int size = list.size();
                    for (int counter = 0; counter < size; ++counter) {
                        EmailMessageTO emailMessage = list.get(counter);
                        emailMessage.preprocessEmail();
                        String userEmailAddress = emailMessage.getTo();
                        String content = emailMessage.getContent();
                        String subject = emailMessage.getSubject();
                        String replyTo = emailMessage.getReplyTo();
                        String personalFromName = emailMessage.getPersonalFromName();
                        boolean success = this.sendEmail(subject, content, userEmailAddress, replyTo, personalFromName);
                        if (success) {
                            logger.debug("Successfully sent email to:" + userEmailAddress, new Object[0]);
                        } else {
                            logger.error("Could not send email to:" + userEmailAddress, new Object[0]);
                        }
                        emailMessage = null;
                    }
                }
                int secs = 30;
                Thread.sleep((long)secs * 1000L);
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while Thread.sleep()", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected boolean sendEmail(final String subject, final String content, final String userEmailAddress, final String replyTo, final String personalFromName) {
        boolean success = true;
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                mimeMessage.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)userEmailAddress));
                InternetAddress[] replyTos = new InternetAddress[1];
                if (replyTo != null && !"".equals(replyTo)) {
                    replyTos[0] = new InternetAddress(replyTo);
                    mimeMessage.setReplyTo((Address[])replyTos);
                }
                InternetAddress fromAddress = new InternetAddress(EmailMessageSender.this.getDefaultFromAddress());
                if (personalFromName != null) {
                    fromAddress.setPersonal(personalFromName);
                }
                mimeMessage.setFrom((Address)fromAddress);
                mimeMessage.setContent((Object)content, "text/html; charset=utf-8");
                mimeMessage.setSubject(subject);
                logger.debug("sending email to [" + userEmailAddress + "]subject subject :[" + subject + "]", new Object[0]);
            }
        };
        try {
            if (this.isAuthenticatedSMTP()) {
                this.emailService.send(preparator);
            } else {
                this.emailServiceNoAuth.send(preparator);
            }
        }
        catch (MailException ex) {
            logger.error("Error sending email notification to:" + userEmailAddress, (Exception)((Object)ex), new Object[0]);
            success = false;
        }
        return success;
    }

    public void shutdown() {
        if (this.thread != null) {
            this.running = false;
            this.thread.interrupt();
        }
    }

    public boolean isAuthenticatedSMTP() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.mail.smtp.auth"));
        return toReturn;
    }

    public JavaMailSender getEmailService() {
        return this.emailService;
    }

    public void setEmailService(JavaMailSender emailService) {
        this.emailService = emailService;
    }

    public void setEmailMessages(EmailMessageQueueTo emailMessages) {
        this.emailMessages = emailMessages;
    }

    public JavaMailSender getEmailServiceNoAuth() {
        return this.emailServiceNoAuth;
    }

    public void setEmailServiceNoAuth(JavaMailSender emailServiceNoAuth) {
        this.emailServiceNoAuth = emailServiceNoAuth;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

