/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;

public class StrSubstitutorVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(StrSubstitutorVisitor.class);
    public static final StrMatcher PREFIX = StrMatcher.stringMatcher((String)"${plugin:");
    protected StrSubstitutor strSubstitutor;

    public StrSubstitutorVisitor(Map<String, String> variables) {
        HashMap escapedVars = new HashMap(variables.size());
        variables.forEach((key, value) -> escapedVars.put(key, StringEscapeUtils.escapeXml10((String)value)));
        this.strSubstitutor = new StrSubstitutor(StrLookup.mapLookup(escapedVars), PREFIX, StrSubstitutor.DEFAULT_SUFFIX, '$');
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        logger.debug("Replacing parameters in file: {0}", file);
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            String originalContent = IOUtils.toString((InputStream)inputStream);
            String updatedContent = this.strSubstitutor.replace(originalContent);
            if (!StringUtils.equals((CharSequence)originalContent, (CharSequence)updatedContent)) {
                logger.debug("Updating file {}", file);
                Files.write(file, updatedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
            return fileVisitResult;
        }
        catch (IOException e) {
            logger.error("Error reading file {0}", e, file);
            throw e;
        }
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.error("Error reading file at {0}", exc, file);
        throw exc;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }
}

