/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.studio.api.v1.constant.GitRepositories;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.GitLogDAO;
import org.craftercms.studio.api.v2.dal.RemoteRepository;
import org.craftercms.studio.api.v2.dal.RemoteRepositoryDAO;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.repository.RetryingRepositoryOperationFacade;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.GitRepositoryHelper;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.git.GitContentRepositoryConstants;
import org.craftercms.studio.impl.v1.repository.git.TreeCopier;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.springframework.web.context.ServletContextAware;

public class GitContentRepository
implements ContentRepository,
ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(GitContentRepository.class);
    private TextEncryptor encryptor;
    private static final String STUDIO_MANIFEST_LOCATION = "/META-INF/MANIFEST.MF";
    protected ServletContext ctx;
    protected StudioConfiguration studioConfiguration;
    protected ServicesConfig servicesConfig;
    protected GitLogDAO gitLogDao;
    protected RemoteRepositoryDAO remoteRepositoryDAO;
    protected UserServiceInternal userServiceInternal;
    protected SecurityService securityService;
    protected SiteFeedMapper siteFeedMapper;
    protected ClusterDAO clusterDao;
    protected GeneralLockService generalLockService;
    protected RetryingOperationFacade retryingOperationFacade;
    protected RetryingRepositoryOperationFacade retryingRepositoryOperationFacade;

    @Override
    public boolean contentExists(String site, String path) {
        boolean toReturn;
        block19: {
            toReturn = false;
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repo == null) break block19;
                RevTree tree = helper.getTreeForLastCommit(repo);
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                    String gitPath;
                    if (tw != null && tw.getObjectId(0) != null) {
                        toReturn = true;
                        tw.close();
                    } else if (tw == null && (StringUtils.isEmpty((CharSequence)(gitPath = helper.getGitPath(path))) || gitPath.equals("."))) {
                        toReturn = true;
                    }
                }
                catch (IOException e) {
                    logger.info("Content not found for site: " + site + " path: " + path, e);
                }
            }
            catch (Exception e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path, e, new Object[0]);
            }
        }
        return toReturn;
    }

    @Override
    public InputStream getContent(String site, String path) throws ContentNotFoundException, CryptoException {
        ObjectStream toReturn = null;
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
        if (repo == null) {
            throw new ContentNotFoundException("Repository not found for site " + site);
        }
        try {
            RevTree tree = helper.getTreeForLastCommit(repo);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                if (tw != null && tw.getObjectId(0) != null) {
                    ObjectId id = tw.getObjectId(0);
                    ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                    toReturn = objectLoader.openStream();
                    tw.close();
                }
            }
            catch (IOException e) {
                logger.error("Error while getting content for file at site: " + site + " path: " + path, e, new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to create RevTree for site: " + site + " path: " + path, e, new Object[0]);
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getContentSize(String site, String path) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            RevTree tree = helper.getTreeForLastCommit(repo);
            try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                if (tw == null) return -1L;
                if (tw.getObjectId(0) == null) return -1L;
                ObjectId id = tw.getObjectId(0);
                ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                long l = objectLoader.getSize();
                return l;
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error while getting content for file at site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeContent(String site, String path, InputStream content) {
        String commitId = null;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repo != null) {
                    if (helper.writeFile(repo, site, path, content)) {
                        PersonIdent user = helper.getCurrentUserIdent();
                        String username = this.securityService.getCurrentUser();
                        String comment = helper.getCommitMessage("studio.repo.sandbox.write.commitMessage").replace("{username}", username).replace("{path}", path);
                        commitId = helper.commitFile(repo, site, path, comment, user);
                    } else {
                        logger.error("Failed to write content site: " + site + " path: " + path, new Object[0]);
                    }
                } else {
                    logger.error("Missing repository during write for site: " + site + " path: " + path, new Object[0]);
                }
            }
        }
        catch (CryptoException | ServiceLayerException | UserNotFoundException e) {
            logger.error("Unknown service error during write for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createFolder(String site, String path, String name) {
        String commitId = null;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                boolean result;
                Repository repo;
                Path emptyFilePath;
                block29: {
                    emptyFilePath = Paths.get(path, name, ".keep");
                    repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                    try {
                        File file = new File(repo.getDirectory().getParent(), emptyFilePath.toString());
                        File folder = file.getParentFile();
                        if (folder != null && !folder.exists()) {
                            folder.mkdirs();
                        }
                        if (!file.createNewFile()) {
                            logger.error("error writing file: site: " + site + " path: " + emptyFilePath, new Object[0]);
                            result = false;
                            break block29;
                        }
                        try (Git git = new Git(repo);){
                            AddCommand addCommand = git.add().addFilepattern(helper.getGitPath(emptyFilePath.toString()));
                            this.retryingRepositoryOperationFacade.call(addCommand);
                            git.close();
                            result = true;
                        }
                        catch (GitAPIException e) {
                            logger.error("error adding file to git: site: " + site + " path: " + emptyFilePath, (Exception)((Object)e), new Object[0]);
                            result = false;
                        }
                    }
                    catch (IOException e) {
                        logger.error("error writing file: site: " + site + " path: " + emptyFilePath, e, new Object[0]);
                        result = false;
                    }
                }
                if (result) {
                    try {
                        commitId = helper.commitFile(repo, site, emptyFilePath.toString(), helper.getCommitMessage("studio.repo.createFolder.commitMessage").replaceAll("\\{site\\}", site).replaceAll("\\{path\\}", path + "/" + name), helper.getCurrentUserIdent());
                    }
                    catch (ServiceLayerException | UserNotFoundException e) {
                        logger.error("Unknown service error during commit for site: " + site + " path: " + emptyFilePath, e, new Object[0]);
                    }
                }
            }
        }
        catch (CryptoException e) {
            logger.error("Unexpected service error creating folder " + name + " for site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String deleteContent(String site, String path, String approver) {
        String commitId = null;
        boolean isPage = path.endsWith("/index.xml");
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                try (Git git = new Git(repo);){
                    String pathToDelete = helper.getGitPath(path);
                    Path parentToDelete = Paths.get(pathToDelete, new String[0]).getParent();
                    RmCommand rmCommand = git.rm().addFilepattern(pathToDelete).setCached(false);
                    this.retryingRepositoryOperationFacade.call(rmCommand);
                    String pathToCommit = pathToDelete;
                    if (isPage) {
                        pathToCommit = this.deleteParentFolder(git, parentToDelete, true);
                    }
                    commitId = helper.commitFile(repo, site, pathToCommit, helper.getCommitMessage("studio.repo.deleteContent.commitMessage").replaceAll("\\{path\\}", path), StringUtils.isEmpty((CharSequence)approver) ? helper.getCurrentUserIdent() : helper.getAuthorIdent(approver));
                }
            }
        }
        catch (IOException | UserNotFoundException | GitAPIException e) {
            logger.error("Error while deleting content for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        catch (CryptoException | ServiceLayerException e) {
            logger.error("Unknown service error during delete for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    private String deleteParentFolder(Git git, Path parentFolder, boolean wasPage) throws GitAPIException, CryptoException, IOException {
        String parent;
        String toRet = parent = parentFolder.toString();
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        String folderToDelete = helper.getGitPath(parent);
        Path toDelete = Paths.get(git.getRepository().getDirectory().getParent(), parent);
        List dirs = Files.walk(toDelete, new FileVisitOption[0]).filter(x -> !x.equals(toDelete)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(y -> y.getFileName().toString()).collect(Collectors.toList());
        List files = Files.walk(toDelete, 1, new FileVisitOption[0]).filter(x -> !x.equals(toDelete)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(y -> y.getFileName().toString()).collect(Collectors.toList());
        if (wasPage || CollectionUtils.isEmpty(dirs) && (CollectionUtils.isEmpty(files) || files.size() < 2 && ((String)files.get(0)).equals(".keep"))) {
            if (CollectionUtils.isNotEmpty(dirs)) {
                for (String child : dirs) {
                    Path childToDelete = Paths.get(folderToDelete, child);
                    this.deleteParentFolder(git, childToDelete, false);
                    RmCommand rmCommand = git.rm().addFilepattern(folderToDelete + "/" + child + "/" + "*").setCached(false);
                    this.retryingRepositoryOperationFacade.call(rmCommand);
                }
            }
            if (CollectionUtils.isNotEmpty(files)) {
                for (String child : files) {
                    git.rm().addFilepattern(folderToDelete + "/" + child).setCached(false).call();
                }
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> moveContent(String site, String fromPath, String toPath, String newName) {
        TreeMap<String, String> toRet = new TreeMap<String, String>();
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                String gitFromPath = helper.getGitPath(fromPath);
                String gitToPath = StringUtils.isEmpty((CharSequence)newName) ? helper.getGitPath(toPath) : helper.getGitPath(toPath + "/" + newName);
                try (Git git = new Git(repo);){
                    Path sourcePath = Paths.get(repo.getDirectory().getParent(), gitFromPath);
                    File sourceFile = sourcePath.toFile();
                    Path targetPath = Paths.get(repo.getDirectory().getParent(), gitToPath);
                    File targetFile = targetPath.toFile();
                    if (sourceFile.getCanonicalFile().equals(targetFile.getCanonicalFile())) {
                        sourceFile.renameTo(targetFile);
                    } else if (targetFile.isFile()) {
                        if (sourceFile.isFile()) {
                            sourceFile.renameTo(targetFile);
                        } else {
                            logger.error("Invalid move operation: Trying to rename a directory to a file for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: " + newName, new Object[0]);
                        }
                    } else if (sourceFile.isDirectory()) {
                        File[] dirList;
                        for (File child : dirList = sourceFile.listFiles()) {
                            if (child.equals(sourceFile)) continue;
                            FileUtils.moveToDirectory((File)child, (File)targetFile, (boolean)true);
                        }
                        FileUtils.deleteDirectory((File)sourceFile);
                    } else if (sourceFile.isFile()) {
                        FileUtils.moveFile((File)sourceFile, (File)targetFile);
                    } else {
                        FileUtils.moveToDirectory((File)sourceFile, (File)targetFile, (boolean)true);
                    }
                    AddCommand addCommand = git.add().addFilepattern(gitToPath);
                    this.retryingRepositoryOperationFacade.call(addCommand);
                    StatusCommand statusCommand = git.status().addPath(gitToPath);
                    Status gitStatus = (Status)this.retryingRepositoryOperationFacade.call(statusCommand);
                    Set changeSet = gitStatus.getAdded();
                    for (String pathToCommit : changeSet) {
                        String pathRemoved = pathToCommit.replace(gitToPath, gitFromPath);
                        CommitCommand commitCommand = git.commit().setOnly(pathToCommit).setOnly(pathRemoved).setAuthor(helper.getCurrentUserIdent()).setCommitter(helper.getCurrentUserIdent()).setMessage(helper.getCommitMessage("studio.repo.moveContent.commitMessage").replaceAll("\\{fromPath\\}", fromPath).replaceAll("\\{toPath\\}", toPath + (StringUtils.isNotEmpty((CharSequence)newName) ? newName : "")));
                        RevCommit commit = (RevCommit)this.retryingRepositoryOperationFacade.call(commitCommand);
                        String commitId = commit.getName();
                        toRet.put(pathToCommit, commitId);
                    }
                }
            }
        }
        catch (IOException | CryptoException | ServiceLayerException | UserNotFoundException | GitAPIException e) {
            logger.error("Error while moving content for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: " + newName, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copyContent(String site, String fromPath, String toPath) {
        String commitId = null;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                String gitFromPath = helper.getGitPath(fromPath);
                String gitToPath = helper.getGitPath(toPath);
                try (Git git = new Git(repo);){
                    Path sourcePath = Paths.get(repo.getDirectory().getParent(), fromPath);
                    File sourceFile = sourcePath.toFile();
                    Path targetPath = Paths.get(repo.getDirectory().getParent(), toPath);
                    File targetFile = targetPath.toFile();
                    FileUtils.copyDirectory((File)sourceFile, (File)targetFile);
                    git.add().addFilepattern(gitToPath).call();
                    CommitCommand commitCommand = git.commit().setOnly(gitFromPath).setOnly(gitToPath).setAuthor(helper.getCurrentUserIdent()).setCommitter(helper.getCurrentUserIdent()).setMessage(helper.getCommitMessage("studio.repo.copyContent.commitMessage").replaceAll("\\{fromPath\\}", fromPath).replaceAll("\\{toPath\\}", toPath));
                    RevCommit commit = (RevCommit)this.retryingRepositoryOperationFacade.call(commitCommand);
                    commitId = commit.getName();
                }
            }
        }
        catch (IOException | CryptoException | ServiceLayerException | UserNotFoundException | GitAPIException e) {
            logger.error("Error while copying content for site: " + site + " fromPath: " + fromPath + " toPath: " + toPath + " newName: ", new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    @Override
    public RepositoryItem[] getContentChildren(String site, String path) {
        ArrayList<RepositoryItem> retItems;
        block36: {
            retItems = new ArrayList<RepositoryItem>();
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                RevTree tree = helper.getTreeForLastCommit(repo);
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                    if (tw != null) {
                        ObjectLoader loader = repo.open((AnyObjectId)tw.getObjectId(0));
                        if (loader.getType() == 2) {
                            int depth = tw.getDepth();
                            tw.enterSubtree();
                            while (tw.next()) {
                                if (tw.getDepth() != depth + 1) continue;
                                RepositoryItem item = new RepositoryItem();
                                item.name = tw.getNameString();
                                String visitFolderPath = "/" + tw.getPathString();
                                loader = repo.open((AnyObjectId)tw.getObjectId(0));
                                item.isFolder = loader.getType() == 2;
                                int lastIdx = visitFolderPath.lastIndexOf("/" + item.name);
                                if (lastIdx > 0) {
                                    item.path = visitFolderPath.substring(0, lastIdx);
                                }
                                if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)item.name)) continue;
                                retItems.add(item);
                            }
                            tw.close();
                        } else {
                            logger.debug("Object is not tree for site: " + site + " path: " + path + " - it does not have children", new Object[0]);
                        }
                        break block36;
                    }
                    String gitPath = helper.getGitPath(path);
                    if (!StringUtils.isEmpty((CharSequence)gitPath) && !gitPath.equals(".")) break block36;
                    try (TreeWalk treeWalk = new TreeWalk(repo);){
                        treeWalk.addTree((AnyObjectId)tree);
                        while (treeWalk.next()) {
                            ObjectLoader loader = repo.open((AnyObjectId)treeWalk.getObjectId(0));
                            RepositoryItem item = new RepositoryItem();
                            item.name = treeWalk.getNameString();
                            String visitFolderPath = "/" + treeWalk.getPathString();
                            loader = repo.open((AnyObjectId)treeWalk.getObjectId(0));
                            item.isFolder = loader.getType() == 2;
                            int lastIdx = visitFolderPath.lastIndexOf("/" + item.name);
                            item.path = lastIdx > 0 ? visitFolderPath.substring(0, lastIdx) : "";
                            if (ArrayUtils.contains((Object[])GitContentRepositoryConstants.IGNORE_FILES, (Object)item.name)) continue;
                            retItems.add(item);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Error while getting children for site: " + site + " path: " + path, e, new Object[0]);
                    }
                }
                catch (IOException e) {
                    logger.error("Error while getting children for site: " + site + " path: " + path, e, new Object[0]);
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path, (Exception)e, new Object[0]);
            }
        }
        RepositoryItem[] items = new RepositoryItem[retItems.size()];
        items = retItems.toArray(items);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionTO[] getContentVersionHistory(String site, String path) {
        ArrayList<VersionTO> versionHistory = new ArrayList<VersionTO>();
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                ObjectId head = repo.resolve("HEAD");
                String gitPath = helper.getGitPath(path);
                try (Git git = new Git(repo);){
                    Iterable commits = git.log().add((AnyObjectId)head).addPath(gitPath).call();
                    for (RevCommit revCommit : commits) {
                        VersionTO versionTO = new VersionTO();
                        versionTO.setVersionNumber(revCommit.getName());
                        versionTO.setLastModifier(revCommit.getAuthorIdent().getName());
                        versionTO.setLastModifiedDate(Instant.ofEpochSecond(revCommit.getCommitTime()).atZone(ZoneOffset.UTC));
                        versionTO.setComment(revCommit.getFullMessage());
                        versionHistory.add(versionTO);
                    }
                }
                catch (IOException e) {
                    logger.error("error while getting history for content item " + path, new Object[0]);
                }
            }
        }
        catch (IOException | CryptoException | GitAPIException e) {
            logger.error("Failed to create Git repo for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
        VersionTO[] toRet = new VersionTO[versionHistory.size()];
        return versionHistory.toArray(toRet);
    }

    @Override
    public String createVersion(String site, String path, boolean majorVersion) {
        return this.createVersion(site, path, "", majorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createVersion(String site, String path, String comment, boolean majorVersion) {
        String toReturn;
        block24: {
            toReturn = "";
            String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
            this.generalLockService.lock(gitLockKey);
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                if (majorVersion) {
                    Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.PUBLISHED);
                    synchronized (repository) {
                        Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.PUBLISHED);
                        String gitPath = helper.getGitPath(path);
                        try (Git git = new Git(repo);){
                            PersonIdent currentUserIdent = helper.getCurrentUserIdent();
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HHmmssX");
                            Calendar cal = Calendar.getInstance();
                            String versionLabel = dateFormat.format(cal.getTime());
                            TagCommand tagCommand = git.tag().setName(versionLabel).setMessage(comment).setTagger(currentUserIdent);
                            this.retryingRepositoryOperationFacade.call(tagCommand);
                            toReturn = versionLabel;
                        }
                        catch (ServiceLayerException | UserNotFoundException | GitAPIException err) {
                            logger.error("error creating new version for site:  " + site + " path: " + path, (Exception)err, new Object[0]);
                        }
                        break block24;
                    }
                }
                logger.info("request to create minor revision ignored for site: " + site + " path: " + path, new Object[0]);
            }
            catch (CryptoException e) {
                logger.error("Unexpected error creating new version for site:  " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String revertContent(String site, String path, String version, boolean major, String comment) {
        String commitId = null;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        this.generalLockService.lock(gitLockKey);
        try {
            InputStream versionContent = this.getContentVersion(site, path, version);
            commitId = this.writeContent(site, path, versionContent);
            this.createVersion(site, path, major);
        }
        catch (ContentNotFoundException err) {
            logger.error("error reverting content for site:  " + site + " path: " + path, err, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return commitId;
    }

    @Override
    public InputStream getContentVersion(String site, String path, String version) throws ContentNotFoundException {
        ObjectStream toReturn;
        block17: {
            toReturn = null;
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                RevTree tree = helper.getTreeForCommit(repo, version);
                if (tree == null) break block17;
                try (TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)helper.getGitPath(path), (RevTree)tree);){
                    if (tw != null) {
                        ObjectId id = tw.getObjectId(0);
                        ObjectLoader objectLoader = repo.open((AnyObjectId)id);
                        toReturn = objectLoader.openStream();
                        tw.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Error while getting content for file at site: " + site + " path: " + path + " version: " + version, e, new Object[0]);
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Failed to create RevTree for site: " + site + " path: " + path + " version: " + version, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockItem(String site, String path) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                try (TreeWalk tw = new TreeWalk(repo);){
                    RevTree tree = helper.getTreeForLastCommit(repo);
                    tw.addTree((AnyObjectId)tree);
                    tw.setRecursive(false);
                    tw.setFilter((TreeFilter)PathFilter.create((String)path));
                    if (!tw.next()) {
                        return;
                    }
                    File repoRoot = repo.getWorkTree();
                    Paths.get(repoRoot.getPath(), tw.getPathString());
                    File file = new File(tw.getPathString());
                    LockFile lock = new LockFile(file);
                    lock.lock();
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error while locking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockItemForPublishing(String site, String path) {
        try {
            Repository repo;
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = repo = helper.getRepository(site, GitRepositories.PUBLISHED);
            synchronized (repository) {
                try (TreeWalk tw = new TreeWalk(repo);){
                    RevTree tree = helper.getTreeForLastCommit(repo);
                    tw.addTree((AnyObjectId)tree);
                    tw.setRecursive(false);
                    tw.setFilter((TreeFilter)PathFilter.create((String)path));
                    if (!tw.next()) {
                        return;
                    }
                    File repoRoot = repo.getWorkTree();
                    Paths.get(repoRoot.getPath(), tw.getPathString());
                    File file = new File(tw.getPathString());
                    LockFile lock = new LockFile(file);
                    lock.lock();
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error while locking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLockItem(String site, String path) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
            synchronized (repository) {
                try (TreeWalk tw = new TreeWalk(repo);){
                    RevTree tree = helper.getTreeForLastCommit(repo);
                    tw.addTree((AnyObjectId)tree);
                    tw.setRecursive(false);
                    tw.setFilter((TreeFilter)PathFilter.create((String)path));
                    if (!tw.next()) {
                        return;
                    }
                    File repoRoot = repo.getWorkTree();
                    Paths.get(repoRoot.getPath(), tw.getPathString());
                    File file = new File(tw.getPathString());
                    LockFile lock = new LockFile(file);
                    lock.unlock();
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error while unlocking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLockItemForPublishing(String site, String path) {
        try {
            Repository repo;
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = repo = helper.getRepository(site, GitRepositories.PUBLISHED);
            synchronized (repository) {
                try (TreeWalk tw = new TreeWalk(repo);){
                    RevTree tree = helper.getTreeForLastCommit(repo);
                    tw.addTree((AnyObjectId)tree);
                    tw.setRecursive(false);
                    tw.setFilter((TreeFilter)PathFilter.create((String)path));
                    if (!tw.next()) {
                        return;
                    }
                    File repoRoot = repo.getWorkTree();
                    Paths.get(repoRoot.getPath(), tw.getPathString());
                    File file = new File(tw.getPathString());
                    LockFile lock = new LockFile(file);
                    lock.unlock();
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error while unlocking file for site: " + site + " path: " + path, (Exception)e, new Object[0]);
        }
    }

    public void bootstrap() throws Exception {
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        if (Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.repo.bootstrapRepo")) && helper.createGlobalRepo()) {
            String bootstrapFolderPath = this.ctx.getRealPath("/repo-bootstrap/global");
            Path source = FileSystems.getDefault().getPath(bootstrapFolderPath, new String[0]);
            logger.info("Bootstrapping with baseline @ " + source.toFile().toString(), new Object[0]);
            Path globalConfigPath = helper.buildRepoPath(GitRepositories.GLOBAL);
            TreeCopier tc = new TreeCopier(source, globalConfigPath);
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(source, opts, Integer.MAX_VALUE, tc);
            String studioManifestLocation = this.ctx.getRealPath(STUDIO_MANIFEST_LOCATION);
            if (Files.exists(Paths.get(studioManifestLocation, new String[0]), new LinkOption[0])) {
                FileUtils.copyFile((File)Paths.get(studioManifestLocation, new String[0]).toFile(), (File)Paths.get(globalConfigPath.toAbsolutePath().toString(), this.studioConfiguration.getProperty("studio.repo.blueprintsPath"), "BLUEPRINTS.MF").toFile());
            }
            Repository globalConfigRepo = helper.getRepository("", GitRepositories.GLOBAL);
            try (Git git = new Git(globalConfigRepo);){
                Status status = git.status().call();
                if (status.hasUncommittedChanges() || !status.isClean()) {
                    AddCommand addCommand = git.add().addFilepattern(".");
                    this.retryingRepositoryOperationFacade.call(addCommand);
                    CommitCommand commitCommand = git.commit().setMessage(helper.getCommitMessage("studio.repo.initialCommit.commitMessage"));
                    this.retryingRepositoryOperationFacade.call(commitCommand);
                }
            }
            catch (GitAPIException err) {
                logger.error("error creating initial commit for global configuration", (Exception)((Object)err), new Object[0]);
            }
        }
        if (!helper.buildGlobalRepo()) {
            logger.error("Failed to create global repository!", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteSite(String site) {
        boolean toReturn;
        block16: {
            String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
            this.generalLockService.lock(gitLockKey);
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository != null) {
                    Repository repository2 = repository;
                    synchronized (repository2) {
                        Repository publishedRepository = helper.getRepository(site, GitRepositories.PUBLISHED);
                        if (publishedRepository != null) {
                            Repository repository3 = publishedRepository;
                            synchronized (repository3) {
                                toReturn = helper.deleteSiteGitRepo(site);
                            }
                        } else {
                            toReturn = helper.deleteSiteGitRepo(site);
                        }
                        break block16;
                    }
                }
                Path sitePath = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site);
                try {
                    FileUtils.deleteDirectory((File)sitePath.toFile());
                    toReturn = true;
                }
                catch (IOException e) {
                    logger.error("Error while deleting site " + site, e, new Object[0]);
                    toReturn = false;
                }
            }
            catch (CryptoException e) {
                logger.error("Error while deleting site " + site, (Exception)((Object)e), new Object[0]);
                toReturn = false;
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialPublish(String site, String sandboxBranch, String environment, String author, String comment) throws DeploymentException, CryptoException {
        String gitLockKey = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", site);
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(site, GitRepositories.PUBLISHED);
        String commitId = "";
        String sandboxBranchName = sandboxBranch;
        if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
            sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
        }
        this.generalLockService.lock(gitLockKey);
        Repository repository = repo;
        synchronized (repository) {
            try (Git git = new Git(repo);){
                CheckoutCommand checkoutCommand;
                logger.debug("Fetch from sandbox for site " + site, new Object[0]);
                git.fetch().call();
                logger.debug("Checkout published/master branch for site " + site, new Object[0]);
                try {
                    checkoutCommand = git.checkout().setName(sandboxBranchName);
                    this.retryingRepositoryOperationFacade.call(checkoutCommand);
                    PullCommand pullCommand = git.pull().setRemote("origin").setRemoteBranchName(sandboxBranchName).setStrategy(MergeStrategy.THEIRS);
                    this.retryingRepositoryOperationFacade.call(pullCommand);
                }
                catch (RefNotFoundException e) {
                    logger.error("Failed to checkout published master and to pull content from sandbox for site " + site, (Exception)((Object)e), new Object[0]);
                    throw new DeploymentException("Failed to checkout published master and to pull content from sandbox for site " + site);
                }
                logger.debug("Checkout environment branch " + environment + " for site " + site, new Object[0]);
                try {
                    checkoutCommand = git.checkout().setCreateBranch(true).setForce(true).setStartPoint(sandboxBranchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setName(environment);
                    this.retryingRepositoryOperationFacade.call(checkoutCommand);
                }
                catch (RefNotFoundException e) {
                    logger.info("Not able to find branch " + environment + " for site " + site + ". Creating new branch", new Object[0]);
                }
                PersonIdent authorIdent = helper.getAuthorIdent(author);
                ZonedDateTime publishDate = ZonedDateTime.now(ZoneOffset.UTC);
                String tagName = publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX")) + "_published_on_" + publishDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmmssSSSX"));
                TagCommand tagCommand = git.tag().setTagger(authorIdent).setName(tagName).setMessage(comment);
                this.retryingRepositoryOperationFacade.call(tagCommand);
            }
            catch (Exception e) {
                logger.error("Error when publishing site " + site + " to environment " + environment, e, new Object[0]);
                throw new DeploymentException("Error when publishing site " + site + " to environment " + environment + " [commit ID = " + commitId + "]");
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepoLastCommitId(String site) {
        String toReturn;
        block6: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block6;
                Repository repository2 = repository;
                synchronized (repository2) {
                    Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                    ObjectId commitId = repo.resolve("HEAD");
                    if (commitId != null) {
                        toReturn = commitId.getName();
                    }
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Error getting last commit ID for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRepoFirstCommitId(String site) {
        String toReturn;
        block19: {
            toReturn = "";
            try {
                GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
                Repository repository = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                if (repository == null) break block19;
                Repository repository2 = repository;
                synchronized (repository2) {
                    Repository repo = helper.getRepository(site, StringUtils.isEmpty((CharSequence)site) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX);
                    if (repo != null) {
                        try (RevWalk rw = new RevWalk(repo);){
                            ObjectId head = repo.resolve("HEAD");
                            if (head != null) {
                                RevCommit root = rw.parseCommit((AnyObjectId)head);
                                rw.sort(RevSort.REVERSE);
                                rw.markStart(root);
                                RevCommit first = rw.next();
                                toReturn = first.getName();
                                logger.debug("getRepoFirstCommitId for site: " + site + " First commit ID: " + toReturn, new Object[0]);
                            }
                        }
                    }
                }
            }
            catch (IOException | CryptoException e) {
                logger.error("Error getting first commit ID for site " + site, (Exception)e, new Object[0]);
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEditCommitIds(String site, String path, String commitIdFrom, String commitIdTo) {
        ArrayList<String> commitIds = new ArrayList<String>();
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(site, GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(site, GitRepositories.SANDBOX);
                if (StringUtils.isEmpty((CharSequence)commitIdFrom)) {
                    commitIdFrom = this.getRepoFirstCommitId(site);
                }
                if (StringUtils.isEmpty((CharSequence)commitIdTo)) {
                    commitIdTo = this.getRepoLastCommitId(site);
                }
                ObjectId objCommitIdFrom = repo.resolve(commitIdFrom);
                ObjectId objCommitIdTo = repo.resolve(commitIdTo);
                try (Git git = new Git(repo);){
                    if (!objCommitIdFrom.equals((AnyObjectId)objCommitIdTo)) {
                        Iterable commits = git.log().addPath(helper.getGitPath(path)).addRange((AnyObjectId)objCommitIdFrom, (AnyObjectId)objCommitIdTo).call();
                        for (RevCommit commit : commits) {
                            commitIds.add(0, commit.getId().getName());
                        }
                    }
                }
                catch (GitAPIException e) {
                    logger.error("Error getting commit ids for site " + site + " and path " + path + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)((Object)e), new Object[0]);
                }
            }
        }
        catch (IOException | CryptoException e) {
            logger.error("Error getting operations for site " + site + " and path " + path + " from commit ID: " + commitIdFrom + " to commit ID: " + commitIdTo, (Exception)e, new Object[0]);
        }
        return commitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertFullGitLog(String siteId, int processed) {
        ArrayList<GitLog> gitLogs = new ArrayList<GitLog>();
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repository = helper.getRepository(siteId, GitRepositories.SANDBOX);
            synchronized (repository) {
                Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
                try (Git git = new Git(repo);){
                    Iterable logs = git.log().call();
                    for (RevCommit rev : logs) {
                        GitLog gitLog = new GitLog();
                        gitLog.setCommitId(rev.getId().getName());
                        gitLog.setProcessed(processed);
                        gitLog.setSiteId(siteId);
                        gitLogs.add(gitLog);
                    }
                }
            }
        }
        catch (CryptoException | GitAPIException e) {
            logger.error("Error getting full git log for site " + siteId, (Exception)e, new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("gitLogs", gitLogs);
        params.put("processed", 1);
        this.gitLogDao.insertGitLogList(params);
    }

    @Override
    @RetryingOperation
    public void deleteGitLogForSite(String siteId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        this.gitLogDao.deleteGitLogForSite(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createSitePushToRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, final String remotePrivateKey, boolean createAsOrphan) throws InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, ServiceLayerException {
        boolean toRet = true;
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            try (Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);){
                try (Git git = new Git(repo);){
                    RemoteRefUpdate update;
                    PushResult pushResult;
                    Iterator remoteRefUpdateIterator;
                    boolean pkauth = false;
                    final Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    PushCommand pushCommand = git.push();
                    switch (authenticationType) {
                        case "none": {
                            logger.debug("No authentication", new Object[0]);
                            break;
                        }
                        case "basic": {
                            logger.debug("Basic authentication", new Object[0]);
                            pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteUsername, remotePassword));
                            break;
                        }
                        case "token": {
                            logger.debug("Token based authentication", new Object[0]);
                            pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                            break;
                        }
                        case "key": {
                            logger.debug("Private key authentication", new Object[0]);
                            tempKey.toFile().deleteOnExit();
                            pushCommand.setTransportConfigCallback(new TransportConfigCallback(){

                                public void configure(Transport transport) {
                                    SshTransport sshTransport = (SshTransport)transport;
                                    sshTransport.setSshSessionFactory(GitContentRepository.this.getSshSessionFactory(remotePrivateKey, tempKey));
                                }
                            });
                            pkauth = true;
                            break;
                        }
                        default: {
                            throw new ServiceLayerException("Unsupported authentication type " + authenticationType);
                        }
                    }
                    logger.debug("Push site " + siteId + " to remote repository " + remoteName + "(" + remoteUrl + ")", new Object[0]);
                    pushCommand.setPushAll().setRemote(remoteName);
                    Iterable result = (Iterable)this.retryingRepositoryOperationFacade.call(pushCommand);
                    if (pkauth) {
                        Files.delete(tempKey);
                    }
                    logger.debug("Check push result to verify it was success", new Object[0]);
                    Iterator resultIter = result.iterator();
                    if (resultIter.hasNext() && (remoteRefUpdateIterator = (pushResult = (PushResult)resultIter.next()).getRemoteUpdates().iterator()).hasNext() && (update = (RemoteRefUpdate)remoteRefUpdateIterator.next()).getStatus().equals((Object)RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD)) {
                        logger.error("Remote repository: " + remoteName + " (" + remoteUrl + ") is not bare repository", new Object[0]);
                        throw new RemoteRepositoryNotBareException("Remote repository: " + remoteName + " (" + remoteUrl + ") is not bare repository");
                    }
                }
                catch (InvalidRemoteException e) {
                    logger.error("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                    throw new InvalidRemoteRepositoryException("Invalid remote repository: " + remoteName + " (" + remoteUrl + ")");
                }
                catch (TransportException e) {
                    if (StringUtils.endsWithIgnoreCase((CharSequence)e.getMessage(), (CharSequence)"not authorized")) {
                        logger.error("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                        throw new InvalidRemoteRepositoryCredentialsException("Bad credentials or read only repository: " + remoteName + " (" + remoteUrl + ") for username " + remoteUsername, e);
                    }
                    logger.error("Remote repository not found: " + remoteName + " (" + remoteUrl + ")", (Exception)((Object)e), new Object[0]);
                    throw new RemoteRepositoryNotFoundException("Remote repository not found: " + remoteName + " (" + remoteUrl + ")");
                }
                catch (ClassCastException e) {
                    logger.error("Wrong protocol used to access repository: " + remoteName + " (" + remoteUrl + ")", e, new Object[0]);
                    throw new InvalidRemoteRepositoryCredentialsException("Wrong protocol used to access repository: " + remoteName + " (" + remoteUrl + ")", e);
                }
                catch (IOException | ServiceLayerException e) {
                    logger.error("Failed to push newly created site " + siteId + " to remote repository " + remoteUrl, e, new Object[0]);
                    throw new ServiceLayerException(e);
                }
            }
        }
        catch (CryptoException | GitAPIException e) {
            logger.error("Failed to push newly created site " + siteId + " to remote repository " + remoteUrl, (Exception)e, new Object[0]);
            toRet = false;
        }
        finally {
            this.generalLockService.unlock(gitLockKey);
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteUrlException, ServiceLayerException {
        boolean isValid = false;
        try {
            logger.debug("Add remote " + remoteName + " to the sandbox repo for the site " + siteId, new Object[0]);
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
            try (Git git = new Git(repo);){
                StoredConfig storedConfig = repo.getConfig();
                Set remotes = storedConfig.getSubsections("remote");
                if (remotes.contains(remoteName)) {
                    throw new RemoteAlreadyExistsException(remoteName);
                }
                RemoteAddCommand remoteAddCommand = git.remoteAdd();
                remoteAddCommand.setName(remoteName);
                remoteAddCommand.setUri(new URIish(remoteUrl));
                this.retryingRepositoryOperationFacade.call(remoteAddCommand);
                try {
                    isValid = this.isRemoteValid(git, remoteName, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                }
                finally {
                    if (!isValid) {
                        RemoteRemoveCommand remoteRemoveCommand = git.remoteRemove();
                        remoteRemoveCommand.setRemoteName(remoteName);
                        this.retryingRepositoryOperationFacade.call(remoteRemoveCommand);
                        List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                        ArrayList<String> branchesToDelete = new ArrayList<String>();
                        for (Ref remoteBranchRef : resultRemoteBranches) {
                            if (!remoteBranchRef.getName().startsWith("refs/remotes/" + remoteName)) continue;
                            branchesToDelete.add(remoteBranchRef.getName());
                        }
                        if (CollectionUtils.isNotEmpty(branchesToDelete)) {
                            DeleteBranchCommand delBranch = git.branchDelete();
                            String[] array = new String[branchesToDelete.size()];
                            delBranch.setBranchNames(branchesToDelete.toArray(array));
                            delBranch.setForce(true);
                            this.retryingRepositoryOperationFacade.call(delBranch);
                        }
                    }
                }
            }
            catch (ClassCastException | URISyntaxException e) {
                logger.error("Remote URL is invalid " + remoteUrl, e, new Object[0]);
                throw new InvalidRemoteUrlException("Remote URL is invalid " + remoteUrl, e);
            }
            catch (IOException | GitAPIException e) {
                logger.error("Error while adding remote " + remoteName + " (url: " + remoteUrl + ") for site " + siteId, (Exception)e, new Object[0]);
                throw new ServiceLayerException("Error while adding remote " + remoteName + " (url: " + remoteUrl + ") for site " + siteId, (Exception)e);
            }
            if (isValid) {
                this.insertRemoteToDb(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
            }
        }
        catch (CryptoException e) {
            throw new ServiceLayerException(e);
        }
        return isValid;
    }

    private boolean isRemoteValid(Git git, String remote, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, final String remotePrivateKey) throws CryptoException, IOException, ServiceLayerException, GitAPIException {
        LsRemoteCommand lsRemoteCommand = git.lsRemote();
        lsRemoteCommand.setRemote(remote);
        switch (authenticationType) {
            case "none": {
                logger.debug("No authentication", new Object[0]);
                break;
            }
            case "basic": {
                logger.debug("Basic authentication", new Object[0]);
                lsRemoteCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteUsername, remotePassword));
                break;
            }
            case "token": {
                logger.debug("Token based authentication", new Object[0]);
                lsRemoteCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                break;
            }
            case "key": {
                logger.debug("Private key authentication", new Object[0]);
                final Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                tempKey.toFile().deleteOnExit();
                lsRemoteCommand.setTransportConfigCallback(new TransportConfigCallback(){

                    public void configure(Transport transport) {
                        SshTransport sshTransport = (SshTransport)transport;
                        sshTransport.setSshSessionFactory(GitContentRepository.this.getSshSessionFactory(remotePrivateKey, tempKey));
                    }
                });
                Files.delete(tempKey);
                break;
            }
            default: {
                throw new ServiceLayerException("Unsupported authentication type " + authenticationType);
            }
        }
        lsRemoteCommand.call();
        return true;
    }

    private void insertRemoteToDb(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws CryptoException {
        logger.debug("Inserting remote " + remoteName + " for site " + siteId + " into database.", new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        params.put("remoteUrl", remoteUrl);
        params.put("authenticationType", authenticationType);
        params.put("remoteUsername", remoteUsername);
        if (StringUtils.isNotEmpty((CharSequence)remotePassword)) {
            logger.debug("Encrypt password before inserting to database", new Object[0]);
            String hashedPassword = this.encryptor.encrypt(remotePassword);
            params.put("remotePassword", hashedPassword);
        } else {
            params.put("remotePassword", remotePassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteToken)) {
            logger.debug("Encrypt token before inserting to database", new Object[0]);
            String hashedToken = this.encryptor.encrypt(remoteToken);
            params.put("remoteToken", hashedToken);
        } else {
            params.put("remoteToken", remoteToken);
        }
        if (StringUtils.isNotEmpty((CharSequence)remotePrivateKey)) {
            logger.debug("Encrypt private key before inserting to database", new Object[0]);
            String hashedPrivateKey = this.encryptor.encrypt(remotePrivateKey);
            params.put("remotePrivateKey", hashedPrivateKey);
        } else {
            params.put("remotePrivateKey", remotePrivateKey);
        }
        logger.debug("Insert site remote record into database", new Object[0]);
        this.remoteRepositoryDAO.insertRemoteRepository(params);
        params = new HashMap();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        RemoteRepository remoteRepository = this.remoteRepositoryDAO.getRemoteRepository(params);
        if (remoteRepository != null) {
            this.insertClusterRemoteRepository(remoteRepository);
        }
    }

    public void insertClusterRemoteRepository(RemoteRepository remoteRepository) {
        String localAddress;
        ClusterMember member;
        HierarchicalConfiguration<ImmutableNode> registrationData = this.studioConfiguration.getSubConfig("studio.clustering.node.registration");
        if (registrationData != null && !registrationData.isEmpty() && (member = this.clusterDao.getMemberByLocalAddress(localAddress = registrationData.getString("localAddress"))) != null) {
            this.retryingOperationFacade.addClusterRemoteRepository(member.getId(), remoteRepository.getId());
        }
    }

    @Override
    @RetryingOperation
    public void removeRemoteRepositoriesForSite(String siteId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        this.remoteRepositoryDAO.deleteRemoteRepositoriesForSite(params);
    }

    @Override
    public List<RemoteRepositoryInfoTO> listRemote(String siteId, String sandboxBranch) throws ServiceLayerException, CryptoException {
        ArrayList<RemoteRepositoryInfoTO> res = new ArrayList<RemoteRepositoryInfoTO>();
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        try (Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);){
            try (Git git = new Git(repo);){
                List resultRemotes = git.remoteList().call();
                if (CollectionUtils.isNotEmpty((Collection)resultRemotes)) {
                    block32: for (RemoteConfig conf : resultRemotes) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("siteId", siteId);
                        params.put("remoteName", conf.getName());
                        RemoteRepository remoteRepository = this.remoteRepositoryDAO.getRemoteRepository(params);
                        if (remoteRepository == null) continue;
                        switch (remoteRepository.getAuthenticationType()) {
                            case "none": {
                                logger.debug("No authentication", new Object[0]);
                                git.fetch().setRemote(conf.getName()).call();
                                continue block32;
                            }
                            case "basic": {
                                logger.debug("Basic authentication", new Object[0]);
                                String hashedPassword = remoteRepository.getRemotePassword();
                                String password = this.encryptor.decrypt(hashedPassword);
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteRepository.getRemoteUsername(), password))).call();
                                continue block32;
                            }
                            case "token": {
                                logger.debug("Token based authentication", new Object[0]);
                                String hashedToken = remoteRepository.getRemoteToken();
                                String remoteToken = this.encryptor.decrypt(hashedToken);
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""))).call();
                                continue block32;
                            }
                            case "key": {
                                logger.debug("Private key authentication", new Object[0]);
                                final Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                                String hashedPrivateKey = remoteRepository.getRemotePrivateKey();
                                final String privateKey = this.encryptor.decrypt(hashedPrivateKey);
                                tempKey.toFile().deleteOnExit();
                                ((FetchCommand)git.fetch().setRemote(conf.getName()).setTransportConfigCallback(new TransportConfigCallback(){

                                    public void configure(Transport transport) {
                                        SshTransport sshTransport = (SshTransport)transport;
                                        sshTransport.setSshSessionFactory(GitContentRepository.this.getSshSessionFactory(privateKey, tempKey));
                                    }
                                })).call();
                                Files.delete(tempKey);
                                continue block32;
                            }
                        }
                        throw new ServiceLayerException("Unsupported authentication type " + remoteRepository.getAuthenticationType());
                    }
                    List resultRemoteBranches = git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
                    HashMap remoteBranches = new HashMap();
                    for (Ref remoteBranchRef : resultRemoteBranches) {
                        String branchFullName = remoteBranchRef.getName().replace("refs/remotes/", "");
                        String remotePart = "";
                        String branchNamePart = "";
                        int slashIndex = branchFullName.indexOf("/");
                        if (slashIndex > 0) {
                            remotePart = branchFullName.substring(0, slashIndex);
                            branchNamePart = branchFullName.substring(slashIndex + 1);
                        }
                        if (!remoteBranches.containsKey(remotePart)) {
                            remoteBranches.put(remotePart, new ArrayList());
                        }
                        ((List)remoteBranches.get(remotePart)).add(branchNamePart);
                    }
                    String sandboxBranchName = sandboxBranch;
                    if (StringUtils.isEmpty((CharSequence)sandboxBranchName)) {
                        sandboxBranchName = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
                    }
                    for (RemoteConfig conf : resultRemotes) {
                        RemoteRepositoryInfoTO rri = new RemoteRepositoryInfoTO();
                        rri.setName(conf.getName());
                        ArrayList<String> branches = (ArrayList<String>)remoteBranches.get(rri.getName());
                        if (CollectionUtils.isEmpty((Collection)branches)) {
                            branches = new ArrayList<String>();
                            branches.add(sandboxBranchName);
                        }
                        rri.setBranches((List<String>)branches);
                        StringBuilder sbUrl = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getURIs())) {
                            for (int i = 0; i < conf.getURIs().size(); ++i) {
                                sbUrl.append(((URIish)conf.getURIs().get(i)).toString());
                                if (i >= conf.getURIs().size() - 1) continue;
                                sbUrl.append(":");
                            }
                        }
                        rri.setUrl(sbUrl.toString());
                        StringBuilder sbFetch = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getFetchRefSpecs())) {
                            for (int i = 0; i < conf.getFetchRefSpecs().size(); ++i) {
                                sbFetch.append(((RefSpec)conf.getFetchRefSpecs().get(i)).toString());
                                if (i >= conf.getFetchRefSpecs().size() - 1) continue;
                                sbFetch.append(":");
                            }
                        }
                        rri.setFetch(sbFetch.toString());
                        StringBuilder sbPushUrl = new StringBuilder();
                        if (CollectionUtils.isNotEmpty((Collection)conf.getPushURIs())) {
                            for (int i = 0; i < conf.getPushURIs().size(); ++i) {
                                sbPushUrl.append(((URIish)conf.getPushURIs().get(i)).toString());
                                if (i >= conf.getPushURIs().size() - 1) continue;
                                sbPushUrl.append(":");
                            }
                        } else {
                            sbPushUrl.append(rri.getUrl());
                        }
                        rri.setPush_url(sbPushUrl.toString());
                        res.add(rri);
                    }
                }
            }
            catch (IOException | CryptoException | GitAPIException e) {
                logger.error("Error getting remote repositories for site " + siteId, (Exception)e, new Object[0]);
            }
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean pushToRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException {
        logger.debug("Get remote data from database for remote " + remoteName + " and site " + siteId, new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", siteId);
        params.put("remoteName", remoteName);
        RemoteRepository remoteRepository = this.remoteRepositoryDAO.getRemoteRepository(params);
        logger.debug("Prepare push command.", new Object[0]);
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.SANDBOX);
        try (Git git = new Git(repo);){
            Iterable pushResultIterable = null;
            PushCommand pushCommand = git.push();
            logger.debug("Set remote " + remoteName, new Object[0]);
            pushCommand.setRemote(remoteRepository.getRemoteName());
            logger.debug("Set branch to be " + remoteBranch, new Object[0]);
            RefSpec r = new RefSpec();
            r = r.setSourceDestination("refs/heads/" + repo.getBranch(), "refs/heads/" + remoteBranch);
            pushCommand.setRefSpecs(new RefSpec[]{r});
            switch (remoteRepository.getAuthenticationType()) {
                case "none": {
                    logger.debug("No authentication", new Object[0]);
                    pushResultIterable = pushCommand.call();
                    break;
                }
                case "basic": {
                    logger.debug("Basic authentication", new Object[0]);
                    String hashedPassword = remoteRepository.getRemotePassword();
                    String password = this.encryptor.decrypt(hashedPassword);
                    pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteRepository.getRemoteUsername(), password));
                    pushResultIterable = pushCommand.call();
                    break;
                }
                case "token": {
                    logger.debug("Token based authentication", new Object[0]);
                    String hashedToken = remoteRepository.getRemoteToken();
                    String remoteToken = this.encryptor.decrypt(hashedToken);
                    pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(remoteToken, ""));
                    pushResultIterable = pushCommand.call();
                    break;
                }
                case "key": {
                    logger.debug("Private key authentication", new Object[0]);
                    final Path tempKey = Files.createTempFile(UUID.randomUUID().toString(), ".tmp", new FileAttribute[0]);
                    String hashedPrivateKey = remoteRepository.getRemotePrivateKey();
                    final String privateKey = this.encryptor.decrypt(hashedPrivateKey);
                    tempKey.toFile().deleteOnExit();
                    pushCommand.setTransportConfigCallback(new TransportConfigCallback(){

                        public void configure(Transport transport) {
                            SshTransport sshTransport = (SshTransport)transport;
                            sshTransport.setSshSessionFactory(GitContentRepository.this.getSshSessionFactory(privateKey, tempKey));
                        }
                    });
                    pushResultIterable = (Iterable)this.retryingRepositoryOperationFacade.call(pushCommand);
                    Files.delete(tempKey);
                    break;
                }
                default: {
                    throw new ServiceLayerException("Unsupported authentication type " + remoteRepository.getAuthenticationType());
                }
            }
            boolean toRet = true;
            List<RemoteRefUpdate.Status> failure = Arrays.asList(RemoteRefUpdate.Status.REJECTED_NODELETE, RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD, RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED, RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            for (PushResult pushResult : pushResultIterable) {
                Collection updates = pushResult.getRemoteUpdates();
                for (RemoteRefUpdate remoteRefUpdate : updates) {
                    if (toRet = toRet && !failure.contains(remoteRefUpdate.getStatus())) continue;
                }
                if (toRet) continue;
            }
            boolean bl = toRet;
            return bl;
        }
        catch (InvalidRemoteException e) {
            logger.error("Remote is invalid " + remoteName, (Exception)((Object)e), new Object[0]);
            throw new InvalidRemoteUrlException();
        }
        catch (IOException | CryptoException | GitAPIException | JGitInternalException e) {
            logger.error("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e, new Object[0]);
            throw new ServiceLayerException("Error while pushing to remote " + remoteName + " branch " + remoteBranch + " for site " + siteId, (Exception)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean pullFromRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, CryptoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SshSessionFactory getSshSessionFactory(String privateKey, final Path tempKey) {
        try {
            Files.write(tempKey, privateKey.getBytes(), new OpenOption[0]);
            JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    Properties config = new Properties();
                    config.put("StrictHostKeyChecking", "no");
                    session.setConfig(config);
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch defaultJSch = new JSch();
                    defaultJSch.addIdentity(tempKey.toAbsolutePath().toString());
                    return defaultJSch;
                }
            };
            return sshSessionFactory;
        }
        catch (IOException e) {
            logger.error("Failed to create private key for SSH connection.", e, new Object[0]);
            return null;
        }
    }

    @Override
    public boolean isFolder(String siteId, String path) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Path p = Paths.get(helper.buildRepoPath(StringUtils.isEmpty((CharSequence)siteId) ? GitRepositories.GLOBAL : GitRepositories.SANDBOX, siteId).toAbsolutePath().toString(), path);
            File file = p.toFile();
            return file.isDirectory();
        }
        catch (CryptoException e) {
            logger.error("Unexpected error checking if path is folder for site: " + siteId + " and path: " + path, new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStagingRepository(String siteId) throws ServiceLayerException, CryptoException {
        GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
        Repository repo = helper.getRepository(siteId, GitRepositories.PUBLISHED);
        String stagingName = this.servicesConfig.getStagingEnvironment(siteId);
        String liveName = this.servicesConfig.getLiveEnvironment(siteId);
        String gitLockKey = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKey);
        Repository repository = repo;
        synchronized (repository) {
            try (Git git = new Git(repo);){
                logger.debug("Checkout live first becuase it is not allowed to delete checkedout branch", new Object[0]);
                CheckoutCommand checkoutCommand = git.checkout().setName(liveName);
                this.retryingRepositoryOperationFacade.call(checkoutCommand);
                logger.debug("Delete staging branch in order to reset it for site: " + siteId, new Object[0]);
                DeleteBranchCommand deleteBranchCommand = git.branchDelete().setBranchNames(new String[]{stagingName}).setForce(true);
                this.retryingRepositoryOperationFacade.call(deleteBranchCommand);
                logger.debug("Create new branch for staging with live HEAD as starting point", new Object[0]);
                CreateBranchCommand createBranchCommand = git.branchCreate().setName(stagingName).setStartPoint(liveName);
                this.retryingRepositoryOperationFacade.call(createBranchCommand);
            }
            catch (GitAPIException e) {
                logger.error("Error while reseting staging environment for site: " + siteId, new Object[0]);
                throw new ServiceLayerException(e);
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
    }

    @Override
    public void reloadRepository(String siteId) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            helper.removeSandbox(siteId);
            helper.getRepository(siteId, GitRepositories.SANDBOX);
        }
        catch (CryptoException e) {
            logger.error("Unexpected error reloading repository for site " + siteId, new Object[0]);
        }
    }

    protected void cleanup(String siteId, GitRepositories repository) {
        try {
            GitRepositoryHelper helper = GitRepositoryHelper.getHelper(this.studioConfiguration, this.securityService, this.userServiceInternal, this.encryptor, this.generalLockService, this.retryingRepositoryOperationFacade);
            Repository sandbox = helper.getRepository(siteId, repository);
            try (Git git = new Git(sandbox);){
                GarbageCollectCommand garbageCollectCommand = git.gc();
                this.retryingRepositoryOperationFacade.call(garbageCollectCommand);
            }
        }
        catch (Exception e) {
            logger.warn("Error cleaning up repository for site " + siteId, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupRepositories(String siteId) {
        if (StringUtils.isEmpty((CharSequence)siteId)) {
            logger.info("Cleaning up global repository", new Object[0]);
            String gitLockKey = "GLOBAL_REPOSITORY_GIT_LOCK";
            this.generalLockService.lock(gitLockKey);
            try {
                this.cleanup(siteId, GitRepositories.GLOBAL);
            }
            finally {
                this.generalLockService.unlock(gitLockKey);
            }
        }
        logger.info("Cleaning up repositories for site {0}", siteId);
        String gitLockKeySandbox = "{site}_SANDBOX_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        String gitLockKeyPublished = "{site}_PUBLISHED_REPOSITORY_GIT_LOCK".replaceAll("\\{site\\}", siteId);
        this.generalLockService.lock(gitLockKeySandbox);
        try {
            this.cleanup(siteId, GitRepositories.SANDBOX);
        }
        finally {
            this.generalLockService.unlock(gitLockKeySandbox);
        }
        this.generalLockService.lock(gitLockKeyPublished);
        try {
            this.cleanup(siteId, GitRepositories.PUBLISHED);
        }
        finally {
            this.generalLockService.unlock(gitLockKeyPublished);
        }
    }

    public void setServletContext(ServletContext ctx) {
        this.ctx = ctx;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public GitLogDAO getGitLogDao() {
        return this.gitLogDao;
    }

    public void setGitLogDao(GitLogDAO gitLogDao) {
        this.gitLogDao = gitLogDao;
    }

    public RemoteRepositoryDAO getRemoteRepositoryDAO() {
        return this.remoteRepositoryDAO;
    }

    public void setRemoteRepositoryDAO(RemoteRepositoryDAO remoteRepositoryDAO) {
        this.remoteRepositoryDAO = remoteRepositoryDAO;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public SiteFeedMapper getSiteFeedMapper() {
        return this.siteFeedMapper;
    }

    public void setSiteFeedMapper(SiteFeedMapper siteFeedMapper) {
        this.siteFeedMapper = siteFeedMapper;
    }

    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDao) {
        this.clusterDao = clusterDao;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }

    public RetryingRepositoryOperationFacade getRetryingRepositoryOperationFacade() {
        return this.retryingRepositoryOperationFacade;
    }

    public void setRetryingRepositoryOperationFacade(RetryingRepositoryOperationFacade retryingRepositoryOperationFacade) {
        this.retryingRepositoryOperationFacade = retryingRepositoryOperationFacade;
    }
}

