/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.job;

import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.springframework.beans.factory.annotation.Required;

public class RepositoryCleanupJob {
    protected static final Logger logger = LoggerFactory.getLogger(RepositoryCleanupJob.class);
    protected SiteService siteService;
    protected ContentRepository contentRepository;

    public void cleanupAllRepositories() {
        logger.info("Starting cleanup for global repo", new Object[0]);
        this.contentRepository.cleanupRepositories("");
        logger.info("Starting cleanup for all sites", new Object[0]);
        this.siteService.getAllAvailableSites().forEach(this.contentRepository::cleanupRepositories);
    }

    @Required
    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    @Required
    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

