/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.repository.job;

import java.util.concurrent.locks.ReentrantLock;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.springframework.core.task.TaskExecutor;

public class SyncDatabaseWithRepository {
    private static final Logger logger = LoggerFactory.getLogger(SyncDatabaseWithRepository.class);
    private static ReentrantLock taskLock = new ReentrantLock();
    protected SecurityService securityService;
    protected TaskExecutor taskExecutor;
    protected SiteService siteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String site, String lastDbCommitId) {
        if (taskLock.tryLock()) {
            try {
                logger.debug("Starting Sync Database With Repository Task.", new Object[0]);
                SyncDatabaseWithRepositoryTask task = new SyncDatabaseWithRepositoryTask(site, lastDbCommitId);
                this.taskExecutor.execute((Runnable)task);
            }
            finally {
                taskLock.unlock();
            }
        }
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    class SyncDatabaseWithRepositoryTask
    implements Runnable {
        private String site;
        private String lastDbCommitId;

        public SyncDatabaseWithRepositoryTask(String site, String lastDbCommitId) {
            this.site = site;
            this.lastDbCommitId = lastDbCommitId;
        }

        @Override
        public void run() {
            logger.debug("Start synchronizing database with repository  for site " + this.site, new Object[0]);
            try {
                SyncDatabaseWithRepository.this.siteService.syncDatabaseWithRepo(this.site, this.lastDbCommitId);
            }
            catch (SiteNotFoundException e) {
                logger.error("Error while syncing database with repository", e, new Object[0]);
            }
        }
    }
}

