/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.aws;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.exception.AwsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsUtils {
    private static final Logger logger = LoggerFactory.getLogger(AwsUtils.class);
    public static final int MIN_PART_SIZE = 0x500000;

    public static void uploadStream(String inputBucket, String inputKey, AmazonS3 s3Client, int partSize, String filename, InputStream content) throws AwsException {
        LinkedList<PartETag> etags = new LinkedList<PartETag>();
        InitiateMultipartUploadResult initResult = null;
        try {
            int read;
            int partNumber = 1;
            long totalBytes = 0L;
            MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(mimeMap.getContentType(filename));
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(inputBucket, inputKey, meta);
            initResult = s3Client.initiateMultipartUpload(initRequest);
            byte[] buffer = new byte[partSize];
            logger.debug("Starting upload for file '{}'", (Object)filename);
            while (0 < (read = IOUtils.read((InputStream)content, (byte[])buffer))) {
                totalBytes += (long)read;
                if (logger.isTraceEnabled()) {
                    logger.trace("Uploading part {} with size {} - total: {}", new Object[]{partNumber, read, totalBytes});
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, read);
                UploadPartRequest uploadRequest = new UploadPartRequest().withUploadId(initResult.getUploadId()).withBucketName(inputBucket).withKey(inputKey).withInputStream((InputStream)bais).withPartNumber(partNumber).withPartSize((long)read).withLastPart(read < partSize);
                etags.add(s3Client.uploadPart(uploadRequest).getPartETag());
                ++partNumber;
            }
            if (totalBytes == 0L) {
                s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(inputBucket, inputKey, initResult.getUploadId()));
                s3Client.putObject(inputBucket, inputKey, (InputStream)new ByteArrayInputStream(new byte[0]), meta);
            } else {
                CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(inputBucket, inputKey, initResult.getUploadId(), etags);
                s3Client.completeMultipartUpload(completeRequest);
            }
            logger.debug("Upload completed for file '{}'", (Object)filename);
        }
        catch (Exception e) {
            if (initResult != null) {
                s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(inputBucket, inputKey, initResult.getUploadId()));
            }
            throw new AwsException("Upload of file '" + filename + "' failed", e);
        }
    }

    public static String getS3Url(String bucket, String key) {
        return String.format("s3://%s/%s", bucket, key);
    }
}

