/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxConfig;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import com.box.sdk.EncryptionAlgorithm;
import com.box.sdk.JWTEncryptionPreferences;
import org.apache.commons.io.FilenameUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.profiles.box.BoxProfile;
import org.craftercms.studio.api.v1.exception.BoxException;
import org.craftercms.studio.api.v1.service.box.BoxService;
import org.craftercms.studio.impl.v1.util.config.profiles.SiteAwareConfigProfileLoader;
import org.springframework.beans.factory.annotation.Required;

public class BoxServiceImpl
implements BoxService {
    protected static final String URL_FORMAT = "/remote-assets/box/%s/%s.%s";
    protected SiteAwareConfigProfileLoader<BoxProfile> profileLoader;

    @Required
    public void setProfileLoader(SiteAwareConfigProfileLoader<BoxProfile> profileLoader) {
        this.profileLoader = profileLoader;
    }

    protected BoxProfile getProfile(String site, String profileId) throws BoxException {
        try {
            return this.profileLoader.loadProfile(site, profileId);
        }
        catch (ConfigurationException e) {
            throw new BoxException("Unable to load Box profile", (Exception)((Object)e));
        }
    }

    protected BoxAPIConnection getConnection(BoxProfile profile) {
        JWTEncryptionPreferences jwtPrefs = new JWTEncryptionPreferences();
        jwtPrefs.setPublicKeyID(profile.getPublicKeyId());
        jwtPrefs.setPrivateKey(profile.getPrivateKey());
        jwtPrefs.setPrivateKeyPassword(profile.getPrivateKeyPassword());
        jwtPrefs.setEncryptionAlgorithm(EncryptionAlgorithm.RSA_SHA_256);
        BoxConfig config = new BoxConfig(profile.getClientId(), profile.getClientSecret(), profile.getEnterpriseId(), jwtPrefs);
        return BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((BoxConfig)config);
    }

    @Override
    public String getAccessToken(String site, String profileId) throws BoxException {
        BoxProfile profile = this.getProfile(site, profileId);
        BoxAPIConnection api = this.getConnection(profile);
        return api.getAccessToken();
    }

    @Override
    public String getUrl(String site, String profileId, String fileId, String filename) throws BoxException {
        this.getProfile(site, profileId);
        return String.format(URL_FORMAT, profileId, fileId, FilenameUtils.getExtension((String)filename));
    }
}

