/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.service.StudioCacheContext;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ContentTypesConfigImpl
implements ContentTypesConfig {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypesConfigImpl.class);
    private static final String QUICK_CREATE = "quickCreate";
    private static final String QUICK_CREATE_PATH = "quickCreatePath";
    protected ContentService contentService;
    protected GeneralLockService generalLockService;
    protected StudioConfiguration studioConfiguration;

    @Override
    @ValidateParams
    public ContentTypeConfigTO getContentTypeConfig(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="contentType") String contentType) {
        if (StringUtils.isNotEmpty((CharSequence)contentType) && !StringUtils.equals((CharSequence)contentType, (CharSequence)"unknown")) {
            return this.loadConfiguration(site, contentType);
        }
        return null;
    }

    @Override
    @ValidateParams
    public ContentTypeConfigTO loadConfiguration(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="contentType") String contentType) {
        String siteConfigPath = this.getConfigPath().replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        String configFileFullPath = siteConfigPath + "/" + this.getConfigFileName();
        Document document = null;
        try {
            if (this.contentService.contentExists(site, configFileFullPath)) {
                document = this.contentService.getContentAsDocument(site, configFileFullPath);
            }
        }
        catch (DocumentException e) {
            logger.debug("No content type configuration document found at " + configFileFullPath, new Object[]{e});
        }
        if (document != null) {
            Element root = document.getRootElement();
            String name = root.valueOf("@name");
            ContentTypeConfigTO contentTypeConfig = new ContentTypeConfigTO();
            contentTypeConfig.setName(name);
            contentTypeConfig.setLabel(root.valueOf("label"));
            String imageThumbnail = root.valueOf("image-thumbnail");
            if (imageThumbnail != null) {
                contentTypeConfig.setImageThumbnail(imageThumbnail);
            }
            contentTypeConfig.setForm(root.valueOf("form"));
            boolean previewable = ContentFormatUtils.getBooleanValue(root.valueOf("previewable"));
            contentTypeConfig.setFormPath(root.valueOf("form-path"));
            contentTypeConfig.setPreviewable(previewable);
            contentTypeConfig.setModelInstancePath(root.valueOf("model-instance-path"));
            boolean contentAsFolder = ContentFormatUtils.getBooleanValue(root.valueOf("content-as-folder"));
            contentTypeConfig.setContentAsFolder(contentAsFolder);
            boolean useRoundedFolder = ContentFormatUtils.getBooleanValue(root.valueOf("use-rounded-folder"));
            contentTypeConfig.setUseRoundedFolder(useRoundedFolder);
            List<String> pathIncludes = this.getPaths(root, "paths/includes/pattern");
            if (pathIncludes.size() == 0) {
                pathIncludes.add(".*");
            }
            contentTypeConfig.setPathIncludes(pathIncludes);
            List<String> pathExcludes = this.getPaths(root, "paths/excludes/pattern");
            contentTypeConfig.setPathExcludes(pathExcludes);
            this.loadRoles(contentTypeConfig, root.selectNodes("allowed-roles/role"));
            this.loadDeleteDependencies(contentTypeConfig, root.selectNodes("delete-dependencies/delete-dependency"));
            this.loadCopyDependencyPatterns(contentTypeConfig, root.selectNodes("copy-dependencies/copy-dependency"));
            contentTypeConfig.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
            contentTypeConfig.setType(this.getContentTypeTypeByName(name));
            boolean quickCreate = ContentFormatUtils.getBooleanValue(root.valueOf(QUICK_CREATE));
            contentTypeConfig.setQuickCreate(quickCreate);
            contentTypeConfig.setQuickCreatePath(root.valueOf(QUICK_CREATE_PATH));
            return contentTypeConfig;
        }
        logger.debug("No content type configuration document found at " + configFileFullPath, new Object[0]);
        return null;
    }

    protected void loadDeleteDependencies(ContentTypeConfigTO contentTypeConfig, List<Node> nodes) {
        ArrayList<DeleteDependencyConfigTO> deleteConfigs = new ArrayList<DeleteDependencyConfigTO>();
        if (nodes != null) {
            for (Node node : nodes) {
                Node patternNode = node.selectSingleNode("pattern");
                Node removeFolderNode = node.selectSingleNode("remove-empty-folder");
                if (patternNode == null) continue;
                String pattern = patternNode.getText();
                String removeEmptyFolder = removeFolderNode.getText();
                boolean isRemoveEmptyFolder = false;
                if (removeEmptyFolder != null) {
                    isRemoveEmptyFolder = Boolean.valueOf(removeEmptyFolder);
                }
                if (!StringUtils.isNotEmpty((CharSequence)pattern)) continue;
                DeleteDependencyConfigTO deleteConfigTO = new DeleteDependencyConfigTO(pattern, isRemoveEmptyFolder);
                deleteConfigs.add(deleteConfigTO);
            }
            contentTypeConfig.setDeleteDependencies(deleteConfigs);
        }
    }

    private String getContentTypeTypeByName(String name) {
        if (Pattern.matches("/component/.*?", name)) {
            return "component";
        }
        if (Pattern.matches("/page/.*?", name)) {
            return "page";
        }
        return "unknown";
    }

    private List<String> getPaths(Element root, String path) {
        ArrayList<String> paths = null;
        List nodes = root.selectNodes(path);
        if (nodes != null && nodes.size() > 0) {
            paths = new ArrayList(nodes.size());
            for (Node node : nodes) {
                String role = node.getText();
                if (StringUtils.isEmpty((CharSequence)role)) continue;
                paths.add(role);
            }
        } else {
            paths = new ArrayList<String>();
        }
        return paths;
    }

    protected void loadRoles(ContentTypeConfigTO config, List<Node> nodes) {
        HashSet<String> roles = null;
        if (nodes != null && nodes.size() > 0) {
            roles = new HashSet(nodes.size());
            for (Node node : nodes) {
                String role = node.getText();
                if (StringUtils.isEmpty((CharSequence)role)) continue;
                roles.add(role);
            }
        } else {
            roles = new HashSet<String>();
        }
        config.setAllowedRoles(roles);
    }

    protected void loadCopyDependencyPatterns(ContentTypeConfigTO config, List<Node> copyDependencyNodes) {
        ArrayList<CopyDependencyConfigTO> copyConfig = new ArrayList<CopyDependencyConfigTO>();
        if (copyDependencyNodes != null) {
            for (Node copyDependency : copyDependencyNodes) {
                Node patternNode = copyDependency.selectSingleNode("pattern");
                Node targetNode = copyDependency.selectSingleNode("target");
                if (patternNode == null || targetNode == null) continue;
                String pattern = patternNode.getText();
                String target = targetNode.getText();
                if (!StringUtils.isNotEmpty((CharSequence)pattern) || !StringUtils.isNotEmpty((CharSequence)target)) continue;
                CopyDependencyConfigTO copyDependencyConfigTO = new CopyDependencyConfigTO(pattern, target);
                copyConfig.add(copyDependencyConfigTO);
            }
        }
        config.setCopyDepedencyPattern(copyConfig);
    }

    @Override
    @ValidateParams
    public ContentTypeConfigTO reloadConfiguration(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="contentType") String contentType) {
        StudioCacheContext cacheContext = new StudioCacheContext(site, true);
        String siteConfigPath = this.getConfigPath().replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        ContentTypeConfigTO config = this.loadConfiguration(site, contentType);
        return config;
    }

    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.contentTypes.configPath");
    }

    public String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.contentTypes.configFileName");
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

