/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.configuration;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DmFolderConfigTO;
import org.craftercms.studio.api.v1.to.FacetRangeTO;
import org.craftercms.studio.api.v1.to.FacetTO;
import org.craftercms.studio.api.v1.to.RepositoryConfigTO;
import org.craftercms.studio.api.v1.to.SiteConfigTO;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesConfigImpl
implements ServicesConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesConfigImpl.class);
    protected static final String PATTERN_PAGE = "page";
    protected static final String PATTERN_COMPONENT = "component";
    protected static final String PATTERN_ASSET = "asset";
    protected static final String PATTERN_DOCUMENT = "document";
    protected static final String PATTERN_RENDERING_TEMPLATE = "rendering-template";
    protected static final String PATTERN_SCRIPTS = "scripts";
    protected static final String PATTERN_LEVEL_DESCRIPTOR = "level-descriptor";
    protected static final String PATTERN_PREVIEWABLE_MIMETYPES = "previewable-mimetypes";
    protected static final String ELM_PATTERN = "pattern";
    protected static final String ATTR_NAME = "@name";
    protected static final String ATTR_PATH = "@path";
    protected static final String ATTR_READ_DIRECT_CHILDREN = "@read-direct-children";
    protected static final String ATTR_ATTACH_ROOT_PREFIX = "@attach-root-prefix";
    protected ContentTypesConfig contentTypesConfig;
    protected ContentService contentService;
    protected ContentRepository contentRepository;
    protected GeneralLockService generalLockService;
    protected StudioConfiguration studioConfiguration;
    protected ConfigurationService configurationService;

    protected SiteConfigTO getSiteConfig(String site) {
        return this.loadConfiguration(site);
    }

    @Override
    @ValidateParams
    public String getWemProject(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getWemProject() != null) {
            return config.getWemProject();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<DmFolderConfigTO> getFolders(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getFolders();
        }
        return null;
    }

    @Override
    @ValidateParams
    public String getRootPrefix(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getRootPrefix();
        }
        return null;
    }

    @Override
    @ValidateParams
    public ContentTypeConfigTO getContentTypeConfig(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="name") String name) {
        return this.contentTypesConfig.getContentTypeConfig(site, name);
    }

    @Override
    @ValidateParams
    public List<String> getAssetPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getAssetPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<DeleteDependencyConfigTO> getDeleteDependencyPatterns(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="contentType") String contentType) {
        if (contentType == null) {
            return Collections.emptyList();
        }
        ContentTypeConfigTO contentTypeConfig = this.contentTypesConfig.getContentTypeConfig(site, contentType);
        if (contentTypeConfig != null) {
            return contentTypeConfig.getDeleteDependencyPattern();
        }
        return Collections.emptyList();
    }

    @Override
    @ValidateParams
    public List<CopyDependencyConfigTO> getCopyDependencyPatterns(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="contentType") String contentType) {
        if (contentType == null) {
            return Collections.emptyList();
        }
        ContentTypeConfigTO contentTypeConfig = this.contentTypesConfig.getContentTypeConfig(site, contentType);
        if (contentTypeConfig != null) {
            return contentTypeConfig.getCopyDepedencyPattern();
        }
        return Collections.emptyList();
    }

    @Override
    @ValidateParams
    public List<String> getComponentPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getComponentPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getPagePatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getPagePatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getRenderingTemplatePatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getRenderingTemplatePatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getScriptsPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getScriptsPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getLevelDescriptorPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getLevelDescriptorPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getDocumentPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getDocumentPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public String getLevelDescriptorName(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getLevelDescriptorName();
        }
        return null;
    }

    @Override
    @ValidateParams
    public List<String> getDisplayInWidgetPathPatterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getDisplayPatterns();
        }
        return null;
    }

    @Override
    @ValidateParams
    public String getDefaultTimezone(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.getTimezone();
        }
        return null;
    }

    @Override
    @ValidateParams
    public String getPluginFolderPattern(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.getPluginFolderPattern();
        }
        return null;
    }

    protected SiteConfigTO loadConfiguration(String site) {
        Document document = null;
        SiteConfigTO siteConfig = null;
        try {
            document = this.configurationService.getConfigurationAsDocument(site, "studio", this.getConfigFileName(), this.studioConfiguration.getProperty("studio.configuration.environment.active"));
        }
        catch (IOException | DocumentException e) {
            LOGGER.error("Error while loading configuration for " + site + " at " + this.getConfigFileName(), e);
        }
        if (document != null) {
            Element root = document.getRootElement();
            Node configNode = root.selectSingleNode("/site-config");
            String name = configNode.valueOf("display-name");
            siteConfig = new SiteConfigTO();
            siteConfig.setName(name);
            siteConfig.setWemProject(configNode.valueOf("wem-project"));
            siteConfig.setTimezone(configNode.valueOf("default-timezone"));
            String sandboxBranch = configNode.valueOf("sandbox-branch");
            if (StringUtils.isEmpty((CharSequence)sandboxBranch)) {
                sandboxBranch = this.studioConfiguration.getProperty("studio.repo.siteSandboxBranch");
            }
            siteConfig.setSandboxBranch(sandboxBranch);
            String stagingEnvironmentEnabledValue = configNode.valueOf("published-repository/enable-staging-environment");
            if (StringUtils.isEmpty((CharSequence)stagingEnvironmentEnabledValue)) {
                siteConfig.setStagingEnvironmentEnabled(false);
            } else {
                siteConfig.setStagingEnvironmentEnabled(Boolean.valueOf(stagingEnvironmentEnabledValue));
            }
            String stagingEnvironment = configNode.valueOf("published-repository/staging-environment");
            if (StringUtils.isEmpty((CharSequence)stagingEnvironment)) {
                stagingEnvironment = this.studioConfiguration.getProperty("studio.repo.published.staging");
            }
            siteConfig.setStagingEnvironment(stagingEnvironment);
            String liveEnvironment = configNode.valueOf("published-repository/live-environment");
            if (StringUtils.isEmpty((CharSequence)liveEnvironment)) {
                liveEnvironment = this.studioConfiguration.getProperty("studio.repo.published.live");
            }
            siteConfig.setLiveEnvironment(liveEnvironment);
            this.loadSiteUrlsConfiguration(siteConfig, configNode.selectSingleNode("site-urls"));
            String adminEmailAddressValue = configNode.valueOf("admin-email-address");
            siteConfig.setAdminEmailAddress(adminEmailAddressValue);
            this.loadSiteRepositoryConfiguration(siteConfig, configNode.selectSingleNode("repository"));
            siteConfig.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
            this.loadFacetConfiguration(configNode, siteConfig);
            siteConfig.setPluginFolderPattern(configNode.valueOf("plugin-folder-pattern"));
        } else {
            LOGGER.error("No site configuration found for " + site + " at " + this.getConfigFileName());
        }
        return siteConfig;
    }

    protected void loadSiteUrlsConfiguration(SiteConfigTO siteConfig, Node configNode) {
        if (Objects.nonNull(configNode)) {
            String authoringUrlValue = configNode.valueOf("authoring-url");
            siteConfig.setAuthoringUrl(authoringUrlValue);
            String stagingUrlValue = configNode.valueOf("staging-url");
            siteConfig.setStagingUrl(stagingUrlValue);
            String liveUrlValue = configNode.valueOf("live-url");
            siteConfig.setLiveUrl(liveUrlValue);
        }
    }

    protected void loadFacetConfiguration(Node root, SiteConfigTO config) {
        List facetsConfig = root.selectNodes("search/facets/facet");
        if (CollectionUtils.isNotEmpty((Collection)facetsConfig)) {
            Map<String, FacetTO> facets = facetsConfig.stream().map(facetConfig -> {
                FacetTO facet = new FacetTO();
                facet.setName(XmlUtils.selectSingleNodeValue((Node)facetConfig, (String)"name/text()"));
                facet.setField(XmlUtils.selectSingleNodeValue((Node)facetConfig, (String)"field/text()"));
                facet.setDate(Boolean.parseBoolean(XmlUtils.selectSingleNodeValue((Node)facetConfig, (String)"date/text()")));
                facet.setMultiple(Boolean.parseBoolean(XmlUtils.selectSingleNodeValue((Node)facetConfig, (String)"multiple/text()")));
                List rangesConfig = facetConfig.selectNodes("ranges/range");
                if (CollectionUtils.isNotEmpty((Collection)rangesConfig)) {
                    List<FacetRangeTO> ranges = rangesConfig.stream().map(rangeConfig -> {
                        String to;
                        FacetRangeTO range = new FacetRangeTO();
                        range.setLabel(XmlUtils.selectSingleNodeValue((Node)rangeConfig, (String)"label/text()"));
                        String from = XmlUtils.selectSingleNodeValue((Node)rangeConfig, (String)"from/text()");
                        if (StringUtils.isNotEmpty((CharSequence)from)) {
                            range.setFrom(from);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(to = XmlUtils.selectSingleNodeValue((Node)rangeConfig, (String)"to/text()")))) {
                            range.setTo(to);
                        }
                        return range;
                    }).collect(Collectors.toList());
                    facet.setRanges(ranges);
                }
                return facet;
            }).collect(Collectors.toMap(FacetTO::getName, Function.identity()));
            config.setFacets(facets);
        }
    }

    protected void loadSiteRepositoryConfiguration(SiteConfigTO siteConfig, Node node) {
        RepositoryConfigTO repoConfigTO = new RepositoryConfigTO();
        repoConfigTO.setRootPrefix(node.valueOf("@rootPrefix"));
        repoConfigTO.setLevelDescriptorName(node.valueOf(PATTERN_LEVEL_DESCRIPTOR));
        this.loadFolderConfiguration(siteConfig, repoConfigTO, node.selectNodes("folders/folder"));
        this.loadPatterns(siteConfig, repoConfigTO, node.selectNodes("patterns/pattern-group"));
        List<String> displayPatterns = this.getStringList(node.selectNodes("display-in-widget-patterns/display-in-widget-pattern"));
        repoConfigTO.setDisplayPatterns(displayPatterns);
        siteConfig.setRepositoryConfig(repoConfigTO);
    }

    protected List<String> getStringList(List<Node> nodes) {
        ArrayList<String> items = null;
        if (nodes != null && nodes.size() > 0) {
            items = new ArrayList(nodes.size());
            for (Node node : nodes) {
                items.add(node.getText());
            }
        } else {
            items = new ArrayList<String>(0);
        }
        return items;
    }

    protected void loadPatterns(SiteConfigTO site, RepositoryConfigTO repo, List<Node> nodes) {
        if (nodes != null) {
            for (Node node : nodes) {
                String patternKey = node.valueOf(ATTR_NAME);
                if (!StringUtils.isEmpty((CharSequence)patternKey)) {
                    List patternNodes = node.selectNodes(ELM_PATTERN);
                    if (patternNodes == null) continue;
                    ArrayList<String> patterns = new ArrayList<String>(patternNodes.size());
                    for (Node patternNode : patternNodes) {
                        String pattern = patternNode.getText();
                        if (StringUtils.isEmpty((CharSequence)pattern)) continue;
                        patterns.add(pattern);
                    }
                    if (patternKey.equals(PATTERN_PAGE)) {
                        repo.setPagePatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_COMPONENT)) {
                        repo.setComponentPatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_ASSET)) {
                        repo.setAssetPatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_DOCUMENT)) {
                        repo.setDocumentPatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_RENDERING_TEMPLATE)) {
                        repo.setRenderingTemplatePatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_SCRIPTS)) {
                        repo.setScriptsPatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_LEVEL_DESCRIPTOR)) {
                        repo.setLevelDescriptorPatterns(patterns);
                        continue;
                    }
                    if (patternKey.equals(PATTERN_PREVIEWABLE_MIMETYPES)) {
                        repo.setPreviewableMimetypesPaterns(patterns);
                        continue;
                    }
                    LOGGER.error("Unknown pattern key: " + patternKey + " is provided in " + site.getName());
                    continue;
                }
                LOGGER.error("no pattern key provided in " + site.getName() + " configuration. Skipping the pattern.");
            }
        } else {
            LOGGER.warn(site.getName() + " does not have any pattern configuration.");
        }
    }

    protected void loadFolderConfiguration(SiteConfigTO site, RepositoryConfigTO repo, List<Node> folderNodes) {
        if (folderNodes != null) {
            ArrayList<DmFolderConfigTO> folders = new ArrayList<DmFolderConfigTO>(folderNodes.size());
            for (Node folderNode : folderNodes) {
                DmFolderConfigTO folderConfig = new DmFolderConfigTO();
                folderConfig.setName(folderNode.valueOf(ATTR_NAME));
                folderConfig.setPath(folderNode.valueOf(ATTR_PATH));
                folderConfig.setReadDirectChildren(ContentFormatUtils.getBooleanValue(folderNode.valueOf(ATTR_READ_DIRECT_CHILDREN)));
                folderConfig.setAttachRootPrefix(ContentFormatUtils.getBooleanValue(folderNode.valueOf(ATTR_ATTACH_ROOT_PREFIX)));
                folders.add(folderConfig);
            }
            repo.setFolders(folders);
        } else {
            LOGGER.warn(site.getName() + " does not have any folder configuration.");
        }
    }

    @Override
    @ValidateParams
    public List<String> getPreviewableMimetypesPaterns(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null && config.getRepositoryConfig() != null) {
            return config.getRepositoryConfig().getPreviewableMimetypesPaterns();
        }
        return null;
    }

    public String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.generalConfigFileName");
    }

    @Override
    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.loadConfiguration(site);
    }

    @Override
    @ValidateParams
    public String getSandboxBranchName(@ValidateStringParam(name="site") String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.getSandboxBranch();
        }
        return null;
    }

    @Override
    public boolean isStagingEnvironmentEnabled(String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.isStagingEnvironmentEnabled();
        }
        return false;
    }

    @Override
    public String getStagingEnvironment(String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.getStagingEnvironment();
        }
        return null;
    }

    @Override
    public String getLiveEnvironment(String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (config != null) {
            return config.getLiveEnvironment();
        }
        return null;
    }

    @Override
    public Map<String, FacetTO> getFacets(String site) {
        SiteConfigTO config = this.getSiteConfig(site);
        if (Objects.nonNull(config)) {
            return config.getFacets();
        }
        return null;
    }

    @Override
    public String getAuthoringUrl(String siteId) {
        SiteConfigTO config = this.getSiteConfig(siteId);
        if (Objects.nonNull(config)) {
            if (StringUtils.isEmpty((CharSequence)config.getAuthoringUrl())) {
                return "http://localhost:8080";
            }
            return config.getAuthoringUrl();
        }
        return null;
    }

    @Override
    public String getStagingUrl(String siteId) {
        SiteConfigTO config = this.getSiteConfig(siteId);
        if (Objects.nonNull(config)) {
            if (StringUtils.isEmpty((CharSequence)config.getStagingUrl())) {
                return "http://localhost:8080";
            }
            return config.getStagingUrl();
        }
        return null;
    }

    @Override
    public String getLiveUrl(String siteId) {
        SiteConfigTO config = this.getSiteConfig(siteId);
        if (Objects.nonNull(config)) {
            if (StringUtils.isEmpty((CharSequence)config.getLiveUrl())) {
                return "http://localhost:8080";
            }
            return config.getLiveUrl();
        }
        return null;
    }

    @Override
    public String getAdminEmailAddress(String siteId) {
        SiteConfigTO config = this.getSiteConfig(siteId);
        if (Objects.nonNull(config)) {
            return config.getAdminEmailAddress();
        }
        return null;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentTypesConfig getContentTypesConfig() {
        return this.contentTypesConfig;
    }

    public void setContentTypesConfig(ContentTypesConfig contentTypesConfig) {
        this.contentTypesConfig = contentTypesConfig;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

