/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.ItemState;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.executor.ProcessContentExecutor;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentItemIdGenerator;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyDiffService;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentAssetInfoTO;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.CopyDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DeleteDependencyConfigTO;
import org.craftercms.studio.api.v1.to.DmOrderTO;
import org.craftercms.studio.api.v1.to.GoLiveDeleteCandidates;
import org.craftercms.studio.api.v1.to.RenderingTemplateTO;
import org.craftercms.studio.api.v1.to.ResultTO;
import org.craftercms.studio.api.v1.to.VersionTO;
import org.craftercms.studio.api.v1.util.DebugUtils;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.security.UserService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentItemOrderComparator;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v2.utils.spring.ContentResource;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class ContentServiceImpl
implements ContentService {
    private static final Logger logger = LoggerFactory.getLogger(ContentServiceImpl.class);
    private static final String COPY_DEP_XPATH = "//*/text()[normalize-space(.)='{copyDep}']/parent::*";
    private static final String COPY_DEP = "{copyDep}";
    private org.craftercms.studio.api.v1.repository.ContentRepository _contentRepository;
    private ContentRepository contentRepository;
    protected ServicesConfig servicesConfig;
    protected GeneralLockService generalLockService;
    protected ObjectStateService objectStateService;
    protected DependencyService dependencyService;
    protected ProcessContentExecutor contentProcessor;
    protected ObjectMetadataManager objectMetadataManager;
    protected SecurityService securityService;
    protected DmPageNavigationOrderService dmPageNavigationOrderService;
    protected DmContentLifeCycleService dmContentLifeCycleService;
    protected EventService eventService;
    protected SiteService siteService;
    protected ContentItemIdGenerator contentItemIdGenerator;
    protected StudioConfiguration studioConfiguration;
    protected DependencyDiffService dependencyDiffService;
    protected ContentTypeService contentTypeService;
    protected EntitlementValidator entitlementValidator;
    protected AuditServiceInternal auditServiceInternal;
    protected UserService userService;
    public static final Pattern COPY_FILE_PATTERN = Pattern.compile("(.+)-([0-9]+)\\.(.+)");
    public static final Pattern COPY_FOLDER_PATTERN = Pattern.compile("(.+)-([0-9]+)");

    @Override
    @ValidateParams
    public boolean contentExists(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this._contentRepository.contentExists(site, path);
    }

    @Override
    @ValidateParams
    public InputStream getContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws ContentNotFoundException, CryptoException {
        if (StringUtils.equals((CharSequence)site, (CharSequence)this.studioConfiguration.getProperty("studio.configuration.global.systemSite"))) {
            return this._contentRepository.getContent("", path);
        }
        return this._contentRepository.getContent(site, path);
    }

    @Override
    @ValidateParams
    public long getContentSize(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="path") String path) {
        return this._contentRepository.getContentSize(site, path);
    }

    @Override
    @ValidateParams
    public String getContentAsString(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this.getContentAsString(site, path, null);
    }

    @Override
    @ValidateParams
    public String getContentAsString(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="encoding") String encoding) {
        String content = null;
        try (InputStream is = this._contentRepository.getContent(site, path);){
            if (is != null) {
                content = StringUtils.isEmpty((CharSequence)encoding) ? IOUtils.toString((InputStream)is) : IOUtils.toString((InputStream)is, (String)encoding);
            }
        }
        catch (Exception err) {
            logger.debug("Failed to get content as string for path {0}", err, path);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public Document getContentAsDocument(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws DocumentException {
        Document retDocument = null;
        InputStream is = null;
        try {
            is = this.getContent(site, path);
        }
        catch (CryptoException | ContentNotFoundException e) {
            logger.debug("Content not found for path {0}", e, path);
        }
        if (is != null) {
            try {
                SAXReader saxReader = new SAXReader();
                try {
                    saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (SAXException ex) {
                    logger.error("Unable to turn off external entity loading, This could be a security risk.", ex, new Object[0]);
                }
                retDocument = saxReader.read(is);
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException err) {
                    logger.debug("Error closing stream for path {0}", err, path);
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException err) {
                logger.debug("Error closing stream for path {0}", err, path);
            }
        }
        return retDocument;
    }

    @Override
    @ValidateParams
    public Resource getContentAsResource(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws ContentNotFoundException {
        if (this.contentExists(site, path)) {
            return new ContentResource(this, site, path);
        }
        throw new ContentNotFoundException(path, site, String.format("File '%s' not found in site '%s'", path, site));
    }

    @Override
    @ValidateParams
    public void writeContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="fileName") String fileName, @ValidateStringParam(name="contentType") String contentType, InputStream input, @ValidateStringParam(name="createFolders") String createFolders, @ValidateStringParam(name="edit") String edit, @ValidateStringParam(name="unlock") String unlock) throws ServiceLayerException {
        this.writeContent(site, path, fileName, contentType, input, createFolders, edit, unlock, false);
    }

    @Override
    @ValidateParams
    public void writeContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="fileName") String fileName, @ValidateStringParam(name="contentType") String contentType, InputStream input, @ValidateStringParam(name="createFolders") String createFolders, @ValidateStringParam(name="edit") String edit, @ValidateStringParam(name="unlock") String unlock, boolean skipAuditLogInsert) throws ServiceLayerException {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.ITEM, 1);
        }
        catch (EntitlementException e) {
            throw new ServiceLayerException("Unable to complete request due to entitlement limits. Please contact your system administrator.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("fileName", fileName);
        params.put("contentType", contentType);
        params.put("createFolders", createFolders);
        params.put("edit", edit);
        params.put("unlock", unlock);
        params.put("skipAuditLogInsert", String.valueOf(skipAuditLogInsert));
        String id = site + ":" + path + ":" + fileName + ":" + contentType;
        String relativePath = path;
        boolean contentExists = this.contentExists(site, path);
        String lockKey = id;
        if (contentExists) {
            lockKey = site + ":" + path;
        }
        try {
            ContentItemTO itemTo;
            String savedPath;
            boolean isSaveAndClose;
            boolean bl = isSaveAndClose = StringUtils.isNotEmpty((CharSequence)unlock) && !unlock.equalsIgnoreCase("false");
            if (contentExists) {
                ItemState itemState = this.objectStateService.getObjectState(site, path);
                if (itemState == null) {
                    ContentItemTO item = this.getContentItem(site, path, 0);
                    this.objectStateService.insertNewEntry(site, item);
                    itemState = this.objectStateService.getObjectState(site, path);
                }
                if (itemState != null) {
                    if (itemState.getSystemProcessing() != 0) {
                        logger.error("Error Content {0} is being processed (Object State is system processing);", path);
                        throw new ServiceLayerException("Content " + path + " is in system processing, we can't write it");
                    }
                    this.objectStateService.setSystemProcessing(site, path, true);
                } else {
                    logger.error("the object state is still null even after attempting to create it for site {0} path {1} fileName {2} contentType {3}.", site, path, fileName, contentType);
                }
            } else if (this.objectStateService.deletedPathExists(site, path) || this.objectMetadataManager.movedPathExists(site, path)) {
                throw new ServiceLayerException("Content " + path + " for site " + site + ", cannot be created because this name/URL was in use by another content item that has been moved or deleted by not yet published.");
            }
            String chainID = "assetContent";
            if (path.startsWith("/site")) {
                chainID = "formContent";
            }
            this.processContent(id, input, true, params, chainID);
            this.objectStateService.setSystemProcessing(site, path, false);
            String savedFileName = (String)params.get("fileName");
            relativePath = savedPath = (String)params.get("path");
            if (!savedPath.endsWith(savedFileName)) {
                relativePath = savedPath + "/" + savedFileName;
            }
            if ((itemTo = this.getContentItem(site, relativePath, 0)) != null) {
                if (isSaveAndClose) {
                    this.objectStateService.transition(site, itemTo, TransitionEvent.SAVE);
                } else {
                    this.objectStateService.transition(site, itemTo, TransitionEvent.SAVE_FOR_PREVIEW);
                }
                this.objectStateService.setSystemProcessing(site, itemTo.getUri(), false);
            } else {
                this.objectStateService.insertNewEntry(site, itemTo);
            }
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(site);
            this.eventService.publish("studio.event.previewSync", context);
        }
        catch (RuntimeException e) {
            logger.error("error writing content", e, new Object[0]);
            this.objectStateService.setSystemProcessing(site, relativePath, false);
            this.objectStateService.setSystemProcessing(site, path, false);
            throw e;
        }
    }

    @Override
    @ValidateParams
    public void writeContentAndRename(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateSecurePathParam(name="targetPath") String targetPath, @ValidateStringParam(name="fileName") String fileName, @ValidateStringParam(name="contentType") String contentType, InputStream input, @ValidateStringParam(name="createFolders") String createFolders, @ValidateStringParam(name="edit") String edit, @ValidateStringParam(name="unlock") String unlock, boolean createFolder) throws ServiceLayerException {
        String id = site + ":" + path + ":" + fileName + ":" + contentType;
        logger.debug("Write and rename for site '{}' path '{}' targetPath '{}' fileName '{}' content type '{}'", site, path, targetPath, fileName, contentType);
        try {
            this.writeContent(site, path, fileName, contentType, input, createFolders, edit, unlock, true);
            this.moveContent(site, path, targetPath);
        }
        catch (RuntimeException | ServiceLayerException e) {
            logger.error("Error while executing write and rename for site '{}' path '{}' targetPath '{}' fileName '{}' content type '{}'", e, site, path, targetPath, fileName, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public Map<String, Object> writeContentAsset(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="assetName") String assetName, InputStream in, String isImage, String allowedWidth, String allowedHeight, String allowLessSize, String draft, String unlock, String systemAsset) throws ServiceLayerException {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.ITEM, 1);
        }
        catch (EntitlementException e) {
            throw new ServiceLayerException("Unable to complete request due to entitlement limits. Please contact your system administrator.");
        }
        boolean isSystemAsset = Boolean.valueOf(systemAsset);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("fileName", assetName);
        params.put("isImage", isImage);
        params.put("allowLessSize", allowLessSize);
        params.put("allowedWidth", allowedWidth);
        params.put("allowedHeight", allowedHeight);
        params.put("contentType", "");
        params.put("createFolders", "true");
        params.put("unlock", unlock);
        params.put("systemAsset", String.valueOf(isSystemAsset));
        boolean exists = this.contentExists(site, path + "/" + assetName);
        params.put("activityType", exists ? "UPDATE" : "CREATE");
        String id = site + ":" + path + ":" + assetName + ":";
        ContentItemTO item = null;
        try {
            ItemState itemState;
            path = path + "/" + assetName;
            item = this.getContentItem(site, path);
            if (item != null && (itemState = this.objectStateService.getObjectState(site, path)) != null) {
                if (itemState.getSystemProcessing() != 0) {
                    logger.error(String.format("Error Content %s is being processed (Object State is SYSTEM_PROCESSING);", path), new Object[0]);
                    throw new RuntimeException(String.format("Content \"%s\" is being processed", path));
                }
                this.objectStateService.setSystemProcessing(site, path, true);
            }
            if (this.objectStateService.deletedPathExists(site, path) || this.objectMetadataManager.movedPathExists(site, path)) {
                throw new ServiceLayerException("Content " + path + " for site " + site + ", cannot be created because this name/URL was in use by another content item that has been moved or deleted by not yet published.");
            }
            ResultTO result = this.processContent(id, in, false, params, "assetContent");
            ContentAssetInfoTO assetInfoTO = (ContentAssetInfoTO)result.getItem();
            if (isSystemAsset) {
                path = path.replace(assetName, assetInfoTO.getFileName());
            }
            item = this.getContentItem(site, path);
            item.setSize(assetInfoTO.getSize());
            item.setSizeUnit(assetInfoTO.getSizeUnit());
            if (item != null) {
                if (result.getCommitId() != null) {
                    this.objectStateService.transition(site, item, TransitionEvent.SAVE);
                } else {
                    this.objectStateService.transition(site, item, TransitionEvent.CANCEL_EDIT);
                }
            }
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(site);
            this.eventService.publish("studio.event.previewSync", context);
            HashMap<String, Object> toRet = new HashMap<String, Object>();
            toRet.put("success", true);
            toRet.put("message", item);
            HashMap<String, Object> hashMap = toRet;
            return hashMap;
        }
        catch (Exception e) {
            logger.error("Error processing content", e, new Object[0]);
            HashMap<String, Object> toRet = new HashMap<String, Object>();
            toRet.put("success", true);
            toRet.put("message", e.getMessage());
            toRet.put("error", e);
            HashMap<String, Object> hashMap = toRet;
            return hashMap;
        }
        finally {
            if (item != null) {
                this.objectStateService.setSystemProcessing(site, path, false);
            }
        }
    }

    @Override
    @ValidateParams
    public boolean writeContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, InputStream content) throws ServiceLayerException {
        String commitId = this._contentRepository.writeContent(site, path, content);
        boolean result = StringUtils.isNotEmpty((CharSequence)commitId);
        if (result) {
            if (!this.objectMetadataManager.metadataExist(site, path)) {
                this.objectMetadataManager.insertNewObjectMetadata(site, path);
            }
            this.objectMetadataManager.updateCommitId(site, path, commitId);
            this.contentRepository.insertGitLog(site, commitId, 1, 1);
            this.siteService.updateLastCommitId(site, commitId);
        }
        return result;
    }

    @Override
    @ValidateParams
    public boolean createFolder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="name") String name) throws SiteNotFoundException {
        boolean toRet = false;
        String commitId = this._contentRepository.createFolder(site, path, name);
        if (commitId != null) {
            SiteFeed siteFeed = this.siteService.getSite(site);
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("CREATE");
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setActorId(this.securityService.getCurrentUser());
            auditLog.setPrimaryTargetId(site + ":" + path + "/" + name);
            auditLog.setPrimaryTargetType("Folder");
            auditLog.setPrimaryTargetValue(path + "/" + name);
            this.auditServiceInternal.insertAuditLog(auditLog);
            this.contentRepository.insertGitLog(site, commitId, 1, 1);
            this.siteService.updateLastCommitId(site, commitId);
            toRet = true;
        }
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean deleteContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="approver") String approver) throws SiteNotFoundException {
        return this.deleteContent(site, path, true, approver);
    }

    @Override
    @ValidateParams
    public boolean deleteContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean generateActivity, @ValidateStringParam(name="approver") String approver) throws SiteNotFoundException {
        boolean toReturn = false;
        if (generateActivity) {
            this.generateDeleteActivity(site, path, approver);
        }
        String commitId = this._contentRepository.deleteContent(site, path, approver);
        this.objectStateService.deleteObjectStateForPath(site, path);
        this.objectMetadataManager.deleteObjectMetadata(site, path);
        try {
            this.dependencyService.deleteItemDependencies(site, path);
        }
        catch (ServiceLayerException e) {
            logger.error("Error deleting dependencies for site " + site + " path " + path, e, new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)commitId)) {
            this.contentRepository.insertGitLog(site, commitId, 1);
        }
        PreviewEventContext context = new PreviewEventContext();
        context.setSite(site);
        this.eventService.publish("studio.event.previewSync", context);
        if (commitId != null) {
            toReturn = true;
        }
        return toReturn;
    }

    protected void generateDeleteActivity(String site, String path, String approver) throws SiteNotFoundException {
        boolean exists;
        if (StringUtils.isEmpty((CharSequence)approver)) {
            approver = this.securityService.getCurrentUser();
        }
        if (exists = this.contentExists(site, path)) {
            ContentItemTO item = this.getContentItem(site, path, 0);
            ItemMetadata properties = this.objectMetadataManager.getProperties(site, path);
            String user = properties != null && !StringUtils.isEmpty((CharSequence)properties.getSubmittedBy()) ? properties.getSubmittedBy() : approver;
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            if (item.isFolder()) {
                extraInfo.put("contentType", "folder");
            } else {
                extraInfo.put("contentType", this.getContentTypeClass(site, path));
            }
            logger.debug("[DELETE] posting delete activity on " + path + " by " + user + " in " + site, new Object[0]);
            SiteFeed siteFeed = this.siteService.getSite(site);
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("DELETE");
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setActorId(user);
            auditLog.setPrimaryTargetId(site + ":" + path);
            auditLog.setPrimaryTargetType("Content Item");
            auditLog.setPrimaryTargetValue(path);
            auditLog.setPrimaryTargetSubtype(this.getContentTypeClass(site, path));
            this.auditServiceInternal.insertAuditLog(auditLog);
            if (path.endsWith(".xml")) {
                String contentType = item.getContentType();
                this.dmContentLifeCycleService.process(site, user, path, contentType, DmContentLifeCycleService.ContentLifeCycleOperation.DELETE, null);
            }
        }
    }

    @Override
    @ValidateParams
    public String copyContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="fromPath") String fromPath, @ValidateSecurePathParam(name="toPath") String toPath) {
        return this.copyContent(site, fromPath, toPath, new HashSet<String>());
    }

    /*
     * Exception decompiling
     */
    protected String copyContent(String site, String fromPath, String toPath, Set<String> processedPaths) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Document replaceCopyDependency(Document document, String depPath, String copyDepPath) {
        Element root = document.getRootElement();
        List includes = root.selectNodes(COPY_DEP_XPATH.replace(COPY_DEP, depPath));
        if (includes != null) {
            for (Node includeNode : includes) {
                includeNode.setText(includeNode.getText().replace(depPath, copyDepPath));
            }
        }
        return document;
    }

    private Map<String, String> getCopyDependencies(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="sourceContentPath") String sourceContentPath, @ValidateSecurePathParam(name="dependencyPath") String dependencyPath) throws ServiceLayerException {
        HashMap<String, String> copyDependency = new HashMap<String, String>();
        if (sourceContentPath.endsWith(".xml") && dependencyPath.endsWith(".xml")) {
            ContentItemTO dependencyItem = this.getContentItem(site, sourceContentPath);
            if (dependencyItem != null) {
                String contentType = dependencyItem.getContentType();
                List<CopyDependencyConfigTO> copyDependencyPatterns = this.servicesConfig.getCopyDependencyPatterns(site, contentType);
                if (copyDependencyPatterns != null && copyDependencyPatterns.size() > 0) {
                    logger.debug("Copy Pattern provided for contentType" + contentType, new Object[0]);
                    Set<String> dependencies = this.dependencyService.getItemDependencies(site, dependencyPath, 1);
                    if (CollectionUtils.isNotEmpty(dependencies)) {
                        for (String dependency : dependencies) {
                            for (CopyDependencyConfigTO copyConfig : copyDependencyPatterns) {
                                if (!this.contentExists(site, dependency) || !StringUtils.isNotEmpty((CharSequence)copyConfig.getPattern()) || !StringUtils.isNotEmpty((CharSequence)copyConfig.getTarget()) || !dependency.matches(copyConfig.getPattern())) continue;
                                copyDependency.put(dependency, copyConfig.getTarget());
                            }
                        }
                    }
                } else {
                    logger.debug("Copy Pattern is not provided for contentType" + contentType, new Object[0]);
                }
            } else {
                logger.debug("Not found dependency item at site {0} path {!}", site, sourceContentPath);
            }
        }
        return copyDependency;
    }

    @Override
    @ValidateParams
    public String moveContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="fromPath") String fromPath, @ValidateSecurePathParam(name="toPath") String toPath) {
        Object retNewFileName = null;
        boolean opSuccess = false;
        String movePath = null;
        try {
            String sourcePath = fromPath.indexOf("/index.xml") != -1 ? fromPath.substring(0, fromPath.lastIndexOf("/")) : fromPath;
            String sourcePathOnly = fromPath.substring(0, fromPath.lastIndexOf("/"));
            Map<String, String> movePathMap = this.constructNewPathforCutCopy(site, fromPath, toPath, true);
            movePath = movePathMap.get("FILE_PATH");
            String moveFileName = movePathMap.get("FILE_NAME");
            String movePathOnly = movePath.substring(0, movePath.lastIndexOf("/"));
            boolean moveAltFileName = "true".equals(movePathMap.get("ALT_NAME"));
            boolean targetIsIndex = "index.xml".equals(moveFileName);
            boolean sourceIsIndex = "index.xml".equals(fromPath);
            String targetPath = movePathOnly;
            if (movePathOnly.equals(sourcePathOnly) || moveAltFileName && !targetIsIndex || !sourceIsIndex && !targetIsIndex) {
                targetPath = movePath;
            }
            logger.debug("Move file for site {0} from {1} to {2}, sourcePath {3} to target path {4}", site, fromPath, toPath, sourcePath, targetPath);
            Map<String, String> commitIds = this._contentRepository.moveContent(site, sourcePath, targetPath);
            if (commitIds != null) {
                this.updateDatabaseOnMove(site, fromPath, movePath);
                this.updateChildrenOnMove(site, fromPath, movePath);
                for (Map.Entry<String, String> entry : commitIds.entrySet()) {
                    this.objectMetadataManager.updateCommitId(site, "/" + entry.getKey(), entry.getValue());
                    this.contentRepository.insertGitLog(site, entry.getValue(), 1, 1);
                }
                this.siteService.updateLastCommitId(site, this._contentRepository.getRepoLastCommitId(site));
            } else {
                logger.error("Repository move failed site {0} from {1} to {2}", site, sourcePath, targetPath);
                movePath = fromPath;
            }
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(site);
            this.eventService.publish("studio.event.previewSync", context);
        }
        catch (ServiceLayerException eMoveErr) {
            logger.error("Content not found while moving content for site {0} from {1} to {2}, new name is {3}", eMoveErr, site, fromPath, toPath, movePath);
        }
        return movePath;
    }

    protected void updateDatabaseOnMove(String site, String fromPath, String movePath) throws SiteNotFoundException {
        logger.debug("updateDatabaseOnMove FROM {0} TO {1}  ", fromPath, movePath);
        String user = this.securityService.getCurrentUser();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sourcePath", fromPath);
        params.put("targetPath", movePath);
        ContentItemTO renamedItem = this.getContentItem(site, movePath, 0);
        String contentType = renamedItem.getContentType();
        if (!renamedItem.isFolder()) {
            this.dmContentLifeCycleService.process(site, user, movePath, contentType, DmContentLifeCycleService.ContentLifeCycleOperation.RENAME, params);
            this.objectStateService.updateObjectPath(site, fromPath, movePath);
            this.objectStateService.transition(site, renamedItem, TransitionEvent.SAVE);
            renamedItem = this.getContentItem(site, movePath, 0);
        }
        if (!this.objectMetadataManager.isRenamed(site, fromPath)) {
            ItemMetadata metadata = this.objectMetadataManager.getProperties(site, fromPath);
            if (metadata == null && !renamedItem.isFolder()) {
                if (!this.objectMetadataManager.metadataExist(site, fromPath)) {
                    this.objectMetadataManager.insertNewObjectMetadata(site, fromPath);
                }
                metadata = this.objectMetadataManager.getProperties(site, fromPath);
            }
            if (!renamedItem.isNew() && !renamedItem.isFolder()) {
                logger.debug("item is not new, and has not previously been moved. Track the old URL {0}", fromPath);
                HashMap<String, Object> objMetadataProps = new HashMap<String, Object>();
                objMetadataProps.put("renamed", 1);
                objMetadataProps.put("oldUrl", fromPath);
                this.objectMetadataManager.setObjectMetadata(site, fromPath, objMetadataProps);
            }
        }
        if (!renamedItem.isFolder()) {
            if (this.objectMetadataManager.metadataExist(site, movePath) && !StringUtils.equalsIgnoreCase((CharSequence)fromPath, (CharSequence)movePath)) {
                this.objectMetadataManager.deleteObjectMetadata(site, movePath);
            }
            this.objectMetadataManager.updateObjectPath(site, fromPath, movePath);
        }
        SiteFeed siteFeed = this.siteService.getSite(site);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("MOVE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(site + ":" + movePath);
        if (renamedItem.isFolder()) {
            auditLog.setPrimaryTargetType("Folder");
        } else {
            auditLog.setPrimaryTargetType("Content Item");
        }
        auditLog.setPrimaryTargetValue(movePath);
        auditLog.setPrimaryTargetSubtype(this.getContentTypeClass(site, movePath));
        this.auditServiceInternal.insertAuditLog(auditLog);
        this.updateDependenciesOnMove(site, fromPath, movePath);
    }

    protected void updateDependenciesOnMove(String site, String fromPath, String movePath) {
        try {
            this.dependencyService.deleteItemDependencies(site, fromPath);
        }
        catch (ServiceLayerException e) {
            logger.error("Error while deleting dependencies for site " + site + " path " + fromPath, e, new Object[0]);
        }
        try {
            this.dependencyService.upsertDependencies(site, movePath);
        }
        catch (ServiceLayerException e) {
            logger.error("Error while updating dependencies on move content site: " + site + " path: " + movePath, e, new Object[0]);
        }
    }

    protected void updateChildrenOnMove(String site, String fromPath, String movePath) throws SiteNotFoundException {
        logger.debug("updateChildrenOnMove from {0} to {1}", fromPath, movePath);
        ContentItemTO movedTO = this.getContentItem(site, movePath, 2);
        List<ContentItemTO> childrenTOs = movedTO.getChildren();
        for (ContentItemTO childTO : childrenTOs) {
            String childToPath = childTO.getUri();
            String oldParentFolderPath = fromPath.replace("/index.xml", "");
            String parentFolderPath = movePath.replace("/index.xml", "");
            String childFromPath = childToPath.replace(parentFolderPath, oldParentFolderPath);
            logger.debug("updateChildrenOnMove handling child from: {0} to: {1}  ", childFromPath, childToPath);
            this.updateDatabaseOnMove(site, childFromPath, childToPath);
            this.updateChildrenOnMove(site, childFromPath, childToPath);
        }
    }

    protected Map<String, String> constructNewPathforCutCopy(String site, String fromPath, String toPath, boolean adjustOnCollide) throws ServiceLayerException {
        HashMap<String, String> result = new HashMap<String, String>();
        String fromPathOnly = fromPath.substring(0, fromPath.lastIndexOf("/"));
        String fromFileNameOnly = fromPath.substring(fromPath.lastIndexOf("/") + 1);
        boolean fromFileIsIndex = "index.xml".equals(fromFileNameOnly);
        logger.debug("Cut/copy name rules from path: '{0}' name: '{1}'", fromPathOnly, fromFileNameOnly);
        if (fromFileIsIndex) {
            fromFileNameOnly = fromPathOnly.substring(fromPathOnly.lastIndexOf("/") + 1);
            fromPathOnly = fromPathOnly.substring(0, fromPathOnly.lastIndexOf("/"));
            logger.debug("Cut/copy name rules index from path: '{0}' name: '{1}'", fromPathOnly, fromFileNameOnly);
        }
        String newPathOnly = toPath.contains(".xml") ? toPath.substring(0, toPath.lastIndexOf("/")) : toPath;
        String newFileNameOnly = toPath.contains(".xml") ? toPath.substring(toPath.lastIndexOf("/") + 1) : fromFileNameOnly;
        boolean newFileIsIndex = "index.xml".equals(newFileNameOnly);
        logger.debug("Cut/copy name rules to path: '{0}' name: '{1}'", newPathOnly, newFileNameOnly);
        if (newFileIsIndex) {
            newFileNameOnly = newPathOnly.substring(newPathOnly.lastIndexOf("/") + 1);
            newPathOnly = newPathOnly.substring(0, newPathOnly.lastIndexOf("/"));
            logger.debug("Cut/copy name rules index to path: '{0}' name: '{1}'", newPathOnly, newFileNameOnly);
        }
        String proposedDestPath = null;
        String proposedDestPath_filename = null;
        String proposedDestPath_folder = null;
        boolean targetPathExistsPriorToOp = false;
        targetPathExistsPriorToOp = this.contentExists(site, toPath);
        if (fromFileIsIndex && newFileIsIndex) {
            if (newPathOnly.equals(fromPathOnly) && !targetPathExistsPriorToOp) {
                proposedDestPath = newPathOnly + "/" + newFileNameOnly + "/" + "index.xml";
                proposedDestPath_filename = "index.xml";
                proposedDestPath_folder = newFileNameOnly;
            } else {
                proposedDestPath = newPathOnly + "/" + newFileNameOnly + "/" + fromFileNameOnly + "/" + "index.xml";
                proposedDestPath_filename = "index.xml";
                proposedDestPath_folder = fromFileNameOnly;
            }
        } else if (fromFileIsIndex && !newFileIsIndex) {
            proposedDestPath = newPathOnly + "/" + fromFileNameOnly + "/" + "index.xml";
            proposedDestPath_filename = "index.xml";
            proposedDestPath_folder = fromFileNameOnly;
        } else if (!fromFileIsIndex && newFileIsIndex) {
            proposedDestPath = newPathOnly + "/" + newFileNameOnly + "/" + fromFileNameOnly;
            proposedDestPath_filename = fromFileNameOnly;
            proposedDestPath_folder = newFileNameOnly;
        } else if (fromFileNameOnly.equals(newFileNameOnly)) {
            proposedDestPath = !this._contentRepository.contentExists(site, newPathOnly) || this._contentRepository.isFolder(site, newPathOnly) ? newPathOnly + "/" + fromFileNameOnly : newPathOnly;
            proposedDestPath_filename = fromFileNameOnly;
            proposedDestPath_folder = newPathOnly.substring(0, newPathOnly.lastIndexOf("/"));
        } else {
            proposedDestPath = newPathOnly + "/" + newFileNameOnly;
            proposedDestPath_filename = newFileNameOnly;
            proposedDestPath_folder = newPathOnly.substring(0, newPathOnly.lastIndexOf("/"));
        }
        logger.debug("Initial Proposed Path: {0} ", proposedDestPath);
        result.put("FILE_PATH", proposedDestPath);
        result.put("FILE_NAME", proposedDestPath_filename);
        result.put("FILE_FOLDER", proposedDestPath_folder);
        result.put("MODIFIER", "");
        result.put("ALT_NAME", "false");
        boolean contentExists = false;
        if (adjustOnCollide) {
            contentExists = this.contentExists(site, proposedDestPath);
        }
        if (adjustOnCollide && contentExists) {
            logger.debug("File already found at path {0}, creating new name", proposedDestPath);
            try {
                Map<String, String> ids = this.contentItemIdGenerator.getIds();
                String id = ids.get("pageGroupId");
                if (proposedDestPath.indexOf("/index.xml") == -1) {
                    int pdpli = proposedDestPath.lastIndexOf(".");
                    if (pdpli == -1) {
                        pdpli = proposedDestPath.length();
                    }
                    proposedDestPath = proposedDestPath.substring(0, pdpli) + "-" + id + proposedDestPath.substring(pdpli);
                    proposedDestPath_filename = proposedDestPath.substring(proposedDestPath.lastIndexOf("/") + 1);
                    proposedDestPath_folder = proposedDestPath.substring(0, proposedDestPath.lastIndexOf("/"));
                    proposedDestPath_folder = proposedDestPath_folder.substring(proposedDestPath_folder.lastIndexOf("/") + 1);
                } else {
                    proposedDestPath = proposedDestPath.substring(0, proposedDestPath.indexOf("/index.xml")) + "-" + id + proposedDestPath.substring(proposedDestPath.lastIndexOf("/index.xml"));
                    proposedDestPath_filename = "index.xml";
                    proposedDestPath_folder = proposedDestPath.replace("/index.xml", "");
                    proposedDestPath_folder = proposedDestPath_folder.substring(proposedDestPath_folder.lastIndexOf("/") + 1);
                }
                result.put("FILE_PATH", proposedDestPath);
                result.put("FILE_NAME", proposedDestPath_filename);
                result.put("FILE_FOLDER", proposedDestPath_folder);
                result.put("MODIFIER", id);
                result.put("ALT_NAME", "true");
            }
            catch (Exception altPathGenErr) {
                throw new ServiceLayerException("Unable to generate an alternative path for name collision: " + proposedDestPath, altPathGenErr);
            }
        }
        logger.debug("Final proposed path from : '{0}' to: '{1}' final name '{2}'", fromPath, toPath, proposedDestPath);
        return result;
    }

    protected Map<String, String> getItemSpecificDependencies(String site, String path, Document document, Map<String, String> copyDependencies) throws ServiceLayerException {
        List includes;
        Set<String> deps = this.dependencyService.getItemSpecificDependencies(site, path, 1);
        for (String dep : deps) {
            copyDependencies.put(dep, dep);
        }
        Element root = document.getRootElement();
        List keys = root.selectNodes("//key");
        if (keys != null) {
            for (Node keyNode : keys) {
                String keyValue = ((Element)keyNode).getText();
                if (!keyValue.contains("/page")) continue;
                copyDependencies.put(keyValue, keyValue);
            }
        }
        if ((includes = root.selectNodes("//include")) != null) {
            for (Node includeNode : includes) {
                String includeValue = ((Element)includeNode).getText();
                if (!includeValue.contains("/page")) continue;
                copyDependencies.put(includeValue, includeValue);
            }
        }
        return copyDependencies;
    }

    protected Map<String, String> getContentIds(Document document) {
        HashMap<String, String> ids = new HashMap<String, String>();
        if (document != null) {
            Node groupIdNode;
            Element root = document.getRootElement();
            Node pageIdNode = root.selectSingleNode("//objectId");
            if (pageIdNode != null) {
                ids.put("pageId", ((Element)pageIdNode).getText());
            }
            if ((groupIdNode = root.selectSingleNode("//objectGroupId")) != null) {
                ids.put("pageGroupId", ((Element)groupIdNode).getText());
            }
        }
        return ids;
    }

    protected Document updateContentOnCopy(Document document, String filename, String folder, Map<String, String> params, String modifier) throws ServiceLayerException {
        List includes;
        List keys;
        Node groupIdNode;
        Node internalNameNode;
        Node pageIdNode;
        Node folderNode;
        Element root = document.getRootElement();
        String originalPageId = null;
        String originalGroupId = null;
        Node filenameNode = root.selectSingleNode("//file-name");
        if (filenameNode != null) {
            filenameNode.setText(filename);
        }
        if ((folderNode = root.selectSingleNode("//folder-name")) != null) {
            folderNode.setText(folder);
        }
        if ((pageIdNode = root.selectSingleNode("//objectId")) != null) {
            originalPageId = pageIdNode.getText();
            pageIdNode.setText(params.get("pageId"));
        }
        if (modifier != null && (internalNameNode = root.selectSingleNode("//internal-name")) != null) {
            String internalNameValue = internalNameNode.getText();
            internalNameNode.setText(internalNameValue + " " + modifier);
        }
        if ((groupIdNode = root.selectSingleNode("//objectGroupId")) != null) {
            originalGroupId = groupIdNode.getText();
            groupIdNode.setText(params.get("pageGroupId"));
        }
        if ((keys = root.selectNodes("//key")) != null) {
            for (Node keyNode : keys) {
                String keyValue = keyNode.getText();
                keyValue = keyValue.replaceAll(originalPageId, params.get("pageId"));
                if (!(keyValue = keyValue.replaceAll(originalGroupId, params.get("pageGroupId"))).contains("/page")) continue;
                keyNode.setText(keyValue);
            }
        }
        if ((includes = root.selectNodes("//include")) != null) {
            for (Node includeNode : includes) {
                String includeValue = includeNode.getText();
                includeValue = includeValue.replaceAll(originalPageId, params.get("pageId"));
                if (!(includeValue = includeValue.replaceAll(originalGroupId, params.get("pageGroupId"))).contains("/page")) continue;
                includeNode.setText(includeValue);
            }
        }
        return document;
    }

    protected ContentItemTO createNewContentItemTO(String site, String contentPath) {
        ContentItemTO item = new ContentItemTO();
        item.uri = contentPath = FilenameUtils.normalize((String)contentPath, (boolean)true);
        item.path = contentPath.substring(0, contentPath.lastIndexOf("/"));
        item.name = contentPath.substring(contentPath.lastIndexOf("/") + 1);
        item.asset = true;
        item.site = site;
        item.internalName = item.name;
        item.contentType = "unknown";
        item.disabled = false;
        item.savedAsDraft = false;
        item.floating = false;
        item.hideInAuthoring = false;
        item.page = false;
        item.previewable = false;
        item.isPreviewable = false;
        item.component = false;
        item.document = false;
        item.asset = true;
        item.browserUri = "";
        item.isNew = true;
        item.submitted = false;
        item.scheduled = false;
        item.deleted = false;
        item.submittedForDeletion = false;
        item.inProgress = true;
        item.live = false;
        item.folder = this._contentRepository.isFolder(site, contentPath);
        return item;
    }

    protected ContentItemTO populateContentDrivenProperties(String site, ContentItemTO item) throws Exception {
        Document contentDoc;
        String contentPath = item.uri;
        logger.debug("Populating page props '{}'", contentPath);
        item.setLevelDescriptor(item.name.equals(this.servicesConfig.getLevelDescriptorName(site)));
        item.isPage = item.page = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getPagePatterns(site));
        item.isPreviewable = item.previewable = item.page;
        item.isComponent = item.component = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getComponentPatterns(site)) || item.isLevelDescriptor();
        item.isAsset = item.asset = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getAssetPatterns(site));
        item.isDocument = item.document = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getDocumentPatterns(site));
        item.uri = contentPath;
        item.path = contentPath.substring(0, contentPath.lastIndexOf("/"));
        item.name = contentPath.substring(contentPath.lastIndexOf("/") + 1);
        item.browserUri = contentPath;
        if (item.page) {
            item.browserUri = contentPath.replace("/site/website", "").replace("/index.xml", "");
        }
        if ((contentDoc = this.getContentAsDocument(site, contentPath)) != null) {
            Element rootElement = contentDoc.getRootElement();
            String internalName = rootElement.valueOf("internal-name");
            String contentType = rootElement.valueOf("content-type");
            String disabled = rootElement.valueOf("disabled");
            String savedAsDraft = rootElement.valueOf("savedAsDraft");
            String navigation = rootElement.valueOf("placeInNav");
            String hideInAuthoring = rootElement.valueOf("hideInAuthoring");
            String displayTemplate = rootElement.valueOf("display-template");
            item.internalName = internalName != null ? internalName : null;
            item.contentType = contentType != null ? contentType : null;
            item.disabled = disabled != null && "true".equalsIgnoreCase(disabled);
            item.savedAsDraft = savedAsDraft != null && "true".equalsIgnoreCase(savedAsDraft);
            item.hideInAuthoring = hideInAuthoring != null && "true".equalsIgnoreCase(hideInAuthoring);
            item.navigation = navigation != null && "true".equalsIgnoreCase(navigation);
            item.floating = !item.navigation;
            item.setOrders(this.getItemOrders(rootElement.selectNodes("//orderDefault_f")));
            if (displayTemplate != null) {
                RenderingTemplateTO template = new RenderingTemplateTO();
                template.uri = displayTemplate;
                template.name = "DEFAULT";
                item.renderingTemplates.add(template);
            }
        } else {
            logger.debug("no xml document could be loaded for site '{}' path '{}'", site, contentPath);
        }
        Pattern taxonomyPattern = Pattern.compile("/site/taxonomy/([^<]+)\\.xml");
        Matcher matcher = taxonomyPattern.matcher(contentPath);
        if (matcher.matches()) {
            item.contentType = "taxonomy";
        }
        return item;
    }

    protected void addOrderValue(List<DmOrderTO> orders, String orderName, String orderStr) {
        Double orderValue = null;
        try {
            orderValue = Double.parseDouble(orderStr);
        }
        catch (NumberFormatException e) {
            logger.debug(orderName + ", " + orderStr + " is not a valid order value pair.", new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)orderName) && orderValue != null) {
            DmOrderTO order = new DmOrderTO();
            order.setId(orderName);
            order.setOrder(orderValue);
            orders.add(order);
        }
    }

    protected List<DmOrderTO> getItemOrders(List<Node> nodes) {
        if (nodes != null) {
            ArrayList<DmOrderTO> orders = new ArrayList<DmOrderTO>(nodes.size());
            for (Node node : nodes) {
                String orderName = "default";
                String orderStr = node.getText();
                this.addOrderValue(orders, orderName, orderStr);
            }
            return orders;
        }
        return null;
    }

    protected ContentItemTO populateItemChildren(ContentItemTO item, int depth) {
        String contentPath = item.uri;
        item.children = new ArrayList<ContentItemTO>();
        item.numOfChildren = 0;
        if (contentPath.indexOf("/index.xml") != -1 || contentPath.indexOf(".") == -1) {
            if (contentPath.indexOf("/index.xml") != -1) {
                contentPath = contentPath.replace("/index.xml", "");
            }
            RepositoryItem[] childRepoItems = this._contentRepository.getContentChildren(item.site, contentPath);
            boolean indexFound = false;
            if (childRepoItems != null) {
                item.numOfChildren = childRepoItems.length;
                if (item.numOfChildren != 0) {
                    item.isContainer = true;
                    item.container = true;
                }
                ArrayList<ContentItemTO> children = new ArrayList<ContentItemTO>();
                logger.debug("Checking if {0} has index", contentPath);
                for (int j = 0; j < childRepoItems.length; ++j) {
                    if ("index.xml".equals(childRepoItems[j].name)) {
                        if (!item.uri.contains("/index.xml")) {
                            item.path = item.uri;
                            item.uri = item.uri + "/" + "index.xml";
                        }
                        --item.numOfChildren;
                        indexFound = true;
                        continue;
                    }
                    if (depth <= 1) continue;
                    String childPath = childRepoItems[j].path + "/" + childRepoItems[j].name;
                    if (childPath.startsWith("/site/website/") && childRepoItems[j].isFolder && this.contentExists(item.site, childPath + "/" + "index.xml")) {
                        children.add(this.getContentItem(item.site, childPath + "/" + "index.xml", depth - 1));
                        continue;
                    }
                    children.add(this.getContentItem(item.site, childPath, depth - 1));
                }
                if (!indexFound && this._contentRepository.isFolder(item.site, contentPath)) {
                    item.folder = true;
                    item.isContainer = true;
                    item.container = true;
                    item.page = false;
                    item.asset = false;
                    item.component = false;
                    item.previewable = false;
                    item.isPreviewable = false;
                    item.internalName = item.name;
                    item.contentType = "folder";
                    item.path = item.uri;
                }
                ContentItemOrderComparator comparator = new ContentItemOrderComparator("default", true, true, true);
                Collections.sort(children, comparator);
                item.children = children;
            } else {
                item.isContainer = true;
                item.container = true;
            }
        } else {
            item.isContainer = false;
            item.container = false;
        }
        if (item.internalName == null) {
            item.internalName = item.name;
        }
        return item;
    }

    @Override
    @ValidateParams
    public ContentItemTO getContentItem(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this.getContentItem(site, path, 2);
    }

    @Override
    @ValidateParams
    public ContentItemTO getContentItem(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateIntegerParam(name="depth") int depth) {
        ContentItemTO item = null;
        logger.debug("Getting content item for site '{}' path '{}' depth '{}'", site, path, depth);
        DebugUtils.addDebugStack(logger);
        long startTime = System.currentTimeMillis();
        try {
            if (this.contentExists(site, path)) {
                item = this.loadContentItem(site, path);
                if (depth != 0) {
                    item = this.populateItemChildren(item, depth);
                }
                this.populateMetadata(site, item);
                if (!item.isFolder() || item.isContainer()) {
                    this.populateWorkflowProperties(site, item);
                } else {
                    item.setNew(!this.objectStateService.isFolderLive(site, item.getUri()));
                    item.isNew = item.isNew();
                }
            } else {
                item = this.createDummyDmContentItemForDeletedNode(site, path);
            }
        }
        catch (Exception err) {
            logger.debug("error constructing item for object at site '{}' path '{}'", err, site, path);
        }
        long executionTime = System.currentTimeMillis() - startTime;
        logger.debug("Content item from site '{}' path '{}' retrieved in '{}' milli-seconds", site, path, executionTime);
        return item;
    }

    protected ContentItemTO loadContentItem(String site, String path) {
        ContentItemTO item = this.createNewContentItemTO(site, path);
        if (item.uri.endsWith(".xml") && !item.uri.startsWith("/config/")) {
            try {
                item = this.populateContentDrivenProperties(site, item);
            }
            catch (Exception err) {
                logger.debug("error constructing item for object at site '{}' path '{}'", err, site, path);
            }
        } else {
            item.setLevelDescriptor(item.name.equals(this.servicesConfig.getLevelDescriptorName(site)));
            item.isPage = item.page = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getPagePatterns(site));
            item.isPreviewable = item.previewable = item.page;
            item.isAsset = item.asset = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getAssetPatterns(site)) || ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getRenderingTemplatePatterns(site)) || ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getScriptsPatterns(site));
            item.isComponent = item.component = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getComponentPatterns(site)) || item.isLevelDescriptor() || item.asset;
            item.isDocument = item.document = ContentUtils.matchesPatterns(item.getUri(), this.servicesConfig.getDocumentPatterns(site));
            item.browserUri = item.getUri();
            item.setContentType(this.getContentTypeClass(site, path));
        }
        this.loadContentTypeProperties(site, item, item.contentType);
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String mimeType = mimeTypesMap.getContentType(item.getName());
        if (StringUtils.isNotEmpty((CharSequence)mimeType)) {
            item.setMimeType(mimeType);
        }
        return item;
    }

    protected void loadContentTypeProperties(String site, ContentItemTO item, String contentType) {
        if (item.isFolder()) {
            item.setContentType("folder");
        } else if (!(contentType == null || contentType.equals("folder") || contentType.equals("asset") || contentType.equals("unknown"))) {
            ContentTypeConfigTO config = this.servicesConfig.getContentTypeConfig(site, contentType);
            if (config != null) {
                item.setForm(config.getForm());
                item.setFormPagePath(config.getFormPath());
                item.setPreviewable(config.isPreviewable());
                item.isPreviewable = item.previewable;
            }
        } else {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            String mimeType = mimeTypesMap.getContentType(item.getName());
            if (mimeType != null && !StringUtils.isEmpty((CharSequence)mimeType)) {
                item.setPreviewable(ContentUtils.matchesPatterns(mimeType, this.servicesConfig.getPreviewableMimetypesPaterns(site)));
                item.isPreviewable = item.previewable;
            }
        }
    }

    protected void populateWorkflowProperties(String site, ContentItemTO item) {
        ItemState state = this.objectStateService.getObjectState(site, item.getUri(), false);
        if (state != null) {
            if (item.isFolder()) {
                boolean liveFolder = this.objectStateService.isFolderLive(site, item.getUri());
                item.setNew(!liveFolder);
                item.setLive(liveFolder);
            } else {
                item.setNew(State.isNew(State.valueOf(state.getState())));
                item.setLive(State.isLive(State.valueOf(state.getState())));
            }
            item.isNew = item.isNew();
            item.isLive = item.isLive();
            item.setInProgress(!item.isLive());
            item.isInProgress = item.isInProgress();
            item.setScheduled(State.isScheduled(State.valueOf(state.getState())));
            item.isScheduled = item.isScheduled();
            item.setSubmitted(State.isSubmitted(State.valueOf(state.getState())));
            item.isSubmitted = item.isSubmitted();
            item.setInFlight(state.getSystemProcessing() == 1);
            item.isInFlight = item.isInFlight();
        } else if (item.isFolder()) {
            boolean liveFolder = this.objectStateService.isFolderLive(site, item.getUri());
            item.setNew(!liveFolder);
            item.setLive(liveFolder);
            item.isNew = item.isNew();
            item.isLive = item.isLive();
            item.setInProgress(!item.isLive());
            item.isInProgress = item.isInProgress();
        }
    }

    protected void populateMetadata(String site, ContentItemTO item) {
        ItemMetadata metadata = this.objectMetadataManager.getProperties(site, item.getUri());
        if (metadata != null) {
            if (StringUtils.isEmpty((CharSequence)metadata.getLockOwner())) {
                item.setLockOwner("");
            } else {
                item.setLockOwner(metadata.getLockOwner());
            }
            if (metadata.getLaunchDate() != null) {
                item.scheduledDate = metadata.getLaunchDate();
                item.setScheduledDate(metadata.getLaunchDate());
            }
            if (metadata.getPublishedDate() != null) {
                item.published = true;
                item.setPublished(true);
                item.publishedDate = metadata.getPublishedDate();
                item.setPublishedDate(metadata.getPublishedDate());
            }
            if (StringUtils.isEmpty((CharSequence)metadata.getModifier())) {
                item.setUser("");
                item.setUserLastName("");
                item.setUserFirstName("");
            } else {
                item.user = metadata.getModifier();
                item.setUser(metadata.getModifier());
                if (StringUtils.isEmpty((CharSequence)metadata.getFirstName())) {
                    item.userFirstName = metadata.getModifier();
                    item.setUserFirstName(metadata.getModifier());
                } else {
                    item.userFirstName = metadata.getFirstName();
                    item.setUserFirstName(metadata.getFirstName());
                }
                if (StringUtils.isEmpty((CharSequence)metadata.getLastName())) {
                    item.userLastName = "";
                    item.setUserLastName("");
                } else {
                    item.userLastName = metadata.getLastName();
                    item.setUserLastName(metadata.getLastName());
                }
            }
            if (metadata.getModified() != null) {
                item.lastEditDate = metadata.getModified();
                item.eventDate = metadata.getModified();
                item.setLastEditDate(metadata.getModified());
                item.setEventDate(metadata.getModified());
            }
            if (StringUtils.isNotEmpty((CharSequence)metadata.getSubmissionComment())) {
                item.setSubmissionComment(metadata.getSubmissionComment());
            }
            if (StringUtils.isNotEmpty((CharSequence)metadata.getSubmittedToEnvironment())) {
                item.setSubmittedToEnvironment(metadata.getSubmittedToEnvironment());
            }
        } else {
            item.setLockOwner("");
        }
    }

    @Override
    @ValidateParams
    public ContentItemTO getContentItemTree(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateIntegerParam(name="depth") int depth) {
        logger.debug("Getting content item  tree for '{}':'{}' depth '{}'", site, path, depth);
        DebugUtils.addDebugStack(logger);
        long startTime = System.currentTimeMillis();
        boolean isPages = path.contains("/site/website");
        ContentItemTO root = null;
        root = isPages && this.contentExists(site, path + "/" + "index.xml") ? (depth > 1 ? this.getContentItem(site, path + "/" + "index.xml", depth) : this.getContentItem(site, path + "/" + "index.xml")) : (depth > 1 ? this.getContentItem(site, path, depth) : this.getContentItem(site, path));
        long executionTime = System.currentTimeMillis() - startTime;
        logger.debug("Content item tree ['{}':'{}' depth '{}'] retrieved in '{}' milli-seconds", site, path, depth, executionTime);
        return root;
    }

    @Override
    @ValidateParams
    public VersionTO[] getContentItemVersionHistory(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this._contentRepository.getContentVersionHistory(site, path);
    }

    @Override
    @ValidateParams
    public boolean revertContentItem(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="version") String version, boolean major, @ValidateStringParam(name="comment") String comment) throws SiteNotFoundException {
        boolean toReturn = false;
        String commitId = this._contentRepository.revertContent(site, path, version, major, comment);
        if (commitId != null) {
            try {
                this.dependencyService.upsertDependencies(site, path);
            }
            catch (ServiceLayerException e) {
                logger.error("Error while extracting dependencies for reverted content. Site: " + site + " path: " + path + " version: " + version, new Object[0]);
            }
            this.objectStateService.transition(site, path, TransitionEvent.REVERT);
            this.objectMetadataManager.updateCommitId(site, path, commitId);
            SiteFeed siteFeed = this.siteService.getSite(site);
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("REVERT");
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setActorId(this.securityService.getCurrentUser());
            auditLog.setPrimaryTargetId(site + ":" + path);
            auditLog.setPrimaryTargetType("Content Item");
            auditLog.setPrimaryTargetValue(path);
            auditLog.setPrimaryTargetSubtype(this.getContentTypeClass(site, path));
            this.auditServiceInternal.insertAuditLog(auditLog);
            this.contentRepository.insertGitLog(site, commitId, 1, 1);
            this.siteService.updateLastCommitId(site, commitId);
            toReturn = true;
        }
        if (toReturn) {
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(site);
            this.eventService.publish("studio.event.previewSync", context);
        }
        return toReturn;
    }

    @Override
    @ValidateParams
    public InputStream getContentVersion(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="version") String version) throws ContentNotFoundException {
        return this._contentRepository.getContentVersion(site, path, version);
    }

    @Override
    @ValidateParams
    public String getContentVersionAsString(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="version") String version) throws ContentNotFoundException {
        String content = null;
        try {
            content = IOUtils.toString((InputStream)this.getContentVersion(site, path, version));
        }
        catch (Exception err) {
            logger.debug("Failed to get content as string for path {0}, exception {1}", path, err);
        }
        return content;
    }

    @Override
    @ValidateParams
    public ContentItemTO createDummyDmContentItemForDeletedNode(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="relativePath") String relativePath) {
        String contentTypeClass;
        String folderPath;
        String timeZone;
        ContentItemTO item = new ContentItemTO();
        item.timezone = timeZone = this.servicesConfig.getDefaultTimezone(site);
        String name = ContentUtils.getPageName(relativePath);
        item.path = folderPath = name.equals("index.xml") ? relativePath.replace("/" + name, "") : relativePath;
        String internalName = folderPath;
        int index = folderPath.lastIndexOf("/");
        if (index != -1) {
            internalName = folderPath.substring(index + 1);
        }
        item.internalName = internalName;
        item.isDisabled = false;
        item.isNavigation = false;
        item.name = name;
        item.uri = relativePath;
        item.contentType = contentTypeClass = this.getContentTypeClass(site, relativePath);
        if (contentTypeClass.equals("component")) {
            item.component = true;
        } else if (contentTypeClass.equals("document")) {
            item.document = true;
        }
        item.isDeleted = true;
        item.deleted = true;
        item.isContainer = false;
        item.container = false;
        item.isNew = false;
        item.isInProgress = false;
        item.timezone = this.servicesConfig.getDefaultTimezone(site);
        item.isPreviewable = false;
        item.browserUri = this.getBrowserUri(item);
        return item;
    }

    protected String getBrowserUri(ContentItemTO item) {
        String replacePattern = item.isComponent ? "/site/(components|component-bindings|indexes|resources)" : (item.isAsset ? "/static-assets" : (item.isDocument ? "/site/documents" : "/site/website"));
        boolean isPage = !item.isComponent && !item.isAsset && !item.isDocument;
        return ContentServiceImpl.getBrowserUri(item.uri, replacePattern, isPage);
    }

    protected static String getBrowserUri(String uri, String replacePattern, boolean isPage) {
        String browserUri = uri.replaceFirst(replacePattern, "");
        if ((browserUri = browserUri.replaceFirst("/index.xml", "")).length() == 0) {
            browserUri = "/";
        }
        if (isPage) {
            browserUri = browserUri.replaceFirst("\\.xml", ".html");
        }
        return browserUri;
    }

    @Override
    @ValidateParams
    public String getContentTypeClass(@ValidateStringParam(name="site") String site, String uri) {
        if (this.matchesPatterns(uri, this.servicesConfig.getPagePatterns(site))) {
            return "page";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getComponentPatterns(site)) || uri.endsWith("/" + this.servicesConfig.getLevelDescriptorName(site))) {
            return "component";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getDocumentPatterns(site))) {
            return "document";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getAssetPatterns(site))) {
            return "asset";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getRenderingTemplatePatterns(site))) {
            return "renderingTemplate";
        }
        if (StringUtils.startsWith((CharSequence)uri, (CharSequence)this.contentTypeService.getConfigPath())) {
            return "content type";
        }
        if (this.matchesPatterns(uri, Arrays.asList("/site/taxonomy/([^<]+)\\.xml"))) {
            return "taxonomy";
        }
        if (this.matchesPatterns(uri, this.servicesConfig.getScriptsPatterns(site))) {
            return "script";
        }
        return "unknown";
    }

    protected boolean matchesPatterns(String uri, List<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!uri.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public ResultTO processContent(@ValidateStringParam(name="id") String id, InputStream input, boolean isXml, Map<String, String> params, @ValidateStringParam(name="contentChainForm") String contentChainForm) throws ServiceLayerException {
        long start = System.currentTimeMillis();
        try {
            String[] strings = id.split(":");
            long startTime = System.currentTimeMillis();
            ResultTO to = this.contentProcessor.processContent(id, input, isXml, params, contentChainForm);
            long duration = System.currentTimeMillis() - startTime;
            logger.debug("Write Duration: '{}'", duration);
            ResultTO resultTO = to;
            return resultTO;
        }
        finally {
            long end = System.currentTimeMillis();
            logger.debug("Write complete for [" + id + "] in time [" + (end - start) + "]", new Object[0]);
        }
    }

    @Override
    @ValidateParams
    public String getNextAvailableName(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        String[] levels = path.split("/");
        int length = levels.length;
        if (length > 0) {
            ContentItemTO item = this.getContentItem(site, path, 0);
            if (item != null) {
                String name = ContentUtils.getPageName(path);
                String parentPath = ContentUtils.getParentUrl(path);
                ContentItemTO parentItem = this.getContentItemTree(site, parentPath, 1);
                if (parentItem != null) {
                    int lastIndex = name.lastIndexOf(".");
                    String ext = item.isFolder() ? "" : name.substring(lastIndex);
                    String originalName = item.isFolder() || item.isContainer() ? name : name.substring(0, lastIndex);
                    List<ContentItemTO> children = parentItem.getChildren();
                    int lastNumber = 0;
                    String namePattern = originalName + "-[0-9]+" + ext;
                    if (children != null && children.size() > 0) {
                        for (ContentItemTO child : children) {
                            Pattern pattern;
                            Matcher matcher;
                            if ((item.isFolder() || item.isContainer()) != (child.isFolder() || child.isContainer())) continue;
                            String childName = child.getName();
                            if (child.isFolder() || child.isContainer()) {
                                childName = ContentUtils.getPageName(child.getBrowserUri());
                            }
                            if (!childName.matches(namePattern) || !(matcher = (pattern = item.isFolder() || item.isContainer() ? COPY_FOLDER_PATTERN : COPY_FILE_PATTERN).matcher(childName)).matches()) continue;
                            int helper = ContentFormatUtils.getIntValue(matcher.group(2));
                            lastNumber = helper > lastNumber ? helper : lastNumber;
                        }
                    }
                    String nextName = originalName + "-" + ++lastNumber + ext;
                    return nextName;
                }
            }
        } else {
            return "";
        }
        return levels[length - 1];
    }

    @Override
    @ValidateParams
    public GoLiveDeleteCandidates getDeleteCandidates(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="relativePath") String relativePath) throws ServiceLayerException {
        ContentItemTO contentItem = this.getContentItem(site, relativePath);
        GoLiveDeleteCandidates deletedItems = new GoLiveDeleteCandidates(site, this, this.objectStateService);
        if (contentItem != null) {
            this.childDeleteItems(site, contentItem, deletedItems);
        }
        return deletedItems;
    }

    protected void childDeleteItems(String site, ContentItemTO contentItem, GoLiveDeleteCandidates items) throws ServiceLayerException {
        if (contentItem.isFolder()) {
            if ((contentItem = this.getContentItemTree(site, contentItem.getUri(), 1)).getChildren() != null && contentItem.getNumOfChildren() > 0) {
                for (ContentItemTO child : contentItem.getChildren()) {
                    this.childDeleteItems(site, child, items);
                }
            }
        } else {
            this.addDependenciesToDelete(site, contentItem.getUri(), contentItem.getUri(), items);
            this.addRemovedDependenicesToDelete(site, contentItem.getUri(), items);
        }
        items.getPaths().add(contentItem.getUri());
    }

    protected void addDependenciesToDelete(String site, String sourceContentPath, String dependencyPath, GoLiveDeleteCandidates candidates) throws ServiceLayerException {
        HashSet dependencyParentFolder = new HashSet();
        Set<String> dependencies = this.dependencyService.getDeleteDependencies(site, sourceContentPath);
        for (String dependency : dependencies) {
            candidates.addDependency(dependency);
            logger.debug("Added to delete" + dependency, new Object[0]);
        }
        for (String parentFolderToDelete : dependencyParentFolder) {
            RepositoryItem[] children = this._contentRepository.getContentChildren(site, parentFolderToDelete);
            ArrayList<String> childItems = new ArrayList<String>();
            for (RepositoryItem child : children) {
                childItems.add(child.path + "/" + child.name);
            }
            if (!candidates.getAllItems().containsAll(childItems)) continue;
            logger.debug("Added parentFolder for delete" + parentFolderToDelete, new Object[0]);
            candidates.addDependencyParentFolder(parentFolderToDelete);
        }
    }

    protected void addRemovedDependenicesToDelete(String site, String relativePath, GoLiveDeleteCandidates candidates) throws ServiceLayerException {
        if (relativePath.endsWith(".xml") && !this.objectStateService.isNew(site, relativePath)) {
            DependencyDiffService.DiffRequest diffRequest = new DependencyDiffService.DiffRequest(site, relativePath, null, null, site, true);
            List<String> deleted = this.getRemovedDependenices(diffRequest, true);
            logger.debug("Removed dependenices for path[" + relativePath + "] : " + deleted, new Object[0]);
            for (String dependency : deleted) {
                candidates.getLiveDependencyItems().add(dependency);
            }
        }
    }

    protected List<String> getRemovedDependenices(DependencyDiffService.DiffRequest diffRequest, boolean matchDeletePattern) throws ServiceLayerException {
        DependencyDiffService.DiffResponse diffResponse = this.dependencyDiffService.diff(diffRequest);
        List<String> removedDep = diffResponse.getRemovedDependencies();
        if (matchDeletePattern) {
            removedDep = this.filterDependenicesMatchingDeletePattern(diffRequest.getSite(), diffRequest.getSourcePath(), diffResponse.getRemovedDependencies());
        }
        return removedDep;
    }

    protected List<String> filterDependenicesMatchingDeletePattern(String site, String sourcePath, List<String> dependencies) throws ServiceLayerException {
        List<DeleteDependencyConfigTO> deleteAssociations;
        ArrayList<String> matchingDep = new ArrayList<String>();
        if (sourcePath.endsWith(".xml") && sourcePath.endsWith(".xml") && (deleteAssociations = this.getDeletePatternConfig(site, sourcePath)) != null && deleteAssociations.size() > 0) {
            for (String dependency : dependencies) {
                for (DeleteDependencyConfigTO deleteAssoc : deleteAssociations) {
                    if (!dependency.matches(deleteAssoc.getPattern())) continue;
                    matchingDep.add(dependency);
                }
            }
        }
        return matchingDep;
    }

    protected List<DeleteDependencyConfigTO> getDeletePatternConfig(String site, String relativePath, boolean isInLiveRepo) throws ServiceLayerException {
        ArrayList<DeleteDependencyConfigTO> deleteAssociations = new ArrayList();
        ContentItemTO dependencyItem = this.getContentItem(site, relativePath, 0);
        String contentType = dependencyItem.getContentType();
        deleteAssociations = this.servicesConfig.getDeleteDependencyPatterns(site, contentType);
        return deleteAssociations;
    }

    protected List<DeleteDependencyConfigTO> getDeletePatternConfig(String site, String relativePath) throws ServiceLayerException {
        return this.getDeletePatternConfig(site, relativePath, false);
    }

    @Override
    @ValidateParams
    public void lockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        this._contentRepository.lockItem(site, path);
        this.objectMetadataManager.lockContent(site, path, this.securityService.getCurrentUser());
    }

    @Override
    @ValidateParams
    public void unLockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ContentItemTO item = this.getContentItem(site, path, 0);
        this.objectStateService.transition(site, item, TransitionEvent.CANCEL_EDIT);
        this._contentRepository.unLockItem(site, path);
        this.objectMetadataManager.unLockContent(site, path);
    }

    @Override
    @ValidateParams
    public List<DmOrderTO> getItemOrders(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws ContentNotFoundException {
        List<DmOrderTO> dmOrderTOs = this.getOrders(site, path, "default", false);
        for (DmOrderTO dmOrderTO : dmOrderTOs) {
            dmOrderTO.setName(StringEscapeUtils.escapeJava((String)dmOrderTO.getName()));
        }
        return dmOrderTOs;
    }

    private List<DmOrderTO> getOrders(String site, String relativePath, String orderName, boolean includeFloating) {
        ContentItemTO item;
        int index;
        if (!StringUtils.isEmpty((CharSequence)relativePath) && relativePath.endsWith(".xml") && (index = relativePath.lastIndexOf("/")) > 0) {
            int secondIndex;
            String fileName = relativePath.substring(index + 1);
            String path = relativePath.substring(0, index);
            if ("index.xml".equals(fileName) && (secondIndex = path.lastIndexOf("/")) > 0) {
                path = path.substring(0, secondIndex);
            }
            relativePath = path;
        }
        if ((item = this.getContentItem(site, relativePath)).getChildren() != null) {
            ArrayList<DmOrderTO> orders = new ArrayList<DmOrderTO>(item.getChildren().size());
            String pathIndex = relativePath + "/" + "index.xml";
            for (ContentItemTO child : item.getChildren()) {
                if (pathIndex.equals(child.getUri()) || child.isLevelDescriptor() || child.isDeleted() || child.isFloating() && !includeFloating) continue;
                DmOrderTO order = new DmOrderTO();
                order.setId(child.getUri());
                Double orderNumber = child.getOrder(orderName);
                if (orderNumber == null || !(orderNumber > 0.0)) continue;
                order.setOrder(child.getOrder(orderName));
                order.setName(child.getInternalName());
                if (child.isDisabled()) {
                    order.setDisabled("true");
                } else {
                    order.setDisabled("false");
                }
                if (child.isNavigation()) {
                    order.setPlaceInNav("true");
                } else {
                    order.setPlaceInNav("false");
                }
                orders.add(order);
            }
            return orders;
        }
        return null;
    }

    @Override
    @ValidateParams
    public double reorderItems(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="relativePath") String relativePath, @ValidateSecurePathParam(name="before") String before, @ValidateSecurePathParam(name="after") String after, @ValidateStringParam(name="orderName") String orderName) throws ServiceLayerException {
        Double beforeOrder = null;
        Double afterOrder = null;
        DmOrderTO beforeOrderTO = null;
        DmOrderTO afterOrderTO = null;
        if (!StringUtils.isEmpty((CharSequence)before)) {
            ContentItemTO beforeItem = this.getContentItem(site, before, 0);
            beforeOrder = beforeItem.getOrder(orderName);
            beforeOrderTO = new DmOrderTO();
            beforeOrderTO.setId(before);
            if (beforeOrder != null && beforeOrder > 0.0) {
                beforeOrderTO.setOrder(beforeOrder);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)after)) {
            ContentItemTO afterItem = this.getContentItem(site, after, 0);
            afterOrder = afterItem.getOrder(orderName);
            afterOrderTO = new DmOrderTO();
            afterOrderTO.setId(after);
            if (afterOrder != null && afterOrder > 0.0) {
                afterOrderTO.setOrder(afterOrder);
            }
        }
        if (afterOrder == null && beforeOrder == null) {
            return this.dmPageNavigationOrderService.getNewNavOrder(site, ContentUtils.getParentUrl(relativePath.replace("/index.xml", "")));
        }
        if (beforeOrder == null) {
            return (0.0 + afterOrder) / 2.0;
        }
        if (afterOrder == null) {
            logger.info("afterOrder == null", new Object[0]);
            return this.dmPageNavigationOrderService.getNewNavOrder(site, ContentUtils.getParentUrl(relativePath.replace("/index.xml", "")), beforeOrder);
        }
        return this.computeReorder(site, relativePath, beforeOrderTO, afterOrderTO, orderName);
    }

    protected double computeReorder(String site, String relativePath, DmOrderTO beforeOrderTO, DmOrderTO afterOrderTO, String orderName) throws ContentNotFoundException {
        List<DmOrderTO> orderTO = this.getOrders(site, relativePath, orderName, true);
        Collections.sort(orderTO);
        int beforeIndex = orderTO.indexOf(beforeOrderTO);
        int afterIndex = orderTO.indexOf(afterOrderTO);
        if (beforeIndex + 1 != afterIndex) {
            beforeOrderTO = orderTO.get(afterIndex - 1);
        }
        return (beforeOrderTO.getOrder() + afterOrderTO.getOrder()) / 2.0;
    }

    @Override
    @ValidateParams
    public boolean renameFolder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="name") String name) throws ServiceLayerException {
        boolean toRet = false;
        String parentPath = "/" + FilenameUtils.getPathNoEndSeparator((String)path);
        String targetPath = parentPath + "/" + name;
        if (this.contentExists(site, targetPath)) {
            Map<String, String> ids = this.contentItemIdGenerator.getIds();
            String id = ids.get("pageGroupId");
            targetPath = targetPath + "-" + (String)id;
        }
        logger.debug("Rename folder for site {0} sourcePath {3} to target path {4}", site, path, targetPath);
        Map<String, String> commitIds = this._contentRepository.moveContent(site, path, targetPath);
        if (commitIds != null) {
            this.updateDatabaseOnMove(site, path, targetPath);
            this.updateChildrenOnMove(site, path, targetPath);
            for (Map.Entry entry : commitIds.entrySet()) {
                this.objectMetadataManager.updateCommitId(site, "/" + (String)entry.getKey(), (String)entry.getValue());
                this.contentRepository.insertGitLog(site, (String)entry.getValue(), 1);
            }
            this.siteService.updateLastCommitId(site, this._contentRepository.getRepoLastCommitId(site));
            PreviewEventContext context = new PreviewEventContext();
            context.setSite(site);
            this.eventService.publish("studio.event.previewSync", context);
            toRet = true;
        } else {
            logger.error("Repository move failed site {0} from {1} to {2}", site, path, targetPath);
        }
        return toRet;
    }

    @Override
    public boolean pushToRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, AuthenticationException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        boolean toRet = this._contentRepository.pushToRemote(siteId, remoteName, remoteBranch);
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("PUSH_TO_REMOTE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(remoteName + "/" + remoteBranch);
        auditLog.setPrimaryTargetType("Remote Repository");
        auditLog.setPrimaryTargetValue(remoteName + "/" + remoteBranch);
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    @Override
    public boolean pullFromRemote(String siteId, String remoteName, String remoteBranch) throws ServiceLayerException, InvalidRemoteUrlException, AuthenticationException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        boolean toRet = this._contentRepository.pullFromRemote(siteId, remoteName, remoteBranch);
        SiteFeed siteFeed = this.siteService.getSite(siteId);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("PULL_FROM_REMOTE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(this.userService.getCurrentUser().getUsername());
        auditLog.setPrimaryTargetId(remoteName + "/" + remoteBranch);
        auditLog.setPrimaryTargetType("Remote Repository");
        auditLog.setPrimaryTargetValue(remoteName + "/" + remoteBranch);
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    public org.craftercms.studio.api.v1.repository.ContentRepository getContentRepository() {
        return this._contentRepository;
    }

    public void setContentRepository(org.craftercms.studio.api.v1.repository.ContentRepository contentRepository) {
        this._contentRepository = contentRepository;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public ProcessContentExecutor getContentProcessor() {
        return this.contentProcessor;
    }

    public void setContentProcessor(ProcessContentExecutor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public DmPageNavigationOrderService getDmPageNavigationOrderService() {
        return this.dmPageNavigationOrderService;
    }

    public void setDmPageNavigationOrderService(DmPageNavigationOrderService dmPageNavigationOrderService) {
        this.dmPageNavigationOrderService = dmPageNavigationOrderService;
    }

    public DmContentLifeCycleService getDmContentLifeCycleService() {
        return this.dmContentLifeCycleService;
    }

    public void setDmContentLifeCycleService(DmContentLifeCycleService dmContentLifeCycleService) {
        this.dmContentLifeCycleService = dmContentLifeCycleService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentItemIdGenerator getContentItemIdGenerator() {
        return this.contentItemIdGenerator;
    }

    public void setContentItemIdGenerator(ContentItemIdGenerator contentItemIdGenerator) {
        this.contentItemIdGenerator = contentItemIdGenerator;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public DependencyDiffService getDependencyDiffService() {
        return this.dependencyDiffService;
    }

    public void setDependencyDiffService(DependencyDiffService dependencyDiffService) {
        this.dependencyDiffService = dependencyDiffService;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public ContentRepository getContentRepositoryV2() {
        return this.contentRepository;
    }

    public void setContentRepositoryV2(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }
}

