/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.configuration.ContentTypesConfig;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class ContentTypeServiceImpl
implements ContentTypeService {
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeServiceImpl.class);
    protected ContentService contentService;
    protected ServicesConfig servicesConfig;
    protected ContentTypesConfig contentTypesConfig;
    protected SecurityService securityService;
    protected ContentRepository contentRepository;
    protected StudioConfiguration studioConfiguration;

    @Override
    @ValidateParams
    public ContentTypeConfigTO getContentTypeForContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws ServiceLayerException {
        ContentItemTO itemTO = this.contentService.getContentItem(site, path, 0);
        if (itemTO != null) {
            String type = itemTO.getContentType();
            if (!StringUtils.isEmpty((CharSequence)type)) {
                return this.servicesConfig.getContentTypeConfig(site, type);
            }
            throw new ServiceLayerException("No content type specified for " + path + " in site: " + site);
        }
        throw new ContentNotFoundException(path + " is not found in site: " + site);
    }

    @Override
    public boolean isUserAllowed(Set<String> userRoles, ContentTypeConfigTO item) {
        if (item != null) {
            String name = item.getName();
            Set<String> allowedRoles = item.getAllowedRoles();
            logger.debug("Checking allowed roles on " + name + ". user roles: " + userRoles + ", allowed roles: " + allowedRoles, new Object[0]);
            if (allowedRoles == null || allowedRoles.size() == 0) {
                return true;
            }
            boolean notAllowed = Collections.disjoint(userRoles, allowedRoles);
            if (notAllowed) {
                logger.debug(name + " is not allowed for the user.", new Object[0]);
                return false;
            }
            return true;
        }
        logger.debug("no content type config provided. returning true for user access to content type checking.", new Object[0]);
        return true;
    }

    @Override
    @ValidateParams
    public ContentTypeConfigTO getContentTypeByRelativePath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="relativePath") String relativePath) throws ServiceLayerException {
        ContentItemTO item = this.contentService.getContentItem(site, relativePath, 0);
        if (item != null) {
            String type = item.getContentType();
            if (!StringUtils.isEmpty((CharSequence)type)) {
                return this.servicesConfig.getContentTypeConfig(site, type);
            }
            throw new ServiceLayerException("No content type specified for " + relativePath + " in site: " + site);
        }
        throw new ContentNotFoundException(relativePath + " is not found in site: " + site);
    }

    @Override
    @ValidateParams
    public ContentTypeConfigTO getContentType(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="type") String type) {
        return this.servicesConfig.getContentTypeConfig(site, type);
    }

    @Override
    @ValidateParams
    public List<ContentTypeConfigTO> getAllContentTypes(@ValidateStringParam(name="site") String site, boolean searchable) {
        return this.getAllContentTypes(site);
    }

    @Override
    @ValidateParams
    public List<ContentTypeConfigTO> getAllowedContentTypesForPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="relativePath") String relativePath) throws ServiceLayerException {
        String user = this.securityService.getCurrentUser();
        Set<String> userRoles = this.securityService.getUserRoles(site, user);
        List<ContentTypeConfigTO> allContentTypes = this.getAllContentTypes(site);
        if (CollectionUtils.isNotEmpty(allContentTypes)) {
            ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
            for (ContentTypeConfigTO contentTypeConfig : allContentTypes) {
                if (CollectionUtils.isNotEmpty(contentTypeConfig.getPathIncludes())) {
                    for (String pathIncludes : contentTypeConfig.getPathIncludes()) {
                        if (!relativePath.matches(pathIncludes)) continue;
                        logger.debug(relativePath + " matches " + pathIncludes, new Object[0]);
                        boolean isMatch = true;
                        if (contentTypeConfig.getPathExcludes() != null) {
                            for (String excludePath : contentTypeConfig.getPathExcludes()) {
                                if (!relativePath.matches(excludePath)) continue;
                                logger.debug(relativePath + " matches an exclude path: " + excludePath, new Object[0]);
                                isMatch = false;
                                break;
                            }
                        }
                        if (!isMatch) continue;
                        this.addContentTypes(site, userRoles, contentTypeConfig, contentTypes);
                    }
                    continue;
                }
                if (!CollectionUtils.isEmpty(contentTypeConfig.getPathExcludes())) continue;
                this.addContentTypes(site, userRoles, contentTypeConfig, contentTypes);
            }
            return contentTypes;
        }
        logger.error("No content type path configuration is found for site: " + site, new Object[0]);
        return null;
    }

    protected void addContentTypes(String site, Set<String> userRoles, ContentTypeConfigTO config, List<ContentTypeConfigTO> contentTypes) {
        boolean isAllowed = this.isUserAllowed(userRoles, config);
        if (isAllowed) {
            contentTypes.add(config);
        }
    }

    @Override
    @ValidateParams
    public boolean changeContentType(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="contentType") String contentType) throws ServiceLayerException {
        ContentTypeConfigTO contentTypeConfigTO = this.getContentType(site, contentType);
        if (contentTypeConfigTO.getFormPath().equalsIgnoreCase("simple")) {
            return true;
        }
        ContentItemTO item = this.contentService.getContentItem(site, path, 0);
        if (item != null) {
            this.contentService.lockContent(site, path);
            Document original = null;
            try {
                original = this.contentService.getContentAsDocument(site, path);
            }
            catch (DocumentException e) {
                logger.error("Error while getting document for site: " + site + " path: " + path, (Exception)((Object)e), new Object[0]);
                return false;
            }
            throw new RuntimeException("Is it getting here?");
        }
        throw new ContentNotFoundException(path + " is not a valid content path.");
    }

    protected List<ContentTypeConfigTO> getAllContentTypes(String site) {
        String contentTypesRootPath = this.getConfigPath().replaceAll("\\{site\\}", site);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(site, contentTypesRootPath);
        ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                ContentTypeConfigTO config;
                String configPath = folders[i].path + "/" + folders[i].name + "/" + this.getConfigFileName();
                if (this.contentService.contentExists(site, configPath) && (config = this.contentTypesConfig.reloadConfiguration(site, configPath.replace(contentTypesRootPath, "").replace("/" + this.getConfigFileName(), ""))) != null) {
                    contentTypes.add(config);
                }
                this.reloadContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
        return contentTypes;
    }

    @Override
    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        String contentTypesRootPath = this.getConfigPath().replaceAll("\\{site\\}", site);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(site, contentTypesRootPath);
        ArrayList<ContentTypeConfigTO> contentTypes = new ArrayList<ContentTypeConfigTO>();
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                ContentTypeConfigTO config;
                String configPath = folders[i].path + "/" + folders[i].name + "/" + this.getConfigFileName();
                if (this.contentService.contentExists(site, configPath) && (config = this.contentTypesConfig.reloadConfiguration(site, configPath.replace(contentTypesRootPath, "").replace("/" + this.getConfigFileName(), ""))) != null) {
                    contentTypes.add(config);
                }
                this.reloadContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
    }

    protected void reloadContentTypeConfigForChildren(String site, RepositoryItem node, List<ContentTypeConfigTO> contentTypes) {
        String contentTypesRootPath = this.getConfigPath().replaceAll("\\{site\\}", site);
        String fullPath = node.path + "/" + node.name;
        logger.debug("Get Content Type Config fot Children path = {0}", fullPath);
        RepositoryItem[] folders = this.contentRepository.getContentChildren(site, fullPath);
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                ContentTypeConfigTO config;
                if (!folders[i].isFolder) continue;
                String configPath = folders[i].path + "/" + folders[i].name + "/" + this.getConfigFileName();
                if (this.contentService.contentExists(site, configPath) && (config = this.contentTypesConfig.reloadConfiguration(site, configPath.replace(contentTypesRootPath, "").replace("/" + this.getConfigFileName(), ""))) != null) {
                    contentTypes.add(config);
                }
                this.reloadContentTypeConfigForChildren(site, folders[i], contentTypes);
            }
        }
    }

    @Override
    public String getConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.contentTypes.configBasePath");
    }

    public String getConfigFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.contentTypes.configFileName");
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentTypesConfig getContentTypesConfig() {
        return this.contentTypesConfig;
    }

    public void setContentTypesConfig(ContentTypesConfig contentTypesConfig) {
        this.contentTypesConfig = contentTypesConfig;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

