/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ContentNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.script.ScriptExecutor;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmContentLifeCycleService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.craftercms.studio.impl.v1.util.spring.context.ApplicationContextProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class DmContentLifeCycleServiceImpl
extends AbstractRegistrableService
implements DmContentLifeCycleService {
    private static final Logger logger = LoggerFactory.getLogger(DmContentLifeCycleServiceImpl.class);
    protected ContentService contentService;
    protected SecurityService securityService;
    protected ScriptExecutor scriptExecutor;
    protected StudioConfiguration studioConfiguration;
    protected Map<String, Object> _scriptObjects;

    public String getScriptLocation() {
        return this.studioConfiguration.getProperty("studio.contentProcessor.contentLifeCycle.scriptLocation");
    }

    public Map<String, Object> getScriptObjects() {
        return this._scriptObjects;
    }

    public void setScriptObjects(Map<String, Object> scriptObjects) {
        this._scriptObjects = scriptObjects;
    }

    @Override
    public void register() {
        this.getServicesManager().registerService(DmContentLifeCycleService.class, this);
    }

    @Override
    @ValidateParams
    public void process(@ValidateStringParam(name="site") String site, @ValidateStringParam String user, @ValidateSecurePathParam String path, @ValidateStringParam(name="contentType") String contentType, DmContentLifeCycleService.ContentLifeCycleOperation operation, Map<String, String> params) {
        if (operation == null) {
            logger.warn("No lifecycle operation provided for " + site + ":" + path, new Object[0]);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)contentType) || StringUtils.equals((CharSequence)contentType, (CharSequence)"unknown")) {
            logger.warn("Skipping content lifecycle script execution. no content type provided for " + site + ":" + path, new Object[0]);
            return;
        }
        String scriptPath = this.getScriptPath(site, contentType);
        if (!this.contentService.contentExists(site, scriptPath)) {
            logger.error("No script found at " + scriptPath + ", contentType: " + contentType, new Object[0]);
            return;
        }
        String script = this.contentService.getContentAsString(site, scriptPath);
        if (StringUtils.isNotEmpty((CharSequence)script)) {
            Map<String, Object> model = this.buildModel(site, user, path, contentType, operation.toString(), params);
            try {
                this.scriptExecutor.executeScriptString(script, model);
            }
            catch (Exception e) {
                logger.error("Error while executing content lifecycle script for " + site + ":" + path, e, new Object[0]);
            }
        }
    }

    protected String getScriptPath(String site, String contentType) {
        String location = this.getScriptLocation().replaceAll("\\{site\\}", site).replaceAll("\\{content\\-type\\}", contentType);
        return location;
    }

    protected Map<String, Object> buildModel(String site, String user, String path, String contentType, String operation, Map<String, String> params) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        for (String scriptObjectName : this._scriptObjects.keySet()) {
            model.put(scriptObjectName, this._scriptObjects.get(scriptObjectName));
        }
        model.put("site", site);
        model.put("path", path);
        user = StringUtils.isEmpty((CharSequence)user) ? this.securityService.getCurrentUser() : user;
        model.put("user", user);
        model.put("contentType", contentType);
        model.put("contentLifecycleOperation", operation);
        model.put("contentLoader", new XmlContentLoader());
        model.put("applicationContext", ApplicationContextProvider.getApplicationContext());
        if (params != null) {
            for (String key : params.keySet()) {
                model.put(key, params.get(key));
            }
        }
        return model;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public class XmlContentLoader
    implements Serializable {
        private static final long serialVersionUID = -7848136703282922101L;

        public Document getContent(String site, String path) {
            InputStream is = null;
            try {
                is = DmContentLifeCycleServiceImpl.this.contentService.getContent(site, path);
                SAXReader saxReader = new SAXReader();
                try {
                    saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (SAXException ex) {
                    logger.error("Unable to turn off external entity loading, This could be a security risk.", ex, new Object[0]);
                }
                Document content = saxReader.read(is);
                return content;
            }
            catch (CryptoException | ContentNotFoundException | DocumentException e) {
                logger.error("Error while reading content from site " + site + " path " + path, (Exception)e, new Object[0]);
                if (is != null) {
                    ContentUtils.release(is);
                }
                return null;
            }
        }
    }
}

