/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateDoubleParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.NavigationOrderSequence;
import org.craftercms.studio.api.v1.dal.NavigationOrderSequenceMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class DmPageNavigationOrderServiceImpl
extends AbstractRegistrableService
implements DmPageNavigationOrderService {
    private static final Logger logger = LoggerFactory.getLogger(DmPageNavigationOrderServiceImpl.class);
    protected GeneralLockService generalLockService;
    protected ContentService contentService;
    protected StudioConfiguration studioConfiguration;
    protected NavigationOrderSequenceMapper navigationOrderSequenceMapper;

    @Override
    public void register() {
        this._servicesManager.registerService(DmPageNavigationOrderService.class, this);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public double getNewNavOrder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this.getNewNavOrder(site, path, -1.0);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public double getNewNavOrder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateDoubleParam(name="currentMaxNavOrder") double currentMaxNavOrder) {
        double lastNavOrder = 1000.0;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", path);
            NavigationOrderSequence navigationOrderSequence = this.navigationOrderSequenceMapper.getPageNavigationOrderForSiteAndPath(params);
            if (navigationOrderSequence == null) {
                navigationOrderSequence = new NavigationOrderSequence();
                navigationOrderSequence.setSite(site);
                navigationOrderSequence.setPath(path);
                ContentItemTO itemTreeTO = this.contentService.getContentItemTree(site, path, 1);
                if (itemTreeTO == null) {
                    navigationOrderSequence.setMaxCount(0.0);
                } else {
                    if (StringUtils.isEmpty((CharSequence)itemTreeTO.getNodeRef())) {
                        navigationOrderSequence.setFolderId(UUID.randomUUID().toString());
                    } else {
                        navigationOrderSequence.setFolderId(itemTreeTO.getNodeRef());
                    }
                    if (currentMaxNavOrder < 0.0) {
                        navigationOrderSequence.setMaxCount(1000.0f * (float)itemTreeTO.getNumOfChildren());
                    } else {
                        double newMaxCount = currentMaxNavOrder + (double)this.getPageNavigationOrderIncrement();
                        navigationOrderSequence.setMaxCount(newMaxCount);
                    }
                }
                this.navigationOrderSequenceMapper.insert(navigationOrderSequence);
            } else {
                double newMaxCount = navigationOrderSequence.getMaxCount() + (double)this.getPageNavigationOrderIncrement();
                navigationOrderSequence.setMaxCount(newMaxCount);
                this.navigationOrderSequenceMapper.update(navigationOrderSequence);
            }
            lastNavOrder = navigationOrderSequence.getMaxCount();
        }
        catch (Exception e) {
            logger.error("Unexpected error: ", e, new Object[0]);
        }
        return lastNavOrder;
    }

    @Override
    @ValidateParams
    public boolean addNavOrder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, Document document) {
        boolean docUpdated = false;
        Element root = document.getRootElement();
        Node navOrderNode = root.selectSingleNode("//orderDefault_f");
        if (navOrderNode != null) {
            String newOrder = String.valueOf(this.getNewNavOrder(site, path));
            ((Element)navOrderNode).setText(newOrder);
            docUpdated = true;
        }
        return docUpdated;
    }

    @Override
    @ValidateParams
    public boolean updateNavOrder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, Document document) {
        boolean docUpdated = false;
        Element root = document.getRootElement();
        Node navOrderNode = root.selectSingleNode("//orderDefault_f");
        if (navOrderNode != null) {
            String value = ((Element)navOrderNode).getText();
            if (StringUtils.isEmpty((CharSequence)value)) {
                String newOrder = String.valueOf(this.getNewNavOrder(site, path));
                ((Element)navOrderNode).setText(newOrder);
                docUpdated = true;
            } else {
                logger.debug("Nav Order value already exist: " + value, new Object[0]);
            }
        }
        return docUpdated;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteSequencesForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.navigationOrderSequenceMapper.deleteSequencesForSite(params);
    }

    @Override
    public int getPageNavigationOrderIncrement() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.pageNavigationOrder.increment"));
        return toReturn;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public NavigationOrderSequenceMapper getNavigationOrderSequenceMapper() {
        return this.navigationOrderSequenceMapper;
    }

    public void setNavigationOrderSequenceMapper(NavigationOrderSequenceMapper navigationOrderSequenceMapper) {
        this.navigationOrderSequenceMapper = navigationOrderSequenceMapper;
    }
}

