/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.studio.api.v1.dal.ItemState;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ImportService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentFormatUtils;
import org.craftercms.studio.impl.v1.util.ContentUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class ImportServiceImpl
implements ImportService {
    private static final Logger logger = LoggerFactory.getLogger(ImportServiceImpl.class);
    protected SiteService siteService;
    protected SecurityService securityService;
    protected ContentRepository contentRepository;
    protected ContentService contentService;
    protected ObjectStateService objectStateService;
    protected DmPublishService dmPublishService;
    protected StudioConfiguration studioConfiguration;
    private boolean inProgress = false;
    private boolean pauseEanbeld = false;
    private long nextStop;
    private long currentDelayInterval;
    private long currentDelayLength;

    @Override
    @ValidateParams
    public void importSite(@ValidateSecurePathParam(name="configLocation") String configLocation) throws SiteNotFoundException {
        Element root;
        List siteNodes;
        Document document = this.loadConfiguration(configLocation);
        if (document != null && (siteNodes = (root = document.getRootElement()).selectNodes("site")) != null) {
            for (Node siteNode : siteNodes) {
                String name = siteNode.valueOf("name");
                String buildDataLocation = siteNode.valueOf("build-data-location");
                String publishingChannelGroup = siteNode.valueOf("publish-channel-group");
                String publishStr = siteNode.valueOf("publish");
                boolean publish = !StringUtils.isEmpty((CharSequence)publishStr) && publishStr.equalsIgnoreCase("true");
                String publishSize = siteNode.valueOf("publish-chunk-size");
                int chunkSize = !StringUtils.isEmpty((CharSequence)publishSize) && StringUtils.isNumeric((CharSequence)publishSize) ? Integer.valueOf(publishSize) : -1;
                Node foldersNode = siteNode.selectSingleNode("folders");
                String sourceLocation = buildDataLocation + "/" + name;
                String delayIntervalStr = siteNode.valueOf("delay-interval");
                int delayInterval = !StringUtils.isEmpty((CharSequence)delayIntervalStr) && StringUtils.isNumeric((CharSequence)delayIntervalStr) ? Integer.valueOf(delayIntervalStr) : -1;
                String delayLengthStr = siteNode.valueOf("delay-length");
                int delayLength = !StringUtils.isEmpty((CharSequence)delayLengthStr) && StringUtils.isNumeric((CharSequence)delayLengthStr) ? Integer.valueOf(delayLengthStr) : -1;
                this.importFromConfigNode(name, publishingChannelGroup, foldersNode, sourceLocation, "/", publish, chunkSize, delayInterval, delayLength);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Document loadConfiguration(String configLocation) {
        FileInputStream in;
        block6: {
            Document document;
            logger.debug("[IMPORT] loading " + configLocation, new Object[0]);
            in = null;
            try {
                in = new FileInputStream(configLocation);
                if (in == null) break block6;
                document = ContentUtils.convertStreamToXml(in);
            }
            catch (FileNotFoundException e) {
                logger.error("[IMPORT] failed to load configuration.", e, new Object[0]);
                ContentUtils.release(in);
            }
            catch (DocumentException e2) {
                logger.error("[IMPORT] failed to load configuration.", (Exception)((Object)e2), new Object[0]);
                {
                    catch (Throwable throwable) {
                        ContentUtils.release(in);
                        throw throwable;
                    }
                }
                ContentUtils.release(in);
            }
            ContentUtils.release(in);
            return document;
        }
        ContentUtils.release(in);
        return null;
    }

    private void importFromConfigNode(String site, String publishChannelGroup, Node node, String fileRoot, String targetRoot, boolean publish, int chunkSize, int delayInterval, int delayLength) throws SiteNotFoundException {
        if (!this.inProgress) {
            this.inProgress = true;
            if (delayInterval > 0) {
                this.pauseEanbeld = true;
            }
            this.currentDelayInterval = delayInterval * 1000;
            this.currentDelayLength = delayLength * 1000;
            HashSet<String> importedPaths = new HashSet<String>();
            ArrayList<String> importedFullPaths = new ArrayList<String>();
            logger.info("[IMPORT] started importing in " + site + ", pause enabled: " + this.pauseEanbeld + ", delay interval: " + this.currentDelayInterval + ", delay length: " + this.currentDelayLength, new Object[0]);
            boolean overWrite = ContentFormatUtils.getBooleanValue(node.valueOf("@over-write"));
            List folderNodes = node.selectNodes("folder");
            if (publish) {
                String user = this.securityService.getCurrentUser();
                logger.debug("[IMPORT] publishing user: " + user, new Object[0]);
                this.nextStop = System.currentTimeMillis() + this.currentDelayInterval;
                this.createFolders(site, importedPaths, importedFullPaths, folderNodes, fileRoot, targetRoot, "", overWrite, user);
                logger.info("Starting Publish of Imported Files (Total " + importedFullPaths.size() + " On chunkSize of " + chunkSize + " )", new Object[0]);
                this.publish(site, publishChannelGroup, targetRoot, importedFullPaths, chunkSize);
            } else {
                this.nextStop = System.currentTimeMillis() + this.currentDelayInterval;
                this.createFolders(site, importedPaths, importedFullPaths, folderNodes, fileRoot, targetRoot, "", overWrite, null);
            }
            this.inProgress = false;
        } else {
            logger.info("[IMPORT] an import process is currently running.", new Object[0]);
        }
    }

    private void createFolders(String site, Set<String> importedPaths, List<String> importedFullPaths, List<Node> nodes, String fileRoot, String targetRoot, String parentPath, boolean overWrite, String user) throws SiteNotFoundException {
        logger.info("[IMPORT] createFolders : site[" + site + "] ] fileRoot [" + fileRoot + "] targetRoot [ " + targetRoot + "] parentPath [" + parentPath + "] overwrite[" + overWrite + "]", new Object[0]);
        if (nodes != null) {
            for (Node node : nodes) {
                boolean importAll;
                boolean folderOverWrite;
                String name = node.valueOf("@name");
                String value = node.valueOf("@over-write");
                boolean bl = folderOverWrite = StringUtils.isEmpty((CharSequence)value) ? overWrite : ContentFormatUtils.getBooleanValue(value);
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                String currentFilePath = fileRoot + "/" + name;
                String currentPath = parentPath + "/" + name;
                boolean folderExists = this.contentService.contentExists(site, currentPath);
                if (!folderExists) {
                    this.contentService.createFolder(site, parentPath, name);
                }
                if (importAll = ContentFormatUtils.getBooleanValue(node.valueOf("@import-all"))) {
                    this.importRootFileList(site, importedPaths, importedFullPaths, fileRoot + "/" + name, targetRoot, currentPath, folderOverWrite, user);
                    continue;
                }
                List childFolders = node.selectNodes("folder");
                this.createFolders(site, importedPaths, importedFullPaths, childFolders, currentFilePath, targetRoot, currentPath, folderOverWrite, user);
                List childFiles = node.selectNodes("file");
                this.createFiles(site, importedPaths, importedFullPaths, childFiles, currentFilePath, targetRoot, currentPath, folderOverWrite, user);
            }
        }
    }

    protected void importRootFileList(String site, Set<String> importedPaths, List<String> importedFullPaths, String fileRoot, String targetRoot, String parentPath, boolean overWrite, String user) throws SiteNotFoundException {
        URL resourceUrl = this.getResourceUrl(fileRoot);
        if (resourceUrl != null) {
            String[] children;
            String resourcePath = resourceUrl.getFile();
            File file = new File(resourcePath);
            if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
                for (String childName : children) {
                    File childFile = new File(resourcePath + "/" + childName);
                    if (childFile.isDirectory()) {
                        String currentPath = parentPath + "/" + childName;
                        boolean folderExists = this.contentService.contentExists(site, currentPath);
                        if (!folderExists) {
                            this.contentService.createFolder(site, parentPath, childName);
                        }
                        logger.info("[IMPORT] Importing " + parentPath + "/" + childName, new Object[0]);
                        this.importFileList(site, importedPaths, importedFullPaths, fileRoot + "/" + childName, targetRoot, parentPath + "/" + childName, overWrite, user);
                        logger.info("[IMPORT] Finished Importing " + parentPath + "/" + childName, new Object[0]);
                        continue;
                    }
                    this.writeContentInTransaction(site, importedPaths, importedFullPaths, fileRoot, targetRoot, parentPath, childName, overWrite, user);
                }
            }
        } else {
            logger.error("[IMPORT] " + fileRoot + " is not found.", new Object[0]);
        }
    }

    private URL getResourceUrl(String filePath) {
        try {
            return new File(filePath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Not able to find " + filePath);
        }
    }

    protected void importFileList(String site, Set<String> importedPaths, List<String> importedFullPaths, String fileRoot, String targetRoot, String parentPath, boolean overWrite, String user) throws SiteNotFoundException {
        logger.info("[IMPORT] importFileList: fileRoot [" + fileRoot + "] name [" + targetRoot + "] overwrite[" + overWrite + "]", new Object[0]);
        URL resourceUrl = this.getResourceUrl(fileRoot);
        if (resourceUrl != null) {
            String[] children;
            String resourcePath = resourceUrl.getFile();
            File file = new File(resourcePath);
            if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
                for (String childName : children) {
                    File childFile = new File(resourcePath + "/" + childName);
                    if (childFile.isDirectory()) {
                        String currentPath = parentPath + "/" + childName;
                        boolean folderExists = this.contentService.contentExists(site, currentPath);
                        if (!folderExists) {
                            this.contentService.createFolder(site, parentPath, childName);
                        }
                        this.importFileList(site, importedPaths, importedFullPaths, fileRoot + "/" + childName, targetRoot, parentPath + "/" + childName, overWrite, user);
                        continue;
                    }
                    this.writeContentInTransaction(site, importedPaths, importedFullPaths, fileRoot, targetRoot, parentPath, childName, overWrite, user);
                }
            }
        } else {
            logger.error("[IMPORT] " + fileRoot + " is not found.", new Object[0]);
        }
    }

    protected void writeContentInTransaction(String site, Set<String> importedPaths, List<String> importedFullPaths, String fileRoot, String targetRoot, String parentPath, String name, boolean overWrite, String user) {
        long startTimeWrite = System.currentTimeMillis();
        logger.debug("[IMPORT] writing file in transaction: " + parentPath + "/" + name, new Object[0]);
        this.writeContent(site, importedPaths, importedFullPaths, fileRoot, targetRoot, parentPath, name, overWrite);
        logger.debug("[IMPORT] done writing file in transaction: " + parentPath + "/" + name + ", time: " + (System.currentTimeMillis() - startTimeWrite), new Object[0]);
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeContent(String site, Set<String> importedPaths, List<String> importedFullPaths, String fileRoot, String targetRoot, String parentPath, String name, boolean overWrite) {
        long startTimeWrite;
        FileInputStream in;
        block11: {
            boolean isXml = true;
            String processChain = this.getXmlChainName();
            if (!name.endsWith(".xml")) {
                isXml = false;
                processChain = this.getAssetChainName();
            }
            in = null;
            String filePath = parentPath + "/" + name;
            String fileSystemPath = fileRoot + "/" + name;
            logger.info("[IMPORT] writeContent: fileRoot [" + fileRoot + "] fullPath [" + filePath + "] overwrite[" + overWrite + "] process chain [ " + processChain + "]", new Object[0]);
            startTimeWrite = System.currentTimeMillis();
            logger.debug("[IMPORT] writing file: " + parentPath + "/" + name, new Object[0]);
            try {
                File file = new File(fileSystemPath);
                if (!file.exists()) break block11;
                in = new FileInputStream(file);
                String currentPath = parentPath + "/" + name;
                boolean contentExists = this.contentService.contentExists(site, currentPath);
                Map<String, String> params = this.createParams(site, isXml, targetRoot, parentPath, name);
                String id = site + ":" + filePath + ":" + name;
                if (!contentExists || overWrite) {
                    String fullPath = targetRoot + filePath;
                    this.objectStateService.setSystemProcessing(site, currentPath, true);
                    this.contentService.processContent(id, in, isXml, params, processChain);
                    ContentItemTO item = this.contentService.getContentItem(site, currentPath);
                    if (item != null) {
                        this.objectStateService.transition(site, item, TransitionEvent.SAVE);
                        this.objectStateService.setSystemProcessing(site, currentPath, false);
                    } else {
                        ItemState state = this.objectStateService.getObjectState(site, currentPath);
                        if (state == null) {
                            this.objectStateService.insertNewEntry(site, currentPath);
                        }
                    }
                    importedPaths.add(filePath);
                    importedFullPaths.add(fullPath);
                    break block11;
                }
                logger.debug("[IMPORT] " + filePath + " exists and set to not to overrwite. skipping this file.", new Object[0]);
            }
            catch (FileNotFoundException e) {
                logger.warn("[IMPORT] " + filePath + " does not exist.", new Object[0]);
                ContentUtils.release(in);
            }
            catch (ServiceLayerException e2) {
                logger.error("[IMPORT] failed to import " + filePath, e2, new Object[0]);
                {
                    catch (Throwable throwable) {
                        ContentUtils.release(in);
                        throw throwable;
                    }
                }
                ContentUtils.release(in);
            }
        }
        ContentUtils.release(in);
        logger.debug("[IMPORT] done writing file: " + parentPath + "/" + name + ", time: " + (System.currentTimeMillis() - startTimeWrite), new Object[0]);
    }

    private Map<String, String> createParams(String site, boolean isXml, String targetRoot, String parentPath, String name) {
        HashMap<String, String> params = new HashMap<String, String>();
        String filePath = parentPath + "/" + name;
        String path = isXml ? filePath : parentPath;
        String fullPath = targetRoot + filePath;
        params.put("site", site);
        params.put("path", path);
        params.put("fullPath", fullPath);
        params.put("fileName", name);
        params.put("user", this.getAssignee());
        params.put("createFolders", "true");
        params.put("unlock", "true");
        logger.debug("[IMPORT] creating/updating " + filePath, new Object[0]);
        return params;
    }

    protected void pause() {
        if (this.pauseEanbeld && System.currentTimeMillis() >= this.nextStop) {
            logger.debug("[IMPORT] pausing import process.", new Object[0]);
            try {
                Thread.sleep(this.currentDelayLength);
                this.nextStop = System.currentTimeMillis() + this.currentDelayInterval;
            }
            catch (InterruptedException e) {
                logger.error("[IMPORT] error while pausing import process.", e, new Object[0]);
            }
            logger.debug("[IMPORT] done pausing import process.", new Object[0]);
        }
    }

    protected void createFiles(String site, Set<String> importedPaths, List<String> importedFullPaths, List<Node> nodes, String fileRoot, String targetRoot, String parentPath, boolean overWrite, String user) {
        logger.info("[IMPORT] createFiles: fileRoot [" + fileRoot + "] parentFullPath [" + parentPath + "] overwrite[" + overWrite + "]", new Object[0]);
        if (nodes != null) {
            for (Node node : nodes) {
                boolean fileOverwrite;
                String name = node.valueOf("@name");
                String value = node.valueOf("@over-write");
                boolean bl = fileOverwrite = StringUtils.isEmpty((CharSequence)value) ? overWrite : ContentFormatUtils.getBooleanValue(value);
                if (StringUtils.isEmpty((CharSequence)name)) continue;
                this.writeContentInTransaction(site, importedPaths, importedFullPaths, fileRoot, targetRoot, parentPath, name, fileOverwrite, user);
            }
        }
    }

    protected void publish(String site, String publishChannelGroup, String targetRoot, List<String> fullPaths, int chunkSize) {
        if (chunkSize < 1) {
            logger.info("[IMPORT] publising chunk size not defined. publishing all together.", new Object[0]);
            this.submitToGoLive(site, publishChannelGroup, fullPaths);
        } else {
            int total = fullPaths.size();
            int count = 0;
            HashSet<String> goLiveItemPaths = new HashSet<String>(chunkSize);
            ArrayList<String> goLiveItemFullPaths = new ArrayList<String>(chunkSize);
            for (String importedFullPath : fullPaths) {
                logger.debug("\t\t" + importedFullPath, new Object[0]);
                if (goLiveItemFullPaths.size() < chunkSize) {
                    goLiveItemFullPaths.add(importedFullPath);
                    String goLiveItemPath = importedFullPath.replaceFirst(targetRoot, "");
                    goLiveItemPaths.add(goLiveItemPath);
                    ++count;
                }
                if (goLiveItemPaths.size() != chunkSize) continue;
                logger.info("[IMPORT] submitting " + chunkSize + " imported files to " + publishChannelGroup + " (" + count + "/" + total + ")", new Object[0]);
                this.submitToGoLive(site, publishChannelGroup, goLiveItemFullPaths);
                goLiveItemPaths = new HashSet(chunkSize);
                goLiveItemFullPaths = new ArrayList(chunkSize);
            }
            if (goLiveItemPaths.size() < chunkSize) {
                logger.info("[IMPORT] submitting " + chunkSize + " imported files to " + publishChannelGroup + " (" + count + "/" + total + ")", new Object[0]);
                this.submitToGoLive(site, publishChannelGroup, goLiveItemFullPaths);
                goLiveItemPaths = new HashSet(chunkSize);
                goLiveItemFullPaths = new ArrayList(chunkSize);
            }
        }
    }

    protected void submitToGoLive(String site, String publishChannelGroup, List<String> importedFullPaths) {
        MultiChannelPublishingContext mcpContext = new MultiChannelPublishingContext(publishChannelGroup, "", "Import Service");
        this.dmPublishService.publish(site, importedFullPaths, null, mcpContext);
        logger.info("All files have been submitted to be publish", new Object[0]);
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public String getAssignee() {
        return this.studioConfiguration.getProperty("studio.import.assignee");
    }

    public String getXmlChainName() {
        return this.studioConfiguration.getProperty("studio.import.xmlChainName");
    }

    public String getAssetChainName() {
        return this.studioConfiguration.getProperty("studio.import.assetChainName");
    }

    public class PublishingChannel {
        private String id;
        private String name;
        private String url;
        private String password;
        private String target;
        private boolean publishMetadata;

        public PublishingChannel() {
        }

        public PublishingChannel(String id, String name, String url, String password, String target, boolean publishMetadata) {
            this.id = id;
            this.name = name;
            this.url = url;
            this.password = password;
            this.target = target;
            this.publishMetadata = publishMetadata;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public boolean isPublishMetadata() {
            return this.publishMetadata;
        }

        public void setPublishMetadata(boolean publishMetadata) {
            this.publishMetadata = publishMetadata;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

