/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.content;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.ItemMetadataMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.springframework.dao.DuplicateKeyException;

public class ObjectMetadataManagerImpl
implements ObjectMetadataManager {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMetadataManagerImpl.class);
    protected ItemMetadataMapper itemMetadataMapper;

    @Override
    @ValidateParams
    public void insertNewObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        try {
            this.itemMetadataMapper.insertEntry(params);
        }
        catch (DuplicateKeyException e) {
            logger.debug("Failed to insert metadata for site: " + site + " and path: " + path + " into item_metadata table, because it is duplicate entry.", new Object[0]);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void setObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, Map<String, Object> properties) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.putAll(properties);
        this.itemMetadataMapper.setProperties(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void setObjectMetadataForCommitId(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="commitId") String commitId, Map<String, Object> properties) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("commitId", commitId);
        params.putAll(properties);
        this.itemMetadataMapper.setPropertiesForCommit(params);
    }

    @Override
    @RetryingOperation
    public void updateObjectMetadata(ItemMetadata itemMetadata) {
        this.itemMetadataMapper.updateObjectMetadata(itemMetadata);
    }

    @Override
    @ValidateParams
    public ItemMetadata getProperties(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        String cleanPath = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", cleanPath);
        return this.itemMetadataMapper.getProperties(params);
    }

    @Override
    @ValidateParams
    public boolean metadataExist(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        int cnt = this.itemMetadataMapper.countEntries(params);
        if (cnt < 1) {
            return false;
        }
        return cnt <= 1;
    }

    @Override
    @ValidateParams
    public boolean isRenamed(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            ItemMetadata metadata = this.getProperties(site, path);
            return metadata.getRenamed() > 0;
        }
        return false;
    }

    @Override
    @ValidateParams
    public String getOldPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            ItemMetadata metadata = this.getProperties(site, path);
            return metadata.getOldUrl();
        }
        return "";
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void lockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="lockOwner") String lockOwner) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", lockOwner);
        this.itemMetadataMapper.setLockOwner(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void unLockContent(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        if (!this.metadataExist(site, path = FilenameUtils.normalize((String)path, (boolean)true))) {
            this.insertNewObjectMetadata(site, path);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("lockOwner", null);
        this.itemMetadataMapper.setLockOwner(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectMetadataForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.itemMetadataMapper.deleteObjectMetadataForSite(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectMetadata(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.itemMetadataMapper.deleteEntry(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectMetadataForFolder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path + "/%");
        this.itemMetadataMapper.deleteFolder(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void updateObjectPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="oldPath") String oldPath, @ValidateSecurePathParam(name="newPath") String newPath) {
        newPath = FilenameUtils.normalize((String)newPath, (boolean)true);
        oldPath = FilenameUtils.normalize((String)oldPath, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.itemMetadataMapper.updateObjectPath(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void clearRenamed(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("renamed", false);
        params.put("oldUrl", "");
        this.setObjectMetadata(site, path, params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void updateCommitId(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="commitId") String commitId) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        params.put("commitId", commitId);
        this.itemMetadataMapper.updateCommitId(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public boolean movedPathExists(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("path", path);
        return this.itemMetadataMapper.movedPathExists(params) > 0;
    }

    @Override
    @ValidateParams
    public List<String> getSameCommitItems(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("path", path);
        return this.itemMetadataMapper.getSameCommitItems(params);
    }

    @Override
    @ValidateParams
    public int countAllItems() {
        return this.itemMetadataMapper.countAllItems();
    }

    @Override
    public int getContentDashboardTotal(String siteId, String path, String modifier, String contentType, long state, ZonedDateTime dateFrom, ZonedDateTime dateTo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("path", path);
        params.put("modifier", modifier);
        params.put("contentType", contentType);
        params.put("dateFrom", dateFrom);
        params.put("dateTo", dateTo);
        return this.itemMetadataMapper.getContentDashboardTotal(params);
    }

    @Override
    public List<ItemMetadata> getContentDashboard(String siteId, String path, String modifier, String contentType, long state, ZonedDateTime dateFrom, ZonedDateTime dateTo, String sortBy, String order, int offset, int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", siteId);
        params.put("path", path);
        params.put("modifier", modifier);
        params.put("contentType", contentType);
        params.put("dateFrom", dateFrom);
        params.put("dateTo", dateTo);
        if (StringUtils.isNotEmpty((CharSequence)sortBy)) {
            String sortParam = "";
            switch (sortBy) {
                case "label": {
                    sortParam = "label";
                    break;
                }
                case "path": {
                    sortParam = "path";
                    break;
                }
                case "modifier": {
                    sortParam = "modifier";
                    break;
                }
                case "modifiedDate": {
                    sortParam = "modified";
                    break;
                }
                case "contentType": {
                    sortParam = "content_type";
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)sortParam)) {
                params.put("sort", sortParam);
            }
        }
        params.put("order", order);
        params.put("offset", offset);
        params.put("limit", limit);
        return this.itemMetadataMapper.getContentDashboard(params);
    }

    @Override
    public void updateLastPublishedDate(String siteId, String path, ZonedDateTime publishedDate) {
        this.itemMetadataMapper.updateLastPublishedDate(siteId, path, publishedDate);
    }

    @Override
    public void updateLastPublishedDateBulk(String siteId, List<String> paths, ZonedDateTime publishedDate) {
        this.itemMetadataMapper.updateLastPublishedDateBulk(siteId, paths, publishedDate);
    }

    public ItemMetadataMapper getItemMetadataMapper() {
        return this.itemMetadataMapper;
    }

    public void setItemMetadataMapper(ItemMetadataMapper itemMetadataMapper) {
        this.itemMetadataMapper = itemMetadataMapper;
    }
}

