/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.FastArrayList;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.DeploymentSyncHistory;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.PublishRequestMapper;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.CommitNotFoundException;
import org.craftercms.studio.api.v1.exception.EnvironmentNotFoundException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.AuthenticationException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.CopyToEnvironmentItem;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DmDeploymentTaskTO;
import org.craftercms.studio.api.v1.to.PublishingChannelTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.api.v1.util.filter.DmFilterWrapper;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.PublishRequest;
import org.craftercms.studio.api.v2.dal.PublishRequestDAO;
import org.craftercms.studio.api.v2.dal.RepoOperation;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class DeploymentServiceImpl
implements DeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentServiceImpl.class);
    private static int CTED_AUTOINCREMENT = 0;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected DependencyService dependencyService;
    protected DmFilterWrapper dmFilterWrapper;
    protected SiteService siteService;
    protected ObjectStateService objectStateService;
    protected ObjectMetadataManager objectMetadataManager;
    protected org.craftercms.studio.api.v1.repository.ContentRepository contentRepository;
    protected DmPublishService dmPublishService;
    protected SecurityService securityService;
    protected EventService eventService;
    protected NotificationService notificationService;
    protected DeploymentHistoryProvider deploymentHistoryProvider;
    protected StudioConfiguration studioConfiguration;
    protected PublishRequestMapper publishRequestMapper;
    protected AuditServiceInternal auditServiceInternal;
    protected ContentRepository contentRepositoryV2;
    protected PublishingManager publishingManager;
    protected PublishRequestDAO publishRequestDAO;
    protected RetryingOperationFacade retryingOperationFacade;

    @Override
    @ValidateParams
    public void deploy(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<String> paths, ZonedDateTime scheduledDate, @ValidateStringParam(name="approver") String approver, @ValidateStringParam(name="submissionComment") String submissionComment, boolean scheduleDateNow) throws DeploymentException {
        if (scheduledDate != null && scheduledDate.isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.SUBMIT_WITHOUT_WORKFLOW_SCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED);
        }
        ArrayList<String> newPaths = new ArrayList<String>();
        ArrayList<String> updatedPaths = new ArrayList<String>();
        ArrayList<String> movedPaths = new ArrayList<String>();
        HashMap<String, List<String>> groupedPaths = new HashMap<String, List<String>>();
        for (String string : paths) {
            boolean isFolder = this.contentRepository.isFolder(site, string);
            if (isFolder) {
                logger.debug("Content item at path " + string + " for site " + site + " is folder and will not be added to publishing queue.", new Object[0]);
                continue;
            }
            if (this.objectStateService.isNew(site, string)) {
                newPaths.add(string);
                continue;
            }
            if (this.objectMetadataManager.isRenamed(site, string)) {
                movedPaths.add(string);
                continue;
            }
            updatedPaths.add(string);
        }
        groupedPaths.put("NEW", newPaths);
        groupedPaths.put("MOVE", movedPaths);
        groupedPaths.put("UPDATE", updatedPaths);
        List<org.craftercms.studio.api.v1.dal.PublishRequest> items = this.createItems(site, environment, groupedPaths, scheduledDate, approver, submissionComment);
        for (org.craftercms.studio.api.v1.dal.PublishRequest item : items) {
            this.publishRequestMapper.insertItemForDeployment(item);
        }
        this.objectStateService.setSystemProcessingBulk(site, paths, false);
        try {
            this.sendContentApprovalEmail(items, scheduleDateNow);
        }
        catch (Exception exception) {
            logger.error("Error sending approval notification ", exception, new Object[0]);
        }
        String string = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
        try {
            this.siteService.updatePublishingStatusMessage(site, "queued", string);
        }
        catch (SiteNotFoundException e) {
            logger.error("Error updating publishing status for site " + site, new Object[0]);
        }
    }

    protected void sendContentApprovalEmail(List<org.craftercms.studio.api.v1.dal.PublishRequest> itemList, boolean scheduleDateNow) {
        for (org.craftercms.studio.api.v1.dal.PublishRequest listItem : itemList) {
            ItemMetadata itemMetadata = this.objectMetadataManager.getProperties(listItem.getSite(), listItem.getPath());
            if (itemMetadata == null || itemMetadata.getSendEmail() != 1) continue;
            this.notificationService.notifyContentApproval(listItem.getSite(), itemMetadata.getSubmittedBy(), this.getPathRelativeToSite(itemList), listItem.getUser(), scheduleDateNow ? null : listItem.getScheduledDate(), Locale.ENGLISH);
            break;
        }
    }

    private List<String> getPathRelativeToSite(List<org.craftercms.studio.api.v1.dal.PublishRequest> itemList) {
        ArrayList<String> paths = new ArrayList<String>(itemList.size());
        for (org.craftercms.studio.api.v1.dal.PublishRequest copyToEnvironment : itemList) {
            paths.add(copyToEnvironment.getPath());
        }
        return paths;
    }

    private List<org.craftercms.studio.api.v1.dal.PublishRequest> createItems(String site, String environment, Map<String, List<String>> paths, ZonedDateTime scheduledDate, String approver, String submissionComment) {
        ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest> newItems = new ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest>();
        String packageId = UUID.randomUUID().toString();
        HashMap<String, String> params = null;
        for (String action : paths.keySet()) {
            for (String path : paths.get(action)) {
                org.craftercms.studio.api.v1.dal.PublishRequest item = new org.craftercms.studio.api.v1.dal.PublishRequest();
                ItemMetadata metadata = this.objectMetadataManager.getProperties(site, path);
                if (metadata == null) continue;
                params = new HashMap<String, String>();
                params.put("site_id", site);
                params.put("environment", environment);
                params.put("state", "READY_FOR_LIVE");
                params.put("path", path);
                params.put("commitId", metadata.getCommitId());
                if (this.publishRequestMapper.checkItemQueued(params) > 0) {
                    logger.info("Path " + path + " with commit ID " + metadata.getCommitId() + " already has queued publishing request for environment " + environment + " of site " + site + ". Adding another publishing request is skipped.", new Object[0]);
                } else {
                    String commitId;
                    item.setId(++CTED_AUTOINCREMENT);
                    item.setSite(site);
                    item.setEnvironment(environment);
                    item.setPath(path);
                    item.setScheduledDate(scheduledDate);
                    item.setState("READY_FOR_LIVE");
                    item.setAction(action);
                    if (metadata.getRenamed() > 0) {
                        String oldPath = metadata.getOldUrl();
                        item.setOldPath(oldPath);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(commitId = metadata.getCommitId())) && this.contentRepositoryV2.commitIdExists(site, commitId)) {
                        item.setCommitId(commitId);
                    } else {
                        if (StringUtils.isNotEmpty((CharSequence)commitId)) {
                            logger.warn("Commit ID is NULL for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                        } else {
                            logger.warn("Commit ID " + commitId + " does not exist for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                        }
                        logger.info("Publishing content from HEAD for " + path, new Object[0]);
                        item.setCommitId(this.contentRepository.getRepoLastCommitId(site));
                    }
                    String contentTypeClass = this.contentService.getContentTypeClass(site, path);
                    item.setContentTypeClass(contentTypeClass);
                    item.setUser(approver);
                    item.setSubmissionComment(submissionComment);
                    item.setPackageId(packageId);
                    newItems.add(item);
                }
                if (scheduledDate == null || !scheduledDate.isAfter(ZonedDateTime.now(ZoneOffset.UTC))) continue;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("submissionComment", submissionComment);
                properties.put("submittedToEnvironment", environment);
                properties.put("launchDate", scheduledDate);
                this.objectMetadataManager.setObjectMetadata(site, path, properties);
            }
        }
        return newItems;
    }

    @Override
    @ValidateParams
    public void delete(@ValidateStringParam(name="site") String site, List<String> paths, @ValidateStringParam(name="approver") String approver, ZonedDateTime scheduledDate, String submissionComment) throws DeploymentException, SiteNotFoundException {
        if (scheduledDate != null && scheduledDate.isAfter(ZonedDateTime.now(ZoneOffset.UTC))) {
            this.objectStateService.transitionBulk(site, paths, TransitionEvent.DELETE, State.NEW_DELETED);
        }
        Set<String> environments = this.getAllPublishedEnvironments(site);
        for (String environment : environments) {
            List<org.craftercms.studio.api.v1.dal.PublishRequest> items = this.createDeleteItems(site, environment, paths, approver, scheduledDate, submissionComment);
            for (org.craftercms.studio.api.v1.dal.PublishRequest item : items) {
                this.publishRequestMapper.insertItemForDeployment(item);
            }
        }
        this.objectStateService.setSystemProcessingBulk(site, paths, false);
        String statusMessage = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
        try {
            this.siteService.updatePublishingStatusMessage(site, "queued", statusMessage);
        }
        catch (SiteNotFoundException e) {
            logger.error("Error updating publishing status for site " + site, new Object[0]);
        }
    }

    private List<org.craftercms.studio.api.v1.dal.PublishRequest> createDeleteItems(String site, String environment, List<String> paths, String approver, ZonedDateTime scheduledDate, String submissionComment) throws SiteNotFoundException {
        ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest> newItems = new ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest>(paths.size());
        String packageId = UUID.randomUUID().toString();
        for (String path : paths) {
            if (!this.contentService.contentExists(site, path)) continue;
            ContentItemTO contentItem = this.contentService.getContentItem(site, path, 0);
            if (!contentItem.isFolder()) {
                String lastRepoCommitId;
                org.craftercms.studio.api.v1.dal.PublishRequest item = new org.craftercms.studio.api.v1.dal.PublishRequest();
                ItemMetadata metadata = this.objectMetadataManager.getProperties(site, path);
                item.setId(++CTED_AUTOINCREMENT);
                item.setSite(site);
                item.setEnvironment(environment);
                item.setPath(path);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setAction("DELETE");
                if (metadata != null) {
                    String commitId;
                    if (metadata.getRenamed() > 0) {
                        String oldPath = metadata.getOldUrl();
                        item.setOldPath(oldPath);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(commitId = metadata.getCommitId())) && this.contentRepositoryV2.commitIdExists(site, commitId)) {
                        item.setCommitId(commitId);
                    } else {
                        if (StringUtils.isNotEmpty((CharSequence)commitId)) {
                            logger.warn("Commit ID is NULL for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                        } else {
                            logger.warn("Commit ID " + commitId + " does not exist for content " + path + ". Was the git repo reset at some point?", new Object[0]);
                        }
                        logger.info("Publishing content from HEAD for " + path, new Object[0]);
                        item.setCommitId(this.contentRepository.getRepoLastCommitId(site));
                    }
                }
                String contentTypeClass = this.contentService.getContentTypeClass(site, path);
                item.setContentTypeClass(contentTypeClass);
                item.setUser(approver);
                item.setPackageId(packageId);
                item.setSubmissionComment(submissionComment);
                newItems.add(item);
                if (this.contentService.contentExists(site, path)) {
                    this.contentService.deleteContent(site, path, approver);
                    if (path.endsWith("/index.xml")) {
                        this.deleteFolder(site, path.replace("/index.xml", ""), approver);
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)(lastRepoCommitId = this.contentRepository.getRepoLastCommitId(site)))) continue;
                item.setCommitId(lastRepoCommitId);
                continue;
            }
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            ArrayList<String> childPaths = new ArrayList<String>();
            for (RepositoryItem child : children) {
                childPaths.add(child.path + "/" + child.name);
            }
            newItems.addAll(this.createDeleteItems(site, environment, childPaths, approver, scheduledDate, submissionComment));
            this.deleteFolder(site, path, approver);
        }
        return newItems;
    }

    private void deleteFolder(String site, String path, String user) throws SiteNotFoundException {
        String folderPath = path.replace("/index.xml", "");
        if (this.contentService.contentExists(site, path)) {
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            if (children.length < 1) {
                if (path.endsWith("/index.xml")) {
                    this.contentService.deleteContent(site, path, true, user);
                    this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
                    this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
                    String parentPath = ContentUtils.getParentUrl(path);
                    this.deleteFolder(site, parentPath, user);
                } else {
                    this.contentService.deleteContent(site, path, true, user);
                    this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
                    this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
                }
            }
        } else {
            this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
            this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteDeploymentDataForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.publishRequestMapper.deleteDeploymentDataForSite(params);
    }

    @Override
    @ValidateParams
    public List<PublishRequest> getScheduledItems(@ValidateStringParam(name="site") String site, String filterType) {
        String contentTypeClass = null;
        switch (filterType) {
            case "page": 
            case "component": 
            case "asset": {
                contentTypeClass = filterType;
                break;
            }
            default: {
                contentTypeClass = null;
            }
        }
        return this.publishRequestDAO.getScheduledItems(site, "READY_FOR_LIVE", contentTypeClass, ZonedDateTime.now(ZoneOffset.UTC));
    }

    @Override
    @ValidateParams
    public void cancelWorkflow(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) throws DeploymentException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.put("state", (Object)CopyToEnvironmentItem.State.READY_FOR_LIVE);
        params.put("canceledState", (Object)CopyToEnvironmentItem.State.CANCELLED);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        this.publishRequestMapper.cancelWorkflow(params);
    }

    @Override
    @ValidateParams
    public void cancelWorkflowBulk(@ValidateStringParam(name="site") String site, Set<String> paths) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("paths", paths);
        params.put("state", (Object)CopyToEnvironmentItem.State.READY_FOR_LIVE);
        params.put("canceledState", (Object)CopyToEnvironmentItem.State.CANCELLED);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        this.retryingOperationFacade.cancelWorkflowBulk(params);
    }

    @Override
    @ValidateParams
    public List<DmDeploymentTaskTO> getDeploymentHistory(@ValidateStringParam(name="site") String site, @ValidateIntegerParam(name="daysFromToday") int daysFromToday, @ValidateIntegerParam(name="numberOfItems") int numberOfItems, @ValidateStringParam(name="sort") String sort, boolean ascending, @ValidateStringParam(name="filterType") String filterType) throws SiteNotFoundException {
        ZonedDateTime toDate = ZonedDateTime.now(ZoneOffset.UTC);
        ZonedDateTime fromDate = toDate.minusDays(daysFromToday);
        List<DeploymentSyncHistory> deployReports = this.deploymentHistoryProvider.getDeploymentHistory(site, this.getEnvironmentNames(site), fromDate, toDate, this.dmFilterWrapper, filterType, numberOfItems);
        ArrayList<DmDeploymentTaskTO> tasks = new ArrayList<DmDeploymentTaskTO>();
        if (deployReports != null) {
            int count = 0;
            String timezone = this.servicesConfig.getDefaultTimezone(site);
            HashMap processedItems = new HashMap();
            for (int index = 0; index < deployReports.size() && count < numberOfItems; ++index) {
                ContentItemTO deployedItem;
                DeploymentSyncHistory entry = deployReports.get(index);
                String env = entry.getEnvironment();
                if (!processedItems.containsKey(env)) {
                    processedItems.put(env, new HashSet());
                }
                if (((Set)processedItems.get(env)).contains(entry.getPath()) || (deployedItem = this.getDeployedItem(entry.getSite(), entry.getPath())) == null) continue;
                deployedItem.eventDate = entry.getSyncDate();
                deployedItem.endpoint = entry.getTarget();
                deployedItem.setUser(entry.getUser());
                deployedItem.setEndpoint(entry.getEnvironment());
                String deployedLabel = entry.getSyncDate().withZoneSameInstant(ZoneId.of(timezone)).format(DateTimeFormatter.ISO_OFFSET_DATE);
                if (tasks.size() > 0) {
                    DmDeploymentTaskTO lastTask = (DmDeploymentTaskTO)tasks.get(tasks.size() - 1);
                    String lastDeployedLabel = lastTask.getInternalName();
                    if (lastDeployedLabel.equals(deployedLabel)) {
                        lastTask.setNumOfChildren(lastTask.getNumOfChildren() + 1);
                        lastTask.getChildren().add(deployedItem);
                    } else {
                        tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                    }
                } else {
                    tasks.add(this.createDeploymentTask(deployedLabel, deployedItem));
                }
                ((Set)processedItems.get(env)).add(entry.getPath());
            }
        }
        return tasks;
    }

    private List<String> getEnvironmentNames(String siteId) {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(this.servicesConfig.getLiveEnvironment(siteId));
        if (this.servicesConfig.isStagingEnvironmentEnabled(siteId)) {
            toRet.add(this.servicesConfig.getStagingEnvironment(siteId));
        }
        return toRet;
    }

    protected DmDeploymentTaskTO createDeploymentTask(String deployedLabel, ContentItemTO item) {
        DmDeploymentTaskTO task = new DmDeploymentTaskTO();
        task.setInternalName(deployedLabel);
        List<ContentItemTO> taskItems = task.getChildren();
        if (taskItems == null) {
            taskItems = new ArrayList<ContentItemTO>();
            task.setChildren(taskItems);
        }
        taskItems.add(item);
        task.setNumOfChildren(taskItems.size());
        return task;
    }

    protected ContentItemTO getDeployedItem(String site, String path) {
        ContentItemTO item = null;
        if (!this.contentService.contentExists(site, path)) {
            item = this.contentService.createDummyDmContentItemForDeletedNode(site, path);
            item.setLockOwner("");
        } else {
            item = this.contentService.getContentItem(site, path, 0);
        }
        return item;
    }

    @Override
    @ValidateParams
    public List<ContentItemTO> getScheduledItems(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="sort") String sort, boolean ascending, @ValidateStringParam(name="subSort") String subSort, boolean subAscending, @ValidateStringParam(name="filterType") String filterType) throws ServiceLayerException {
        if (StringUtils.isEmpty((CharSequence)sort)) {
            sort = "eventDate";
        }
        DmContentItemComparator comparator = new DmContentItemComparator(sort, ascending, true, true);
        DmContentItemComparator subComparator = new DmContentItemComparator(subSort, subAscending, true, true);
        List<ContentItemTO> items = null;
        items = this.getScheduledItems(site, comparator, subComparator, filterType);
        return items;
    }

    protected List<ContentItemTO> getScheduledItems(String site, DmContentItemComparator comparator, DmContentItemComparator subComparator, String filterType) {
        FastArrayList results = new FastArrayList();
        List<String> displayPatterns = this.servicesConfig.getDisplayInWidgetPathPatterns(site);
        List<PublishRequest> deploying = this.getScheduledItems(site, filterType);
        for (PublishRequest deploymentItem : deploying) {
            Set<String> permissions = this.securityService.getUserPermissions(site, deploymentItem.getPath(), this.securityService.getCurrentUser(), Collections.emptyList());
            if (!permissions.contains("publish")) continue;
            this.addScheduledItem(site, deploymentItem.getEnvironment(), deploymentItem.getScheduledDate(), deploymentItem.getPath(), deploymentItem.getPackageId(), (List<ContentItemTO>)results, comparator, subComparator, displayPatterns);
        }
        return results;
    }

    protected void addScheduledItem(String site, String environment, ZonedDateTime launchDate, String path, String packageId, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns) {
        try {
            this.addToScheduledDateList(site, environment, launchDate, path, packageId, scheduledItems, comparator, subComparator, displayPatterns);
            if (!path.endsWith("/index.xml") && !path.endsWith(".xml")) {
                path = path + "/" + "index.xml";
            }
        }
        catch (ServiceLayerException e) {
            logger.error("failed to read site " + site + " path " + path + ". " + e.getMessage(), new Object[0]);
        }
    }

    protected void addToScheduledDateList(String site, String environment, ZonedDateTime launchDate, String path, String packageId, List<ContentItemTO> scheduledItems, DmContentItemComparator comparator, DmContentItemComparator subComparator, List<String> displayPatterns) throws ServiceLayerException {
        String timeZone = this.servicesConfig.getDefaultTimezone(site);
        String dateLabel = launchDate.withZoneSameInstant(ZoneId.of(timeZone)).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        if (ContentUtils.matchesPatterns(path, displayPatterns)) {
            ContentItemTO itemToAdd = this.contentService.getContentItem(site, path, 0);
            itemToAdd.scheduledDate = launchDate;
            itemToAdd.environment = environment;
            itemToAdd.packageId = packageId;
            boolean found = false;
            for (int index = 0; index < scheduledItems.size(); ++index) {
                ContentItemTO currDateItem = scheduledItems.get(index);
                if (currDateItem.name.equals(dateLabel)) {
                    currDateItem.addChild(itemToAdd, subComparator, false);
                    found = true;
                    break;
                }
                if (itemToAdd.scheduledDate.compareTo(currDateItem.scheduledDate) >= 0) continue;
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(index, dateItem);
                found = true;
                break;
            }
            if (!found) {
                ContentItemTO dateItem = this.createDateItem(dateLabel, itemToAdd, comparator, timeZone);
                scheduledItems.add(dateItem);
            }
        }
    }

    protected ContentItemTO createDateItem(String name, ContentItemTO itemToAdd, DmContentItemComparator comparator, String timeZone) {
        ContentItemTO dateItem = new ContentItemTO();
        dateItem.name = name;
        dateItem.internalName = name;
        dateItem.eventDate = itemToAdd.scheduledDate;
        dateItem.scheduledDate = itemToAdd.scheduledDate;
        dateItem.timezone = timeZone;
        dateItem.addChild(itemToAdd, comparator, false);
        return dateItem;
    }

    @Override
    @ValidateParams
    public Map<String, List<PublishingChannelTO>> getAvailablePublishingChannelGroups(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        List<PublishingChannelTO> channelsTO = this.getPublishedEnvironments(site);
        HashMap<String, List<PublishingChannelTO>> result = new HashMap<String, List<PublishingChannelTO>>();
        result.put("availablePublishChannels", channelsTO);
        return result;
    }

    protected List<PublishingChannelTO> getPublishedEnvironments(String site) {
        ArrayList<PublishingChannelTO> channelTOs = new ArrayList<PublishingChannelTO>();
        Set<String> environments = this.getAllPublishedEnvironments(site);
        for (String ch : environments) {
            PublishingChannelTO chTO = new PublishingChannelTO();
            chTO.setName(ch);
            chTO.setPublish(true);
            chTO.setUpdateStatus(false);
            channelTOs.add(chTO);
        }
        return channelTOs;
    }

    protected Set<String> getAllPublishedEnvironments(String site) {
        LinkedHashSet<String> publishedEnvironments = new LinkedHashSet<String>();
        publishedEnvironments.add(this.servicesConfig.getLiveEnvironment(site));
        if (this.servicesConfig.isStagingEnvironmentEnabled(site)) {
            publishedEnvironments.add(this.servicesConfig.getStagingEnvironment(site));
        }
        return publishedEnvironments;
    }

    @Override
    @ValidateParams
    public void syncAllContentToPreview(@ValidateStringParam(name="site") String site, boolean waitTillDone) throws ServiceLayerException {
        PreviewEventContext context = new PreviewEventContext(waitTillDone);
        context.setSite(site);
        this.eventService.publish("studio.event.previewSync", context);
    }

    @Override
    @ValidateParams
    public void bulkGoLive(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, @ValidateSecurePathParam(name="path") String path, String comment) throws ServiceLayerException {
        this.dmPublishService.bulkGoLive(site, environment, path, comment);
    }

    @Override
    @ValidateParams
    public boolean enablePublishing(@ValidateStringParam(name="site") String site, boolean enabled) throws SiteNotFoundException, AuthenticationException {
        String status;
        String message;
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        if (!this.securityService.isSiteAdmin(this.securityService.getCurrentUser(), site)) {
            throw new AuthenticationException();
        }
        boolean toRet = this.siteService.enablePublishing(site, enabled);
        if (enabled) {
            logger.info("Publishing started for site {0}", site);
            if (this.publishingManager.isPublishingQueueEmpty(site)) {
                message = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default");
                status = "ready";
            } else {
                message = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.queued");
                status = "queued";
            }
        } else {
            logger.info("Publishing stopped for site {0}", site);
            message = this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.stopped");
            message = message.replace("{username}", this.securityService.getCurrentUser()).replace("{datetime}", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssX")));
            status = "stopped";
        }
        this.siteService.updatePublishingStatusMessage(site, status, message);
        SiteFeed siteFeed = this.siteService.getSite(site);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setSiteId(siteFeed.getId());
        if (enabled) {
            auditLog.setOperation("START_PUBLISHER");
        } else {
            auditLog.setOperation("STOP_PUBLISHER");
        }
        auditLog.setActorId(this.securityService.getCurrentUser());
        auditLog.setPrimaryTargetId(siteFeed.getSiteId());
        auditLog.setPrimaryTargetType("Site");
        auditLog.setPrimaryTargetValue(siteFeed.getName());
        this.auditServiceInternal.insertAuditLog(auditLog);
        return toRet;
    }

    @Override
    @ValidateParams
    public void publishCommits(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<String> commitIds, @ValidateStringParam(name="comment") String comment) throws SiteNotFoundException, EnvironmentNotFoundException, CommitNotFoundException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        Set<String> environments = this.getAllPublishedEnvironments(site);
        if (!environments.contains(environment)) {
            throw new EnvironmentNotFoundException();
        }
        if (!this.checkCommitIds(site, commitIds)) {
            throw new CommitNotFoundException();
        }
        logger.debug("Creating publish request items for queue for site " + site + " environment " + environment, new Object[0]);
        List<org.craftercms.studio.api.v1.dal.PublishRequest> publishRequests = this.createCommitItems(site, environment, commitIds, ZonedDateTime.now(ZoneOffset.UTC), this.securityService.getCurrentUser(), comment);
        logger.debug("Insert publish request items to the queue", new Object[0]);
        for (org.craftercms.studio.api.v1.dal.PublishRequest request : publishRequests) {
            this.publishRequestMapper.insertItemForDeployment(request);
        }
        logger.debug("Completed adding commits to publishing queue", new Object[0]);
    }

    private boolean checkCommitIds(String site, List<String> commitIds) {
        boolean toRet = true;
        for (String commitId : commitIds) {
            if (!StringUtils.isNotEmpty((CharSequence)commitId)) continue;
            toRet = toRet && this.contentRepositoryV2.commitIdExists(site, commitId);
        }
        return toRet;
    }

    private List<org.craftercms.studio.api.v1.dal.PublishRequest> createCommitItems(String site, String environment, List<String> commitIds, ZonedDateTime scheduledDate, String approver, String comment) {
        ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest> newItems = new ArrayList<org.craftercms.studio.api.v1.dal.PublishRequest>(commitIds.size());
        String packageId = UUID.randomUUID().toString();
        logger.debug("Get repository operations for each commit id and create publish request items", new Object[0]);
        for (String commitId : commitIds) {
            logger.debug("Get repository operations for commit " + commitId, new Object[0]);
            List<RepoOperation> operations = this.contentRepositoryV2.getOperationsFromDelta(site, commitId + "~1", commitId);
            block7: for (RepoOperation op : operations) {
                logger.debug("Creating publish request item: ", new Object[0]);
                org.craftercms.studio.api.v1.dal.PublishRequest item = new org.craftercms.studio.api.v1.dal.PublishRequest();
                item.setId(++CTED_AUTOINCREMENT);
                item.setSite(site);
                item.setEnvironment(environment);
                item.setScheduledDate(scheduledDate);
                item.setState("READY_FOR_LIVE");
                item.setCommitId(commitId);
                item.setUser(approver);
                item.setPackageId(packageId);
                item.setSubmissionComment(comment);
                switch (op.getAction()) {
                    case CREATE: 
                    case COPY: {
                        item.setPath(op.getPath());
                        item.setAction("NEW");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case UPDATE: {
                        item.setPath(op.getPath());
                        item.setAction("UPDATE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case DELETE: {
                        item.setPath(op.getPath());
                        item.setAction("DELETE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    case MOVE: {
                        item.setPath(op.getMoveToPath());
                        item.setOldPath(op.getPath());
                        item.setAction("MOVE");
                        item.setContentTypeClass(this.contentService.getContentTypeClass(site, op.getPath()));
                        break;
                    }
                    default: {
                        logger.error("Error: Unknown repo operation for site " + site + " operation: " + (Object)((Object)op.getAction()), new Object[0]);
                        continue block7;
                    }
                }
                logger.debug("\tPath: " + item.getPath() + " operation: " + item.getAction(), new Object[0]);
                newItems.add(item);
            }
        }
        logger.debug("Created " + newItems.size() + " publish request items for queue", new Object[0]);
        return newItems;
    }

    @Override
    public void publishItems(String site, String environment, ZonedDateTime schedule, List<String> paths, String submissionComment) throws ServiceLayerException, DeploymentException {
        if (!this.siteService.exists(site)) {
            throw new SiteNotFoundException();
        }
        Set<String> environements = this.getAllPublishedEnvironments(site);
        if (!environements.contains(environment)) {
            throw new EnvironmentNotFoundException();
        }
        Set<String> dependencies = this.dependencyService.calculateDependenciesPaths(site, paths);
        HashSet<String> allPaths = new HashSet<String>();
        allPaths.addAll(paths);
        allPaths.addAll(dependencies);
        this.cancelWorkflowBulk(site, allPaths);
        ArrayList<String> asList = new ArrayList<String>();
        asList.addAll(allPaths);
        String approver = this.securityService.getCurrentUser();
        boolean scheduledDateIsNow = false;
        if (schedule == null) {
            scheduledDateIsNow = true;
            schedule = ZonedDateTime.now(ZoneOffset.UTC);
        }
        this.deploy(site, environment, asList, schedule, approver, submissionComment, scheduledDateIsNow);
    }

    @Override
    public void resetStagingEnvironment(String siteId) throws ServiceLayerException, CryptoException {
        if (!this.siteService.exists(siteId)) {
            throw new SiteNotFoundException(siteId);
        }
        this.contentRepository.resetStagingRepository(siteId);
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public void setDmFilterWrapper(DmFilterWrapper dmFilterWrapper) {
        this.dmFilterWrapper = dmFilterWrapper;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public org.craftercms.studio.api.v1.repository.ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(org.craftercms.studio.api.v1.repository.ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public DeploymentHistoryProvider getDeploymentHistoryProvider() {
        return this.deploymentHistoryProvider;
    }

    public void setDeploymentHistoryProvider(DeploymentHistoryProvider deploymentHistoryProvider) {
        this.deploymentHistoryProvider = deploymentHistoryProvider;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public PublishRequestMapper getPublishRequestMapper() {
        return this.publishRequestMapper;
    }

    public void setPublishRequestMapper(PublishRequestMapper publishRequestMapper) {
        this.publishRequestMapper = publishRequestMapper;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public ContentRepository getContentRepositoryV2() {
        return this.contentRepositoryV2;
    }

    public void setContentRepositoryV2(ContentRepository contentRepositoryV2) {
        this.contentRepositoryV2 = contentRepositoryV2;
    }

    public PublishingManager getPublishingManager() {
        return this.publishingManager;
    }

    public void setPublishingManager(PublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    public PublishRequestDAO getPublishRequestDAO() {
        return this.publishRequestDAO;
    }

    public void setPublishRequestDAO(PublishRequestDAO publishRequestDAO) {
        this.publishRequestDAO = publishRequestDAO;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }
}

