/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;

public class DmPublishServiceImpl
extends AbstractRegistrableService
implements DmPublishService {
    private static final Logger logger = LoggerFactory.getLogger(DmPublishServiceImpl.class);
    protected DeploymentService deploymentService;
    protected SecurityService securityService;
    protected SiteService siteService;
    protected ContentService contentService;
    protected ContentRepository contentRepository;
    protected ObjectMetadataManager objectMetadataManager;
    protected ObjectStateService objectStateService;
    protected DependencyService dependencyService;

    @Override
    public void register() {
        this._servicesManager.registerService(DmPublishService.class, this);
    }

    @Override
    @ValidateParams
    public void publish(@ValidateStringParam(name="site") String site, List<String> paths, ZonedDateTime launchDate, MultiChannelPublishingContext mcpContext) {
        boolean scheduledDateIsNow = false;
        if (launchDate == null) {
            scheduledDateIsNow = true;
            launchDate = ZonedDateTime.now(ZoneOffset.UTC);
        }
        String approver = this.securityService.getCurrentUser();
        ZonedDateTime ld = launchDate;
        try {
            this.deploymentService.deploy(site, mcpContext.getPublishingChannelGroup(), paths, ld, approver, mcpContext.getSubmissionComment(), scheduledDateIsNow);
        }
        catch (DeploymentException e) {
            logger.error("Error while submitting paths to publish", new Object[0]);
        }
    }

    @Override
    @ValidateParams
    public void unpublish(@ValidateStringParam(name="site") String site, List<String> paths, String approver) {
        this.unpublish(site, paths, approver, null);
    }

    @Override
    @ValidateParams
    public void unpublish(@ValidateStringParam(name="site") String site, List<String> paths, @ValidateStringParam(name="approver") String approver, ZonedDateTime scheduleDate) {
        if (scheduleDate == null) {
            scheduleDate = ZonedDateTime.now(ZoneOffset.UTC);
        }
        try {
            this.deploymentService.delete(site, paths, approver, scheduleDate, null);
        }
        catch (SiteNotFoundException | DeploymentException ex) {
            logger.error("Unable to delete files due a error ", ex, new Object[0]);
        }
    }

    @Override
    @ValidateParams
    public void cancelScheduledItem(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        try {
            this.deploymentService.cancelWorkflow(site, path);
        }
        catch (DeploymentException e) {
            logger.error(String.format("Error while canceling workflow for content at %s, site %s", path, site), e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public void bulkGoLive(@ValidateStringParam(name="site") String site, @ValidateStringParam String environment, @ValidateSecurePathParam(name="path") String path, String comment) throws ServiceLayerException {
        logger.info("Starting Bulk Publish to '" + environment + "' for path " + path + " site " + site, new Object[0]);
        String queryPath = path;
        if (queryPath.startsWith("/index.xml")) {
            queryPath = queryPath.replace("/index.xml", "");
        }
        logger.debug("Get change set for subtree for site: " + site + " root path: " + queryPath, new Object[0]);
        List<Object> childrenPaths = new ArrayList();
        childrenPaths = this.objectStateService.getChangeSetForSubtree(site, queryPath);
        logger.debug("Collected " + childrenPaths.size() + " content items for site " + site + " and root path " + queryPath, new Object[0]);
        HashSet<String> processedPaths = new HashSet<String>();
        ZonedDateTime launchDate = ZonedDateTime.now(ZoneOffset.UTC);
        for (String string : childrenPaths) {
            String childHash = DigestUtils.md2Hex((String)string);
            logger.debug("Processing dependencies for site " + site + " path " + string, new Object[0]);
            if (!processedPaths.add(childHash)) continue;
            ArrayList<String> pathsToPublish = new ArrayList<String>();
            ArrayList<String> candidatesToPublish = new ArrayList<String>();
            pathsToPublish.add(string);
            candidatesToPublish.addAll(this.objectMetadataManager.getSameCommitItems(site, string));
            candidatesToPublish.addAll(this.dependencyService.getPublishingDependencies(site, string));
            for (String pathToAdd : candidatesToPublish) {
                String hash = DigestUtils.md2Hex((String)pathToAdd);
                if (!processedPaths.add(hash)) continue;
                pathsToPublish.add(pathToAdd);
            }
            String aprover = this.securityService.getCurrentUser();
            if (StringUtils.isEmpty((CharSequence)comment)) {
                comment = "Bulk Publish invoked by " + aprover;
            }
            logger.info("Deploying package of " + pathsToPublish.size() + " items to '" + environment + "' for site" + site + " path " + string, new Object[0]);
            try {
                this.deploymentService.deploy(site, environment, pathsToPublish, launchDate, aprover, comment, true);
            }
            catch (DeploymentException e) {
                logger.error("Error while running Bulk Publish operation", e, new Object[0]);
            }
            finally {
                logger.debug("Finished processing deployment package for path " + string + " site " + site, new Object[0]);
            }
        }
        logger.info("Finished Bulk Publish to '" + environment + "' for path " + path + " site " + site, new Object[0]);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }
}

