/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.deployment;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemMetadata;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.dal.PublishRequestMapper;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.ContentRepository;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentException;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.deployment.PublishingManager;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.to.DeploymentItemTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.service.deployment.DeploymentHistoryProvider;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class PublishingManagerImpl
implements PublishingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishingManagerImpl.class);
    private static final String LIVE_ENVIRONMENT = "live";
    private static final String PRODUCTION_ENVIRONMENT = "Production";
    protected SiteService siteService;
    protected ObjectStateService objectStateService;
    protected ContentService contentService;
    protected DeploymentService deploymentService;
    protected ContentRepository contentRepository;
    protected ObjectMetadataManager objectMetadataManager;
    protected ServicesConfig servicesConfig;
    protected StudioConfiguration studioConfiguration;
    protected DependencyService dependencyService;
    protected DeploymentHistoryProvider deploymentHistoryProvider;
    protected PublishRequestMapper publishRequestMapper;
    protected RetryingOperationFacade retryingOperationFacade;

    @Override
    @ValidateParams
    public List<PublishRequest> getItemsReadyForDeployment(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("state", "READY_FOR_LIVE");
        params.put("environment", environment);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        return this.publishRequestMapper.getItemsReadyForDeployment(params);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DeploymentItemTO processItem(PublishRequest item) throws DeploymentException, SiteNotFoundException {
        ItemMetadata itemMetadata;
        if (item == null) {
            throw new DeploymentException("Cannot process item, item is null.");
        }
        DeploymentItemTO deploymentItem = new DeploymentItemTO();
        deploymentItem.setSite(item.getSite());
        deploymentItem.setPath(item.getPath());
        deploymentItem.setCommitId(item.getCommitId());
        deploymentItem.setPackageId(item.getPackageId());
        String site = item.getSite();
        String path = item.getPath();
        String oldPath = item.getOldPath();
        String environment = item.getEnvironment();
        String action = item.getAction();
        String user = item.getUser();
        String liveEnvironment = LIVE_ENVIRONMENT;
        if (this.servicesConfig.isStagingEnvironmentEnabled(site)) {
            liveEnvironment = this.servicesConfig.getLiveEnvironment(site);
        }
        boolean isLive = false;
        if (StringUtils.isNotEmpty((CharSequence)liveEnvironment)) {
            if (liveEnvironment.equals(environment)) {
                isLive = true;
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)LIVE_ENVIRONMENT, (CharSequence)item.getEnvironment()) || StringUtils.equalsIgnoreCase((CharSequence)PRODUCTION_ENVIRONMENT, (CharSequence)environment)) {
            isLive = true;
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)"DELETE")) {
            RepositoryItem[] children;
            if (oldPath != null && oldPath.length() > 0) {
                this.contentService.deleteContent(site, oldPath, user);
                boolean hasRenamedChildren = false;
                if (oldPath.endsWith("/index.xml")) {
                    if (this.contentService.contentExists(site, oldPath.replace("/index.xml", "")) && (children = this.contentRepository.getContentChildren(site, oldPath.replace("/index.xml", ""))).length > 1) {
                        hasRenamedChildren = true;
                    }
                    if (!hasRenamedChildren) {
                        this.deleteFolder(site, oldPath.replace("/index.xml", ""), user);
                    }
                }
                deploymentItem.setMove(true);
                deploymentItem.setOldPath(oldPath);
                this.objectMetadataManager.clearRenamed(site, path);
            }
            boolean haschildren = false;
            if (item.getPath().endsWith("/index.xml") && this.contentService.contentExists(site, path.replace("/index.xml", "")) && (children = this.contentRepository.getContentChildren(site, path.replace("/index.xml", ""))).length > 1) {
                haschildren = true;
            }
            if (this.contentService.contentExists(site, path)) {
                this.contentService.deleteContent(site, path, user);
                if (!haschildren) {
                    this.deleteFolder(site, path.replace("/index.xml", ""), user);
                }
            }
            deploymentItem.setDelete(true);
            return deploymentItem;
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)"MOVE")) {
            deploymentItem.setMove(true);
            deploymentItem.setOldPath(oldPath);
            if (oldPath != null && oldPath.length() > 0 && isLive) {
                this.objectMetadataManager.clearRenamed(site, path);
            }
        }
        if ((itemMetadata = this.objectMetadataManager.getProperties(site, path)) == null) {
            if (!this.contentService.contentExists(site, path)) {
                LOGGER.warn("Content item: '" + site + "':'" + path + "' cannot be published. Content does not exist in git nor in the database. Skipping...", new Object[0]);
                return null;
            }
            LOGGER.warn("Content item: '" + site + "':'" + path + "' doesn't exists in the database, but does exist in git. This may cause problems in the environment: '" + environment + "'", new Object[0]);
        } else {
            ContentItemTO contentItem = this.contentService.getContentItem(site, path);
            if (isLive) {
                LOGGER.debug("Environment is live, transition item to LIVE state {0}:{1}", site, path);
                if (Objects.isNull(itemMetadata.getCommitId()) || itemMetadata.getCommitId().equals(item.getCommitId())) {
                    this.objectStateService.transition(site, contentItem, TransitionEvent.DEPLOYMENT);
                }
            } else {
                this.objectStateService.transition(site, contentItem, TransitionEvent.SAVE);
            }
            itemMetadata.setSubmittedBy("");
            itemMetadata.setSendEmail(0);
            itemMetadata.setSubmittedForDeletion(0);
            itemMetadata.setSubmissionComment("");
            itemMetadata.setSubmittedToEnvironment("");
            itemMetadata.setLaunchDate(null);
            this.objectMetadataManager.updateObjectMetadata(itemMetadata);
        }
        String blacklistConfig = this.studioConfiguration.getProperty("studio.configuration.publishing.blacklist.regex");
        if (!StringUtils.isNotEmpty((CharSequence)blacklistConfig)) return deploymentItem;
        if (!ContentUtils.matchesPatterns(item.getPath(), Arrays.asList(StringUtils.split((String)blacklistConfig, (String)",")))) return deploymentItem;
        LOGGER.debug("File " + item.getPath() + " of the site " + site + " will not be published because it matches the configured publishing blacklist regex patterns.", new Object[0]);
        this.markItemsCompleted(site, item.getEnvironment(), Arrays.asList(item));
        return null;
    }

    private void deleteFolder(String site, String path, String user) throws SiteNotFoundException {
        String folderPath = path.replace("/index.xml", "");
        if (this.contentService.contentExists(site, path)) {
            RepositoryItem[] children = this.contentRepository.getContentChildren(site, path);
            if (children.length < 1) {
                this.contentService.deleteContent(site, path, true, user);
                this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
                this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
                String parentPath = ContentUtils.getParentUrl(path);
                this.deleteFolder(site, parentPath, user);
            }
        } else {
            this.objectStateService.deleteObjectStatesForFolder(site, folderPath);
            this.objectMetadataManager.deleteObjectMetadataForFolder(site, folderPath);
        }
    }

    @Override
    @ValidateParams
    public void markItemsCompleted(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<PublishRequest> processedItems) throws DeploymentException {
        ZonedDateTime completed = ZonedDateTime.now();
        for (PublishRequest item : processedItems) {
            item.setState("COMPLETED");
            item.setCompletedDate(completed);
            this.retryingOperationFacade.markPublishRequestCompleted(item);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void markItemsProcessing(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<PublishRequest> itemsToDeploy) throws DeploymentException {
        for (PublishRequest item : itemsToDeploy) {
            item.setState("PROCESSING");
            this.publishRequestMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void markItemsReady(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<PublishRequest> copyToEnvironmentItems) throws DeploymentException {
        for (PublishRequest item : copyToEnvironmentItems) {
            item.setState("READY_FOR_LIVE");
            this.publishRequestMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void markItemsBlocked(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment, List<PublishRequest> copyToEnvironmentItems) throws DeploymentException {
        for (PublishRequest item : copyToEnvironmentItems) {
            item.setState("BLOCKED");
            this.publishRequestMapper.updateItemDeploymentState(item);
        }
    }

    @Override
    public List<DeploymentItemTO> processMandatoryDependencies(PublishRequest item, Set<String> pathsToDeploy, Set<String> missingDependenciesPaths) throws DeploymentException, ServiceLayerException {
        ArrayList<DeploymentItemTO> mandatoryDependencies = new ArrayList<DeploymentItemTO>();
        String site = item.getSite();
        String path = item.getPath();
        if (StringUtils.equals((CharSequence)item.getAction(), (CharSequence)"NEW") || StringUtils.equals((CharSequence)item.getAction(), (CharSequence)"MOVE")) {
            int idx;
            String helpPath;
            String parentPath;
            if (ContentUtils.matchesPatterns(path, this.servicesConfig.getPagePatterns(site)) && (this.objectStateService.isNew(site, parentPath = (helpPath = path.replace("/" + this.getIndexFile(), "")).substring(0, idx = helpPath.lastIndexOf("/")) + "/" + this.getIndexFile()) || this.objectMetadataManager.isRenamed(site, parentPath)) && !missingDependenciesPaths.contains(parentPath) && !pathsToDeploy.contains(parentPath)) {
                this.deploymentService.cancelWorkflow(site, parentPath);
                missingDependenciesPaths.add(parentPath);
                PublishRequest parentItem = this.createMissingItem(site, parentPath, item);
                DeploymentItemTO parentDeploymentItem = this.processItem(parentItem);
                mandatoryDependencies.add(parentDeploymentItem);
                mandatoryDependencies.addAll(this.processMandatoryDependencies(parentItem, pathsToDeploy, missingDependenciesPaths));
            }
            if (!this.isEnablePublishingWithoutDependencies()) {
                List<String> dependentPaths = this.dependencyService.getPublishingDependencies(site, path);
                for (String dependentPath : dependentPaths) {
                    if (!this.objectStateService.isNew(site, dependentPath) && !this.objectMetadataManager.isRenamed(site, dependentPath) || missingDependenciesPaths.contains(dependentPath) || pathsToDeploy.contains(dependentPath)) continue;
                    this.deploymentService.cancelWorkflow(site, dependentPath);
                    missingDependenciesPaths.add(dependentPath);
                    PublishRequest dependentItem = this.createMissingItem(site, dependentPath, item);
                    DeploymentItemTO dependentDeploymentItem = this.processItem(dependentItem);
                    if (Objects.nonNull(dependentDeploymentItem)) {
                        mandatoryDependencies.add(dependentDeploymentItem);
                    }
                    mandatoryDependencies.addAll(this.processMandatoryDependencies(dependentItem, pathsToDeploy, missingDependenciesPaths));
                }
            }
        }
        return mandatoryDependencies;
    }

    private PublishRequest createMissingItem(String site, String itemPath, PublishRequest item) {
        ItemMetadata metadata;
        PublishRequest missingItem = new PublishRequest();
        missingItem.setSite(site);
        missingItem.setEnvironment(item.getEnvironment());
        missingItem.setPath(itemPath);
        missingItem.setScheduledDate(item.getScheduledDate());
        missingItem.setState(item.getState());
        if (this.objectStateService.isNew(site, itemPath)) {
            missingItem.setAction("NEW");
        }
        if ((metadata = this.objectMetadataManager.getProperties(site, itemPath)) != null) {
            String commitId;
            if (metadata.getRenamed() != 0) {
                String oldPath = metadata.getOldUrl();
                missingItem.setOldPath(oldPath);
                missingItem.setAction("MOVE");
            }
            if (StringUtils.isNotEmpty((CharSequence)(commitId = metadata.getCommitId()))) {
                missingItem.setCommitId(commitId);
            } else {
                missingItem.setCommitId(this.contentRepository.getRepoLastCommitId(site));
            }
        }
        String contentTypeClass = this.contentService.getContentTypeClass(site, itemPath);
        missingItem.setContentTypeClass(contentTypeClass);
        missingItem.setUser(item.getUser());
        missingItem.setSubmissionComment(item.getSubmissionComment());
        missingItem.setPackageId(item.getPackageId());
        return missingItem;
    }

    @Override
    @ValidateParams
    public boolean isPublishingBlocked(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        params.put("state", "BLOCKED");
        Integer result = this.publishRequestMapper.isPublishingBlocked(params);
        return result > 0;
    }

    @Override
    @ValidateParams
    public boolean hasPublishingQueuePackagesReady(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        params.put("state", "READY_FOR_LIVE");
        Integer result = this.publishRequestMapper.isPublishingBlocked(params);
        return result > 0;
    }

    @Override
    @ValidateParams
    public String getPublishingStatus(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        ArrayList<String> states = new ArrayList<String>(){
            {
                this.add("READY_FOR_LIVE");
                this.add("BLOCKED");
                this.add("PROCESSING");
            }
        };
        params.put("states", states);
        PublishRequest result = this.publishRequestMapper.checkPublishingStatus(params);
        return result.getState();
    }

    @Override
    @ValidateParams
    public boolean isPublishingQueueEmpty(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("now", ZonedDateTime.now(ZoneOffset.UTC));
        params.put("state", "READY_FOR_LIVE");
        Integer result = this.publishRequestMapper.isPublishingQueueEmpty(params);
        return result < 1;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void resetProcessingQueue(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="environment") String environment) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("environment", environment);
        params.put("processingState", "PROCESSING");
        params.put("readyState", "READY_FOR_LIVE");
        this.publishRequestMapper.resetProcessingQueue(params);
    }

    public String getIndexFile() {
        return this.studioConfiguration.getProperty("studio.publishingManager.indexFile");
    }

    public boolean isEnablePublishingWithoutDependencies() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.publishingManager.publishingWithoutDependencies.enabled"));
        return toReturn;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public DeploymentHistoryProvider getDeploymentHistoryProvider() {
        return this.deploymentHistoryProvider;
    }

    public void setDeploymentHistoryProvider(DeploymentHistoryProvider deploymentHistoryProvider) {
        this.deploymentHistoryProvider = deploymentHistoryProvider;
    }

    public PublishRequestMapper getPublishRequestMapper() {
        return this.publishRequestMapper;
    }

    public void setPublishRequestMapper(PublishRequestMapper publishRequestMapper) {
        this.publishRequestMapper = publishRequestMapper;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }
}

