/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.ebus.EventSubscriber;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EventServiceImpl
implements EventService,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);
    protected ApplicationContext applicationContext;
    private Map<String, List<EventSubscriber>> eventListeners = new HashMap<String, List<EventSubscriber>>();

    @Override
    @ValidateParams
    public void publish(@ValidateStringParam(name="event") String event, Object ... args) {
        logger.debug(String.format("Publishing %s", event), new Object[0]);
        List<EventSubscriber> listenersForEvent = this.getListenersForEvent(event, false);
        if (listenersForEvent != null) {
            for (EventSubscriber listener : listenersForEvent) {
                Object bean = this.applicationContext.getBean(listener.getBeanName());
                Method method = listener.getMethod();
                try {
                    method.invoke(bean, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("Error invoking listeners method for Publishing event: " + listener.getBeanName() + " - " + listener.getMethod(), new Object[0]);
                }
            }
        }
    }

    protected List<EventSubscriber> getListenersForEvent(String event, boolean create) {
        List<EventSubscriber> listeners = this.eventListeners.get(event);
        if (listeners == null && create) {
            listeners = new ArrayList<EventSubscriber>();
            this.eventListeners.put(event, listeners);
        }
        return listeners;
    }

    @Override
    @ValidateParams
    public void subscribe(@ValidateStringParam(name="event") String event, @ValidateStringParam(name="listener") String listener, Method method) {
        logger.info(String.format("Subscribing %s to %s", listener, event), new Object[0]);
        EventSubscriber subscriber = new EventSubscriber(listener, method);
        this.getListenersForEvent(event, true).add(subscriber);
    }

    @Override
    @ValidateParams
    public void unSubscribe(@ValidateStringParam(name="event") String event, @ValidateStringParam(name="listener") String listener) {
        logger.debug(String.format("UnSubscribing %s to %s", listener, event), new Object[0]);
        List<EventSubscriber> listeners = this.getListenersForEvent(event, false);
        for (EventSubscriber subscriber : listeners) {
            if (!StringUtils.equals((CharSequence)subscriber.getBeanName(), (CharSequence)listener)) continue;
            listeners.remove(subscriber);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

