/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.objectstate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.ItemState;
import org.craftercms.studio.api.v1.dal.ItemStateMapper;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.AbstractRegistrableService;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.State;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class ObjectStateServiceImpl
extends AbstractRegistrableService
implements ObjectStateService {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStateServiceImpl.class);
    protected State[][] transitionTable = null;
    protected ItemStateMapper itemStateMapper;
    protected GeneralLockService generalLockService;
    protected ContentService contentService;
    protected StudioConfiguration studioConfiguration;
    protected RetryingOperationFacade retryingOperationFacade;

    @Override
    public void register() {
        this.getServicesManager().registerService(ObjectStateService.class, this);
        this.initializeTransitionTable();
    }

    @Override
    @ValidateParams
    public ItemState getObjectState(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        return this.getObjectState(site, path, true);
    }

    @Override
    @ValidateParams
    public ItemState getObjectState(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean insert) {
        ContentItemTO item;
        String cleanPath = FilenameUtils.normalize((String)path, (boolean)true);
        String lockId = site + ":" + cleanPath;
        ItemState state = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", cleanPath);
        state = this.itemStateMapper.getObjectStateBySiteAndPath(params);
        if (state == null && insert && this.contentService.contentExists(site, cleanPath) && !(item = this.contentService.getContentItem(site, cleanPath, 0)).isFolder()) {
            this.insertNewEntry(site, item);
            state = this.itemStateMapper.getObjectStateBySiteAndPath(params);
        }
        return state;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void setSystemProcessing(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean isSystemProcessing) {
        String cleanPath = FilenameUtils.normalize((String)path, (boolean)true);
        String lockId = site + ":" + cleanPath;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", cleanPath);
        params.put("systemProcessing", isSystemProcessing);
        logger.debug("Updating system processing in DB: {0}:{1} - {2}", site, cleanPath, isSystemProcessing);
        this.itemStateMapper.setSystemProcessingBySiteAndPath(params);
    }

    @Override
    @ValidateParams
    public void setSystemProcessingBulk(@ValidateStringParam(name="site") String site, List<String> paths, boolean isSystemProcessing) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        if (paths.size() < this.getBulkOperationBatchSize()) {
            this.setSystemProcessingBulkPartial(site, paths, isSystemProcessing);
        } else {
            ArrayList<List<String>> partitions = new ArrayList<List<String>>();
            for (int i = 0; i < paths.size(); i += this.getBulkOperationBatchSize()) {
                partitions.add(paths.subList(i, Math.min(i + this.getBulkOperationBatchSize(), paths.size())));
            }
            for (List list : partitions) {
                this.setSystemProcessingBulkPartial(site, list, isSystemProcessing);
            }
        }
    }

    public void setSystemProcessingBulkPartial(String site, List<String> paths, boolean isSystemProcessing) {
        if (paths != null && !paths.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("paths", paths);
            params.put("systemProcessing", isSystemProcessing);
            this.retryingOperationFacade.setSystemProcessingBySiteAndPathBulk(params);
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void transition(@ValidateStringParam(name="site") String site, ContentItemTO item, TransitionEvent event) {
        String path = FilenameUtils.normalize((String)item.getUri(), (boolean)true);
        this.transition(site, path, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RetryingOperation
    @ValidateParams
    public void transition(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, TransitionEvent event) {
        String itemPath = FilenameUtils.normalize((String)path, (boolean)true);
        String lockKey = site + ":" + path;
        this.generalLockService.lock(lockKey);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", itemPath);
            ItemState currentState = this.itemStateMapper.getObjectStateBySiteAndPath(params);
            State nextState = null;
            if (currentState == null) {
                logger.debug("Preforming transition event " + event.name() + " on object " + lockKey + " without current state", new Object[0]);
                switch (event) {
                    case SAVE: {
                        nextState = State.NEW_UNPUBLISHED_UNLOCKED;
                        break;
                    }
                    case SAVE_FOR_PREVIEW: {
                        nextState = State.NEW_UNPUBLISHED_LOCKED;
                        break;
                    }
                    default: {
                        nextState = State.NEW_UNPUBLISHED_UNLOCKED;
                        break;
                    }
                }
            } else {
                logger.debug("Preforming transition event " + (Object)((Object)event) + " on object " + lockKey + " with " + currentState.getState() + " state", new Object[0]);
                State currentStateValue = State.valueOf(currentState.getState());
                nextState = this.transitionTable[currentStateValue.ordinal()][event.ordinal()];
            }
            if (currentState == null) {
                ItemState newEntry = new ItemState();
                newEntry.setObjectId(UUID.randomUUID().toString());
                newEntry.setSite(site);
                newEntry.setPath(itemPath);
                newEntry.setSystemProcessing(0);
                newEntry.setState(nextState.name());
                this.itemStateMapper.insertEntry(newEntry);
            } else if (nextState.toString() != currentState.getState() && nextState != State.NOOP) {
                currentState.setState(nextState.name());
                this.itemStateMapper.setObjectState(currentState);
            } else if (nextState == State.NOOP) {
                logger.warn("Transition not defined for event " + event.name() + " and current state " + currentState.getState() + " [object id: " + currentState.getObjectId() + "]", new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Transition not defined for event", e, new Object[0]);
        }
        finally {
            this.generalLockService.unlock(lockKey);
        }
        logger.debug("Transition finished for " + event.name() + " on object " + lockKey, new Object[0]);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deployCommitId(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="commitId") String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("commitId", commitId);
        params.put("state", State.EXISTING_UNEDITED_UNLOCKED.name());
        this.itemStateMapper.deployCommitId(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public void insertNewEntry(@ValidateStringParam(name="site") String site, ContentItemTO item) {
        String path = FilenameUtils.normalize((String)item.getUri(), (boolean)true);
        String lockKey = site + ":" + path;
        this.generalLockService.lock(lockKey);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", path);
            ItemState state = this.itemStateMapper.getObjectStateBySiteAndPath(params);
            if (state == null) {
                ItemState newEntry = new ItemState();
                if (StringUtils.isEmpty((CharSequence)item.getNodeRef())) {
                    newEntry.setObjectId(UUID.randomUUID().toString());
                } else {
                    newEntry.setObjectId(item.getNodeRef());
                }
                newEntry.setSite(site);
                newEntry.setPath(path);
                newEntry.setSystemProcessing(0);
                newEntry.setState(State.NEW_UNPUBLISHED_UNLOCKED.name());
                this.itemStateMapper.insertEntry(newEntry);
            }
        }
        finally {
            this.generalLockService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public void insertNewEntry(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        String itemPath = FilenameUtils.normalize((String)path, (boolean)true);
        String lockKey = site + ":" + path;
        this.generalLockService.lock(lockKey);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("site", site);
            params.put("path", itemPath);
            ItemState state = this.itemStateMapper.getObjectStateBySiteAndPath(params);
            if (state == null) {
                ItemState newEntry = new ItemState();
                newEntry.setObjectId(UUID.randomUUID().toString());
                newEntry.setSite(site);
                newEntry.setPath(itemPath);
                newEntry.setSystemProcessing(0);
                newEntry.setState(State.NEW_UNPUBLISHED_UNLOCKED.name());
                this.itemStateMapper.insertEntry(newEntry);
            }
        }
        finally {
            this.generalLockService.unlock(lockKey);
        }
    }

    @Override
    @ValidateParams
    public List<ItemState> getSubmittedItems(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> statesValues = new ArrayList<String>();
        for (State state : State.SUBMITTED_STATES) {
            statesValues.add(state.name());
        }
        params.put("states", statesValues);
        params.put("site", site);
        List<ItemState> objects = this.itemStateMapper.getObjectStateByStates(params);
        return objects;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void updateObjectPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="oldPath") String oldPath, @ValidateSecurePathParam(name="newPath") String newPath) {
        oldPath = FilenameUtils.normalize((String)oldPath, (boolean)true);
        newPath = FilenameUtils.normalize((String)newPath, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("oldPath", oldPath);
        params.put("newPath", newPath);
        this.itemStateMapper.updateObjectPath(params);
    }

    @Override
    @ValidateParams
    public boolean isUpdated(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isUpdated(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isUpdatedOrNew(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isUpdateOrNew(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isUpdatedOrSubmitted(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isUpdateOrSubmitted(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isSubmitted(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isSubmitted(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isNew(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isNew(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isFolderLive(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="folderPath") String folderPath) {
        folderPath = FilenameUtils.normalize((String)folderPath, (boolean)true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("folderPath", folderPath + "%");
        return this.itemStateMapper.isFolderLive(params) > 0;
    }

    @Override
    @ValidateParams
    public boolean isScheduled(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isScheduled(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public boolean isInWorkflow(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        ItemState state = this.getObjectState(site, path = FilenameUtils.normalize((String)path, (boolean)true));
        if (state != null) {
            return State.isInWorkflow(State.valueOf(state.getState()));
        }
        return false;
    }

    @Override
    @ValidateParams
    public List<ItemState> getChangeSet(@ValidateStringParam(name="site") String site) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> statesValues = new ArrayList<String>();
        for (State state : State.IN_PROGRESS_STATES) {
            statesValues.add(state.name());
        }
        params.put("states", statesValues);
        params.put("site", site);
        List<ItemState> objects = this.itemStateMapper.getObjectStateByStates(params);
        return objects;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectState(@ValidateStringParam(name="objectId") String objectId) {
        this.itemStateMapper.deleteObjectState(objectId);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectStateForPath(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        this.itemStateMapper.deleteObjectStateForSiteAndPath(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectStatesForFolder(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path + "/%");
        this.itemStateMapper.deleteObjectStateForSiteAndFolder(params);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void transitionBulk(@ValidateStringParam(name="site") String site, List<String> paths, TransitionEvent event, State defaultTargetState) {
        if (paths != null && !paths.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("site", site);
            params.put("paths", paths);
            List<ItemState> itemStates = this.itemStateMapper.getObjectStateForSiteAndPaths(params);
            HashMap bulkSubsets = new HashMap();
            for (ItemState state : itemStates) {
                if (!bulkSubsets.containsKey(state.getState())) {
                    bulkSubsets.put(State.valueOf(state.getState()), new ArrayList());
                }
                ((List)bulkSubsets.get((Object)State.valueOf(state.getState()))).add(state.getObjectId());
            }
            State nextState = null;
            for (Map.Entry entry : bulkSubsets.entrySet()) {
                if (entry.getKey() == null) {
                    params = new HashMap();
                    params.put("site", site);
                    params.put("paths", paths);
                    params.put("state", defaultTargetState.name());
                    this.itemStateMapper.setObjectStateForSiteAndPaths(params);
                    continue;
                }
                nextState = this.transitionTable[((State)((Object)entry.getKey())).ordinal()][event.ordinal()];
                if (nextState != entry.getKey() && nextState != State.NOOP) {
                    params = new HashMap();
                    params.put("site", site);
                    params.put("paths", paths);
                    params.put("state", nextState.name());
                    this.itemStateMapper.setObjectStateForSiteAndPaths(params);
                    continue;
                }
                if (nextState != State.NOOP) continue;
                logger.warn("Transition not defined for event " + event.name() + " and current state " + ((State)((Object)entry.getKey())).name() + " [setting object state for multiple objects]", new Object[0]);
            }
        }
    }

    @Override
    @ValidateParams
    public List<ItemState> getObjectStateByStates(@ValidateStringParam(name="site") String site, List<String> states) {
        if (states != null && !states.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("states", states);
            params.put("site", site);
            List<ItemState> result = this.itemStateMapper.getObjectStateByStates(params);
            return result;
        }
        return new ArrayList<ItemState>(0);
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public String setObjectState(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="state") String state, boolean systemProcessing) {
        path = FilenameUtils.normalize((String)path, (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        params.put("path", path);
        ItemState objectState = this.itemStateMapper.getObjectStateBySiteAndPath(params);
        if (objectState == null) {
            this.insertNewEntry(site, path);
            objectState = this.itemStateMapper.getObjectStateBySiteAndPath(params);
        }
        objectState.setState(state);
        objectState.setSystemProcessing(systemProcessing ? 1 : 0);
        this.itemStateMapper.setObjectState(objectState);
        return "Success";
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void deleteObjectStatesForSite(@ValidateStringParam(name="site") String site) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("site", site);
        this.itemStateMapper.deleteObjectStatesForSite(params);
    }

    public int getBulkOperationBatchSize() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.objectState.bulkOperationsBatchSize"));
        return toReturn;
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public void setStateForSiteContent(@ValidateStringParam(name="site") String site, State state) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("state", state.name());
        this.itemStateMapper.setStateForSiteContent(params);
    }

    @Override
    @ValidateParams
    public List<String> getChangeSetForSubtree(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("site", site);
        params.put("path", path);
        params.put("likepath", path + (path.endsWith("/") ? "" : "/") + "%");
        params.put("states", State.CHANGE_SET_STATES);
        List<ItemState> result = this.itemStateMapper.getChangeSetForSubtree(params);
        ArrayList<String> toRet = new ArrayList<String>();
        for (ItemState state : result) {
            toRet.add(state.getPath());
        }
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean deletedPathExists(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("siteId", site);
        params.put("path", path);
        params.put("states", State.DELETED_STATES);
        return this.itemStateMapper.deletedPathExists(params) > 0;
    }

    private void initializeTransitionTable() {
        this.transitionTable = new State[][]{{State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NOOP, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NEW_DELETED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_PUBLISHING_FAILED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NEW_SUBMITTED_WITH_WF_SCHEDULED, State.NEW_SUBMITTED_WITH_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_SCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_SUBMITTED_NO_WF_UNSCHEDULED, State.NEW_UNPUBLISHED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.NEW_PUBLISHING_FAILED}, {State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED_LOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.NOOP, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.NOOP, State.NOOP, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.EXISTING_DELETED, State.EXISTING_UNEDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED, State.EXISTING_EDITED_LOCKED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_DELETED, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.EXISTING_SUBMITTED_WITH_WF_SCHEDULED, State.EXISTING_SUBMITTED_WITH_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_SUBMITTED_NO_WF_UNSCHEDULED, State.EXISTING_SUBMITTED_NO_WF_SCHEDULED, State.EXISTING_EDITED_UNLOCKED, State.EXISTING_UNEDITED_UNLOCKED, State.EXISTING_PUBLISHING_FAILED}, {State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.EXISTING_EDITED_UNLOCKED, State.NOOP, State.NOOP, State.NEW_UNPUBLISHED_UNLOCKED, State.NEW_UNPUBLISHED_LOCKED, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP, State.NOOP}};
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ItemStateMapper getItemStateMapper() {
        return this.itemStateMapper;
    }

    public void setItemStateMapper(ItemStateMapper itemStateMapper) {
        this.itemStateMapper = itemStateMapper;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }
}

