/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.ebus.RepositoryEventContext;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.security.PasswordDoesNotMatchException;
import org.craftercms.studio.api.v1.exception.security.UserExternallyManagedException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.job.CronJobContext;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.security.UserDetailsManager;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.ContentTypeConfigTO;
import org.craftercms.studio.api.v1.to.PermissionsConfigTO;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.security.AuthenticationChain;
import org.craftercms.studio.api.v2.service.security.GroupService;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SecurityServiceImpl
implements SecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    protected ContentTypeService contentTypeService;
    protected ContentService contentService;
    protected GeneralLockService generalLockService;
    protected StudioConfiguration studioConfiguration;
    protected JavaMailSender emailService;
    protected JavaMailSender emailServiceNoAuth;
    protected UserDetailsManager userDetailsManager;
    protected ObjectFactory<FreeMarkerConfig> freeMarkerConfig;
    protected GroupService groupService;
    protected UserServiceInternal userServiceInternal;
    protected AuthenticationChain authenticationChain;
    protected ConfigurationService configurationService;
    protected AuditServiceInternal auditServiceInternal;
    protected SiteService siteService;

    @Override
    @ValidateParams
    public String authenticate(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="password") String password) throws Exception {
        RequestContext requestContext = RequestContext.getCurrent();
        HttpServletRequest request = requestContext.getRequest();
        HttpServletResponse response = requestContext.getResponse();
        this.authenticationChain.doAuthenticate(request, response, username, password);
        return this.getCurrentToken();
    }

    @Override
    @ValidateParams
    public boolean validateTicket(@ValidateStringParam(name="ticket") String ticket) {
        if (ticket == null) {
            ticket = this.getCurrentToken();
        }
        boolean valid = false;
        if (StringUtils.isNotEmpty((CharSequence)ticket)) {
            valid = true;
        }
        return valid;
    }

    @Override
    public String getCurrentUser() {
        String username = null;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            Authentication auth = (Authentication)httpSession.getAttribute("studio_authentication");
            if (auth != null) {
                username = auth.getUsername();
            }
        } else {
            CronJobContext cronJobContext = CronJobContext.getCurrent();
            if (cronJobContext != null) {
                username = cronJobContext.getCurrentUser();
            } else {
                RepositoryEventContext repositoryEventContext = RepositoryEventContext.getCurrent();
                if (repositoryEventContext != null) {
                    username = repositoryEventContext.getCurrentUser();
                }
            }
        }
        return username;
    }

    @Override
    public String getCurrentToken() {
        String ticket = null;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            Authentication auth = (Authentication)httpSession.getAttribute("studio_authentication");
            if (auth != null) {
                ticket = auth.getToken();
            }
        } else {
            ticket = this.getJobOrEventTicket();
        }
        if (ticket == null) {
            ticket = "NOTICKET";
        }
        return ticket;
    }

    @Override
    @ValidateParams
    public Map<String, Object> getUserProfile(@ValidateStringParam(name="user") String user) throws ServiceLayerException, UserNotFoundException {
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        User u = this.userServiceInternal.getUserByIdOrUsername(-1L, user);
        if (u != null) {
            toRet.put("username", user);
            toRet.put("first_name", u.getFirstName());
            toRet.put("last_name", u.getLastName());
            toRet.put("email", u.getEmail());
            toRet.put("externally_managed", u.isExternallyManaged());
            String authenticationType = this.studioConfiguration.getProperty("studio.security.type");
            toRet.put("authentication_type", authenticationType);
        }
        return toRet;
    }

    @Override
    public Map<String, Object> getUserProfileByGitName(@ValidateStringParam(name="firstNameLastName") String gitName) throws ServiceLayerException, UserNotFoundException {
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        User u = this.userServiceInternal.getUserByGitName(gitName);
        if (u == null) {
            throw new UserNotFoundException("User " + gitName + " not found");
        }
        toRet.put("username", u.getUsername());
        toRet.put("first_name", u.getFirstName());
        toRet.put("last_name", u.getLastName());
        toRet.put("email", u.getEmail());
        toRet.put("externally_managed", u.isExternallyManaged());
        String authenticationType = this.studioConfiguration.getProperty("studio.security.type");
        toRet.put("authentication_type", authenticationType);
        return toRet;
    }

    @Override
    @ValidateParams
    public Set<String> getUserPermissions(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, List<String> groups) {
        return this.getUserPermissions(site, path, this.getCurrentUser(), groups);
    }

    @Override
    @ValidateParams
    public Set<String> getUserPermissions(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, @ValidateStringParam(name="user") String user, List<String> groups) {
        HashSet<String> roles;
        Set<String> permissions = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)site)) {
            PermissionsConfigTO rolesConfig = this.loadConfiguration(site, this.getRoleMappingsFileName());
            PermissionsConfigTO permissionsConfig = this.loadConfiguration(site, this.getPermissionsFileName());
            roles = new HashSet();
            this.addUserRoles(roles, site, user);
            this.addGroupRoles(roles, site, groups, rolesConfig);
            permissions = this.populateUserPermissions(site, path, roles, permissionsConfig);
            if (path.indexOf("/site") == 0) {
                try {
                    ContentTypeConfigTO config = this.contentTypeService.getContentTypeForContent(site, path);
                    boolean isAllowed = this.contentTypeService.isUserAllowed(roles, config);
                    if (!isAllowed) {
                        logger.debug("The user is not allowed to access " + site + ":" + path + ". adding permission: " + "not allowed", new Object[0]);
                        permissions.add("not allowed");
                        return permissions;
                    }
                }
                catch (ServiceLayerException e) {
                    logger.debug("Error while getting the content type of " + path + ". skipping user role checking on the content.", new Object[0]);
                }
            }
        }
        PermissionsConfigTO globalRolesConfig = this.loadGlobalRolesConfiguration();
        PermissionsConfigTO globalPermissionsConfig = this.loadGlobalPermissionsConfiguration();
        roles = new HashSet<String>();
        this.addGlobalUserRoles(user, roles, globalRolesConfig);
        this.addGlobalGroupRoles(roles, groups, globalRolesConfig);
        permissions.addAll(this.populateUserGlobalPermissions(path, roles, globalPermissionsConfig));
        return permissions;
    }

    protected void addGlobalUserRoles(String user, Set<String> roles, PermissionsConfigTO rolesConfig) {
        try {
            List<Group> groups = this.userServiceInternal.getUserGroups(-1L, user);
            if (rolesConfig != null && groups != null) {
                Map<String, List<String>> rolesMap = rolesConfig.getRoles();
                for (Group group : groups) {
                    String groupName = group.getGroupName();
                    List<String> userRoles = rolesMap.get(groupName);
                    if (roles == null || userRoles == null) continue;
                    roles.addAll(userRoles);
                }
            }
        }
        catch (ServiceLayerException | UserNotFoundException e) {
            logger.error("Unable to retrieve user groups for user {0}", user);
        }
    }

    protected void addGlobalGroupRoles(Set<String> roles, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map<String, List<String>> rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List<String> groupRoles = rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserGlobalPermissions(String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map<String, Map<String, List<Node>>> permissionsMap = permissionsConfig.getPermissions();
                Map<String, List<Node>> siteRoles = permissionsMap.get("###GLOBAL###");
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List<Node> ruleNodes = siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Global permissions found by matching " + regex + " for " + role, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding global permissions " + permission + " to " + path + " for " + role, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    protected String getPermissionsKey(String site, String filename) {
        return new StringBuffer(site).append(":").append(filename).toString();
    }

    protected void addUserRoles(Set<String> roles, String site, String user) {
        if (!StringUtils.isEmpty((CharSequence)user)) {
            Set<String> userRoles = this.getUserRoles(site, user);
            logger.debug("Adding roles by user: " + userRoles, new Object[0]);
            roles.addAll(userRoles);
        }
    }

    @Override
    @ValidateParams
    public Set<String> getUserRoles(@ValidateStringParam(name="site") String site) {
        return this.getUserRoles(site, this.getCurrentUser());
    }

    @Override
    @ValidateParams
    public Set<String> getUserRoles(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user) {
        return this.getUserRoles(site, user, false);
    }

    @Override
    @ValidateParams
    public Set<String> getUserRoles(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="user") String user, boolean includeGlobal) {
        try {
            List<Group> groups = this.userServiceInternal.getUserGroups(-1L, user);
            if (groups != null && groups.size() > 0) {
                logger.debug("Groups for " + user + " in " + site + ": " + groups, new Object[0]);
                PermissionsConfigTO rolesConfig = this.loadConfiguration(site, this.getRoleMappingsFileName());
                HashSet<String> userRoles = new HashSet<String>();
                if (rolesConfig != null) {
                    Map<String, List<String>> rolesMap = rolesConfig.getRoles();
                    for (Group group : groups) {
                        String groupName = group.getGroupName();
                        if (StringUtils.equals((CharSequence)groupName, (CharSequence)"system_admin")) {
                            Collection<List<String>> mapValues = rolesMap.values();
                            mapValues.forEach(valueList -> userRoles.addAll((Collection<String>)valueList));
                            break;
                        }
                        List<String> roles = rolesMap.get(groupName);
                        if (roles == null) continue;
                        userRoles.addAll(roles);
                    }
                }
                if (includeGlobal) {
                    PermissionsConfigTO globalRolesConfig = this.loadGlobalRolesConfiguration();
                    this.addGlobalUserRoles(user, userRoles, globalRolesConfig);
                    List<String> groupNames = groups.stream().map(x -> x.getGroupName()).collect(Collectors.toList());
                    this.addGlobalGroupRoles(userRoles, groupNames, globalRolesConfig);
                }
                return userRoles;
            }
            logger.debug("No groups found for " + user + " in " + site, new Object[0]);
        }
        catch (ServiceLayerException | UserNotFoundException e) {
            logger.error("Error while getting groups for user {0}", e, new Object[0]);
        }
        return new HashSet<String>(0);
    }

    protected void addGroupRoles(Set<String> roles, String site, List<String> groups, PermissionsConfigTO rolesConfig) {
        if (groups != null) {
            Map<String, List<String>> rolesMap = rolesConfig.getRoles();
            for (String group : groups) {
                List<String> groupRoles = rolesMap.get(group);
                if (groupRoles == null) continue;
                logger.debug("Adding roles by group " + group + ": " + roles, new Object[0]);
                roles.addAll(groupRoles);
            }
        }
    }

    protected Set<String> populateUserPermissions(String site, String path, Set<String> roles, PermissionsConfigTO permissionsConfig) {
        HashSet<String> permissions = new HashSet<String>();
        if (roles != null && !roles.isEmpty()) {
            for (String role : roles) {
                Map<String, Map<String, List<Node>>> permissionsMap = permissionsConfig.getPermissions();
                Map<String, List<Node>> siteRoles = permissionsMap.get(site);
                if (siteRoles == null || siteRoles.isEmpty()) {
                    siteRoles = permissionsMap.get("*");
                }
                if (siteRoles != null && !siteRoles.isEmpty()) {
                    List<Node> ruleNodes = siteRoles.get(role);
                    if (ruleNodes == null || ruleNodes.isEmpty()) {
                        ruleNodes = siteRoles.get("*");
                    }
                    if (ruleNodes != null && !ruleNodes.isEmpty()) {
                        for (Node ruleNode : ruleNodes) {
                            String regex = ruleNode.valueOf("@regex");
                            if (!path.matches(regex)) continue;
                            logger.debug("Permissions found by matching " + regex + " for " + role + " in " + site, new Object[0]);
                            List permissionNodes = ruleNode.selectNodes("allowed-permissions/permission");
                            for (Node permissionNode : permissionNodes) {
                                String permission = permissionNode.getText().toLowerCase();
                                logger.debug("adding permissions " + permission + " to " + path + " for " + role + " in " + site, new Object[0]);
                                permissions.add(permission);
                            }
                        }
                        continue;
                    }
                    logger.debug("No default role is set. adding default permission: read", new Object[0]);
                    permissions.add("read");
                    continue;
                }
                logger.debug("No default site is set. adding default permission: read", new Object[0]);
                permissions.add("read");
            }
        } else {
            logger.debug("No user or group matching found. adding default permission: read", new Object[0]);
            permissions.add("read");
        }
        return permissions;
    }

    protected PermissionsConfigTO loadConfiguration(String site, String filename) {
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.configurationService.getConfigurationAsDocument(site, "studio", filename, this.studioConfiguration.getProperty("studio.configuration.environment.active"));
        }
        catch (IOException | DocumentException e) {
            logger.error("Permission mapping not found for " + site + ":" + filename, new Object[0]);
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            this.loadPermissions(site, root, config);
            config.setKey(site + ":" + filename);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Permission mapping not found for " + site + ":" + filename, new Object[0]);
        }
        return config;
    }

    protected void loadRoles(Element root, PermissionsConfigTO config) {
        if (root.getName().equals("role-mappings")) {
            Map<String, List<String>> rolesMap = new HashMap<String, List<String>>();
            List userNodes = root.selectNodes("users/user");
            rolesMap = this.getRoles(userNodes, rolesMap);
            List groupNodes = root.selectNodes("groups/group");
            rolesMap = this.getRoles(groupNodes, rolesMap);
            config.setRoles(rolesMap);
        }
    }

    protected Map<String, List<String>> getRoles(List<Node> nodes, Map<String, List<String>> rolesMap) {
        for (Node node : nodes) {
            String name = node.valueOf("@name");
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            List roleNodes = node.selectNodes("role");
            ArrayList<String> roles = new ArrayList<String>();
            for (Node roleNode : roleNodes) {
                roles.add(roleNode.getText());
            }
            rolesMap.put(name, roles);
        }
        return rolesMap;
    }

    protected void loadPermissions(String siteId, Element root, PermissionsConfigTO config) {
        if (root.getName().equals("permissions")) {
            HashMap<String, Map<String, List<Node>>> permissionsMap = new HashMap<String, Map<String, List<Node>>>();
            Element permissionsRoot = root;
            Element siteNode = (Element)permissionsRoot.selectSingleNode("site");
            if (siteNode != null) {
                permissionsRoot = siteNode;
            }
            List roleNodes = permissionsRoot.selectNodes("role");
            HashMap<String, List> rules = new HashMap<String, List>();
            for (Node roleNode : roleNodes) {
                String roleName = roleNode.valueOf("@name");
                List ruleNodes = roleNode.selectNodes("rule");
                rules.put(roleName, ruleNodes);
            }
            permissionsMap.put(siteId, rules);
            config.setPermissions(permissionsMap);
        }
    }

    protected PermissionsConfigTO loadGlobalPermissionsConfiguration() {
        String globalPermissionsConfigPath = this.getGlobalConfigPath() + "/" + this.getGlobalPermissionsFileName();
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.contentService.getContentAsDocument("", globalPermissionsConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global permission mapping not found (path: {0})", globalPermissionsConfigPath);
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadPermissions("###GLOBAL###", root, config);
            String globalPermissionsKey = "###GLOBAL###:" + this.getGlobalPermissionsFileName();
            config.setKey(globalPermissionsKey);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Global permission mapping not found (path: {0})", globalPermissionsConfigPath);
        }
        return config;
    }

    protected PermissionsConfigTO loadGlobalRolesConfiguration() {
        String globalRolesConfigPath = this.getGlobalConfigPath() + "/" + this.getGlobalRoleMappingsFileName();
        Document document = null;
        PermissionsConfigTO config = null;
        try {
            document = this.contentService.getContentAsDocument("", globalRolesConfigPath);
        }
        catch (DocumentException e) {
            logger.error("Global roles mapping not found (path: {0})", globalRolesConfigPath);
        }
        if (document != null) {
            config = new PermissionsConfigTO();
            config.setMapping(document);
            Element root = document.getRootElement();
            this.loadRoles(root, config);
            String globalRolesKey = "###GLOBAL###:" + this.getGlobalRoleMappingsFileName();
            config.setKey(globalRolesKey);
            config.setLastUpdated(ZonedDateTime.now(ZoneOffset.UTC));
        } else {
            logger.error("Global roles mapping not found (path: {0})", globalRolesConfigPath);
        }
        return config;
    }

    @Override
    @ValidateParams
    public void reloadConfiguration(@ValidateStringParam(name="site") String site) {
        PermissionsConfigTO permissionsConfigTO = this.loadConfiguration(site, this.getPermissionsFileName());
        PermissionsConfigTO rolesConfigTO = this.loadConfiguration(site, this.getRoleMappingsFileName());
    }

    @Override
    public void reloadGlobalConfiguration() {
        PermissionsConfigTO permissionsConfigTO = this.loadGlobalPermissionsConfiguration();
        PermissionsConfigTO rolesConfigTO = this.loadGlobalRolesConfiguration();
    }

    @Override
    public boolean logout() throws SiteNotFoundException {
        String username = this.getCurrentUser();
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpServletRequest httpServletRequest = context.getRequest();
            String ipAddress = httpServletRequest.getRemoteAddr();
            SiteFeed siteFeed = this.siteService.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
            AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
            auditLog.setOperation("LOGOUT");
            auditLog.setActorId(username);
            auditLog.setSiteId(siteFeed.getId());
            auditLog.setPrimaryTargetId(username);
            auditLog.setPrimaryTargetType("User");
            auditLog.setPrimaryTargetValue(username);
            this.auditServiceInternal.insertAuditLog(auditLog);
            logger.info("User " + username + " logged out from IP: " + ipAddress, new Object[0]);
        }
        return true;
    }

    @Override
    public int getAllUsersTotal() throws ServiceLayerException {
        return this.userServiceInternal.getAllUsersTotal();
    }

    @Override
    @ValidateParams
    public boolean validateToken(@ValidateStringParam(name="token") String token) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        StringTokenizer tokenElements;
        boolean toRet = false;
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            String username = tokenElements.nextToken();
            User userProfile = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
            if (userProfile == null) {
                logger.info("User profile not found for " + username, new Object[0]);
                throw new UserNotFoundException();
            }
            if (userProfile.isExternallyManaged()) {
                throw new UserExternallyManagedException();
            }
            long tokenTimestamp = Long.parseLong(tokenElements.nextToken());
            toRet = tokenTimestamp >= System.currentTimeMillis();
        }
        return toRet;
    }

    private String decryptToken(String token) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.studioConfiguration.getProperty("studio.security.cipher.key").getBytes(), this.studioConfiguration.getProperty("studio.security.cipher.type"));
            Cipher cipher = Cipher.getInstance(this.studioConfiguration.getProperty("studio.security.cipher.algorithm"));
            byte[] tokenBytes = Base64.getDecoder().decode(token.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)key, new IvParameterSpec(key.getEncoded()));
            byte[] decrypted = cipher.doFinal(tokenBytes);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error("Error while decrypting forgot password token", e, new Object[0]);
            return null;
        }
    }

    @Override
    @ValidateParams
    public boolean changePassword(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="current") String current, @ValidateStringParam(name="newPassword") String newPassword) throws PasswordDoesNotMatchException, UserExternallyManagedException, ServiceLayerException {
        return this.userServiceInternal.changePassword(username, current, newPassword);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @ValidateParams
    public Map<String, Object> setUserPassword(@ValidateStringParam(name="token") String token, @ValidateStringParam(name="newPassword") String newPassword) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        HashMap<String, Object> toRet = new HashMap<String, Object>();
        toRet.put("username", "");
        toRet.put("success", false);
        if (!this.validateToken(token)) return toRet;
        String username = this.getUsernameFromToken(token);
        if (!StringUtils.isNotEmpty((CharSequence)username)) throw new UserNotFoundException("User not found");
        toRet.put("username", username);
        User user = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
        if (user == null) throw new UserNotFoundException("User not found");
        if (!user.isEnabled()) return toRet;
        toRet.put("success", this.userServiceInternal.setUserPassword(username, newPassword));
        return toRet;
    }

    private String getUsernameFromToken(String token) {
        StringTokenizer tokenElements;
        String toRet = "";
        String decryptedToken = this.decryptToken(token);
        if (StringUtils.isNotEmpty((CharSequence)decryptedToken) && (tokenElements = new StringTokenizer(decryptedToken, "|")).countTokens() == 3) {
            toRet = tokenElements.nextToken();
        }
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean resetPassword(@ValidateStringParam(name="username") String username, @ValidateStringParam(name="newPassword") String newPassword) throws UserNotFoundException, UserExternallyManagedException, ServiceLayerException {
        String currentUser = this.getCurrentUser();
        if (this.isAdmin(currentUser)) {
            return this.userServiceInternal.setUserPassword(username, newPassword);
        }
        return false;
    }

    private boolean isAdmin(String username) throws ServiceLayerException, UserNotFoundException {
        List<Group> userGroups = this.userServiceInternal.getUserGroups(-1L, username);
        boolean toRet = false;
        if (CollectionUtils.isNotEmpty(userGroups)) {
            for (Group group : userGroups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)group.getGroupName(), (CharSequence)"system_admin")) continue;
                toRet = true;
                break;
            }
        }
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean isSiteAdmin(@ValidateStringParam(name="username") String username, String site) {
        boolean toRet = false;
        try {
            Map<String, List<String>> roleMappings;
            if (this.userServiceInternal.isUserMemberOfGroup(username, "system_admin")) {
                return true;
            }
            List<Group> groups = this.userServiceInternal.getUserGroups(-1L, username);
            if (CollectionUtils.isNotEmpty(groups) && MapUtils.isNotEmpty(roleMappings = this.configurationService.geRoleMappings(site))) {
                for (Group group : groups) {
                    String groupName = group.getGroupName();
                    List<String> roles = roleMappings.get(groupName);
                    if (!roles.contains("admin")) continue;
                    toRet = true;
                }
            }
        }
        catch (ServiceLayerException | UserNotFoundException e) {
            logger.warn("Error getting user memberships", e);
        }
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean userExists(@ValidateStringParam(name="username") String username) throws ServiceLayerException {
        return this.userServiceInternal.userExists(-1L, username);
    }

    @Override
    public boolean validateSession(HttpServletRequest request) throws ServiceLayerException {
        UserDetails userDetails;
        HttpSession httpSession = request.getSession();
        String authToken = this.getCurrentToken();
        String userName = this.getCurrentUser();
        if (userName != null && SessionTokenUtils.validateToken(authToken, (userDetails = this.userDetailsManager.loadUserByUsername(userName)).getUsername())) {
            return true;
        }
        httpSession.removeAttribute("studio_authentication");
        httpSession.invalidate();
        return false;
    }

    @Override
    public Authentication getAuthentication() {
        Authentication auth = null;
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            auth = (Authentication)httpSession.getAttribute("studio_authentication");
        }
        return auth;
    }

    protected String getJobOrEventTicket() {
        String ticket = null;
        CronJobContext cronJobContext = CronJobContext.getCurrent();
        if (cronJobContext != null) {
            ticket = cronJobContext.getAuthenticationToken();
        } else {
            RepositoryEventContext repositoryEventContext = RepositoryEventContext.getCurrent();
            if (repositoryEventContext != null) {
                ticket = repositoryEventContext.getAuthenticationToken();
            }
        }
        return ticket;
    }

    public String getRoleMappingsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.roleMappingsFileName");
    }

    public String getPermissionsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.site.permissionMappingsFileName");
    }

    public String getGlobalConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.global.configBasePath");
    }

    public String getGlobalRoleMappingsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.global.roleMappingFileName");
    }

    public String getGlobalPermissionsFileName() {
        return this.studioConfiguration.getProperty("studio.configuration.global.permissionMappingFileName");
    }

    public int getSessionTimeout() {
        int toReturn = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.sessionTimeout"));
        return toReturn;
    }

    public boolean isAuthenticatedSMTP() {
        boolean toReturn = Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.mail.smtp.auth"));
        return toReturn;
    }

    public String getDefaultFromAddress() {
        return this.studioConfiguration.getProperty("studio.mail.from.default");
    }

    public String getSystemSite() {
        return this.studioConfiguration.getProperty("studio.configuration.global.systemSite");
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public JavaMailSender getEmailService() {
        return this.emailService;
    }

    public void setEmailService(JavaMailSender emailService) {
        this.emailService = emailService;
    }

    public JavaMailSender getEmailServiceNoAuth() {
        return this.emailServiceNoAuth;
    }

    public void setEmailServiceNoAuth(JavaMailSender emailServiceNoAuth) {
        this.emailServiceNoAuth = emailServiceNoAuth;
    }

    public UserDetailsManager getUserDetailsManager() {
        return this.userDetailsManager;
    }

    public void setUserDetailsManager(UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    public ObjectFactory<FreeMarkerConfig> getFreeMarkerConfig() {
        return this.freeMarkerConfig;
    }

    public void setFreeMarkerConfig(ObjectFactory<FreeMarkerConfig> freeMarkerConfig) {
        this.freeMarkerConfig = freeMarkerConfig;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public AuthenticationChain getAuthenticationChain() {
        return this.authenticationChain;
    }

    public void setAuthenticationChain(AuthenticationChain authenticationChain) {
        this.authenticationChain = authenticationChain;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

