/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.site;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.plugin.model.PluginDescriptor;
import org.craftercms.commons.rest.RestServiceException;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateNoTagsParam;
import org.craftercms.commons.validation.annotations.param.ValidateParams;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v1.ebus.PreviewEventContext;
import org.craftercms.studio.api.v1.exception.BlueprintNotFoundException;
import org.craftercms.studio.api.v1.exception.DeployerTargetException;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.SiteAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.SiteCreationException;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryCredentialsException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteRepositoryException;
import org.craftercms.studio.api.v1.exception.repository.InvalidRemoteUrlException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotBareException;
import org.craftercms.studio.api.v1.exception.repository.RemoteRepositoryNotFoundException;
import org.craftercms.studio.api.v1.exception.security.GroupAlreadyExistsException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.repository.RepositoryItem;
import org.craftercms.studio.api.v1.service.GeneralLockService;
import org.craftercms.studio.api.v1.service.configuration.ServicesConfig;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.content.ContentTypeService;
import org.craftercms.studio.api.v1.service.content.DmPageNavigationOrderService;
import org.craftercms.studio.api.v1.service.content.ImportService;
import org.craftercms.studio.api.v1.service.content.ObjectMetadataManager;
import org.craftercms.studio.api.v1.service.dependency.DependencyService;
import org.craftercms.studio.api.v1.service.deployment.DeploymentService;
import org.craftercms.studio.api.v1.service.event.EventService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.objectstate.TransitionEvent;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteConfigNotFoundException;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v1.to.RemoteRepositoryInfoTO;
import org.craftercms.studio.api.v1.to.SiteBlueprintTO;
import org.craftercms.studio.api.v1.to.SiteTO;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.AuditLog;
import org.craftercms.studio.api.v2.dal.AuditLogParameter;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.ClusterMember;
import org.craftercms.studio.api.v2.dal.GitLog;
import org.craftercms.studio.api.v2.dal.RepoOperation;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;
import org.craftercms.studio.api.v2.dal.StudioDBScriptRunner;
import org.craftercms.studio.api.v2.dal.StudioDBScriptRunnerFactory;
import org.craftercms.studio.api.v2.deployment.Deployer;
import org.craftercms.studio.api.v2.exception.MissingPluginParameterException;
import org.craftercms.studio.api.v2.repository.ContentRepository;
import org.craftercms.studio.api.v2.service.audit.internal.AuditServiceInternal;
import org.craftercms.studio.api.v2.service.config.ConfigurationService;
import org.craftercms.studio.api.v2.service.dependency.internal.DependencyServiceInternal;
import org.craftercms.studio.api.v2.service.notification.NotificationService;
import org.craftercms.studio.api.v2.service.security.internal.GroupServiceInternal;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.service.site.internal.SitesServiceInternal;
import org.craftercms.studio.api.v2.upgrade.UpgradeManager;
import org.craftercms.studio.api.v2.utils.SqlStatementGeneratorUtils;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.repository.job.RebuildRepositoryMetadata;
import org.craftercms.studio.impl.v1.repository.job.SyncDatabaseWithRepository;
import org.craftercms.studio.impl.v1.service.site.SiteServiceDAL;
import org.craftercms.studio.impl.v2.service.cluster.StudioClusterUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;

public class SiteServiceImpl
implements SiteService {
    private static final Logger logger = LoggerFactory.getLogger(SiteServiceImpl.class);
    protected Deployer deployer;
    protected SiteServiceDAL _siteServiceDAL;
    protected ServicesConfig servicesConfig;
    protected ContentService contentService;
    protected org.craftercms.studio.api.v1.repository.ContentRepository contentRepository;
    protected ContentRepository contentRepositoryV2;
    protected ObjectStateService objectStateService;
    protected DependencyService dependencyService;
    protected SecurityService securityService;
    protected DeploymentService deploymentService;
    protected ObjectMetadataManager objectMetadataManager;
    protected DmPageNavigationOrderService dmPageNavigationOrderService;
    protected ContentTypeService contentTypeService;
    protected ImportService importService;
    protected NotificationService notificationService;
    protected GeneralLockService generalLockService;
    protected RebuildRepositoryMetadata rebuildRepositoryMetadata;
    protected SyncDatabaseWithRepository syncDatabaseWithRepository;
    protected EventService eventService;
    protected GroupServiceInternal groupServiceInternal;
    protected UserServiceInternal userServiceInternal;
    protected UpgradeManager upgradeManager;
    protected StudioConfiguration studioConfiguration;
    protected SitesServiceInternal sitesServiceInternal;
    protected AuditServiceInternal auditServiceInternal;
    protected ConfigurationService configurationService;
    protected StudioClusterUtils studioClusterUtils;
    protected ClusterDAO clusterDao;
    @Autowired
    protected SiteFeedMapper siteFeedMapper;
    protected EntitlementValidator entitlementValidator;
    protected StudioDBScriptRunnerFactory studioDBScriptRunnerFactory;
    protected DependencyServiceInternal dependencyServiceInternal;
    protected RetryingOperationFacade retryingOperationFacade;

    @Override
    @ValidateParams
    public boolean writeConfiguration(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, InputStream content) throws ServiceLayerException {
        String operation = "UPDATE";
        if (!this.contentRepository.contentExists(site, path)) {
            operation = "CREATE";
        }
        String commitId = this.contentRepository.writeContent(site, path, content);
        this.contentRepository.reloadRepository(site);
        PreviewEventContext context = new PreviewEventContext();
        context.setSite(site);
        this.eventService.publish("studio.event.previewSync", context);
        String user = this.securityService.getCurrentUser();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)this.contentTypeService.getConfigPath())) {
            extraInfo.put("contentType", "content type");
        } else {
            extraInfo.put("contentType", "configuration");
        }
        SiteFeed siteFeed = this.getSite(site);
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation(operation);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(site + ":" + path);
        auditLog.setPrimaryTargetType("Content Item");
        auditLog.setPrimaryTargetValue(path);
        this.auditServiceInternal.insertAuditLog(auditLog);
        this.objectStateService.transition(site, path, TransitionEvent.SAVE);
        if (!this.objectMetadataManager.metadataExist(site, path)) {
            this.objectMetadataManager.insertNewObjectMetadata(site, path);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("name", FilenameUtils.getName((String)path));
        properties.put("modified", ZonedDateTime.now(ZoneOffset.UTC));
        properties.put("modifier", user);
        this.objectMetadataManager.setObjectMetadata(site, path, properties);
        if (commitId != null) {
            this.objectMetadataManager.updateCommitId(site, path, commitId);
            this.contentRepositoryV2.insertGitLog(site, commitId, 1);
        }
        boolean toRet = StringUtils.isEmpty((CharSequence)commitId);
        return toRet;
    }

    @Override
    @ValidateParams
    public boolean writeConfiguration(@ValidateSecurePathParam(name="path") String path, InputStream content) throws ServiceLayerException {
        String commitId = this.contentRepository.writeContent("", path, content);
        boolean toReturn = StringUtils.isEmpty((CharSequence)commitId);
        return toReturn;
    }

    @Override
    @ValidateParams
    public Map<String, Object> getConfiguration(@ValidateSecurePathParam(name="path") String path) {
        return null;
    }

    @Override
    @ValidateParams
    public Document getSiteConfiguration(@ValidateStringParam(name="site") String site) throws SiteConfigNotFoundException {
        return this._siteServiceDAL.getSiteConfiguration(site);
    }

    @Override
    @ValidateParams
    public Map<String, Object> getConfiguration(@ValidateStringParam(name="site") String site, @ValidateSecurePathParam(name="path") String path, boolean applyEnv) {
        String configContent;
        if (StringUtils.isEmpty((CharSequence)site)) {
            String configPath = this.getGlobalConfigRoot() + path;
            configContent = this.contentService.getContentAsString(site, configPath);
        } else if (path.startsWith("/content-types/")) {
            String configPath = this.getSitesConfigPath() + path;
            configContent = this.contentService.getContentAsString(site, configPath);
        } else {
            configContent = this.configurationService.getConfigurationAsString(site, "studio", path, this.studioConfiguration.getProperty("studio.configuration.environment.active"));
        }
        Map<String, Object> toRet = null;
        if (configContent != null) {
            configContent = configContent.replaceAll("\"\\n([\\s]+)?+", "\" ");
            configContent = configContent.replaceAll("\\n([\\s]+)?+", "");
            configContent = configContent.replaceAll("<!--(.*?)-->", "");
            toRet = this.convertNodesFromXml(configContent);
        }
        return toRet;
    }

    private Map<String, Object> convertNodesFromXml(String xml) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            return this.createMap(document.getRootElement());
        }
        catch (DocumentException e) {
            logger.error("Error reading xml string:\n" + xml, new Object[0]);
            return null;
        }
    }

    private Map<String, Object> createMap(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node currentNode = element.node(i);
            if (!(currentNode instanceof Element)) continue;
            Element currentElement = (Element)currentNode;
            String key = currentElement.getName();
            Object toAdd = null;
            toAdd = currentElement.isTextOnly() ? currentElement.getStringValue() : this.createMap(currentElement);
            if (map.containsKey(key)) {
                Object value = map.get(key);
                List<Object> listOfValues = new ArrayList();
                if (value instanceof List) {
                    listOfValues = (List)value;
                } else {
                    listOfValues.add(value);
                }
                listOfValues.add(toAdd);
                map.put(key, listOfValues);
                continue;
            }
            map.put(key, toAdd);
        }
        return map;
    }

    @Override
    public Set<String> getAllAvailableSites() {
        List<SiteFeed> sites = this.siteFeedMapper.getSites();
        HashSet<String> toRet = new HashSet<String>();
        for (SiteFeed site : sites) {
            toRet.add(site.getSiteId());
        }
        return toRet;
    }

    @Override
    public int countSites() {
        return this.siteFeedMapper.countSites();
    }

    @Override
    @ValidateParams
    public void createSiteFromBlueprint(@ValidateStringParam(name="blueprintId") String blueprintId, @ValidateNoTagsParam(name="siteName") String siteName, @ValidateStringParam(name="siteId", maxLength=50, whitelistedPatterns={"[a-z0-9\\-]*"}) String siteId, @ValidateStringParam(name="sandboxBranch") String sandboxBranch, @ValidateNoTagsParam(name="desc") String desc, Map<String, String> params, boolean createAsOrphan) throws SiteAlreadyExistsException, SiteCreationException, DeployerTargetException, BlueprintNotFoundException, MissingPluginParameterException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        logger.debug("Get blueprint descriptor for: " + blueprintId, new Object[0]);
        PluginDescriptor descriptor = this.sitesServiceInternal.getBlueprintDescriptor(blueprintId);
        if (Objects.isNull(descriptor)) {
            throw new BlueprintNotFoundException();
        }
        logger.debug("Validating blueprint parameters", new Object[0]);
        this.sitesServiceInternal.validateBlueprintParameters(descriptor, params);
        String blueprintLocation = this.sitesServiceInternal.getBlueprintLocation(blueprintId);
        String searchEngine = descriptor.getPlugin().getSearchEngine();
        logger.debug("Validate site entitlements", new Object[0]);
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.SITE, 1);
        }
        catch (EntitlementException e) {
            throw new SiteCreationException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Exception)((Object)e));
        }
        logger.info("Starting site creation process for site " + siteName + " from " + blueprintId + " blueprint.", new Object[0]);
        boolean success = true;
        String siteUuid = UUID.randomUUID().toString();
        logger.info("Creating deployer targets.", new Object[0]);
        try {
            this.deployer.createTargets(siteId, searchEngine);
        }
        catch (Exception e) {
            success = false;
            String msg = "Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintId + ". The required Deployer targets couldn't be created";
            logger.error(msg, e, new Object[0]);
            throw new DeployerTargetException(msg, e);
        }
        if (success) {
            try {
                logger.info("Copying site content from blueprint.", new Object[0]);
                success = this.createSiteFromBlueprintGit(blueprintLocation, siteName, siteId, sandboxBranch, desc, params);
                ZonedDateTime now = ZonedDateTime.now();
                logger.debug("Adding site UUID.", new Object[0]);
                this.addSiteUuidFile(siteId, siteUuid);
                logger.info("Adding site record to database for site " + siteId, new Object[0]);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteName);
                siteFeed.setSiteId(siteId);
                siteFeed.setSiteUuid(siteUuid);
                siteFeed.setDescription(desc);
                siteFeed.setPublishingStatus("ready");
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                siteFeed.setSearchEngine(searchEngine);
                this.siteFeedMapper.createSite(siteFeed);
                String localeAddress = this.studioClusterUtils.getClusterNodeLocalAddress();
                ClusterMember cm = this.clusterDao.getMemberByLocalAddress(localeAddress);
                if (Objects.nonNull(cm)) {
                    SiteFeed s = this.getSite(siteId);
                    this.clusterDao.insertClusterSiteSyncRepo(cm.getId(), s.getId(), null, null, null);
                }
                logger.info("Upgrading site.", new Object[0]);
                this.upgradeManager.upgradeSite(siteId);
                logger.info("Adding default groups", new Object[0]);
                this.addDefaultGroupsForNewSite(siteId);
                String lastCommitId = this.contentRepositoryV2.getRepoLastCommitId(siteId);
                String creator = this.securityService.getCurrentUser();
                long startGetChangeSetCreatedFilesMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                Map<String, String> createdFiles = this.contentRepositoryV2.getChangeSetPathsFromDelta(siteId, null, lastCommitId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Get change set created files finished in " + (System.currentTimeMillis() - startGetChangeSetCreatedFilesMark) + " milliseconds", new Object[0]);
                }
                logger.info("Adding audit log", new Object[0]);
                this.insertCreateSiteAuditLog(siteId, siteName, createdFiles);
                this.processCreatedFiles(siteId, createdFiles, creator, now, lastCommitId);
                this.contentRepositoryV2.insertGitLog(siteId, lastCommitId, 1, 1);
                this.updateLastCommitId(siteId, lastCommitId);
                this.updateLastVerifiedGitlogCommitId(siteId, lastCommitId);
                this.updateLastSyncedGitlogCommitId(siteId, lastCommitId);
                logger.info("Reload site configuration", new Object[0]);
                this.reloadSiteConfiguration(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintId + ". Rolling back.", e, new Object[0]);
                this.deleteSite(siteId);
                throw new SiteCreationException("Error while creating site: " + siteName + " ID: " + siteId + " from blueprint: " + blueprintId + ". Rolling back.");
            }
        }
        if (success) {
            logger.info("Syncing all content to preview.", new Object[0]);
            try {
                this.deploymentService.syncAllContentToPreview(siteId, true);
            }
            catch (ServiceLayerException e) {
                logger.error("Error while syncing site: " + siteName + " ID: " + siteId + " to preview. Site was successfully created otherwise. Ignoring.", e, new Object[0]);
                throw new SiteCreationException("Error while syncing site: " + siteName + " ID: " + siteId + " to preview. Site was successfully created, but it won't be preview-able until the Preview Deployer is reachable.");
            }
        } else {
            throw new SiteCreationException("Error while creating site: " + siteName + " ID: " + siteId + ".");
        }
        this.setSiteState(siteId, "CREATED");
        logger.info("Finished creating site " + siteId, new Object[0]);
    }

    private void insertCreateSiteAuditLog(String siteId, String siteName, Map<String, String> createdFiles) throws SiteNotFoundException {
        SiteFeed siteFeed = this.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        String user = this.securityService.getCurrentUser();
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("CREATE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(siteId);
        auditLog.setPrimaryTargetType("Site");
        auditLog.setPrimaryTargetValue(siteName);
        ArrayList<AuditLogParameter> auditLogParameters = new ArrayList<AuditLogParameter>();
        createdFiles.forEach((k, v) -> {
            String targetPath = k;
            if (StringUtils.length((CharSequence)v) > 1) {
                targetPath = v;
            }
            AuditLogParameter auditLogParameter = new AuditLogParameter();
            auditLogParameter.setTargetId(siteId + ":" + targetPath);
            auditLogParameter.setTargetType("Content Item");
            auditLogParameter.setTargetValue(targetPath);
            auditLogParameters.add(auditLogParameter);
        });
        auditLog.setParameters(auditLogParameters);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreatedFiles(String siteId, Map<String, String> createdFiles, String creator, ZonedDateTime now, String lastCommitId) {
        long startProcessCreatedFilesMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        StudioDBScriptRunner studioDBScriptRunner = this.studioDBScriptRunnerFactory.getDBScriptRunner();
        studioDBScriptRunner.openConnection();
        try {
            String scriptFilename = "createdFiles_" + UUID.randomUUID();
            Path scriptPath = Files.createTempFile(scriptFilename, ".sql", new FileAttribute[0]);
            for (String path : createdFiles.keySet()) {
                Files.write(scriptPath, SqlStatementGeneratorUtils.upsertItemStateRow(siteId, path).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                Files.write(scriptPath, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                Files.write(scriptPath, SqlStatementGeneratorUtils.upsertItemMetadataRow(siteId, path, creator, now, lastCommitId).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                Files.write(scriptPath, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                this.addDependenciesScriptSnippets(siteId, path, null, scriptPath);
            }
            studioDBScriptRunner.execute(scriptPath.toFile());
            if (logger.isDebugEnabled()) {
                logger.debug("Process created files finished in " + (System.currentTimeMillis() - startProcessCreatedFilesMark) + " milliseconds", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error while creating DB script file for processing created files for site " + siteId, new Object[0]);
        }
        finally {
            studioDBScriptRunner.closeConnection();
        }
    }

    private void addDependenciesScriptSnippets(String siteId, String path, String oldPath, Path file) throws IOException {
        long startDependencyResolver = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Map<String, Set<String>> dependencies = this.dependencyServiceInternal.resolveDependnecies(siteId, path);
        if (logger.isDebugEnabled()) {
            logger.debug("Dependency resolver for " + path + " finished in " + (System.currentTimeMillis() - startDependencyResolver) + " milliseconds", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)oldPath)) {
            Files.write(file, SqlStatementGeneratorUtils.deleteDependencySourcePathRows(siteId, path).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        } else {
            Files.write(file, SqlStatementGeneratorUtils.deleteDependencySourcePathRows(siteId, oldPath).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        if (Objects.nonNull(dependencies) && !dependencies.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : dependencies.entrySet()) {
                for (String targetPath : entry.getValue()) {
                    Files.write(file, SqlStatementGeneratorUtils.insertDependencyRow(siteId, path, targetPath, entry.getKey()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                }
            }
        }
    }

    protected boolean createSiteFromBlueprintGit(String blueprintLocation, String siteName, String siteId, String sandboxBranch, String desc, Map<String, String> params) throws Exception {
        boolean success = true;
        success = this.contentRepositoryV2.createSiteFromBlueprint(blueprintLocation, siteId, sandboxBranch, params);
        String siteConfigFolder = "/config/studio";
        this.replaceFileContentGit(siteId, siteConfigFolder + "/" + "site-config.xml", "SITENAME", siteId);
        return success;
    }

    protected void replaceFileContentGit(String site, String path, String find, String replace) throws Exception {
        InputStream content = this.contentRepository.getContent(site, path);
        String contentAsString = IOUtils.toString((InputStream)content);
        contentAsString = contentAsString.replaceAll(find, replace);
        InputStream contentToWrite = IOUtils.toInputStream((String)contentAsString);
        this.contentRepository.writeContent(site, path, contentToWrite);
    }

    private void addDefaultGroupsForNewSite(String siteId) {
        List<String> defaultGroups = this.getDefaultGroups();
        for (String group : defaultGroups) {
            String description = group + " site default group";
            try {
                if (!this.groupServiceInternal.groupExists(-1L, group)) {
                    try {
                        this.groupServiceInternal.createGroup(1L, group, description);
                        continue;
                    }
                    catch (GroupAlreadyExistsException e) {
                        throw new IllegalStateException(e);
                    }
                }
                logger.warn("Default group: " + group + " not created. It already exists.", new Object[0]);
            }
            catch (ServiceLayerException e) {
                logger.warn("Error creating group " + group, e);
            }
        }
    }

    @Override
    @ValidateParams
    public void createSiteWithRemoteOption(@ValidateStringParam(name="siteId", maxLength=50, whitelistedPatterns={"[a-z0-9\\-]*"}) String siteId, @ValidateStringParam(name="sandboxBranch") String sandboxBranch, @ValidateNoTagsParam(name="description") String description, String blueprintName, @ValidateStringParam(name="remoteName") String remoteName, @ValidateStringParam(name="remoteUrl") String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, @ValidateStringParam(name="createOption") String createOption, Map<String, String> params, boolean createAsOrphan) throws ServiceLayerException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, RemoteRepositoryNotBareException, InvalidRemoteUrlException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        logger.debug("Validate site entitlements", new Object[0]);
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.SITE, 1);
        }
        catch (EntitlementException e) {
            throw new SiteCreationException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Exception)((Object)e));
        }
        switch (createOption) {
            case "clone": {
                logger.info("Clone from remote repository create option selected", new Object[0]);
                this.createSiteCloneRemote(siteId, sandboxBranch, description, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, params, createAsOrphan);
                break;
            }
            case "push": {
                logger.info("Push to remote repository create option selected", new Object[0]);
                this.createSitePushToRemote(siteId, sandboxBranch, description, blueprintName, remoteName, remoteUrl, remoteBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, params, createAsOrphan);
                break;
            }
            default: {
                logger.error("Invalid create option for create site using remote repository: " + createOption + "\nAvailable options: [" + "clone" + ", " + "push" + "]", new Object[0]);
            }
        }
    }

    private void createSiteCloneRemote(String siteId, String sandboxBranch, String description, String remoteName, String remoteUrl, String remoteBranch, boolean singleBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, Map<String, String> params, boolean createAsOrphan) throws ServiceLayerException, InvalidRemoteRepositoryException, InvalidRemoteRepositoryCredentialsException, RemoteRepositoryNotFoundException, InvalidRemoteUrlException {
        boolean success = true;
        String siteUuid = UUID.randomUUID().toString();
        try {
            logger.info("Creating site " + siteId + " by cloning remote repository " + remoteName + " (" + remoteUrl + ")", new Object[0]);
            success = this.contentRepositoryV2.createSiteCloneRemote(siteId, sandboxBranch, remoteName, remoteUrl, remoteBranch, singleBranch, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, params, createAsOrphan);
        }
        catch (ServiceLayerException | InvalidRemoteRepositoryCredentialsException | InvalidRemoteRepositoryException | InvalidRemoteUrlException | RemoteRepositoryNotFoundException e) {
            this.contentRepository.deleteSite(siteId);
            logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.", e, new Object[0]);
            throw e;
        }
        if (!success) {
            this.contentRepository.removeRemoteRepositoriesForSite(siteId);
            this.contentRepository.deleteSite(siteId);
            throw new ServiceLayerException("Failed to create site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + ")");
        }
        String searchEngine = this.studioConfiguration.getProperty("studio.preview.search.engine");
        PluginDescriptor descriptor = this.sitesServiceInternal.getSiteBlueprintDescriptor(siteId);
        if (Objects.nonNull(descriptor) && Objects.nonNull(descriptor.getPlugin())) {
            searchEngine = descriptor.getPlugin().getSearchEngine();
            logger.info("Using search engine {0} from plugin descriptor", searchEngine);
        } else if (Objects.nonNull(descriptor) && Objects.nonNull(descriptor.getBlueprint())) {
            searchEngine = descriptor.getBlueprint().getSearchEngine();
            logger.info("Using search engine {0} from blueprint descriptor", searchEngine);
        } else {
            logger.info("Missing descriptor, using default search engine {0}", searchEngine);
        }
        if (success) {
            try {
                logger.info("Creating Deployer targets for site " + siteId, new Object[0]);
                this.deployer.createTargets(siteId, searchEngine);
            }
            catch (Exception e) {
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back...", e, new Object[0]);
                this.contentRepositoryV2.removeRemote(siteId, remoteName);
                boolean deleted = this.contentRepository.deleteSite(siteId);
                if (!deleted) {
                    logger.error("Error while rolling back site: " + siteId, new Object[0]);
                }
                throw new DeployerTargetException("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). The required Deployer targets couldn't be created", e);
            }
        }
        if (success) {
            ZonedDateTime now = ZonedDateTime.now();
            String creator = this.securityService.getCurrentUser();
            try {
                logger.debug("Adding site UUID.", new Object[0]);
                this.addSiteUuidFile(siteId, siteUuid);
                logger.info("Adding site record to database for site " + siteId, new Object[0]);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteId);
                siteFeed.setSiteId(siteId);
                siteFeed.setSiteUuid(siteUuid);
                siteFeed.setDescription(description);
                siteFeed.setPublishingStatus("ready");
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                siteFeed.setSearchEngine(searchEngine);
                this.siteFeedMapper.createSite(siteFeed);
                this.upgradeManager.upgradeSite(siteId);
                logger.info("Adding default groups for site " + siteId, new Object[0]);
                this.addDefaultGroupsForNewSite(siteId);
                String lastCommitId = this.contentRepositoryV2.getRepoLastCommitId(siteId);
                String firstCommitId = this.contentRepositoryV2.getRepoFirstCommitId(siteId);
                long startGetChangeSetCreatedFilesMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                Map<String, String> createdFiles = this.contentRepositoryV2.getChangeSetPathsFromDelta(siteId, null, lastCommitId);
                if (logger.isDebugEnabled()) {
                    logger.debug("Get change set created files finished in " + (System.currentTimeMillis() - startGetChangeSetCreatedFilesMark) + " milliseconds", new Object[0]);
                }
                this.insertCreateSiteAuditLog(siteId, siteId, createdFiles);
                this.contentRepositoryV2.insertGitLog(siteId, firstCommitId, 1, 1);
                this.processCreatedFiles(siteId, createdFiles, creator, now, lastCommitId);
                this.updateLastCommitId(siteId, lastCommitId);
                this.updateLastVerifiedGitlogCommitId(siteId, lastCommitId);
                this.updateLastSyncedGitlogCommitId(siteId, firstCommitId);
                logger.info("Loading configuration for site " + siteId, new Object[0]);
                this.reloadSiteConfiguration(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.", e, new Object[0]);
                this.deleteSite(siteId);
                throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " as clone from remote repository: " + remoteName + " (" + remoteUrl + "). Rolling back.");
            }
        }
        if (success) {
            logger.info("Sync all site content to preview for " + siteId, new Object[0]);
            try {
                this.deploymentService.syncAllContentToPreview(siteId, true);
            }
            catch (ServiceLayerException e) {
                logger.error("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created otherwise. Ignoring.", e, new Object[0]);
                throw new SiteCreationException("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created, but it won't be preview-able until the Preview Deployer is reachable.");
            }
        } else {
            throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + ".");
        }
        this.setSiteState(siteId, "CREATED");
        logger.info("Finished creating site " + siteId, new Object[0]);
    }

    private void createSitePushToRemote(String siteId, String sandboxBranch, String description, String blueprintId, String remoteName, String remoteUrl, String remoteBranch, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey, Map<String, String> params, boolean createAsOrphan) throws ServiceLayerException {
        if (this.exists(siteId)) {
            throw new SiteAlreadyExistsException();
        }
        logger.debug("Get blueprint descriptor for " + blueprintId, new Object[0]);
        PluginDescriptor descriptor = this.sitesServiceInternal.getBlueprintDescriptor(blueprintId);
        if (Objects.isNull(descriptor)) {
            throw new BlueprintNotFoundException();
        }
        logger.debug("Validate blueprint parameters", new Object[0]);
        this.sitesServiceInternal.validateBlueprintParameters(descriptor, params);
        String blueprintLocation = this.sitesServiceInternal.getBlueprintLocation(blueprintId);
        String searchEngine = descriptor.getPlugin().getSearchEngine();
        boolean success = true;
        String siteUuid = UUID.randomUUID().toString();
        logger.info("Starting site creation process for site " + siteId + " from " + blueprintId + " blueprint.", new Object[0]);
        try {
            logger.info("Creating Deployer targets for site " + siteId, new Object[0]);
            this.deployer.createTargets(siteId, searchEngine);
        }
        catch (RestServiceException e) {
            String msg = "Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId + ". The required Deployer targets couldn't be created";
            logger.error(msg, (Exception)((Object)e), new Object[0]);
            throw new DeployerTargetException(msg, (Exception)((Object)e));
        }
        if (success) {
            try {
                logger.info("Creating site " + siteId + " from blueprint " + blueprintId, new Object[0]);
                success = this.createSiteFromBlueprintGit(blueprintLocation, siteId, siteId, sandboxBranch, description, params);
                this.addSiteUuidFile(siteId, siteUuid);
                logger.info("Adding site record to database for site " + siteId, new Object[0]);
                SiteFeed siteFeed = new SiteFeed();
                siteFeed.setName(siteId);
                siteFeed.setSiteId(siteId);
                siteFeed.setSiteUuid(siteUuid);
                siteFeed.setDescription(description);
                siteFeed.setPublishingStatus("ready");
                siteFeed.setPublishingStatusMessage(this.studioConfiguration.getProperty("studio.job.deployContentToEnvironment.status.message.default"));
                siteFeed.setSandboxBranch(sandboxBranch);
                siteFeed.setSearchEngine(searchEngine);
                this.siteFeedMapper.createSite(siteFeed);
                logger.info("Upgrading site", new Object[0]);
                this.upgradeManager.upgradeSite(siteId);
            }
            catch (Exception e) {
                success = false;
                logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId + ". Rolling back...", e, new Object[0]);
                this.contentRepository.deleteSite(siteId);
                try {
                    this.deployer.deleteTargets(siteId);
                }
                catch (Exception ex) {
                    logger.error("Error while rolling back/deleting site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId + ". This means the site's Deployer targets are still present, but the site was not successfully created", e, new Object[0]);
                }
                throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId, e);
            }
            if (success) {
                ZonedDateTime now = ZonedDateTime.now();
                String creator = this.securityService.getCurrentUser();
                try {
                    logger.info("Pushing site " + siteId + " to remote repository " + remoteName + " (" + remoteUrl + ")", new Object[0]);
                    this.contentRepository.addRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
                    this.contentRepository.createSitePushToRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey, createAsOrphan);
                }
                catch (ServiceLayerException | InvalidRemoteRepositoryCredentialsException | InvalidRemoteRepositoryException | InvalidRemoteUrlException | RemoteRepositoryNotBareException | RemoteRepositoryNotFoundException e) {
                    logger.error("Error while pushing site: " + siteId + " ID: " + siteId + " to remote repository " + remoteName + " (" + remoteUrl + ")", e, new Object[0]);
                    this.contentRepositoryV2.removeRemote(siteId, remoteName);
                }
                try {
                    logger.info("Adding default groups for site " + siteId, new Object[0]);
                    this.addDefaultGroupsForNewSite(siteId);
                    logger.debug("Adding audit logs.", new Object[0]);
                    String lastCommitId = this.contentRepositoryV2.getRepoLastCommitId(siteId);
                    Map<String, String> createdFiles = this.contentRepositoryV2.getChangeSetPathsFromDelta(siteId, null, lastCommitId);
                    this.insertCreateSiteAuditLog(siteId, siteId, createdFiles);
                    this.insertAddRemoteAuditLog(siteId, remoteName);
                    this.processCreatedFiles(siteId, createdFiles, creator, now, lastCommitId);
                    this.contentRepositoryV2.insertGitLog(siteId, lastCommitId, 1, 1);
                    this.updateLastCommitId(siteId, lastCommitId);
                    this.updateLastVerifiedGitlogCommitId(siteId, lastCommitId);
                    this.updateLastSyncedGitlogCommitId(siteId, lastCommitId);
                    logger.info("Loading configuration for site " + siteId, new Object[0]);
                    this.reloadSiteConfiguration(siteId);
                }
                catch (Exception e) {
                    success = false;
                    logger.error("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId + ". Rolling back.", e, new Object[0]);
                    this.deleteSite(siteId);
                    throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + " from blueprint: " + blueprintId + ". Rolling back.");
                }
            }
        }
        if (success) {
            logger.info("Sync all content to preview for site " + siteId, new Object[0]);
            try {
                this.deploymentService.syncAllContentToPreview(siteId, true);
            }
            catch (ServiceLayerException e) {
                logger.error("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created otherwise. Ignoring.", e, new Object[0]);
                throw new SiteCreationException("Error while syncing site: " + siteId + " ID: " + siteId + " to preview. Site was successfully created, but it won't be preview-able until the Preview Deployer is reachable.");
            }
        } else {
            throw new SiteCreationException("Error while creating site: " + siteId + " ID: " + siteId + ".");
        }
        this.setSiteState(siteId, "CREATED");
        logger.info("Finished creating site " + siteId, new Object[0]);
    }

    @Override
    @ValidateParams
    public boolean deleteSite(@ValidateStringParam(name="siteId") String siteId) {
        boolean success = true;
        logger.debug("Deleting site:" + siteId, new Object[0]);
        try {
            this.enablePublishing(siteId, false);
        }
        catch (SiteNotFoundException e) {
            success = false;
            logger.error("Failed to stop publishing for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting Deployer targets", new Object[0]);
            this.deployer.deleteTargets(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the Deployer target for sites:" + siteId, e, new Object[0]);
        }
        try {
            success = success && this.destroySitePreviewContext(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to destroy the preview context for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting repo", new Object[0]);
            this.contentRepository.deleteSite(siteId);
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the repository for site:" + siteId, e, new Object[0]);
        }
        try {
            logger.debug("Deleting database records", new Object[0]);
            SiteFeed siteFeed = this.getSite(siteId);
            this.siteFeedMapper.deleteSite(siteId);
            this.dependencyService.deleteSiteDependencies(siteId);
            this.deploymentService.deleteDeploymentDataForSite(siteId);
            this.objectStateService.deleteObjectStatesForSite(siteId);
            this.objectMetadataManager.deleteObjectMetadataForSite(siteId);
            this.dmPageNavigationOrderService.deleteSequencesForSite(siteId);
            this.contentRepository.deleteGitLogForSite(siteId);
            this.contentRepository.removeRemoteRepositoriesForSite(siteId);
            this.auditServiceInternal.deleteAuditLogForSite(siteFeed.getId());
            this.insertDeleteSiteAuditLog(siteId, siteFeed.getName());
        }
        catch (Exception e) {
            success = false;
            logger.error("Failed to delete the database for site:" + siteId, e, new Object[0]);
        }
        return success;
    }

    private void insertDeleteSiteAuditLog(String siteId, String siteName) throws SiteNotFoundException {
        SiteFeed siteFeed = this.getSite(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"));
        String user = this.securityService.getCurrentUser();
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("DELETE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(siteId);
        auditLog.setPrimaryTargetType("Site");
        auditLog.setPrimaryTargetValue(siteName);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroySitePreviewContext(String site) {
        boolean toReturn = true;
        String requestUrl = this.getDestroySitePreviewContextUrl(site);
        HttpGet getRequest = new HttpGet(requestUrl);
        RequestConfig requestConfig = RequestConfig.custom().setExpectContinueEnabled(true).build();
        getRequest.setConfig(requestConfig);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)getRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                toReturn = false;
            }
        }
        catch (IOException e) {
            logger.error("Error while sending destroy preview context request for site " + site, e, new Object[0]);
            toReturn = false;
        }
        finally {
            getRequest.releaseConnection();
        }
        return toReturn;
    }

    private String getDestroySitePreviewContextUrl(String site) {
        String url = this.studioConfiguration.getProperty("studio.configuration.site.preview.destroy.context.url");
        url = url.replaceAll("\\{siteName\\}", site);
        return url;
    }

    @Override
    public SiteBlueprintTO[] getAvailableBlueprints() {
        RepositoryItem[] blueprintsFolders = this.contentRepository.getContentChildren("", this.studioConfiguration.getProperty("studio.repo.blueprintsPath"));
        ArrayList<SiteBlueprintTO> blueprints = new ArrayList<SiteBlueprintTO>();
        boolean idx = false;
        for (RepositoryItem folder : blueprintsFolders) {
            if (!folder.isFolder) continue;
            SiteBlueprintTO blueprintTO = new SiteBlueprintTO();
            blueprintTO.id = folder.name;
            blueprintTO.label = StringUtils.capitalize((String)folder.name);
            blueprintTO.description = "";
            blueprintTO.screenshots = null;
            blueprints.add(blueprintTO);
        }
        return blueprints.toArray(new SiteBlueprintTO[blueprints.size()]);
    }

    @Override
    public void reloadSiteConfigurations() {
        this.reloadGlobalConfiguration();
        Set<String> sites = this.getAllAvailableSites();
    }

    @Override
    @ValidateParams
    public void reloadSiteConfiguration(@ValidateStringParam(name="site") String site) {
        this.reloadSiteConfiguration(site, true);
    }

    @Override
    public void reloadSiteConfiguration(String site, boolean triggerEvent) {
        SiteTO siteConfig = new SiteTO();
        siteConfig.setSite(site);
        siteConfig.setEnvironment(this.getEnvironment());
        this.servicesConfig.reloadConfiguration(site);
        this.notificationService.reloadConfiguration(site);
        this.securityService.reloadConfiguration(site);
        this.contentTypeService.reloadConfiguration(site);
    }

    @Override
    public void reloadGlobalConfiguration() {
        this.securityService.reloadGlobalConfiguration();
    }

    @Override
    @ValidateParams
    public void syncRepository(@ValidateStringParam(name="site") String site) throws SiteNotFoundException {
        if (!this.exists(site)) {
            throw new SiteNotFoundException();
        }
        String lastDbCommitId = this.siteFeedMapper.getLastCommitId(site, this.studioClusterUtils.getClusterNodeLocalAddress());
        if (lastDbCommitId != null) {
            this.syncDatabaseWithRepository.execute(site, lastDbCommitId);
        } else {
            this.rebuildDatabase(site);
        }
    }

    @Override
    @ValidateParams
    public void rebuildDatabase(@ValidateStringParam(name="site") String site) {
        this.rebuildRepositoryMetadata.execute(site);
    }

    @Override
    @ValidateParams
    public void updateLastCommitId(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="commitId") String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("lastCommitId", commitId);
        this.retryingOperationFacade.updateSiteLastCommitId(params);
        try {
            ClusterMember clusterMember = this.clusterDao.getMemberByLocalAddress(this.studioClusterUtils.getClusterNodeLocalAddress());
            if (Objects.nonNull(clusterMember)) {
                SiteFeed siteFeed = this.getSite(site);
                this.retryingOperationFacade.updateClusterNodeLastCommitId(clusterMember.getId(), siteFeed.getId(), commitId);
            }
        }
        catch (SiteNotFoundException e) {
            logger.error("Site not found " + site, new Object[0]);
        }
    }

    @Override
    public void updateLastVerifiedGitlogCommitId(String site, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("commitId", commitId);
        this.retryingOperationFacade.updateSiteLastVerifiedGitlogCommitId(params);
        try {
            ClusterMember clusterMember = this.clusterDao.getMemberByLocalAddress(this.studioClusterUtils.getClusterNodeLocalAddress());
            if (Objects.nonNull(clusterMember)) {
                SiteFeed siteFeed = this.getSite(site);
                this.retryingOperationFacade.updateClusterNodeLastVerifiedGitlogCommitId(clusterMember.getId(), siteFeed.getId(), commitId);
            }
        }
        catch (SiteNotFoundException e) {
            logger.error("Site not found " + site, new Object[0]);
        }
    }

    @Override
    public void updateLastSyncedGitlogCommitId(String site, String commitId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("siteId", site);
        params.put("commitId", commitId);
        this.retryingOperationFacade.updateSiteLastSyncedGitlogCommitId(params);
        try {
            ClusterMember clusterMember = this.clusterDao.getMemberByLocalAddress(this.studioClusterUtils.getClusterNodeLocalAddress());
            if (Objects.nonNull(clusterMember)) {
                SiteFeed siteFeed = this.getSite(site);
                this.retryingOperationFacade.updateClusterNodeLastSyncedGitlogCommitId(clusterMember.getId(), siteFeed.getId(), commitId);
            }
        }
        catch (SiteNotFoundException e) {
            logger.error("Site not found " + site, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public boolean syncDatabaseWithRepoUnprocessedCommits(@ValidateStringParam(name="site") String site, List<GitLog> commitIds) throws IOException {
        boolean toReturn = true;
        String repoLastCommitId = this.contentRepository.getRepoLastCommitId(site);
        String scriptFilename = "repoOperations_" + UUID.randomUUID();
        Path scriptPath = Files.createTempFile(scriptFilename, ".sql", new FileAttribute[0]);
        boolean success = true;
        long startUpdateDBMark = 0L;
        ArrayList<String> cIds = new ArrayList<String>();
        for (GitLog gitLog : commitIds) {
            String commitId = gitLog.getCommitId();
            long startGetOperationsFromDeltaMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            List<RepoOperation> repoOperationsDelta = this.contentRepositoryV2.getOperationsFromDelta(site, commitId + "~1", commitId);
            if (logger.isDebugEnabled()) {
                logger.debug("Get Repo Operations from Delta finished in " + (System.currentTimeMillis() - startGetOperationsFromDeltaMark) + " milliseconds", new Object[0]);
                logger.debug("Number of Repo operations from delta " + repoOperationsDelta.size(), new Object[0]);
            }
            if (!CollectionUtils.isEmpty(repoOperationsDelta)) {
                logger.debug("Syncing database with repository for site: " + site + " commitId = " + commitId, new Object[0]);
                logger.debug("Operations to sync: ", new Object[0]);
                if (logger.isDebugEnabled()) {
                    for (RepoOperation repoOperation : repoOperationsDelta) {
                        logger.debug("\tOperation: " + repoOperation.getAction().toString() + " " + repoOperation.getPath(), new Object[0]);
                    }
                }
                startUpdateDBMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                success = this.processRepoOperations(site, repoOperationsDelta, scriptPath);
            }
            toReturn = toReturn && success;
        }
        StudioDBScriptRunner studioDBScriptRunner = this.studioDBScriptRunnerFactory.getDBScriptRunner();
        try {
            studioDBScriptRunner.openConnection();
            studioDBScriptRunner.execute(scriptPath.toFile());
        }
        finally {
            studioDBScriptRunner.closeConnection();
        }
        logger.debug("Done syncing operations with a result of: " + success, new Object[0]);
        logger.debug("Syncing database lastCommitId for site: " + site, new Object[0]);
        if (success) {
            this.contentRepositoryV2.markGitLogVerifiedProcessedBulk(site, cIds);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Update DB finished in " + (System.currentTimeMillis() - startUpdateDBMark) + " milliseconds", new Object[0]);
        }
        try {
            logger.debug("Sync preview for site " + site, new Object[0]);
            this.deploymentService.syncAllContentToPreview(site, false);
        }
        catch (ServiceLayerException e) {
            logger.error("Error synchronizing preview with repository for site: " + site, e, new Object[0]);
        }
        logger.info("Done syncing database with repository for site: " + site + " for unprocessed commits with a final result of: " + toReturn, new Object[0]);
        if (toReturn) {
            this.updateLastCommitId(site, repoLastCommitId);
            logger.info("Last commit ID for site: " + site + " is " + repoLastCommitId, new Object[0]);
        } else {
            logger.error("Some operations failed to sync to database for site: " + site + " see previous error logs", new Object[0]);
        }
        return toReturn;
    }

    @Override
    @ValidateParams
    public boolean syncDatabaseWithRepo(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="fromCommitId") String fromCommitId) throws SiteNotFoundException {
        return this.syncDatabaseWithRepo(site, fromCommitId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ValidateParams
    public boolean syncDatabaseWithRepo(@ValidateStringParam(name="site") String site, @ValidateStringParam(name="fromCommitId") String fromCommitId, boolean generateAuditLog) throws SiteNotFoundException {
        boolean toReturn = true;
        String repoLastCommitId = this.contentRepository.getRepoLastCommitId(site);
        long startGetOperationsFromDeltaMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        List<RepoOperation> repoOperationsDelta = this.contentRepositoryV2.getOperationsFromDelta(site, fromCommitId, repoLastCommitId);
        if (logger.isDebugEnabled()) {
            logger.debug("Get Repo Operations from Delta finished in " + (System.currentTimeMillis() - startGetOperationsFromDeltaMark) + " milliseconds", new Object[0]);
            logger.debug("Number of Repo operations from delta " + repoOperationsDelta.size(), new Object[0]);
        }
        if (CollectionUtils.isEmpty(repoOperationsDelta)) {
            logger.debug("Database is up to date with repository for site: " + site, new Object[0]);
            this.contentRepositoryV2.markGitLogVerifiedProcessed(site, fromCommitId);
            this.updateLastCommitId(site, repoLastCommitId);
            this.updateLastVerifiedGitlogCommitId(site, repoLastCommitId);
            return toReturn;
        }
        logger.info("Syncing database with repository for site: " + site + " fromCommitId = " + (StringUtils.isEmpty((CharSequence)fromCommitId) ? "Empty repo" : fromCommitId), new Object[0]);
        logger.debug("Operations to sync: ", new Object[0]);
        for (RepoOperation repoOperation : repoOperationsDelta) {
            logger.debug("\tOperation: " + repoOperation.getAction().toString() + " " + repoOperation.getPath(), new Object[0]);
        }
        long startUpdateDBMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        StudioDBScriptRunner studioDBScriptRunner = this.studioDBScriptRunnerFactory.getDBScriptRunner();
        try {
            studioDBScriptRunner.openConnection();
            String scriptFilename = "repoOperations_" + UUID.randomUUID();
            Path scriptPath = Files.createTempFile(scriptFilename, ".sql", new FileAttribute[0]);
            toReturn = this.processRepoOperations(site, repoOperationsDelta, scriptPath);
            studioDBScriptRunner.execute(scriptPath.toFile());
        }
        catch (IOException e) {
            logger.error("Error while creating db script file for processing created files for site " + site, new Object[0]);
        }
        finally {
            studioDBScriptRunner.closeConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Update DB finished in " + (System.currentTimeMillis() - startUpdateDBMark) + " milliseconds", new Object[0]);
        }
        logger.debug("Done syncing operations with a result of: " + toReturn, new Object[0]);
        logger.debug("Syncing database lastCommitId for site: " + site, new Object[0]);
        logger.debug("Update last commit id " + repoLastCommitId + " for site " + site, new Object[0]);
        this.updateLastCommitId(site, repoLastCommitId);
        this.updateLastVerifiedGitlogCommitId(site, repoLastCommitId);
        if (logger.isDebugEnabled()) {
            logger.debug("Update DB finished in " + (System.currentTimeMillis() - startUpdateDBMark) + " milliseconds", new Object[0]);
        }
        logger.info("Done syncing database with repository for site: " + site + " fromCommitId = " + (StringUtils.isEmpty((CharSequence)fromCommitId) ? "Empty repo" : fromCommitId) + " with a final result of: " + toReturn, new Object[0]);
        logger.info("Last commit ID for site: " + site + " is " + repoLastCommitId, new Object[0]);
        if (!toReturn) {
            logger.error("Some operations failed to sync to database for site: " + site + " see previous error logs", new Object[0]);
        }
        return toReturn;
    }

    private boolean processRepoOperations(String siteId, List<RepoOperation> repoOperations, Path file) throws IOException {
        boolean toReturn = true;
        long startProcessRepoOperationMark = logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        block6: for (RepoOperation repoOperation : repoOperations) {
            switch (repoOperation.getAction()) {
                case CREATE: 
                case COPY: {
                    Files.write(file, SqlStatementGeneratorUtils.upsertItemStateRow(siteId, repoOperation.getPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.upsertItemMetadataRow(siteId, repoOperation.getPath(), repoOperation.getAuthor(), repoOperation.getDateTime(), repoOperation.getCommitId()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    logger.debug("Extract dependencies for site: " + siteId + " path: " + repoOperation.getPath(), new Object[0]);
                    this.addDependenciesScriptSnippets(siteId, repoOperation.getPath(), null, file);
                    continue block6;
                }
                case UPDATE: {
                    Files.write(file, SqlStatementGeneratorUtils.transitionSaveItemStateRow(siteId, repoOperation.getPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.updateItemMetadataRow(siteId, repoOperation.getPath(), repoOperation.getAuthor(), repoOperation.getDateTime(), repoOperation.getCommitId()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    logger.debug("Extract dependencies for site: " + siteId + " path: " + repoOperation.getPath(), new Object[0]);
                    this.addDependenciesScriptSnippets(siteId, repoOperation.getPath(), null, file);
                    continue block6;
                }
                case DELETE: {
                    Files.write(file, SqlStatementGeneratorUtils.deleteItemStateRow(siteId, repoOperation.getPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.deleteItemMetadataRow(siteId, repoOperation.getPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.deleteDependencyRows(siteId, repoOperation.getPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    continue block6;
                }
                case MOVE: {
                    Files.write(file, SqlStatementGeneratorUtils.moveItemStateRow(siteId, repoOperation.getPath(), repoOperation.getMoveToPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.transitionSaveItemStateRow(siteId, repoOperation.getMoveToPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.moveItemMetadataRow(siteId, repoOperation.getPath(), repoOperation.getMoveToPath()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, SqlStatementGeneratorUtils.updateItemMetadataRow(siteId, repoOperation.getMoveToPath(), repoOperation.getAuthor(), repoOperation.getDateTime(), repoOperation.getCommitId()).getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    Files.write(file, "\n\n".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
                    this.addDependenciesScriptSnippets(siteId, repoOperation.getMoveToPath(), repoOperation.getPath(), file);
                    continue block6;
                }
            }
            logger.error("Error: Unknown repo operation for site " + siteId + " operation: " + (Object)((Object)repoOperation.getAction()), new Object[0]);
            toReturn = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Process Repo operations finished in " + (System.currentTimeMillis() - startProcessRepoOperationMark) + " milliseconds", new Object[0]);
        }
        return toReturn;
    }

    @Override
    @ValidateParams
    public boolean exists(@ValidateStringParam(name="site") String site) {
        return this.siteFeedMapper.exists(site) > 0;
    }

    @Override
    @ValidateParams
    public boolean existsById(@ValidateStringParam(name="siteId") String siteId) {
        return this.siteFeedMapper.existsById(siteId) > 0;
    }

    @Override
    @ValidateParams
    public boolean existsByName(@ValidateStringParam(name="siteName") String siteName) {
        return this.siteFeedMapper.existsByName(siteName) > 0;
    }

    @Override
    @ValidateParams
    public int getSitesPerUserTotal() throws UserNotFoundException, ServiceLayerException {
        return this.getSitesPerUserTotal(this.securityService.getCurrentUser());
    }

    @Override
    @ValidateParams
    public int getSitesPerUserTotal(@ValidateStringParam(name="username") String username) throws UserNotFoundException, ServiceLayerException {
        if (this.securityService.userExists(username)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("username", username);
            return this.siteFeedMapper.getSitesPerUserQueryTotal(params);
        }
        throw new UserNotFoundException();
    }

    @Override
    @ValidateParams
    public List<SiteFeed> getSitesPerUser(@ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws UserNotFoundException, ServiceLayerException {
        return this.getSitesPerUser(this.securityService.getCurrentUser(), start, number);
    }

    @Override
    @ValidateParams
    public List<SiteFeed> getSitesPerUser(@ValidateStringParam(name="username") String username, @ValidateIntegerParam(name="start") int start, @ValidateIntegerParam(name="number") int number) throws UserNotFoundException, ServiceLayerException {
        if (this.securityService.userExists(username)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("username", username);
            params.put("start", start);
            params.put("number", number);
            List<String> siteIds = this.siteFeedMapper.getSitesPerUserQuery(params);
            List<SiteFeed> toRet = new ArrayList<SiteFeed>();
            if (siteIds != null && !siteIds.isEmpty()) {
                params = new HashMap();
                params.put("siteids", siteIds);
                toRet = this.siteFeedMapper.getSitesPerUserData(params);
            }
            return toRet;
        }
        throw new UserNotFoundException();
    }

    @Override
    @ValidateParams
    public SiteFeed getSite(@ValidateStringParam(name="siteId") String siteId) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("siteId", siteId);
            return this.siteFeedMapper.getSite(params);
        }
        throw new SiteNotFoundException();
    }

    @Override
    @ValidateParams
    public boolean isPublishingEnabled(@ValidateStringParam(name="siteId") String siteId) {
        try {
            SiteFeed siteFeed = this.getSite(siteId);
            return siteFeed.getPublishingEnabled() > 0;
        }
        catch (SiteNotFoundException e) {
            logger.debug("Site " + siteId + " not found. Publishing disabled", new Object[0]);
            return false;
        }
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public boolean enablePublishing(@ValidateStringParam(name="siteId") String siteId, boolean enabled) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("siteId", siteId);
            params.put("enabled", enabled ? 1 : 0);
            this.siteFeedMapper.enablePublishing(params);
            return true;
        }
        throw new SiteNotFoundException();
    }

    @Override
    @RetryingOperation
    @ValidateParams
    public boolean updatePublishingStatusMessage(@ValidateStringParam(name="siteId") String siteId, @ValidateStringParam(name="status") String status, @ValidateStringParam(name="message") String message) throws SiteNotFoundException {
        if (this.exists(siteId)) {
            this.siteFeedMapper.updatePublishingStatusMessage(siteId, status, message);
            return true;
        }
        throw new SiteNotFoundException();
    }

    @Override
    public boolean addRemote(String siteId, String remoteName, String remoteUrl, String authenticationType, String remoteUsername, String remotePassword, String remoteToken, String remotePrivateKey) throws InvalidRemoteUrlException, ServiceLayerException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        boolean toRet = this.contentRepository.addRemote(siteId, remoteName, remoteUrl, authenticationType, remoteUsername, remotePassword, remoteToken, remotePrivateKey);
        this.insertAddRemoteAuditLog(siteId, remoteName);
        return toRet;
    }

    private void insertAddRemoteAuditLog(String siteId, String remoteName) throws SiteNotFoundException {
        SiteFeed siteFeed = this.getSite(siteId);
        String user = this.securityService.getCurrentUser();
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("ADD_REMOTE");
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setActorId(user);
        auditLog.setPrimaryTargetId(remoteName);
        auditLog.setPrimaryTargetType("Remote Repository");
        auditLog.setPrimaryTargetValue(remoteName);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    public boolean removeRemote(String siteId, String remoteName) throws SiteNotFoundException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        boolean toRet = this.contentRepositoryV2.removeRemote(siteId, remoteName);
        this.insertRemoveRemoteAuditLog(siteId, remoteName);
        return toRet;
    }

    private void insertRemoveRemoteAuditLog(String siteId, String remoteName) throws SiteNotFoundException {
        SiteFeed siteFeed = this.getSite(siteId);
        String user = this.securityService.getCurrentUser();
        AuditLog auditLog = this.auditServiceInternal.createAuditLogEntry();
        auditLog.setOperation("REMOVE_REMOTE");
        auditLog.setActorId(user);
        auditLog.setSiteId(siteFeed.getId());
        auditLog.setPrimaryTargetId(remoteName);
        auditLog.setPrimaryTargetType("Remote Repository");
        auditLog.setPrimaryTargetValue(remoteName);
        this.auditServiceInternal.insertAuditLog(auditLog);
    }

    @Override
    public List<RemoteRepositoryInfoTO> listRemote(String siteId) throws ServiceLayerException, CryptoException {
        if (!this.exists(siteId)) {
            throw new SiteNotFoundException();
        }
        SiteFeed siteFeed = this.getSite(siteId);
        return this.contentRepository.listRemote(siteId, siteFeed.getSandboxBranch());
    }

    @Override
    public List<SiteFeed> getDeletedSites() {
        return this.siteFeedMapper.getDeletedSites();
    }

    private void addSiteUuidFile(String site, String siteUuid) throws IOException {
        Path path = Paths.get(this.studioConfiguration.getProperty("studio.repo.basePath"), this.studioConfiguration.getProperty("studio.repo.sitesRepoBasePath"), site, "site-uuid.txt");
        String toWrite = "# THIS IS A SYSTEM FILE. PLEASE DO NOT EDIT NOR DELETE IT!!!\n" + siteUuid;
        Files.write(path, toWrite.getBytes(), new OpenOption[0]);
    }

    @Override
    @RetryingOperation
    public boolean tryLockPublishingForSite(String siteId, String lockOwnerId, int ttl) {
        logger.debug("Locking publishing for site " + siteId + " with lock owner " + lockOwnerId, new Object[0]);
        int result = this.siteFeedMapper.tryLockPublishingForSite(siteId, lockOwnerId, ttl);
        if (result == 1) {
            logger.debug("Locked publishing for site " + siteId + " with lock owner " + lockOwnerId, new Object[0]);
        } else {
            logger.debug("Failed to publishing for site " + siteId + " with lock owner " + lockOwnerId, new Object[0]);
        }
        return result == 1;
    }

    @Override
    @RetryingOperation
    public boolean unlockPublishingForSite(String siteId, String lockOwnerId) {
        logger.debug("Unlocking publishing for site " + siteId + " lock owner " + lockOwnerId, new Object[0]);
        this.siteFeedMapper.unlockPublishingForSite(siteId, lockOwnerId);
        return true;
    }

    @Override
    @RetryingOperation
    public void updatePublishingLockHeartbeatForSite(String siteId) {
        logger.debug("Update publishing lock heartbeat for site " + siteId, new Object[0]);
        this.siteFeedMapper.updatePublishingLockHeartbeatForSite(siteId);
    }

    @Override
    public String getLastCommitId(String siteId) {
        return this.siteFeedMapper.getLastCommitId(siteId, this.studioClusterUtils.getClusterNodeLocalAddress());
    }

    @Override
    public String getLastVerifiedGitlogCommitId(String siteId) {
        return this.siteFeedMapper.getLastVerifiedGitlogCommitId(siteId, this.studioClusterUtils.getClusterNodeLocalAddress());
    }

    @Override
    public List<String> getAllCreatedSites() {
        return this.siteFeedMapper.getAllCreatedSites("CREATED");
    }

    @Override
    public void setSiteState(String siteId, String state) {
        this.siteFeedMapper.setSiteState(siteId, state);
        try {
            ClusterMember clusterMember = this.clusterDao.getMemberByLocalAddress(this.studioClusterUtils.getClusterNodeLocalAddress());
            if (Objects.nonNull(clusterMember)) {
                SiteFeed siteFeed = this.getSite(siteId);
                this.clusterDao.setSiteState(clusterMember.getId(), siteFeed.getId(), state);
            }
        }
        catch (SiteNotFoundException e) {
            logger.error("Site not found " + siteId, new Object[0]);
        }
    }

    @Override
    public String getSiteState(String siteId) {
        return this.siteFeedMapper.getSiteState(siteId, this.studioClusterUtils.getClusterNodeLocalAddress());
    }

    @Override
    public boolean isPublishedRepoCreated(String siteId) {
        return this.siteFeedMapper.getPublishedRepoCreated(siteId, this.studioClusterUtils.getClusterNodeLocalAddress()) > 0;
    }

    @Override
    public void setPublishedRepoCreated(String siteId) {
        this.siteFeedMapper.setPublishedRepoCreated(siteId);
        try {
            ClusterMember clusterMember = this.clusterDao.getMemberByLocalAddress(this.studioClusterUtils.getClusterNodeLocalAddress());
            if (Objects.nonNull(clusterMember)) {
                SiteFeed siteFeed = this.getSite(siteId);
                this.clusterDao.setPublishedRepoCreated(clusterMember.getId(), siteFeed.getId());
            }
        }
        catch (SiteNotFoundException e) {
            logger.error("Site not found " + siteId, new Object[0]);
        }
    }

    @Override
    public String getLastSyncedGitlogCommitId(String siteId) {
        return this.siteFeedMapper.getLastSyncedGitlogCommitId(siteId, this.studioClusterUtils.getClusterNodeLocalAddress());
    }

    public String getGlobalConfigRoot() {
        return this.studioConfiguration.getProperty("studio.configuration.global.configBasePath");
    }

    public String getSitesConfigPath() {
        return this.studioConfiguration.getProperty("studio.configuration.site.configBasePath");
    }

    public String getEnvironment() {
        return this.studioConfiguration.getProperty("studio.configuration.environment.active");
    }

    public List<String> getDefaultGroups() {
        return Arrays.asList(this.studioConfiguration.getProperty("studio.configuration.defaultGroups").split(","));
    }

    public SiteServiceDAL getSiteService() {
        return this._siteServiceDAL;
    }

    public void setSiteServiceDAL(SiteServiceDAL service) {
        this._siteServiceDAL = service;
    }

    public ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public void setServicesConfig(ServicesConfig servicesConfig) {
        this.servicesConfig = servicesConfig;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public org.craftercms.studio.api.v1.repository.ContentRepository getContenetRepository() {
        return this.contentRepository;
    }

    public void setContentRepository(org.craftercms.studio.api.v1.repository.ContentRepository repo) {
        this.contentRepository = repo;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public ObjectMetadataManager getObjectMetadataManager() {
        return this.objectMetadataManager;
    }

    public void setObjectMetadataManager(ObjectMetadataManager objectMetadataManager) {
        this.objectMetadataManager = objectMetadataManager;
    }

    public DmPageNavigationOrderService getDmPageNavigationOrderService() {
        return this.dmPageNavigationOrderService;
    }

    public void setDmPageNavigationOrderService(DmPageNavigationOrderService dmPageNavigationOrderService) {
        this.dmPageNavigationOrderService = dmPageNavigationOrderService;
    }

    public ContentTypeService getContentTypeService() {
        return this.contentTypeService;
    }

    public void setContentTypeService(ContentTypeService contentTypeService) {
        this.contentTypeService = contentTypeService;
    }

    public ImportService getImportService() {
        return this.importService;
    }

    public void setImportService(ImportService importService) {
        this.importService = importService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public GeneralLockService getGeneralLockService() {
        return this.generalLockService;
    }

    public void setGeneralLockService(GeneralLockService generalLockService) {
        this.generalLockService = generalLockService;
    }

    public RebuildRepositoryMetadata getRebuildRepositoryMetadata() {
        return this.rebuildRepositoryMetadata;
    }

    public void setRebuildRepositoryMetadata(RebuildRepositoryMetadata rebuildRepositoryMetadata) {
        this.rebuildRepositoryMetadata = rebuildRepositoryMetadata;
    }

    public SyncDatabaseWithRepository getSyncDatabaseWithRepository() {
        return this.syncDatabaseWithRepository;
    }

    public void setSyncDatabaseWithRepository(SyncDatabaseWithRepository syncDatabaseWithRepository) {
        this.syncDatabaseWithRepository = syncDatabaseWithRepository;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }

    public GroupServiceInternal getGroupServiceInternal() {
        return this.groupServiceInternal;
    }

    public void setGroupServiceInternal(GroupServiceInternal groupServiceInternal) {
        this.groupServiceInternal = groupServiceInternal;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public SitesServiceInternal getSitesServiceInternal() {
        return this.sitesServiceInternal;
    }

    public void setSitesServiceInternal(SitesServiceInternal sitesServiceInternal) {
        this.sitesServiceInternal = sitesServiceInternal;
    }

    public AuditServiceInternal getAuditServiceInternal() {
        return this.auditServiceInternal;
    }

    public void setAuditServiceInternal(AuditServiceInternal auditServiceInternal) {
        this.auditServiceInternal = auditServiceInternal;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ContentRepository getContentRepositoryV2() {
        return this.contentRepositoryV2;
    }

    public void setContentRepositoryV2(ContentRepository contentRepositoryV2) {
        this.contentRepositoryV2 = contentRepositoryV2;
    }

    public StudioClusterUtils getStudioClusterUtils() {
        return this.studioClusterUtils;
    }

    public void setStudioClusterUtils(StudioClusterUtils studioClusterUtils) {
        this.studioClusterUtils = studioClusterUtils;
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDao) {
        this.clusterDao = clusterDao;
    }

    public StudioDBScriptRunnerFactory getStudioDBScriptRunner() {
        return this.studioDBScriptRunnerFactory;
    }

    public void setStudioDBScriptRunner(StudioDBScriptRunnerFactory studioDBScriptRunnerFactory) {
        this.studioDBScriptRunnerFactory = studioDBScriptRunnerFactory;
    }

    public DependencyServiceInternal getDependencyServiceInternal() {
        return this.dependencyServiceInternal;
    }

    public void setDependencyServiceInternal(DependencyServiceInternal dependencyServiceInternal) {
        this.dependencyServiceInternal = dependencyServiceInternal;
    }

    public RetryingOperationFacade getRetryingOperationFacade() {
        return this.retryingOperationFacade;
    }

    public void setRetryingOperationFacade(RetryingOperationFacade retryingOperationFacade) {
        this.retryingOperationFacade = retryingOperationFacade;
    }
}

