/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.profiles.webdav.WebDavProfile;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.studio.api.v1.exception.WebDavException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.webdav.WebDavService;
import org.craftercms.studio.api.v1.webdav.WebDavItem;
import org.craftercms.studio.impl.v1.util.config.profiles.SiteAwareConfigProfileLoader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.MimeType;
import org.springframework.web.util.UriUtils;

@Deprecated
public class WebDavServiceImpl
implements WebDavService {
    private static final Logger logger = LoggerFactory.getLogger(WebDavServiceImpl.class);
    public static final String PROPERTY_DISPLAY_NAME = "displayname";
    public static final String PROPERTY_CONTENT_TYPE = "getcontenttype";
    public static final String PROPERTY_RESOURCE_TYPE = "resourcetype";
    public static final String FILTER_ALL_ITEMS = "item";
    protected SiteAwareConfigProfileLoader<WebDavProfile> profileLoader;
    protected Charset charset = Charset.defaultCharset();
    protected Set<QName> properties = new HashSet<QName>();

    public WebDavServiceImpl() {
        this.properties.add(new QName("DAV:", PROPERTY_DISPLAY_NAME, "d"));
        this.properties.add(new QName("DAV:", PROPERTY_CONTENT_TYPE, "d"));
        this.properties.add(new QName("DAV:", PROPERTY_RESOURCE_TYPE, "d"));
    }

    @Required
    public void setProfileLoader(SiteAwareConfigProfileLoader<WebDavProfile> profileLoader) {
        this.profileLoader = profileLoader;
    }

    protected WebDavProfile getProfile(String site, String profileId) throws WebDavException {
        try {
            return this.profileLoader.loadProfile(site, profileId);
        }
        catch (ConfigurationException e) {
            throw new WebDavException("Unable to load WebDav profile", (Exception)((Object)e));
        }
    }

    @Override
    public List<WebDavItem> list(@ValidateStringParam(name="site_id") String site, @ValidateStringParam(name="profile") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="type") String type) throws WebDavException {
        WebDavProfile profile = this.getProfile(site, profileId);
        String listPath = StringUtils.appendIfMissing((String)profile.getBaseUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        Sardine sardine = SardineFactory.begin((String)profile.getUsername(), (String)profile.getPassword());
        try {
            MimeType filterType = StringUtils.isEmpty((CharSequence)type) || type.equals(FILTER_ALL_ITEMS) ? MimeType.valueOf((String)"*/*") : new MimeType(type);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                String[] tokens;
                for (String token : tokens = StringUtils.split((String)path, (String)"/")) {
                    if (!StringUtils.isNotEmpty((CharSequence)token)) continue;
                    listPath = listPath + StringUtils.appendIfMissing((String)UriUtils.encode((String)token, (String)this.charset.name()), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                }
            }
            if (!sardine.exists(listPath)) {
                logger.debug("Folder {0} doesn't exist", listPath);
                return Collections.emptyList();
            }
            String basePath = new URL(profile.getBaseUrl()).getPath();
            String baseDomain = profile.getBaseUrl();
            String deliveryUrl = profile.getDeliveryBaseUrl();
            logger.debug("Listing resources at {0}", listPath);
            List resources = sardine.propfind(listPath, 1, this.properties);
            logger.debug("Found {0} resources at {0}", resources.size(), listPath);
            return resources.stream().skip(1L).filter(r -> r.isDirectory() || filterType.includes(MimeType.valueOf((String)r.getContentType()))).map(r -> new WebDavItem(this.getName((DavResource)r), this.getUrl((DavResource)r, baseDomain, deliveryUrl, basePath), r.isDirectory())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new WebDavException("Error listing resources", e);
        }
    }

    protected String getUrl(DavResource resource, String baseUrl, String deliveryUrl, String basePath) {
        String relativePath = StringUtils.removeFirst((String)resource.getPath(), (String)basePath);
        if (resource.isDirectory()) {
            return baseUrl + relativePath;
        }
        return (StringUtils.isNotEmpty((CharSequence)deliveryUrl) ? deliveryUrl : baseUrl) + relativePath;
    }

    protected String getName(DavResource resource) {
        if (StringUtils.isNotEmpty((CharSequence)resource.getDisplayName())) {
            return resource.getDisplayName();
        }
        String path = resource.getPath();
        if (resource.isDirectory()) {
            path = StringUtils.removeEnd((String)path, (String)"/");
        }
        return StringUtils.substringAfterLast((String)path, (String)"/");
    }

    @Override
    public String upload(@ValidateStringParam(name="site_id") String site, @ValidateStringParam(name="profile") String profileId, @ValidateStringParam(name="path") String path, @ValidateStringParam(name="filename") String filename, InputStream content) throws WebDavException {
        WebDavProfile profile = this.getProfile(site, profileId);
        String uploadUrl = StringUtils.appendIfMissing((String)profile.getBaseUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        try {
            Sardine sardine = SardineFactory.begin((String)profile.getUsername(), (String)profile.getPassword());
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                String[] folders;
                for (String folder : folders = StringUtils.split((String)path, (String)"/")) {
                    uploadUrl = uploadUrl + StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                    logger.debug("Checking folder {0}", uploadUrl);
                    if (!sardine.exists(uploadUrl)) {
                        logger.debug("Creating folder {0}", uploadUrl);
                        sardine.createDirectory(uploadUrl);
                        logger.debug("Folder {0} created", uploadUrl);
                        continue;
                    }
                    logger.debug("Folder {0} already exists", uploadUrl);
                }
            }
            uploadUrl = StringUtils.appendIfMissing((String)uploadUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            String fileUrl = uploadUrl + UriUtils.encode((String)filename, (String)this.charset.name());
            logger.debug("Starting upload of file {0}", filename);
            logger.debug("Uploading file to {0}", fileUrl);
            sardine.put(fileUrl, content);
            logger.debug("Upload complete for file {0}", fileUrl);
            if (StringUtils.isNotEmpty((CharSequence)profile.getDeliveryBaseUrl())) {
                fileUrl = StringUtils.replaceFirst((String)fileUrl, (String)profile.getBaseUrl(), (String)profile.getDeliveryBaseUrl());
            }
            return fileUrl;
        }
        catch (Exception e) {
            throw new WebDavException("Error uploading file", e);
        }
    }
}

