/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.service.workflow;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.service.deployment.DmPublishService;
import org.craftercms.studio.api.v1.service.objectstate.ObjectStateService;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.workflow.WorkflowService;
import org.craftercms.studio.api.v1.service.workflow.context.MultiChannelPublishingContext;
import org.craftercms.studio.impl.v1.service.workflow.WorkflowBatch;
import org.craftercms.studio.impl.v1.service.workflow.operation.SubmitLifeCycleOperation;

public class WorkflowProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowProcessor.class);
    protected static final int PRIORITY = 3;
    protected Set<String> inflightItems = new HashSet<String>();
    protected WorkflowService workflowService;
    protected ContentService contentService;
    protected ObjectStateService objectStateService;
    protected DmPublishService dmPublishService;
    protected SecurityService securityService;

    public synchronized boolean isInFlight(String path) {
        return this.inflightItems.contains(path);
    }

    public synchronized void addToWorkflow(String site, List<String> paths, ZonedDateTime launchDate, String label, SubmitLifeCycleOperation operation, String approvedBy, MultiChannelPublishingContext mcpContext) {
        this.inflightItems.addAll(paths);
        WorkflowBatch workflowBatch = this.createBatch(paths, launchDate, label, operation, approvedBy, mcpContext);
        this.execute(site, workflowBatch);
    }

    protected WorkflowBatch createBatch(Collection<String> paths, ZonedDateTime launchDate, String label, SubmitLifeCycleOperation preSubmitOperation, String approvedBy, MultiChannelPublishingContext mcpContext) {
        WorkflowBatch batch = new WorkflowBatch(launchDate, label, approvedBy, mcpContext);
        batch.add(paths);
        batch.addOperation(preSubmitOperation);
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String site, WorkflowBatch workflowBatch) {
        String currentUser = this.securityService.getCurrentUser();
        logger.debug("[WORKFLOW] executing Go Live Processor for " + site, new Object[0]);
        try {
            try {
                List<SubmitLifeCycleOperation> preSubmitOperations = workflowBatch.getPreSubmitOperations();
                for (SubmitLifeCycleOperation preSubmitOperation : preSubmitOperations) {
                    preSubmitOperation.execute();
                }
                logger.debug("[WORKFLOW] submitting " + workflowBatch.getPaths() + " to workflow", new Object[0]);
                if (!workflowBatch.getPaths().isEmpty()) {
                    this.dmPublishService.publish(site, new ArrayList<String>(workflowBatch.getPaths()), workflowBatch.getLaunchDate(), workflowBatch.getMultiChannelPublishingContext());
                }
            }
            finally {
                this.inflightItems.removeAll(workflowBatch.getPaths());
            }
        }
        catch (Exception e) {
            this.inflightItems.removeAll(workflowBatch.getPaths());
            logger.debug("Rolling Back states of " + workflowBatch.getPaths(), new Object[0]);
            this.rollbackOnError(site, workflowBatch.getPaths());
            logger.error("[WORKFLOW] Error submitting workflow", e, new Object[0]);
        }
        logger.debug("[WORKFLOW] exiting Go Live Processor for " + site, new Object[0]);
    }

    private void rollbackOnError(String site, Set<String> allPaths) {
        for (String relativePath : allPaths) {
            try {
                if (!this.contentService.contentExists(site, relativePath)) continue;
                this.objectStateService.setSystemProcessing(site, relativePath, false);
            }
            catch (Exception ex) {
                logger.error("Unable to rollback site " + site + " path " + relativePath, ex, new Object[0]);
            }
        }
    }

    public void removeInFlightItem(String path) {
        this.inflightItems.remove(path);
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public ObjectStateService getObjectStateService() {
        return this.objectStateService;
    }

    public void setObjectStateService(ObjectStateService objectStateService) {
        this.objectStateService = objectStateService;
    }

    public DmPublishService getDmPublishService() {
        return this.dmPublishService;
    }

    public void setDmPublishService(DmPublishService dmPublishService) {
        this.dmPublishService = dmPublishService;
    }
}

