/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.impl.v1.util.XmlUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ContentUtils {
    private static final Logger logger = LoggerFactory.getLogger(ContentUtils.class);

    public static void release(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to release a resource.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void release(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to relase a resource.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public static void release(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.error("Failed to release a reader.", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document convertStreamToXml(InputStream is) throws DocumentException {
        InputStreamReader isReader = null;
        try {
            isReader = new InputStreamReader(is, "UTF-8");
            SAXReader saxReader = new SAXReader();
            try {
                saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                saxReader.setMergeAdjacentText(true);
            }
            catch (SAXException ex) {
                logger.error("Unable to turn off external entity loading, This could be a security risk.", ex, new Object[0]);
            }
            Document document = saxReader.read((Reader)isReader);
            return document;
        }
        catch (DocumentException e) {
            logger.error("Error while coverting stream to XML", (Exception)((Object)e), new Object[0]);
            Document document = null;
            return document;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error while coverting stream to XML", e, new Object[0]);
            Document document = null;
            return document;
        }
        finally {
            ContentUtils.release(is);
            ContentUtils.release(isReader);
        }
    }

    public static boolean matchesPatterns(String uri, List<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!uri.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getParentUrl(String url) {
        int lastIndex = url.lastIndexOf("/");
        return url.substring(0, lastIndex);
    }

    public static String getPageName(String url) {
        int lastIndex = url.lastIndexOf("/");
        return url.substring(lastIndex + 1);
    }

    public static InputStream convertDocumentToStream(Document document, String encoding) {
        try {
            return new ByteArrayInputStream(XmlUtils.convertDocumentToString(document).getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to convert document to stream with encoding: " + encoding, e, new Object[0]);
            return null;
        }
        catch (IOException e) {
            logger.error("Failed to convert document to stream with encoding: " + encoding, e, new Object[0]);
            return null;
        }
    }
}

