/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util;

import java.util.List;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.craftercms.studio.api.v1.to.ContentItemTO;
import org.craftercms.studio.api.v1.util.DmContentItemComparator;
import org.craftercms.studio.impl.v1.util.ContentUtils;

public class GoLiveQueueOrganizer {
    protected static final Logger logger = LoggerFactory.getLogger(GoLiveQueueOrganizer.class);
    protected ContentService contentService;
    protected ContentItemTO.ChildFilter childFilter;

    public GoLiveQueueOrganizer(ContentService contentService, ContentItemTO.ChildFilter childFilter) {
        this.contentService = contentService;
        this.childFilter = childFilter;
    }

    public void addToGoLiveItems(String site, ContentItemTO node, List<ContentItemTO> categoryItems, DmContentItemComparator comparator, boolean includeInProgress, List<String> displayPatterns) throws ServiceLayerException {
        if (ContentUtils.matchesPatterns(node.getUri(), displayPatterns)) {
            this._addToCategoryList(categoryItems, site, node, includeInProgress, comparator);
        }
    }

    protected void _addToCategoryList(List<ContentItemTO> categoryItems, String site, ContentItemTO node, boolean includeInProgress, DmContentItemComparator comparator) {
        this.addThis(categoryItems, comparator, node, includeInProgress);
    }

    protected void addThis(List<ContentItemTO> categoryItems, DmContentItemComparator comparator, ContentItemTO itemToAdd, boolean includeInProgress) {
        boolean include;
        boolean bl = include = itemToAdd.isSubmitted() || itemToAdd.isSubmittedForDeletion();
        if (includeInProgress) {
            boolean bl2 = include = include || itemToAdd.isInProgress();
        }
        if (!include) {
            return;
        }
        ContentItemTO found = null;
        String uri = itemToAdd.getUri();
        for (ContentItemTO categoryItem : categoryItems) {
            String categoryPath = categoryItem.getPath() + "/";
            if (!uri.startsWith(categoryPath)) continue;
            found = categoryItem;
            break;
        }
        if (found != null && !found.getUri().equals(itemToAdd.getUri())) {
            found.addChild(itemToAdd, comparator, true, this.childFilter);
        }
    }
}

