/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util.config.profiles;

import java.io.IOException;
import java.io.InputStream;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.ConfigurationMapper;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.commons.config.profiles.ConfigurationProfile;
import org.craftercms.studio.api.v1.service.content.ContentService;
import org.springframework.beans.factory.annotation.Required;

public class SiteAwareConfigProfileLoader<T extends ConfigurationProfile> {
    private String profilesModule;
    private String profilesPath;
    private ConfigurationMapper<T> profileMapper;
    private ContentService contentService;

    @Required
    public void setProfilesModule(String profilesModule) {
        this.profilesModule = profilesModule;
    }

    @Required
    public void setProfilesPath(String profilesPath) {
        this.profilesPath = profilesPath;
    }

    @Required
    public void setProfileMapper(ConfigurationMapper<T> profileMapper) {
        this.profileMapper = profileMapper;
    }

    @Required
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T loadProfile(String site, String profileId) throws ConfigurationException {
        try (InputStream is = this.contentService.getContent(site, this.profilesPath);){
            ConfigurationProfile configurationProfile = (ConfigurationProfile)this.profileMapper.readConfig((ConfigurationProvider)new ConfigurationProviderImpl(site), this.profilesModule, this.profilesPath, null, profileId);
            return (T)configurationProfile;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while loading profile " + profileId + " from configuration at " + this.profilesPath, (Throwable)e);
        }
    }

    private class ConfigurationProviderImpl
    implements ConfigurationProvider {
        private String site;

        public ConfigurationProviderImpl(String site) {
            this.site = site;
        }

        public boolean configExists(String path) {
            return SiteAwareConfigProfileLoader.this.contentService.contentExists(this.site, path);
        }

        public InputStream getConfig(String path) throws IOException {
            try {
                return SiteAwareConfigProfileLoader.this.contentService.getContent(this.site, path);
            }
            catch (Exception e) {
                throw new IOException("Error reading file", e);
            }
        }
    }
}

