/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.util.spring.mvc;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.view.AbstractView;

public class BinaryView
extends AbstractView {
    public static final String DEFAULT_CONTENT_STREAM_MODEL_ATTR_NAME = "contentStream";
    public static final String DEFAULT_CONTENT_PATH_MODEL_ATTR_NAME = "contentPath";
    public static final String DEFAULT_CONTENT_TYPE = "image/png";
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final String PRAGMA_HEADER_NAME = "Pragma";
    public static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String EXPIRES_HEADER_NAME = "Expires";
    public static final String DISABLED_CACHING_PRAGMA_HEADER_VALUE = "no-cache";
    public static final String DISABLED_CACHING_CACHE_CONTROL_HEADER_VALUE = "no-cache, no-store, max-age=0";
    public static final long DISABLED_CACHING_EXPIRES_HEADER_VALUE = 1L;
    private boolean disableCaching;

    public BinaryView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getContentType());
        response.setCharacterEncoding(DEFAULT_CHARACTER_ENCODING);
        if (this.disableCaching) {
            response.addHeader(PRAGMA_HEADER_NAME, DISABLED_CACHING_PRAGMA_HEADER_VALUE);
            response.addHeader(CACHE_CONTROL_HEADER_NAME, DISABLED_CACHING_CACHE_CONTROL_HEADER_VALUE);
            response.addDateHeader(EXPIRES_HEADER_NAME, 1L);
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletOutputStream out = response.getOutputStream();
        Map responseModelMap = (Map)model.get("responseBody");
        if (responseModelMap != null) {
            InputStream contentStream = (InputStream)responseModelMap.get(DEFAULT_CONTENT_STREAM_MODEL_ATTR_NAME);
            String contentPath = (String)responseModelMap.get(DEFAULT_CONTENT_PATH_MODEL_ATTR_NAME);
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            String contentType = mimetypesFileTypeMap.getContentType(contentPath);
            response.setContentType(contentType);
            if (contentStream != null) {
                IOUtils.write((byte[])IOUtils.toByteArray((InputStream)contentStream), (OutputStream)out);
            }
            out.flush();
            IOUtils.closeQuietly((InputStream)contentStream);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

