/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;

public class MultiReadHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private ByteArrayOutputStream cachedBytes;
    private Map<String, String[]> parameterMap;

    public MultiReadHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public static void toMap(Iterable<NameValuePair> inputParams, Map<String, String[]> toMap) {
        for (NameValuePair e : inputParams) {
            String key = e.getName();
            String value = e.getValue();
            if (toMap.containsKey(key)) {
                String[] newValue = (String[])ArrayUtils.addAll((Object[])toMap.get(key), (Object[])new String[]{value});
                toMap.remove(key);
                toMap.put(key, newValue);
                continue;
            }
            toMap.put(key, new String[]{value});
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String encoding = this.getRequest().getCharacterEncoding();
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = Charset.defaultCharset().name();
        }
        if (this.cachedBytes == null) {
            this.cacheInputStream(encoding);
        }
        return new CachedServletInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void cacheInputStream(String encoding) throws IOException {
        this.cachedBytes = new ByteArrayOutputStream();
        IOUtils.copy((Reader)new InputStreamReader((InputStream)super.getInputStream()), (OutputStream)this.cachedBytes, (String)encoding);
    }

    public String getParameter(String key) {
        Map<String, String[]> parameterMap = this.getParameterMap();
        String[] values = parameterMap.get(key);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public String[] getParameterValues(String key) {
        Map<String, String[]> parameterMap = this.getParameterMap();
        return parameterMap.get(key);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
            this.decode(this.getQueryString(), result);
            String encoding = this.getRequest().getCharacterEncoding();
            if (StringUtils.isEmpty((CharSequence)encoding)) {
                encoding = Charset.defaultCharset().name();
            }
            this.decode(this.getPostBodyAsString(encoding), result);
            this.parameterMap = Collections.unmodifiableMap(result);
        }
        return this.parameterMap;
    }

    private void decode(String queryString, Map<String, String[]> result) {
        if (queryString != null) {
            MultiReadHttpServletRequestWrapper.toMap(this.decodeParams(queryString), result);
        }
    }

    private Iterable<NameValuePair> decodeParams(String body) {
        String encoding = this.getRequest().getCharacterEncoding();
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = Charset.defaultCharset().name();
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(URLEncodedUtils.parse((String)body, (Charset)Charset.forName(encoding)));
        try {
            ContentType ct;
            String cts = this.getContentType();
            if (cts != null && (ct = ContentType.parse((String)cts)).getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                List postParams = URLEncodedUtils.parse((String)IOUtils.toString((Reader)this.getReader()), (Charset)Charset.forName(encoding));
                CollectionUtils.addAll(params, (Iterable)postParams);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return params;
    }

    public String getPostBodyAsString(String encoding) {
        try {
            if (this.cachedBytes == null) {
                this.cacheInputStream(encoding);
            }
            return this.cachedBytes.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String query = StringUtils.isEmpty((CharSequence)this.getQueryString()) ? "" : this.getQueryString();
        StringBuilder sb = new StringBuilder();
        sb.append("URL='").append(this.getRequestURI()).append(query.isEmpty() ? "" : "?" + query).append("', body='");
        String encoding = this.getRequest().getCharacterEncoding();
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = Charset.defaultCharset().name();
        }
        sb.append(this.getPostBodyAsString(encoding));
        sb.append("'");
        return sb.toString();
    }

    public class CachedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream input;

        public CachedServletInputStream() {
            this.input = new ByteArrayInputStream(MultiReadHttpServletRequestWrapper.this.cachedBytes.toByteArray());
        }

        public int read() throws IOException {
            return this.input.read();
        }
    }
}

