/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.dal.SiteFeed;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.site.SiteService;
import org.craftercms.studio.api.v2.dal.Group;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.api.v2.service.security.internal.UserServiceInternal;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.security.access.AccessDecisionVoter;

public abstract class StudioAbstractAccessDecisionVoter
implements AccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioAbstractAccessDecisionVoter.class);
    protected SecurityService securityService;
    protected StudioConfiguration studioConfiguration;
    protected SiteService siteService;
    protected UserServiceInternal userServiceInternal;

    protected boolean isSiteMember(User currentUser, String userParam) {
        try {
            int total1 = this.siteService.getSitesPerUserTotal(userParam);
            List<SiteFeed> sitesFeed1 = this.siteService.getSitesPerUser(userParam, 0, total1);
            int total2 = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List<SiteFeed> sitesFeed2 = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total2);
            HashSet<String> sites1 = new HashSet<String>();
            HashSet<String> sites2 = new HashSet<String>();
            for (SiteFeed site : sitesFeed1) {
                sites1.add(site.getSiteId());
            }
            for (SiteFeed site : sitesFeed2) {
                sites2.add(site.getSiteId());
            }
            Collection intersection = CollectionUtils.intersection(sites1, sites2);
            return CollectionUtils.isNotEmpty((Collection)intersection);
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", e);
            return false;
        }
        catch (ServiceLayerException e) {
            logger.warn("Error getting user membership", e);
            return false;
        }
    }

    protected boolean isSiteMember(String siteId, User currentUser) {
        try {
            int total = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List<SiteFeed> sitesFeed = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total);
            HashSet<String> sites = new HashSet<String>();
            for (SiteFeed site : sitesFeed) {
                sites.add(site.getSiteId());
            }
            return sites.contains(siteId);
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", e);
            return false;
        }
        catch (ServiceLayerException e) {
            logger.warn("Error getting user membership", e);
            return false;
        }
    }

    protected boolean isSiteAdmin(String siteId, User currentUser) {
        try {
            int total = this.siteService.getSitesPerUserTotal(currentUser.getUsername());
            List<SiteFeed> sitesFeed = this.siteService.getSitesPerUser(currentUser.getUsername(), 0, total);
            HashMap<String, Long> sites = new HashMap<String, Long>();
            for (SiteFeed site : sitesFeed) {
                sites.put(site.getSiteId(), site.getId());
            }
            boolean toRet = sites.containsKey(siteId);
            if (toRet) {
                List<Group> userGroups = this.userServiceInternal.getUserGroups((Long)sites.get(siteId), currentUser.getUsername());
                for (Group g : userGroups) {
                    if (!g.getGroupName().equals(this.studioConfiguration.getProperty("studio.configuration.defaultAdminGroup"))) continue;
                    toRet = true;
                    break;
                }
                toRet = userGroups.contains(this.studioConfiguration.getProperty("studio.configuration.defaultAdminGroup"));
            }
            return toRet;
        }
        catch (UserNotFoundException e) {
            logger.info("User is not site member", e);
            return false;
        }
        catch (ServiceLayerException e) {
            logger.error("Error getting user memberships", e, new Object[0]);
            return false;
        }
    }

    protected boolean isSelf(User currentUser, String userParam) {
        return StringUtils.equals((CharSequence)userParam, (CharSequence)currentUser.getUsername());
    }

    protected boolean isAdmin(User user) {
        List<Group> userGroups = null;
        try {
            userGroups = this.userServiceInternal.getUserGroups(-1L, user.getUsername());
        }
        catch (ServiceLayerException | UserNotFoundException e) {
            logger.error("Error getting user memberships", e, new Object[0]);
            return false;
        }
        boolean toRet = false;
        if (CollectionUtils.isNotEmpty(userGroups)) {
            for (Group group : userGroups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)group.getGroupName(), (CharSequence)"system_admin")) continue;
                toRet = true;
                break;
            }
        }
        return toRet;
    }

    protected boolean hasPermission(String siteId, String path, String user, String permission) {
        Set<String> userPermissions = this.securityService.getUserPermissions(siteId, path, user, null);
        return StringUtils.isEmpty((CharSequence)permission) || CollectionUtils.isNotEmpty(userPermissions) && userPermissions.contains(permission);
    }

    protected boolean hasAnyPermission(String siteId, String path, String user, Set<String> permissions) {
        Set<String> userPermissions = this.securityService.getUserPermissions(siteId, path, user, null);
        return CollectionUtils.isEmpty(permissions) || CollectionUtils.isNotEmpty(userPermissions) && CollectionUtils.containsAny(userPermissions, permissions);
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public UserServiceInternal getUserServiceInternal() {
        return this.userServiceInternal;
    }

    public void setUserServiceInternal(UserServiceInternal userServiceInternal) {
        this.userServiceInternal = userServiceInternal;
    }
}

