/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.craftercms.studio.api.v1.service.security.UserDetailsManager;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v1.util.SessionTokenUtils;
import org.craftercms.studio.impl.v2.service.security.Authentication;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.filter.GenericFilterBean;

public class StudioAuthenticationTokenProcessingFilter
extends GenericFilterBean {
    private static final Logger crafterLogger = LoggerFactory.getLogger(StudioAuthenticationTokenProcessingFilter.class);
    private static ReentrantLock semaphore = new ReentrantLock();
    private UserDetailsManager userDetailsManager;
    private SecurityService securityService;
    private StudioConfiguration studioConfiguration;
    private boolean authenticationHeadersEnabled = false;
    private List<String> usernameHeaders = null;

    public void init() {
        List<HierarchicalConfiguration<ImmutableNode>> chainConfig = this.studioConfiguration.getSubConfigs("studio.authentication.chain");
        if (chainConfig != null) {
            this.authenticationHeadersEnabled = chainConfig.stream().anyMatch(providerConfig -> providerConfig.getString("provider").toUpperCase().equals("HEADERS") && providerConfig.getBoolean("enabled"));
            this.usernameHeaders = chainConfig.stream().filter(providerConfig -> providerConfig.getString("provider").toUpperCase().equals("HEADERS") && providerConfig.getBoolean("enabled")).map(providerConfig -> providerConfig.getString("usernameHeader")).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block12: {
            HttpServletRequest httpRequest = this.getAsHttpRequest(servletRequest);
            HttpSession httpSession = httpRequest.getSession();
            semaphore.lock();
            try {
                String userName = this.securityService.getCurrentUser();
                String authToken = this.securityService.getCurrentToken();
                if (userName != null) {
                    UserDetails userDetails = this.userDetailsManager.loadUserByUsername(userName);
                    if (SessionTokenUtils.validateToken(authToken, userDetails.getUsername())) {
                        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), null, userDetails.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)authentication);
                        if ((httpRequest.getRequestURI().startsWith(httpRequest.getContextPath() + "/api/1") || httpRequest.getRequestURI().startsWith(httpRequest.getContextPath() + "/api/2")) && !this.getIgnoreRenewTokenUrls().contains(HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)httpRequest))) {
                            int timeout = Integer.parseInt(this.studioConfiguration.getProperty("studio.security.sessionTimeout"));
                            String newToken = SessionTokenUtils.createToken(userDetails.getUsername(), timeout);
                            this.storeToken(newToken);
                        }
                    } else {
                        crafterLogger.debug("Session is not valid. Clearing HttpSession", new Object[0]);
                        httpSession.removeAttribute("studio_authentication");
                        httpSession.invalidate();
                    }
                    break block12;
                }
                if (!this.isAuthenticationHeadersEnabled()) break block12;
                String usernameHeader = null;
                for (String header : this.usernameHeaders) {
                    usernameHeader = httpRequest.getHeader(header);
                    if (!StringUtils.isNotEmpty((CharSequence)usernameHeader)) continue;
                    try {
                        this.securityService.authenticate(usernameHeader, RandomStringUtils.randomAlphanumeric((int)16));
                        UserDetails userDetails = this.userDetailsManager.loadUserByUsername(usernameHeader);
                        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), null, userDetails.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)authentication);
                        break;
                    }
                    catch (Exception e) {
                        crafterLogger.error("Unable to authenticate user using authentication headers.", e, new Object[0]);
                    }
                }
            }
            catch (ServiceLayerException e) {
                this.logger.error((Object)"Unknown service error trying to authenticate user", (Throwable)e);
            }
            finally {
                semaphore.unlock();
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void storeToken(String token) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            HttpSession httpSession = context.getRequest().getSession();
            Authentication oldAuthentication = (Authentication)httpSession.getAttribute("studio_authentication");
            Authentication newAuthentication = new Authentication(oldAuthentication.getUsername(), token, oldAuthentication.getAuthenticationType(), oldAuthentication.getSsoLogoutUrl());
            httpSession.setAttribute("studio_authentication", (Object)newAuthentication);
        }
    }

    private HttpServletRequest getAsHttpRequest(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            throw new RuntimeException("Expecting an HTTP request");
        }
        return (HttpServletRequest)request;
    }

    public List<String> getIgnoreRenewTokenUrls() {
        return Arrays.asList(this.studioConfiguration.getProperty("studio.security.ignoreRenewTokenUrls").split(","));
    }

    public boolean isAuthenticationHeadersEnabled() {
        return this.authenticationHeadersEnabled;
    }

    public UserDetailsManager getUserDetailsManager() {
        return this.userDetailsManager;
    }

    public void setUserDetailsManager(UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

