/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioCmisDSAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioCmisDSAPIAccessDecisionVoter.class);
    private static final String LIST = "/api/1/services/api/1/cmis/list.json";
    private static final String SEARCH = "/api/1/services/api/1/cmis/search.json";
    private static final String UPLOAD = "/api/1/services/api/1/cmis/upload.json";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation) {
            User currentUser;
            String siteParam;
            block14: {
                FilterInvocation filterInvocation = (FilterInvocation)o;
                HttpServletRequest request = filterInvocation.getRequest();
                requestUri = request.getRequestURI().replace(request.getContextPath(), "");
                siteParam = request.getParameter("site_id");
                currentUser = null;
                try {
                    String username = authentication.getPrincipal().toString();
                    currentUser = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                }
                catch (ClassCastException | ServiceLayerException | UserNotFoundException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block14;
                    logger.info("Error getting current user", e);
                    return 0;
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/cmis/upload.json": {
                    if (currentUser != null) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/cmis/search.json": 
                case "/api/1/services/api/1/cmis/list.json": {
                    if (currentUser != null && this.isSiteMember(siteParam, currentUser)) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

