/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioContentAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioContentAPIAccessDecisionVoter.class);
    private static final String WRITE_CONTENT = "/api/1/services/api/1/content/write-content.json";
    private static final String WRITE_PERMISSION = "write";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        FilterInvocation filterInvocation;
        HttpServletRequest request;
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation && StringUtils.equals((CharSequence)(requestUri = (request = (filterInvocation = (FilterInvocation)o).getRequest()).getRequestURI().replace(request.getContextPath(), "")), (CharSequence)WRITE_CONTENT)) {
            User currentUser;
            String pathParam;
            String siteParam;
            block20: {
                String userParam = request.getParameter("username");
                siteParam = request.getParameter("site_id");
                if (StringUtils.isEmpty((CharSequence)siteParam)) {
                    siteParam = request.getParameter("site");
                }
                pathParam = request.getParameter("path");
                if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    try {
                        ServletInputStream is = request.getInputStream();
                        is.mark(0);
                        String jsonString = IOUtils.toString((InputStream)is);
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString})) {
                            JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
                            if (jsonObject.has("username")) {
                                userParam = jsonObject.getString("username");
                            }
                            if (jsonObject.has("site")) {
                                siteParam = jsonObject.getString("site");
                            }
                            if (jsonObject.has("site_id")) {
                                siteParam = jsonObject.getString("site_id");
                            }
                            if (jsonObject.has("path")) {
                                pathParam = jsonObject.getString("path");
                            }
                        }
                        is.reset();
                    }
                    catch (IOException | JSONException e) {
                        logger.debug("Failed to extract username from POST request", new Object[0]);
                    }
                }
                currentUser = null;
                try {
                    String username = authentication.getPrincipal().toString();
                    currentUser = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                }
                catch (ClassCastException | ServiceLayerException | UserNotFoundException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block20;
                    logger.info("Error getting current user", e);
                    return -1;
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/content/write-content.json": {
                    if (this.siteService.exists(siteParam)) {
                        if (currentUser != null && this.isSiteMember(siteParam, currentUser) && this.hasPermission(siteParam, pathParam, currentUser.getUsername(), WRITE_PERMISSION)) {
                            toRet = 1;
                            break;
                        }
                        toRet = -1;
                        break;
                    }
                    toRet = 0;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

