/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioGroupAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioGroupAPIAccessDecisionVoter.class);
    private static final String ADD_USER = "/api/1/services/api/1/group/add-user.json";
    private static final String CREATE = "/api/1/services/api/1/group/create.json";
    private static final String DELETE = "/api/1/services/api/1/group/delete.json";
    private static final String GET = "/api/1/services/api/1/group/get.json";
    private static final String GET_ALL = "/api/1/services/api/1/group/get-all.json";
    private static final String GET_PER_SITE = "/api/1/services/api/1/group/get-per-site.json";
    private static final String REMOVE_USER = "/api/1/services/api/1/group/remove-user.json";
    private static final String UPDATE = "/api/1/services/api/1/group/update.json";
    private static final String USERS = "/api/1/services/api/1/group/users.json";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation) {
            User currentUser;
            String userParam;
            String siteParam;
            HttpServletRequest request;
            block26: {
                FilterInvocation filterInvocation = (FilterInvocation)o;
                request = filterInvocation.getRequest();
                requestUri = request.getRequestURI().replace(request.getContextPath(), "");
                siteParam = request.getParameter("site_id");
                userParam = request.getParameter("username");
                currentUser = null;
                try {
                    String username = authentication.getPrincipal().toString();
                    currentUser = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                }
                catch (ClassCastException | ServiceLayerException | UserNotFoundException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block26;
                    logger.error("Error getting current user", e, new Object[0]);
                    return 0;
                }
            }
            if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                try {
                    ServletInputStream is = request.getInputStream();
                    is.mark(0);
                    String jsonString = IOUtils.toString((InputStream)is);
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString})) {
                        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
                        if (jsonObject.has("username")) {
                            userParam = jsonObject.getString("username");
                        }
                        if (jsonObject.has("site_id")) {
                            siteParam = jsonObject.getString("site_id");
                        }
                    }
                    is.reset();
                }
                catch (IOException | JSONException e) {
                    logger.debug("Failed to extract username from POST request", new Object[0]);
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/group/add-user.json": 
                case "/api/1/services/api/1/group/create.json": 
                case "/api/1/services/api/1/group/delete.json": 
                case "/api/1/services/api/1/group/get-all.json": 
                case "/api/1/services/api/1/group/remove-user.json": 
                case "/api/1/services/api/1/group/update.json": {
                    if (currentUser != null && (this.isSiteAdmin(this.studioConfiguration.getProperty("studio.configuration.global.systemSite"), currentUser) || this.isSiteAdmin(siteParam, currentUser))) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/group/get.json": 
                case "/api/1/services/api/1/group/get-per-site.json": 
                case "/api/1/services/api/1/group/users.json": {
                    if (currentUser != null && (this.isSiteAdmin(siteParam, currentUser) || this.isSiteMember(siteParam, currentUser))) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

