/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class StudioLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final String PARAM_REDIRECT = "redirect";
    private static final Logger logger = LoggerFactory.getLogger(StudioLoginUrlAuthenticationEntryPoint.class);

    public StudioLoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        String redirectParamValue = request.getContextPath() + UrlUtils.buildRequestUrl((HttpServletRequest)request);
        try {
            redirectParamValue = UriUtils.encode((String)redirectParamValue, (String)StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Unsupported encoding for redirect query param value. Sending param without encoding it", new Object[0]);
        }
        String redirect = super.determineUrlToUseForThisRequest(request, response, exception);
        return UriComponentsBuilder.fromPath((String)redirect).queryParam(PARAM_REDIRECT, new Object[]{redirectParamValue}).toUriString();
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String requestUrl = UrlUtils.buildRequestUrl((HttpServletRequest)request);
        if (StringUtils.startsWith((CharSequence)requestUrl, (CharSequence)"/api/")) {
            response.sendError(401, "Unauthorized");
        } else {
            super.commence(request, response, authException);
        }
    }
}

