/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.studio.api.v1.exception.SiteNotFoundException;
import org.craftercms.studio.api.v1.service.security.SecurityService;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class StudioLogoutFilter
extends LogoutFilter {
    protected SecurityService securityService;

    public StudioLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, SecurityService securityService, LogoutHandler ... handlers) {
        super(logoutSuccessHandler, handlers);
        this.securityService = securityService;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.requiresLogout((HttpServletRequest)req, (HttpServletResponse)res)) {
            try {
                this.securityService.logout();
            }
            catch (SiteNotFoundException e) {
                throw new ServletException("Error performing logout", (Throwable)e);
            }
            super.doFilter(req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }
}

