/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioPublishingAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioPublishingAPIAccessDecisionVoter.class);
    private static final String START = "/api/1/services/api/1/publish/start.json";
    private static final String STATUS = "/api/1/services/api/1/publish/status.json";
    private static final String STOP = "/api/1/services/api/1/publish/stop.json";
    private static final String COMMITS = "/api/1/services/api/1/publish/commits.json";
    private static final String PUBLISH_ITEMS = "/api/1/services/api/1/publish/publish-items.json";
    private static final String RESET_STAGING = "/api/1/services/api/1/publish/reset-staging.json";

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation) {
            User currentUser;
            String siteParam;
            block27: {
                FilterInvocation filterInvocation = (FilterInvocation)o;
                HttpServletRequest request = filterInvocation.getRequest();
                requestUri = request.getRequestURI().replace(request.getContextPath(), "");
                String userParam = request.getParameter("username");
                siteParam = request.getParameter("site_id");
                if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    try {
                        ServletInputStream is = request.getInputStream();
                        is.mark(0);
                        String jsonString = IOUtils.toString((InputStream)is);
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString})) {
                            JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
                            if (jsonObject.has("username")) {
                                userParam = jsonObject.getString("username");
                            }
                            if (jsonObject.has("site_id")) {
                                siteParam = jsonObject.getString("site_id");
                            }
                        }
                        is.reset();
                    }
                    catch (IOException | JSONException e) {
                        logger.debug("Failed to extract username from POST request", new Object[0]);
                    }
                }
                currentUser = null;
                try {
                    String username = authentication.getPrincipal().toString();
                    currentUser = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                }
                catch (ClassCastException | ServiceLayerException | UserNotFoundException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block27;
                    logger.info("Error getting current user", e);
                    return 0;
                }
            }
            switch (requestUri) {
                case "/api/1/services/api/1/publish/start.json": 
                case "/api/1/services/api/1/publish/stop.json": {
                    if (currentUser != null) {
                        toRet = 1;
                        break;
                    }
                    toRet = -1;
                    break;
                }
                case "/api/1/services/api/1/publish/status.json": {
                    if (this.siteService.exists(siteParam)) {
                        if (currentUser != null && this.isSiteMember(siteParam, currentUser)) {
                            toRet = 1;
                            break;
                        }
                        toRet = -1;
                        break;
                    }
                    toRet = 0;
                    break;
                }
                case "/api/1/services/api/1/publish/commits.json": 
                case "/api/1/services/api/1/publish/publish-items.json": 
                case "/api/1/services/api/1/publish/reset-staging.json": {
                    if (this.siteService.exists(siteParam)) {
                        if (currentUser != null && (this.isSiteAdmin(siteParam, currentUser) || this.hasPermission(siteParam, "~DASHBOARD~", currentUser.getUsername(), "publish"))) {
                            toRet = 1;
                            break;
                        }
                        toRet = -1;
                        break;
                    }
                    toRet = 0;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

