/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v1.web.security.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.studio.api.v1.exception.ServiceLayerException;
import org.craftercms.studio.api.v1.exception.security.UserNotFoundException;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.User;
import org.craftercms.studio.impl.v1.web.security.access.StudioAbstractAccessDecisionVoter;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;

public class StudioWorkflowAPIAccessDecisionVoter
extends StudioAbstractAccessDecisionVoter {
    private static final Logger logger = LoggerFactory.getLogger(StudioWorkflowAPIAccessDecisionVoter.class);
    private static final String GO_LIVE = "/api/1/services/api/1/workflow/go-live.json";
    private static final String REJECT = "/api/1/services/api/1/workflow/reject.json";
    private static final String GO_DELETE = "/api/1/services/api/1/workflow/go-delete.json";
    private static final Set<String> URIS_TO_VOTE = new HashSet<String>(){
        {
            this.add(StudioWorkflowAPIAccessDecisionVoter.GO_LIVE);
            this.add(StudioWorkflowAPIAccessDecisionVoter.REJECT);
            this.add(StudioWorkflowAPIAccessDecisionVoter.GO_DELETE);
        }
    };
    private static final String PUBLISH_PERMISSION = "publish";
    private static final String DELETE_PERMISSION = "delete";
    private static final String DELETE_CONTENT_PERMISSION = "delete_content";
    private static final String CANCEL_PUBLISH_PERMISSION = "cancel_publish";
    private static final Set<String> DELETE_PERMISSIONS = new HashSet<String>(){
        {
            this.add(StudioWorkflowAPIAccessDecisionVoter.DELETE_PERMISSION);
            this.add(StudioWorkflowAPIAccessDecisionVoter.DELETE_CONTENT_PERMISSION);
        }
    };
    private static final Set<String> REJECT_PERMISSIONS = new HashSet<String>(){
        {
            this.add(StudioWorkflowAPIAccessDecisionVoter.PUBLISH_PERMISSION);
            this.add(StudioWorkflowAPIAccessDecisionVoter.CANCEL_PUBLISH_PERMISSION);
        }
    };

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public int vote(Authentication authentication, Object o, Collection collection) {
        FilterInvocation filterInvocation;
        HttpServletRequest request;
        int toRet = 0;
        String requestUri = "";
        if (o instanceof FilterInvocation && URIS_TO_VOTE.contains(requestUri = (request = (filterInvocation = (FilterInvocation)o).getRequest()).getRequestURI().replace(request.getContextPath(), ""))) {
            User currentUser;
            ArrayList<String> paths;
            String siteParam;
            block31: {
                String userParam = request.getParameter("username");
                siteParam = request.getParameter("site_id");
                paths = new ArrayList<String>();
                if (StringUtils.isEmpty((CharSequence)siteParam)) {
                    siteParam = request.getParameter("site");
                }
                if (StringUtils.isEmpty((CharSequence)userParam) && StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)HttpMethod.POST.name()) && !ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    try {
                        ServletInputStream is = request.getInputStream();
                        is.mark(0);
                        String jsonString = IOUtils.toString((InputStream)is);
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{jsonString})) {
                            JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
                            if (jsonObject.has("username")) {
                                userParam = jsonObject.getString("username");
                            }
                            if (jsonObject.has("site")) {
                                siteParam = jsonObject.getString("site");
                            }
                            if (jsonObject.has("site_id")) {
                                siteParam = jsonObject.getString("site_id");
                            }
                            if (jsonObject.has("items")) {
                                JSONArray jsonArray = jsonObject.getJSONArray("items");
                                for (int i = 0; i < jsonArray.size(); ++i) {
                                    paths.add(jsonArray.optString(i));
                                }
                            }
                        }
                        is.reset();
                    }
                    catch (IOException | JSONException e) {
                        logger.debug("Failed to extract username from POST request", new Object[0]);
                    }
                }
                currentUser = null;
                try {
                    String username = authentication.getPrincipal().toString();
                    currentUser = this.userServiceInternal.getUserByIdOrUsername(-1L, username);
                }
                catch (ClassCastException | ServiceLayerException | UserNotFoundException e) {
                    if (authentication.getPrincipal().toString().equals("anonymousUser")) break block31;
                    logger.info("Error getting current user", e);
                    return -1;
                }
            }
            block7 : switch (requestUri) {
                case "/api/1/services/api/1/workflow/go-live.json": {
                    if (!this.siteService.exists(siteParam)) break;
                    for (String path : paths) {
                        if (currentUser != null && this.isSiteMember(siteParam, currentUser) && this.hasPermission(siteParam, path, currentUser.getUsername(), PUBLISH_PERMISSION)) {
                            toRet = 1;
                            continue;
                        }
                        toRet = -1;
                        break block7;
                    }
                    break;
                }
                case "/api/1/services/api/1/workflow/reject.json": {
                    if (this.siteService.exists(siteParam)) {
                        for (String path : paths) {
                            if (currentUser != null && this.isSiteMember(siteParam, currentUser) && this.hasAnyPermission(siteParam, path, currentUser.getUsername(), REJECT_PERMISSIONS)) {
                                toRet = 1;
                                continue;
                            }
                            toRet = -1;
                            break block7;
                        }
                        break;
                    }
                    toRet = 0;
                    break;
                }
                case "/api/1/services/api/1/workflow/go-delete.json": {
                    if (this.siteService.exists(siteParam)) {
                        for (String path : paths) {
                            if (currentUser != null && this.isSiteMember(siteParam, currentUser) && this.hasAnyPermission(siteParam, path, currentUser.getUsername(), DELETE_PERMISSIONS)) {
                                toRet = 1;
                                continue;
                            }
                            toRet = -1;
                            break block7;
                        }
                        break;
                    }
                    toRet = 0;
                    break;
                }
                default: {
                    toRet = 0;
                }
            }
        }
        logger.debug("Request: " + requestUri + " - Access: " + toRet, new Object[0]);
        return toRet;
    }

    public boolean supports(Class aClass) {
        return true;
    }
}

