/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.craftercms.commons.crypto.CryptoUtils;
import org.craftercms.commons.entitlements.validator.DbIntegrityValidator;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.DataSourceInitializer;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;

public class DataSourceInitializerImpl
implements DataSourceInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceInitializerImpl.class);
    private static final String SCHEMA = "{schema}";
    private static final String CRAFTER_SCHEMA_NAME = "@crafter_schema_name";
    private static final String DB_QUERY_CHECK_SCHEMA_EXISTS = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '{schema}'";
    private static final String DB_QUERY_CHECK_TABLES = "SHOW TABLES FROM {schema}";
    private static final String DB_QUERY_SET_ADMIN_PASSWORD = "UPDATE {schema}.user SET password = '{password}' WHERE username = 'admin'";
    private static final String DB_QUERY_CHECK_ADMIN_PASSWORD_EMPTY = "SELECT CASE WHEN ISNULL(password) > 0 THEN 1 WHEN CHAR_LENGTH(password) = 0 THEN 1 ELSE 0 END FROM {schema}.user WHERE username = 'admin' ";
    protected String delimiter;
    protected StudioConfiguration studioConfiguration;
    protected DbIntegrityValidator integrityValidator;

    @Override
    public void initDataSource() {
        if (this.isEnabled()) {
            try {
                Class.forName(this.studioConfiguration.getProperty("studio.db.driver"));
            }
            catch (Exception e) {
                logger.error("Error loading JDBC driver", e, new Object[0]);
            }
            try (Connection conn = DriverManager.getConnection(this.studioConfiguration.getProperty("studio.db.initializer.url"));){
                logger.debug("Check if database schema already exists", new Object[0]);
                try (Statement statement = conn.createStatement();
                     ResultSet rs = statement.executeQuery(DB_QUERY_CHECK_SCHEMA_EXISTS.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")));){
                    Throwable throwable;
                    if (rs.next()) {
                        logger.debug("Database schema exists. Check if it is empty.", new Object[0]);
                        throwable = null;
                        try (ResultSet rs2 = statement.executeQuery(DB_QUERY_CHECK_TABLES.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")));){
                            ArrayList<String> tableNames = new ArrayList<String>();
                            while (rs2.next()) {
                                tableNames.add(rs2.getString(1));
                            }
                            if (tableNames.size() == 0) {
                                this.createDatabaseTables(conn, statement);
                            }
                            logger.debug("Database already exists. Validate the integrity of the database", new Object[0]);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    } else {
                        this.createSchema(conn);
                        this.createDatabaseTables(conn, statement);
                    }
                    throwable = null;
                    try (ResultSet rs3 = statement.executeQuery(DB_QUERY_CHECK_ADMIN_PASSWORD_EMPTY.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")));){
                        if (rs3.next() && rs3.getInt(1) > 0) {
                            this.setRandomAdminPassword(conn, statement);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException | SQLException e) {
                    logger.error("Error while initializing database", e, new Object[0]);
                }
            }
            catch (SQLException e) {
                logger.error("Error while connecting to initialize DB", e, new Object[0]);
            }
        }
    }

    private void createDatabaseTables(Connection conn, Statement statement) throws SQLException, IOException {
        String createDbScriptPath = this.getCreateDBScriptPath();
        logger.info("Database tables do not exist.", new Object[0]);
        logger.info("Creating database tables from script " + createDbScriptPath, new Object[0]);
        ScriptRunner sr = new ScriptRunner(conn);
        sr.setDelimiter(this.delimiter);
        sr.setStopOnError(true);
        sr.setLogWriter(null);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(createDbScriptPath);
        String scriptContent = IOUtils.toString((InputStream)is);
        StringReader reader = new StringReader(scriptContent.replaceAll(CRAFTER_SCHEMA_NAME, this.studioConfiguration.getProperty("studio.db.schema")));
        try {
            sr.runScript((Reader)reader);
            if (this.isRandomAdminPasswordEnabled()) {
                this.setRandomAdminPassword(conn, statement);
            }
            this.integrityValidator.store(conn);
        }
        catch (RuntimeSqlException e) {
            logger.error("Error while running create DB script", (Exception)((Object)e), new Object[0]);
        }
    }

    private void setRandomAdminPassword(Connection conn, Statement statement) throws SQLException {
        String randomPassword = this.generateRandomPassword();
        String hashedPassword = CryptoUtils.hashPassword((String)randomPassword);
        String update = DB_QUERY_SET_ADMIN_PASSWORD.replace(SCHEMA, this.studioConfiguration.getProperty("studio.db.schema")).replace("{password}", hashedPassword);
        statement.executeUpdate(update);
        conn.commit();
        logger.info("*** Admin Account Password: \"" + randomPassword + "\" ***", new Object[0]);
    }

    private void createSchema(Connection conn) throws IOException {
        String createSchemaScriptPath = this.getCreateSchemaScriptPath();
        logger.info("Database schema does not exists.", new Object[0]);
        logger.info("Creating database schema from script " + createSchemaScriptPath, new Object[0]);
        ScriptRunner sr = new ScriptRunner(conn);
        sr.setDelimiter(this.delimiter);
        sr.setStopOnError(true);
        sr.setLogWriter(null);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(createSchemaScriptPath);
        String scriptContent = IOUtils.toString((InputStream)is);
        StringReader reader = new StringReader(scriptContent.replaceAll(CRAFTER_SCHEMA_NAME, this.studioConfiguration.getProperty("studio.db.schema")));
        try {
            sr.runScript((Reader)reader);
        }
        catch (RuntimeSqlException e) {
            logger.error("Error while running create DB script", (Exception)((Object)e), new Object[0]);
        }
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.db.initializer.enabled"));
    }

    private String generateRandomPassword() {
        int passwordLength = Integer.parseInt(this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.length"));
        String passwordChars = this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.chars");
        return RandomStringUtils.random((int)passwordLength, (String)passwordChars);
    }

    private String getCreateDBScriptPath() {
        return this.studioConfiguration.getProperty("studio.db.initializer.createDbscriptLocation");
    }

    private String getCreateSchemaScriptPath() {
        return this.studioConfiguration.getProperty("studio.db.initializer.createSchemaScriptLocation");
    }

    private boolean isRandomAdminPasswordEnabled() {
        return Boolean.parseBoolean(this.studioConfiguration.getProperty("studio.db.initializer.randomAdminPassword.enabled"));
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setIntegrityValidator(DbIntegrityValidator integrityValidator) {
        this.integrityValidator = integrityValidator;
    }
}

