/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal;

import java.util.Map;
import org.craftercms.studio.api.v1.dal.DependencyMapper;
import org.craftercms.studio.api.v1.dal.ItemStateMapper;
import org.craftercms.studio.api.v1.dal.PublishRequest;
import org.craftercms.studio.api.v1.dal.PublishRequestMapper;
import org.craftercms.studio.api.v1.dal.SiteFeedMapper;
import org.craftercms.studio.api.v2.annotation.RetryingOperation;
import org.craftercms.studio.api.v2.dal.ClusterDAO;
import org.craftercms.studio.api.v2.dal.GitLogDAO;
import org.craftercms.studio.api.v2.dal.RetryingOperationFacade;

@RetryingOperation
public class RetryingOperationFacadeImpl
implements RetryingOperationFacade {
    private GitLogDAO gitLogDao;
    private ClusterDAO clusterDao;
    private DependencyMapper dependencyMapper;
    private PublishRequestMapper publishRequestMapper;
    private ItemStateMapper itemStateMapper;
    private SiteFeedMapper siteFeedMapper;

    @Override
    public void markGitLogProcessedBeforeMarker(String siteId, long marker, int processed, int unprocessed) {
        this.gitLogDao.markGitLogProcessedBeforeMarker(siteId, marker, processed, unprocessed);
    }

    @Override
    public void markGitLogAudited(String siteId, String commitId, int audited) {
        this.gitLogDao.markGitLogAudited(siteId, commitId, audited);
    }

    @Override
    public void addClusterRemoteRepository(long clusterId, long remoteRepositoryId) {
        this.clusterDao.addClusterRemoteRepository(clusterId, remoteRepositoryId);
    }

    @Override
    public void deleteDependenciesForSite(Map params) {
        this.dependencyMapper.deleteDependenciesForSite(params);
    }

    @Override
    public void deleteDeploymentDataForSite(Map params) {
        this.publishRequestMapper.deleteDeploymentDataForSite(params);
    }

    @Override
    public void deleteAllSourceDependencies(Map params) {
        this.dependencyMapper.deleteAllSourceDependencies(params);
    }

    @Override
    public void insertDependenciesList(Map params) {
        this.dependencyMapper.insertList(params);
    }

    @Override
    public void cancelWorkflowBulk(Map params) {
        this.publishRequestMapper.cancelWorkflowBulk(params);
    }

    @Override
    public void markPublishRequestCompleted(PublishRequest publishRequest) {
        this.publishRequestMapper.markItemCompleted(publishRequest);
    }

    @Override
    public void setSystemProcessingBySiteAndPathBulk(Map params) {
        this.itemStateMapper.setSystemProcessingBySiteAndPathBulk(params);
    }

    @Override
    public void updateSiteLastCommitId(Map params) {
        this.siteFeedMapper.updateLastCommitId(params);
    }

    @Override
    public void updateClusterNodeLastCommitId(long clusterNodeId, long siteId, String commitId) {
        this.clusterDao.updateNodeLastCommitId(clusterNodeId, siteId, commitId);
    }

    @Override
    public void updateSiteLastVerifiedGitlogCommitId(Map params) {
        this.siteFeedMapper.updateLastVerifiedGitlogCommitId(params);
    }

    @Override
    public void updateClusterNodeLastVerifiedGitlogCommitId(long clusterNodeId, long siteId, String commitId) {
        this.clusterDao.updateNodeLastVerifiedGitlogCommitId(clusterNodeId, siteId, commitId);
    }

    @Override
    public void updateSiteLastSyncedGitlogCommitId(Map params) {
        this.siteFeedMapper.updateLastSyncedGitlogCommitId(params);
    }

    @Override
    public void updateClusterNodeLastSyncedGitlogCommitId(long clusterNodeId, long siteId, String commitId) {
        this.clusterDao.updateNodeLastSyncedGitlogCommitId(clusterNodeId, siteId, commitId);
    }

    @Override
    public void markGitLogProcessed(Map params) {
        this.gitLogDao.markGitLogProcessed(params);
    }

    public GitLogDAO getGitLogDao() {
        return this.gitLogDao;
    }

    public void setGitLogDao(GitLogDAO gitLogDao) {
        this.gitLogDao = gitLogDao;
    }

    public ClusterDAO getClusterDao() {
        return this.clusterDao;
    }

    public void setClusterDao(ClusterDAO clusterDao) {
        this.clusterDao = clusterDao;
    }

    public DependencyMapper getDependencyMapper() {
        return this.dependencyMapper;
    }

    public void setDependencyMapper(DependencyMapper dependencyMapper) {
        this.dependencyMapper = dependencyMapper;
    }

    public PublishRequestMapper getPublishRequestMapper() {
        return this.publishRequestMapper;
    }

    public void setPublishRequestMapper(PublishRequestMapper publishRequestMapper) {
        this.publishRequestMapper = publishRequestMapper;
    }

    public ItemStateMapper getItemStateMapper() {
        return this.itemStateMapper;
    }

    public void setItemStateMapper(ItemStateMapper itemStateMapper) {
        this.itemStateMapper = itemStateMapper;
    }

    public SiteFeedMapper getSiteFeedMapper() {
        return this.siteFeedMapper;
    }

    public void setSiteFeedMapper(SiteFeedMapper siteFeedMapper) {
        this.siteFeedMapper = siteFeedMapper;
    }
}

