/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.craftercms.studio.api.v1.log.Logger;
import org.craftercms.studio.api.v1.log.LoggerFactory;
import org.craftercms.studio.api.v2.dal.StudioDBScriptRunner;

public class StudioDBScriptRunnerImpl
implements StudioDBScriptRunner {
    private static final Logger logger = LoggerFactory.getLogger(StudioDBScriptRunnerImpl.class);
    protected String delimiter;
    protected DataSource dataSource;
    protected int scriptLinesBufferSize = 10000;
    protected Connection connection = null;

    protected StudioDBScriptRunnerImpl(String delimiter, DataSource dataSource, int scriptLinesBufferSize) {
        this.delimiter = delimiter;
        this.dataSource = dataSource;
        this.scriptLinesBufferSize = scriptLinesBufferSize;
    }

    @Override
    public void openConnection() {
        if (Objects.isNull(this.connection)) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (SQLException throwables) {
                logger.error("Failed to open connection with DB", throwables, new Object[0]);
            }
        }
    }

    @Override
    public void closeConnection() {
        if (!Objects.isNull(this.connection)) {
            try {
                this.connection.close();
            }
            catch (SQLException throwables) {
                logger.error("Failed to close connection with DB", throwables, new Object[0]);
            }
            this.connection = null;
        }
    }

    @Override
    public void execute(File sqlScriptFile) {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(sqlScriptFile));){
            this.connection = this.dataSource.getConnection();
            this.connection.setAutoCommit(false);
            ScriptRunner scriptRunner = new ScriptRunner(this.connection);
            scriptRunner.setAutoCommit(false);
            scriptRunner.setDelimiter(this.delimiter);
            scriptRunner.setStopOnError(true);
            scriptRunner.setLogWriter(null);
            StringBuilder sb = new StringBuilder();
            String line = null;
            boolean moreWork = true;
            while (moreWork) {
                for (int i = 0; i < this.scriptLinesBufferSize && moreWork; ++i) {
                    line = bufferedReader.readLine();
                    if (Objects.nonNull(line)) {
                        sb.append(line).append("\n");
                        continue;
                    }
                    moreWork = false;
                }
                if (sb.length() <= 0) continue;
                scriptRunner.runScript((Reader)new StringReader(sb.toString()));
                sb.setLength(0);
            }
            this.connection.commit();
        }
        catch (IOException | SQLException e) {
            logger.error("Error executing db script", e, new Object[0]);
            try {
                this.connection.rollback();
            }
            catch (SQLException throwables) {
                logger.error("Failed to rollback after error when running DB script", throwables, new Object[0]);
            }
        }
    }
}

