/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal.cluster;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.springframework.MariaDB4jSpringService;
import java.util.LinkedList;
import java.util.List;
import org.craftercms.studio.api.v2.dal.cluster.DbClusterSynchronizationService;
import org.craftercms.studio.api.v2.dal.cluster.MemberStartupConfig;
import org.craftercms.studio.api.v2.exception.DbClusterStartupException;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.springframework.beans.factory.annotation.Required;

public class DbClusterAwareMariaDB4jSpringService
extends MariaDB4jSpringService {
    public static final String DB_CLUSTER_ENABLED_ARG = "--wsrep_on=ON";
    public static final String DB_CLUSTER_LIB_LOCATION_ARG_FORMAT = "--wsrep_provider=%s";
    public static final String CLUSTER_NAME_ARG_FORMAT = "--wsrep_cluster_name=%s";
    public static final String CLUSTER_ADDRESS_ARG_FORMAT = "--wsrep_cluster_address=%s";
    public static final String NODE_ADDRESS_ARG_FORMAT = "--wsrep_node_address=%s";
    public static final String NODE_NAME_ARG_FORMAT = "--wsrep_node_name=%s";
    public static final String BOOTSTRAP_CLUSTER_ARG = "--wsrep-new-cluster";
    protected StudioConfiguration studioConfiguration;
    protected DbClusterSynchronizationService dbClusterSyncService;
    protected List<String> additionalArgs;

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setDbClusterSyncService(DbClusterSynchronizationService dbClusterSyncService) {
        this.dbClusterSyncService = dbClusterSyncService;
    }

    @Required
    public void setAdditionalArgs(List<String> additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    public String getDbClusterLibLocation() {
        return this.studioConfiguration.getProperty("studio.db.cluster.lib.location");
    }

    public void start() {
        try {
            this.db = DB.newEmbeddedDB((DBConfiguration)this.getConfiguration().build());
        }
        catch (ManagedProcessException e) {
            this.lastException = e;
            throw new IllegalStateException("Embedded MariaDB installation failed", e);
        }
        try {
            this.dbClusterSyncService.synchronizeStartup(startupConfig -> {
                LinkedList<String> args = new LinkedList<String>();
                if (startupConfig.getMode() == MemberStartupConfig.StartupMode.BOOTSTRAP) {
                    args.add(BOOTSTRAP_CLUSTER_ARG);
                }
                args.add(DB_CLUSTER_ENABLED_ARG);
                args.add(String.format(DB_CLUSTER_LIB_LOCATION_ARG_FORMAT, this.getDbClusterLibLocation()));
                args.add(String.format(CLUSTER_NAME_ARG_FORMAT, startupConfig.getClusterName()));
                args.add(String.format(NODE_ADDRESS_ARG_FORMAT, startupConfig.getNodeAddress()));
                args.add(String.format(NODE_NAME_ARG_FORMAT, startupConfig.getNodeName()));
                args.add(String.format(CLUSTER_ADDRESS_ARG_FORMAT, startupConfig.getClusterAddress()));
                args.addAll(this.additionalArgs);
                this.db.getConfiguration().getArgs().addAll(args);
                try {
                    this.db.start();
                }
                catch (ManagedProcessException e) {
                    this.lastException = e;
                    throw new IllegalStateException("Embedded MariaDB start failed", e);
                }
            });
        }
        catch (DbClusterStartupException e) {
            throw new IllegalStateException("DB cluster synchronization failed", e);
        }
    }
}

