/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal.cluster;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.Objects;

public class DbClusterMember
implements DataSerializable {
    public static final String SYNCED_STATUS = "Synced";
    public static final String ACTIVE_STATUS = "Active";
    private String address;
    private String name;
    private boolean safeToBootstrap;
    private volatile String status;
    private volatile long seqno;

    public DbClusterMember() {
    }

    public DbClusterMember(String address, String name) {
        this.address = address;
        this.name = name;
        this.seqno = 0L;
        this.safeToBootstrap = false;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isSafeToBootstrap() {
        return this.safeToBootstrap;
    }

    public void setSafeToBootstrap(boolean safeToBootstrap) {
        this.safeToBootstrap = safeToBootstrap;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean isSynced() {
        return SYNCED_STATUS.equalsIgnoreCase(this.status);
    }

    public boolean isActive() {
        return ACTIVE_STATUS.equalsIgnoreCase(this.status);
    }

    public long getSeqno() {
        return this.seqno;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbClusterMember member = (DbClusterMember)o;
        return this.address.equals(member.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "DbClusterMember{address='" + this.address + '\'' + ", name='" + this.name + '\'' + ", status='" + this.status + '\'' + ", seqno=" + this.seqno + ", safeToBootstrap=" + this.safeToBootstrap + '}';
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.address);
        out.writeUTF(this.name);
        out.writeUTF(this.status);
        out.writeLong(this.seqno);
        out.writeBoolean(this.safeToBootstrap);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.address = in.readUTF();
        this.name = in.readUTF();
        this.status = in.readUTF();
        this.seqno = in.readLong();
        this.safeToBootstrap = in.readBoolean();
    }
}

