/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.studio.impl.v2.dal.cluster;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.query.Predicates;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.craftercms.studio.api.v2.dal.cluster.DbClusterSynchronizationService;
import org.craftercms.studio.api.v2.dal.cluster.MemberStartupConfig;
import org.craftercms.studio.api.v2.exception.DbClusterNodeRecoverSeqnoException;
import org.craftercms.studio.api.v2.exception.DbClusterStartupException;
import org.craftercms.studio.api.v2.utils.StudioConfiguration;
import org.craftercms.studio.impl.v2.dal.cluster.DbClusterMember;
import org.craftercms.studio.impl.v2.dal.cluster.RecoverSeqnoProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DbClusterSynchronizationServiceImpl
implements DbClusterSynchronizationService,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(DbClusterSynchronizationServiceImpl.class);
    protected static final String SAFE_TO_BOOTSTRAP_FLAG_NAME = "safe_to_bootstrap";
    protected String LOCAL_STATE_DB_VAR_NAME = "wsrep_local_state_comment";
    protected String LOCAL_SEQNO_DB_VAR_NAME = "wsrep_last_committed";
    protected static final String GALERA_LOCAL_STATUS_DB_QUERY = "show status where Variable_name in (?, ?)";
    protected ApplicationContext applicationContext;
    protected StudioConfiguration studioConfiguration;
    protected HazelcastInstance hazelcastInstance;
    protected List<String> recoverSeqnoAdditionalArgs;
    protected volatile boolean appReady;
    protected IMap<String, Object> clusterInfo;
    protected IMap<String, DbClusterMember> currentClusterMembers;
    protected DbClusterMember localNode;
    protected MemberStartupConfig localStartupConfig;
    protected Connection connection;
    protected PreparedStatement statusQueryStmt;
    protected ScheduledExecutorService periodicStatusReporterExecutor;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Required
    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    @Required
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Required
    public void setRecoverSeqnoAdditionalArgs(List<String> recoverSeqnoAdditionalArgs) {
        this.recoverSeqnoAdditionalArgs = recoverSeqnoAdditionalArgs;
    }

    public String getClusterName() {
        return this.studioConfiguration.getProperty("studio.db.cluster.name");
    }

    public String getHazelcastClusterNamePrefix() {
        return String.format("dbCluster/%s/", this.getClusterName());
    }

    public int getClusterMemberCount() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.count", Integer.class);
    }

    public String getLocalNodeAddress() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.local.address");
    }

    public String getLocalNodeName() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.local.name");
    }

    public long getStatusReportingPeriodSecs() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.status.report.period", Long.class);
    }

    public long getStatusReportTtlSecs() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.status.report.ttl", Long.class);
    }

    public long getWaitForInitialReportsTimeoutSecs() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.startup.wait.timeout", Long.class);
    }

    public long getWaitForClusterBootstrapTimeoutSecs() {
        return this.studioConfiguration.getProperty("studio.db.cluster.bootrap.wait.timeout", Long.class);
    }

    public long getWaitForLocalNodeToBeSyncedTimeoutSecs() {
        return this.studioConfiguration.getProperty("studio.db.cluster.nodes.local.synced.wait.timeout", Long.class);
    }

    public String getGaleraLibLocation() {
        return this.studioConfiguration.getProperty("studio.db.cluster.lib.location");
    }

    public Path getGrastateFilePath() {
        return Paths.get(this.studioConfiguration.getProperty("studio.db.cluster.grastate.location"), new String[0]);
    }

    public String getDbBasePath() {
        return this.studioConfiguration.getProperty("studio.db.basePath");
    }

    public String getDbDataPath() {
        return this.studioConfiguration.getProperty("studio.db.dataPath");
    }

    public String getDbPort() {
        return this.studioConfiguration.getProperty("studio.db.port");
    }

    public String getDbSocket() {
        return this.studioConfiguration.getProperty("studio.db.socket");
    }

    public void afterPropertiesSet() {
        this.periodicStatusReporterExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void destroy() {
        this.periodicStatusReporterExecutor.shutdownNow();
        this.closeStatusQueryStatement();
        this.closeConnection();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getSource().equals(this.applicationContext)) {
            logger.info("Context refreshed. Status of DB cluster node will switch to '{}'", (Object)"Active");
            this.appReady = true;
        }
    }

    @Override
    public void synchronizeStartup(Consumer<MemberStartupConfig> startupCallback) throws DbClusterStartupException {
        String clusterName = this.getClusterName();
        this.clusterInfo = this.hazelcastInstance.getMap(this.getHazelcastClusterNamePrefix() + "info");
        this.currentClusterMembers = this.hazelcastInstance.getMap(this.getHazelcastClusterNamePrefix() + "members");
        this.localNode = new DbClusterMember(this.getLocalNodeAddress(), this.getLocalNodeName());
        this.localStartupConfig = new MemberStartupConfig(clusterName, this.localNode.getAddress(), this.localNode.getName());
        logger.info("Synchronizing startup of node {} with DB cluster '{}'", (Object)this.localNode.getAddress(), (Object)clusterName);
        if (Files.exists(this.getGrastateFilePath(), new LinkOption[0])) {
            this.localNode.setSeqno(this.recoverLocalSeqno());
            this.localNode.setSafeToBootstrap(this.isSafeToBootstrap());
        }
        this.reportStatus();
        this.waitForInitialReports();
        if (this.localNode.isSafeToBootstrap()) {
            this.bootstrapCluster(startupCallback, true);
        } else {
            Collection<DbClusterMember> activeMembers = this.getActiveClusterMembers();
            if (CollectionUtils.isNotEmpty(activeMembers)) {
                logger.info("DB cluster is running (has active members)");
                this.joinCluster(activeMembers, startupCallback);
            } else if (CollectionUtils.isNotEmpty(this.getSafeToBootstrapMembers())) {
                logger.info("Another DB cluster node has {} = 1", (Object)SAFE_TO_BOOTSTRAP_FLAG_NAME);
                this.joinClusterAfterBootstrap(startupCallback);
            } else if (this.areAllNodesNew()) {
                logger.info("DB cluster is new. This node will bootstrap the cluster");
                this.bootstrapCluster(startupCallback, false);
            } else if (this.checkIfLocalNodeHasHighestSeqno()) {
                logger.info("Local DB cluster node has the highest, non-zero seqno");
                this.localNode.setSafeToBootstrap(true);
                this.reportStatus();
                this.enableSafeToBootstrap();
                this.bootstrapCluster(startupCallback, true);
            } else if (this.localNode.getSeqno() > 0L) {
                logger.info("Another DB cluster node has the highest, non-zero seqno and will bootstrap the cluster");
                this.joinClusterAfterBootstrap(startupCallback);
            } else {
                logger.info("This DB cluster node is new, and cluster is already being bootstrapped by another node");
                this.joinClusterAfterBootstrap(startupCallback);
            }
        }
        this.waitForLocalNodeToBeSynced();
        this.periodicStatusReporterExecutor.scheduleAtFixedRate(new StatusReporter(), 0L, this.getStatusReportingPeriodSecs(), TimeUnit.SECONDS);
    }

    protected void waitForInitialReports() throws DbClusterStartupException {
        Collection<DbClusterMember> activeMembers = this.getActiveClusterMembers();
        if (CollectionUtils.isEmpty(activeMembers)) {
            int memberCount = this.getClusterMemberCount();
            boolean success = this.waitForCondition(this.getWaitForInitialReportsTimeoutSecs(), () -> "initial report of all " + memberCount + " DB cluster members", () -> this.currentClusterMembers.size() >= memberCount);
            if (success) {
                logger.info("All " + memberCount + " DB cluster members have started up");
            } else {
                throw new DbClusterStartupException("Not all " + memberCount + " DB cluster members have started up");
            }
        }
    }

    protected void bootstrapCluster(Consumer<MemberStartupConfig> startupCallback, boolean force) throws DbClusterStartupException {
        Object previous = this.clusterInfo.putIfAbsent((Object)"bootstrappedFrom", (Object)this.localNode.getAddress());
        if (previous == null) {
            logger.info("Local DB cluster node will bootstrap cluster");
            this.localStartupConfig.setMode(MemberStartupConfig.StartupMode.BOOTSTRAP);
            this.start(startupCallback);
        } else {
            if (force) {
                throw new DbClusterStartupException("DB cluster node " + this.localNode.getAddress() + " needs to bootstrap cluster '" + this.getClusterName() + "', but " + previous + " has already bootstrapped it");
            }
            this.joinClusterAfterBootstrap(startupCallback);
        }
    }

    protected void joinClusterAfterBootstrap(Consumer<MemberStartupConfig> startupCallback) throws DbClusterStartupException {
        this.joinCluster(this.waitForClusterBootstrap(), startupCallback);
    }

    protected void joinCluster(Collection<DbClusterMember> activeMembers, Consumer<MemberStartupConfig> startupCallback) throws DbClusterStartupException {
        String clusterAddress = this.getClusterAddress(activeMembers);
        logger.info("Local DB cluster node will join cluster {}", (Object)clusterAddress);
        this.localStartupConfig.setMode(MemberStartupConfig.StartupMode.JOIN);
        this.localStartupConfig.setClusterAddress(clusterAddress);
        this.start(startupCallback);
    }

    protected Collection<DbClusterMember> waitForClusterBootstrap() throws DbClusterStartupException {
        boolean success = this.waitForCondition(this.getWaitForClusterBootstrapTimeoutSecs(), () -> "DB cluster to bootstrap", () -> CollectionUtils.isNotEmpty(this.getActiveClusterMembers()));
        if (success) {
            logger.info("DB cluster bootstrapped");
            return this.getActiveClusterMembers();
        }
        throw new DbClusterStartupException("Timeout while waiting for DB cluster to bootstrap");
    }

    protected void waitForLocalNodeToBeSynced() throws DbClusterStartupException {
        StatusReporter statusReporter = new StatusReporter();
        boolean success = this.waitForCondition(this.getWaitForLocalNodeToBeSyncedTimeoutSecs(), () -> "local DB cluster node to sync with the rest of the cluster (status = " + this.localNode.getStatus() + ")", () -> {
            statusReporter.run();
            return this.localNode.isSynced();
        });
        if (!success) {
            throw new DbClusterStartupException("Timeout while waiting for local DB cluster node to sync with the cluster");
        }
        logger.info("Local DB cluster node is synced");
    }

    protected String getClusterAddress(Collection<DbClusterMember> members) {
        return "gcomm://" + members.stream().map(DbClusterMember::getAddress).collect(Collectors.joining(","));
    }

    protected Collection<DbClusterMember> getActiveClusterMembers() {
        return this.currentClusterMembers.values(Predicates.equal((String)"status", (Comparable)((Object)"Active")));
    }

    protected Collection<DbClusterMember> getSafeToBootstrapMembers() {
        return this.currentClusterMembers.values(Predicates.equal((String)"safeToBootstrap", (Comparable)Boolean.valueOf(true)));
    }

    protected boolean areAllNodesNew() {
        return CollectionUtils.isEmpty((Collection)this.currentClusterMembers.values(Predicates.notEqual((String)"seqno", (Comparable)Long.valueOf(0L))));
    }

    protected boolean checkIfLocalNodeHasHighestSeqno() {
        DbClusterMember highestSeqnoMember = this.currentClusterMembers.values().stream().max((m1, m2) -> NumberUtils.compare((long)m1.getSeqno(), (long)m2.getSeqno())).orElse(this.localNode);
        return highestSeqnoMember.getSeqno() > 0L && highestSeqnoMember.equals(this.localNode);
    }

    protected long recoverLocalSeqno() throws DbClusterStartupException {
        RecoverSeqnoProcess proc = new RecoverSeqnoProcess();
        proc.setBaseDir(this.getDbBasePath());
        proc.setDataDir(this.getDbDataPath());
        proc.setPort(this.getDbPort());
        proc.setSocket(this.getDbSocket());
        proc.setDbClusterLibLocation(this.getGaleraLibLocation());
        proc.setClusterName(this.getClusterName());
        proc.setNodeAddress(this.localNode.getAddress());
        proc.setAdditionalArgs(this.recoverSeqnoAdditionalArgs);
        try {
            return proc.run();
        }
        catch (DbClusterNodeRecoverSeqnoException e) {
            throw new DbClusterStartupException("Unable to recover local DB cluster node seqno", e);
        }
    }

    protected boolean isSafeToBootstrap() throws DbClusterStartupException {
        Path path = this.getGrastateFilePath();
        logger.info("Checking {} file for {} value", (Object)path, (Object)SAFE_TO_BOOTSTRAP_FLAG_NAME);
        try {
            for (String line : Files.readAllLines(path)) {
                if (!line.trim().matches("safe_to_bootstrap\\s*:\\s*1")) continue;
                logger.info("{} = 1", (Object)SAFE_TO_BOOTSTRAP_FLAG_NAME);
                return true;
            }
            logger.info("{} = 0", (Object)SAFE_TO_BOOTSTRAP_FLAG_NAME);
            return false;
        }
        catch (IOException e) {
            throw new DbClusterStartupException("Unable to read grastate file @ " + path, e);
        }
    }

    protected void enableSafeToBootstrap() throws DbClusterStartupException {
        Path path = this.getGrastateFilePath();
        if (Files.exists(path, new LinkOption[0])) {
            String enabledStr = "safe_to_bootstrap: 1";
            logger.info("Setting {} in file {}", (Object)enabledStr, (Object)path);
            try (BufferedReader reader = Files.newBufferedReader(path);){
                String grastateStr = IOUtils.toString((Reader)reader);
                grastateStr = grastateStr.contains(SAFE_TO_BOOTSTRAP_FLAG_NAME) ? grastateStr.replaceFirst("safe_to_bootstrap\\s*:\\s*\\d", enabledStr) : grastateStr + System.lineSeparator() + enabledStr;
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    IOUtils.write((String)grastateStr, (Writer)writer);
                }
            }
            catch (IOException e) {
                throw new DbClusterStartupException("Unable to set " + enabledStr + " in " + path, e);
            }
        }
    }

    protected void initConnection() throws SQLException {
        if (this.connection == null) {
            try {
                Class.forName(this.studioConfiguration.getProperty("studio.db.driver"));
            }
            catch (Exception e) {
                throw new SQLException("Error loading JDBC driver", e);
            }
            this.connection = DriverManager.getConnection(this.studioConfiguration.getProperty("studio.db.initializer.url"));
        }
    }

    protected void initStatusQueryStatement() throws SQLException {
        if (this.statusQueryStmt == null) {
            this.statusQueryStmt = this.connection.prepareStatement(GALERA_LOCAL_STATUS_DB_QUERY);
            this.statusQueryStmt.setString(1, this.LOCAL_STATE_DB_VAR_NAME);
            this.statusQueryStmt.setString(2, this.LOCAL_SEQNO_DB_VAR_NAME);
        }
    }

    protected void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.connection = null;
        }
    }

    protected void closeStatusQueryStatement() {
        try {
            this.statusQueryStmt.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.statusQueryStmt = null;
        }
    }

    protected void queryAndUpdateThisNodeStatus() throws SQLException {
        try (ResultSet rs = this.statusQueryStmt.executeQuery();){
            while (rs.next()) {
                String varName = rs.getString(1);
                if (varName.equalsIgnoreCase(this.LOCAL_STATE_DB_VAR_NAME)) {
                    String status = rs.getString(2);
                    if (this.appReady && status.equalsIgnoreCase("Synced")) {
                        this.localNode.setStatus("Active");
                        continue;
                    }
                    this.localNode.setStatus(status);
                    continue;
                }
                if (!varName.equalsIgnoreCase(this.LOCAL_SEQNO_DB_VAR_NAME)) continue;
                this.localNode.setSeqno(rs.getLong(2));
            }
        }
    }

    protected void reportStatus() {
        logger.debug("Reporting status of local DB cluster node to other cluster members: {}", (Object)this.localNode);
        this.currentClusterMembers.put((Object)this.localNode.getAddress(), (Object)this.localNode, this.getStatusReportTtlSecs(), TimeUnit.SECONDS);
    }

    protected void start(Consumer<MemberStartupConfig> startupCallback) throws DbClusterStartupException {
        try {
            startupCallback.accept(this.localStartupConfig);
        }
        catch (Exception e) {
            if (this.localStartupConfig.getMode() == MemberStartupConfig.StartupMode.BOOTSTRAP) {
                throw new DbClusterStartupException("Error while bootstrapping DB cluster '" + this.getClusterName() + "'", e);
            }
            throw new DbClusterStartupException("Error while joining DB cluster '" + this.getClusterName() + "'", e);
        }
    }

    protected boolean waitForCondition(long timeoutSecs, Supplier<String> conditionStrSupplier, BooleanSupplier predicate) throws DbClusterStartupException {
        long timeBeforeWait;
        long currentTime = timeBeforeWait = System.currentTimeMillis();
        long timeoutMillis = timeoutSecs * 1000L;
        while (currentTime - timeBeforeWait < timeoutMillis && !predicate.getAsBoolean()) {
            String conditionStr = conditionStrSupplier.get();
            logger.info("Waiting for {}...", (Object)conditionStr);
            try {
                Thread.sleep(this.getStatusReportingPeriodSecs() * 1000L);
            }
            catch (InterruptedException e) {
                throw new DbClusterStartupException("Thread interrupted while waiting for " + conditionStr, e);
            }
            this.reportStatus();
            currentTime = System.currentTimeMillis();
        }
        return currentTime - timeBeforeWait < timeoutMillis;
    }

    protected class StatusReporter
    implements Runnable {
        protected StatusReporter() {
        }

        @Override
        public void run() {
            try {
                logger.debug("Querying Galera local node status");
                DbClusterSynchronizationServiceImpl.this.initConnection();
                DbClusterSynchronizationServiceImpl.this.initStatusQueryStatement();
                DbClusterSynchronizationServiceImpl.this.queryAndUpdateThisNodeStatus();
                DbClusterSynchronizationServiceImpl.this.reportStatus();
            }
            catch (Exception e) {
                logger.error("Error while querying Galera local node status", (Throwable)e);
                DbClusterSynchronizationServiceImpl.this.closeStatusQueryStatement();
                DbClusterSynchronizationServiceImpl.this.closeConnection();
            }
        }
    }
}

